/*  Copyright 1986 by Carnegie Mellon  */
/*  See permission and disclaimer notice in file "cmu-note.h"  */
#include	<cmu-note.h>
/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <stdio.h>
#include "sl.h"

/* Statistics counters */
unsigned slmulti = 0;		/* # of times more than 1 packet on queue */
unsigned slwpp = 0;		/* task awakened w/o packet to process */

/*
 * This file contains the code for the net-level packet demultiplexor for the
 *	SLIP code. It demultiplexes the packet according to its protocol
 *	(ie: IP, AddrReply, Chaos, PUP, ...). It also does all the validation 
 *	on the packet that can be done from this level.
 */

sl_demux()
{
    PACKET p;
    char *data;

#ifdef	DEBUG
    if(NDEBUG & INFOMSG)
	printf("SL_DEMUX activated.\n");
#endif

    while(1) {
	tk_block();

#ifdef	DEBUG
	if(NDEBUG & INFOMSG)
		printf("SL_DEMUX running.\n");
#endif

	/* There should be a packet waiting on our queue for us. Get it. */
	p = (PACKET)aq_deq(sl_net->n_inputq);

	if(p == 0) {
#ifdef	DEBUG
		if(NDEBUG & (NETERR|INFOMSG))
			printf("SL_DEMUX: no pkt to process\n");
#endif
		slwpp++;
		continue;
	}

	if(p->nb_len < 4) {
#ifdef	DEBUG
		if(NDEBUG & (NETERR|PROTERR|INFOMSG))
			printf("SL_DEMUX: pkt too short %u\n", p->nb_len);
#endif
		putfree(p);
		continue;
	}

	data = p->nb_prot;

#ifdef	DEBUG
	if(NDEBUG & NETRACE)
		printf("SLIP: IP pkt, length %u\n", p->nb_len);
#endif
	indemux(p, p->nb_len, sl_net);

/* NOTE: if we continue after having an error, we may not process
	other packets sitting on our queue!
*/
	if(sl_net->n_inputq->q_head) {
#ifdef	DEBUG
		if(NDEBUG & INFOMSG)
			printf("SL_DEMUX: More packets; waking self.\n");
#endif
		slmulti++;
		tk_wake(tk_cur);
	}
    }
}


sl_dump(p)
	PACKET p; {
	char *data;
	int i;

	data = p->nb_prot;
	for(i=1;i<121; i++) {
		printf("%02x ", *data++);
		if(i%20 == 0) printf("\n");
		}
	printf("\n");
	}
