typedef	long	time_t;			/* ugly! */

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include <ntcp.h>
#include <ntcpblk.h>

/* this file holds procedures that print TCP statistics on the screen. */
char *tstates[] = {
	"Closed","LISTEN","Trying to Open","SYNRCVD","Established",
	"FIN-WAIT-1","CLOSE-WAIT","CLOSING","FIN-WAIT-2","LAST-ACK",
	"TIMEWAIT"};
extern char *NullStr;
/*  Supply TCP data for line 25 display  */

tcp_state(con,s) register TcpCon con;
char *s; 
{
	sprintf(s,"Sent: %u/%u/%u Rcvd: %u/%u/%u Wind: %u      ",
	tcpbsnt, tcpbsnt-(unsigned)(con->otp)->tc_seq, tcpresend,
	tcpbrcv, tcpbrcv-tcprack, tcprercv,
	(con->otp)->tc_win);
}

/* Display some tcp statistics and a few lines of unacked data. Should be */
/* revised and integrated in with the normal logging system. */

tc_status(con) register TcpCon con;
{
	int	i;	 /* loop index */
	int crseen = 0;
	register struct tcp *otp;	/* output packet pointer */
	otp = (con->otp);

	printf("Connection State: %s\n",tstates[con->conn_state]);
	printf("Packets Sent: %5u\tPackets Received: %u\n",tcppsnt, tcpprcv);
	printf("Bytes Sent: %5u\tAcked: %u\n",tcpbsnt, (unsigned)otp->tc_seq);
	printf("Bytes Received: %5u\tAcked: %u\n", tcpbrcv, tcprack);
	printf("Bad TCP xsums: %5u\tWindow ignored: %u\n",bd_chk,ign_win);
	printf("Packets not for me: %5u\n", tcpsock);
	printf("Resends: %u\tRereceived: %u\n", tcpresend, tcprercv);
	printf("Local Win: %5u\tLocal Low Win: %5d\tForeign Win: %8u\n",
	otp->tc_win,custom.c_tellowwin,con->frn_win);

	printf("Ack #: %08X, Seq #: %08X\n", otp->tc_ack, otp->tc_seq);
	printf("Output Flags: ");
	printf("%s%s%s%s%s%s",
	otp->tc_syn  ? " SYN" : NullStr, otp->tc_fack ? " ACK" : NullStr,
	otp->tc_psh  ? " PSH" : NullStr, otp->tc_furg ? " URG" : NullStr,
	otp->tc_fin  ? " FIN" : NullStr, otp->tc_rst  ? " RST" : NullStr);
	printf("connection variables:\n");
	printf("taken %d\tavail %d\tnumchunks %d\tmaxchunks %d\tlastchunk %d\n",
		con->taken, con->avail, con->numchunks, con->maxchunks,
							con->lastchunk);

	if(con->odlen) printf("\noutput data:\n");
	else {
		putchar('\n');
		return;
	}

	i=0;
	while(1) {
		if((con->odp)[i] == '\n') crseen++;
		putchar((con->odp)[i]);
		if(crseen > 3 || ++i > 100 || i > con->odlen) break;
	}

	printf("\n");
	if(i <= con->odlen) printf("***MORE DATA***\n\n");

}

