/*LINTLIBRARY*/
typedef	long	time_t;

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include <ntcp.h>
#include <ntcpblk.h>

/* This routine forms the main body of the TCP data sending task.  This task
 * is awakened for one of two reasons: someone has data to send, or a resend
 * timeout has occurred and a retransmission is called for.  
 * This routine in either case finishes filling in the header of the
 * output packet, and calls in_write() to send it to the net.
 */
extern timer *tm2;
tcp_send(con)
register TcpCon con; 
{
	int	sndlen;		 /* bytes to send */

	STARTPROCESS;		/* start of process */

	switch(con->SendReason) {
	case NOREASON:	
		printf("TCPsend: Error: no reason to send\n");
		break;
	case ONE_ACK:
/*		printf("ONE_ACK:st %d\n",con->conn_state); */
		if (con->conn_state == TIMEWAIT) {
			/* printf("Resetting TIMEWAIT timers from SEND\n"); */
			tcp_timewait(con);
		}
		else con->SendReason = NOREASON;
		break;
	case TIME_WAIT:
		if (con->avail >= 0) tcp_flush(con);
		/* connection closes normally */
		tcp_clean(con,TRUE);		/* this never returns */
	default:			/* timeout 1,2,... */
/*		printf("Tout %d\n",con->SendReason); */
		if (NOT_YET(con->conn_state, ESTAB)) /* negative timeout */
			(*(con->tc_timeout))(con,NEWDATA-con->SendReason);
		else if (con->SendReason > TIMELIMIT) /* pos timeout */
		{
			(*(con->tc_timeout))(con,con->SendReason-TIMELIMIT);
		}
	case NEWDATA:			/* no timeouts yet */
		con->SendReason++;
		tm_clear(con->tcptm);
/*		printf("Setting ACK (%d) timer -- try %d\n",con->retry_time,con->SendReason - NEWDATA); */
		tm_tset(con->retry_time, tmhnd, (unsigned) con, con->tcptm);
	}

	con->piggied = FALSE;	/* we've sent the piggybacked data */
	/* make sure to avoid silly window syndrome */
	/* if we have fewer  than "loc_lowwater" bytes in our buffer: */
	/* ---> tell the client so he will send more */
	if(con->avail + 1 < con->loc_lowwater) {
		con->otp->tc_win = con->loc_win - con->avail - 1;
	}
	tcp_swab((con->otp));			/* swap the bytes */

	/* Calculate the number of bytes to send, remembering the foreign */
	/* host's window. If the connection isn't yet open, send no data. */
	con->odlen = con->bptr - con->odp;
	sndlen = NOT_YET(con->conn_state, ESTAB) ? 0 : con->odlen;

	/* Finish filling in the TCP header */
	con->ophp.tp_len = swab(sndlen + sizeof(struct tcp));
	*((char *) con->otp + sizeof(struct tcp) + con->odlen) = 0;	/* end the packet with a zero */
	(con->otp)->tc_cksum = cksum(&(con->ophp), sizeof(struct tcpph) >> 1, 0);
	(con->otp)->tc_cksum = ~cksum(con->otp, (sndlen + sizeof(struct tcp) + 1) >> 1,0);

#ifdef	DEBUG
	if (TCDBG) {
		tcp_swab((con->otp));
		printf("SENDING(%u):\t",con->otp->tc_dstp);
		tcp_prpacket(con->otp,con->odp,con->odlen);
		tcp_swab((con->otp));
	}
#endif
	in_write(tcpfd,con->opbi,sndlen+sizeof(struct tcp),con->fhost);
	con->ack_time = cticks + con->ack_dally;

	tcp_swab((con->otp));		/* swap it back so we can use it */
	tcppsnt ++;
	tcpbsnt += (unsigned)(con->otp->tc_seq + sndlen);
	tcprack = tcpbrcv;

	if(con->otp->tc_rst) {		/* user did a reset? */
#ifdef	DEBUG		
		if (TCDBG) printf("TCP_SEND: Closed: both sides reset\n");
#endif
		tcp_clean(con,FALSE);		/* this never returns */
	}
	ENDPROCESS;
}

