/* PCheck -- a Pegasus mail BIFF program for MS-Windows */
/*           John A. Klein 5/91 */


#include <windows.h>
#include <stdio.h>
#include <net/nit.h>
#include <niterror.h>

#define  ID_TIMER 1

/* four icons define the animation, the first is FIRST, the final one LAST */
#define FIRST 0
#define LAST  3

/* number of millisecs to pause between displays */
#define DELAY_CNT 150

/* We add About... item to the system menu */
#define IDM_ABOUT       1

long FAR PASCAL WndProc( HWND,WORD,WORD,LONG );

/* global state, either FIRST or LAST, indicating state of icon */
static short CurState = FIRST;
static WORD  nMsgWaiting;       /* number of mail messages waiting */
static HICON hIcons[LAST+1];    /* handles to our icons */
static HANDLE hInst;            /* hInstance from wndmain */
static HWND   hwndList;         /* child listbox window used by nGetMail() */
static char  szAppName[] = "PCheck";
static long  objectID = 0;      /* Netware bindery ID for user */
static char  maildir[25];       /* directory to search for new mail in */

/* returns TRUE if connected to a novell network, FALSE if not */
/* looks up the object ID for the user running the program, and sets maildir */
/* to the users mail directory (SYS:MAIL\object_ID */
int     CheckForNet( void )
{
   char dummy[48];      /* used for all dummy params */
   WORD ot = -1;        /* object type should come back as OT_USER if lan */
                        /* is installed and user logged in */

   GetConnectionInformation( GetConnectionNumber(),dummy, &ot,&objectID,
                             (BYTE *) &dummy );
   if ( (ot == OT_USER) && (objectID != 0 ) ) {       /* shell loaded */
      sprintf( maildir,"SYS:MAIL/%lx", objectID );
      return TRUE;
   } else {
      return FALSE;
   } /* endif */
}

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{

   HDC          hdc;
   HWND         hwnd;
   HMENU        hMenu;

   MSG          msg;
   TEXTMETRIC   tm;
   WNDCLASS     wndclass;
   int          i;

   if ( hPrevInstance )         /* only run once */
        return FALSE ;

   if ( FALSE == CheckForNet() ) {
      MessageBox(hwnd,"This program is for Novell Networks using PMAIL!",
                 szAppName, MB_ICONEXCLAMATION | MB_OK );
      return( FALSE );
   } /* endif */

   wndclass.style            = CS_HREDRAW | CS_VREDRAW ;
   wndclass.lpfnWndProc      = WndProc;
   wndclass.cbClsExtra       = 0 ;
   wndclass.cbWndExtra       = 0 ;
   wndclass.hInstance        = hInstance ;
   wndclass.hIcon            = NULL ;  /* draw our own icon */
   wndclass.hCursor          = LoadCursor( NULL, IDC_ARROW );
   wndclass.hbrBackground    = GetStockObject( WHITE_BRUSH );
   wndclass.lpszMenuName     = NULL ;
   wndclass.lpszClassName    = szAppName;

   RegisterClass( &wndclass ) ;

   hwnd = CreateWindow(szAppName,                  /* window class name */
                        "PMail Inbox",             /* caption */
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT,          /* inital x */
                        CW_USEDEFAULT,          /* intial y */
                        CW_USEDEFAULT,          /* initial x size */
                        CW_USEDEFAULT,          /* inital y size */
                        NULL,                   /* parent window handle */
                        NULL,                   /* window menu handle */
                        hInstance,              /* program instance handle */
                        NULL );                 /* creation parameters */

   /* set the timer for 15 second intervals.  abort if no timers available */

   if ( !SetTimer( hwnd,ID_TIMER, 15000,NULL) ) {
      MessageBox(hwnd,"Too many clocks or timers!",
                 szAppName, MB_ICONEXCLAMATION | MB_OK );
      return FALSE;
   } /* endif */

   /* Load the icons to animate with */
   for (i=FIRST; i < LAST+1; i++) {
      hIcons[i] = LoadIcon( hInstance, MAKEINTRESOURCE( i+1 ) );
   } /* endfor */
   hInst = hInstance;   /* save as global */

   /* add an About... entry to the system menu */
   hMenu = GetSystemMenu( hwnd, FALSE );

   AppendMenu( hMenu, MF_SEPARATOR, 0, NULL );
   AppendMenu( hMenu, MF_STRING, IDM_ABOUT, "About..." );


   ShowWindow( hwnd, SW_SHOWMINNOACTIVE );      /* start as an icon */
   UpdateWindow( hwnd );

   while( GetMessage( &msg, NULL, 0,0 )) {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

    return msg.wParam;

} /* WndMain */

/* find out how many new mail files have come in.  New mail is stored in the */
/* SYS:MAIL\userID directory, each message in a file with extension .CNM */
/* Each time this routine is run, it maps a temporary DOS drive to the */
/* proper SYS:MAIL directory, and then uses a child listbox to count the .CNM */
/* files. */

/* I don't keep the temp. drive mapped, 'cause then it would show up in file */
/* manager and other list boxes, which is undesirable. */

WORD getMailWaiting( void )
{
   char drive;                          /* temp drive to use */
   WORD dum;
   WORD hdir;                           /* Novell directory handle */
   static char search[] = "T:*.CNM";    /* t is overwritten by real drive */

   /* find an unused drive letter to use for temp handle */
   /* DOS notation, A:=0, B:=1 ... */
   for (drive = 0; GetDriveInformation( drive, &dum, &dum) ; drive++) {
      if ( drive > 25 )
         return( -1 );      /* impossible value indicates temp handle error */
   } /* endfor */

   /* now drive is drive number of unused drive */
   drive = drive + 'A';         /* convert drive number to drive letter */

   /* point temp drive to mail directory */
   if (SUCCESSFUL != AllocTemporaryDirectoryHandle(0,maildir,drive,&hdir,&dum))
      return( -1 );

   /* count the number of files that end .CNM .  We do this by creating a */
   /* listbox window, and sending it a LB_DIR then a LB_GETCOUNT */
   search[0] = drive;   /* put temp drive letter in search string */
   SendMessage( hwndList, LB_RESETCONTENT, 0, (long) search );
   SendMessage( hwndList, LB_DIR, 0, (long) search );
   dum = SendMessage( hwndList, LB_GETCOUNT, 0, 0l );

   /* clean up and return */
   DeallocateDirectoryHandle( hdir );

   return( dum );
}

/* Show icons, either FIRST to LAST or LAST to FIRST order */
void animate( HWND hwnd, short direction )
{
   short        inc,i;
   HDC          hdc;
   PAINTSTRUCT  ps;
   int  temp;

   /* if CurState = direction, go thru animate 2x, back then forward */
   /* otherwise, just go forward */

   hdc = GetDC( hwnd );

   if (CurState == direction) {
      /* work through animation backwords first */
      inc = (CurState) > FIRST ? -LAST : 0 ;
      for (i=FIRST; i < LAST+1; i++) {
         for( temp = GetTickCount(); GetTickCount()-temp < DELAY_CNT;  )
                ;           /* this is slow enuf to see animation */
         DrawIcon( hdc,0,0, hIcons[ abs(i+inc) ] );
      }

      if (CurState == FIRST) {
         CurState = LAST;
      } else {
         CurState = FIRST;
      } /* endif */
   } /* endif */

   inc = (CurState) > FIRST ? -LAST : 0 ;
   for (i=FIRST; i < LAST+1; i++) {
      for( temp = GetTickCount(); GetTickCount()-temp < DELAY_CNT;  )
         ;                      /* this is slow enuf to see animation */
      DrawIcon( hdc,0,0, hIcons[ abs(i+inc) ] );
   }
   if (CurState == FIRST) {
      CurState = LAST;
   } else {
      CurState = FIRST;
   } /* endif */

   ReleaseDC( hwnd, hdc );

} /* animate */


long FAR PASCAL WndProc( HWND hwnd, WORD message, WORD wParam, LONG lParam )
{
   static WORD  nOldMsg;
   static RECT  rect;
   char         cBuffer[20];
   HDC          hdc;
   PAINTSTRUCT  ps;

switch (message) {

case WM_CREATE :

   /* make a child listbox to use to count the mail messages */
   hwndList = CreateWindow("listbox",NULL,WS_CHILDWINDOW,
                        5,5,50,50,      /* not used as window is invisible */
                        hwnd,   /* parent */
                        1, GetWindowWord(hwnd,GWW_HINSTANCE), NULL );

   if ( 0 < (nMsgWaiting = getMailWaiting() ) )
      CurState = LAST;  /* set initial flag state */
   return 0;

case WM_SYSCOMMAND:                     /* something from system menu */
   switch (wParam ) {
   case IDM_ABOUT:
     MessageBox(hwnd,"By John A. Klein 5/91\njohn@chaos.cc.ncsu.edu",
                szAppName, MB_OK | MB_ICONINFORMATION );
     return 0;
   }
   break;       /* any others handled by DefWindowProc */

case WM_TIMER:
   nMsgWaiting = getMailWaiting();

   if (nMsgWaiting == nOldMsg )
      return 0;

   if (nMsgWaiting > nOldMsg)
      animate( hwnd, LAST );
   else                                /* animate from FIRST to LAST */
      animate( hwnd, FIRST );

   nOldMsg = nMsgWaiting;
   InvalidateRect( hwnd, NULL, TRUE ); /* put no of messages on icon */

   return 0;

case WM_SIZE:                   /* This message we should never get */

   GetClientRect( hwnd, &rect );
   return 0 ;

case WM_PAINT:
   hdc = BeginPaint( hwnd, &ps );

   DrawIcon( hdc,0,0, hIcons[ CurState ] );     /* draw Icon */

   wsprintf(cBuffer,"%3d Messages",nMsgWaiting);

   SetWindowText( hwnd, cBuffer );

   EndPaint(hwnd,&ps );
   return 0;

case WM_QUERYOPEN :             /* refuse any de-iconify requests */
   return 0;

case WM_DESTROY:
   KillTimer( hwnd, ID_TIMER );
   PostQuitMessage( 0 );
   return 0;
} /* endswitch */

return DefWindowProc( hwnd, message, wParam, lParam );

} /* wndproc */
