CODE     SEGMENT BYTE PUBLIC
          ASSUME    CS:CODE

; STUFKEYP.ASM  Pascal CALLED KEYBOARD STUFFER
; Keyboard buffer stuffer to avoid use of pipes
; Nov 20,1991   Ver 0.0
; Tony Bigras
; Called
;       PROCEDURE stufkeyp(codekey: INTEGER);
;       codekey has scan code in hi order byte and ascii key in low order

BUFSTART  EQU 1EH ;abs
BUFEND    EQU 3EH ;abs
BIOSDATA  EQU 40H
BUFHEAD   EQU 1AH ;ptr
BUFTAIL   EQU 1CH ;ptr

          PUBLIC STUFKEYP
STUFKEYP  PROC   NEAR

          MOV  BX,SP
          MOV  CX,SS:[BX+2]   ; Get codekey
          MOV    AX,BIOSDATA
          MOV    ES,AX
          CLI
          MOV    BX,WORD PTR ES:[BUFTAIL]
          MOV    SI,BX
          INC    BX
          INC    BX
          CMP    BX,BUFEND
          JB     K1
          MOV    BX,BUFSTART
K1:       CMP    BX,ES:[BUFHEAD]
          JE     K2
          MOV    ES:[SI],CX
          MOV    WORD PTR ES:[BUFTAIL],BX
K2:       STI
          RET    2
stufkeyp ENDP

CODE      ENDS
          END
