
UNIT NetBIOS;
{ ver 0.100
         ^^ bug fix
        ^   minor rev
      ^     major rev
{ Turbo Pascal 5.5 }
{ 0.100 work start nov 25 1991  Tony Bigras  (604) 753-3245 x2588 }
{ Public Domain, Absolutly NO liability accepted!                 }
{ for use of NetBIOS functions   }
{ 0.723 additional checks for netbios

}
INTERFACE

USES Dos;

CONST
  ncbaddname=       $30;
  ncbdelname=       $31;
  ncbreset=         $32;
  ncbadapterstatus= $33;
  ncbsessionstatus= $34;
  ncbaddgroup=      $36;
  ncbcall=          $10;
  ncblisten=        $11;
  ncbhangup=        $12;
  ncbsend=          $14;
  ncbreceive=       $15;
  ncbnetbiosstatus= $7F; { query if netbios loaded }
  postit=           $80; { add to any waitable routine for concurrent action }
  ncbsenddatagram=  $20; { next 4 are guesses }
  ncbrecdatagram=   $21;
  ncbsendbroadcast= $22;
  ncbrecbroadcast=  $23;


TYPE
  netname = ARRAY[1..16] OF CHAR;
    { Format of name is padded trailing with blanks }
    { with a 0 in 16 }
  nameorbufinfo= RECORD
    CASE BOOLEAN OF
      FALSE: (name: netname); { Network name }
      TRUE: (nextbuflen: WORD; { Length of next buffer in chain }
             nexbufptr: POINTER) { Pointer to next buffer in chain }
    END; { CASE }

  ncbtype = RECORD    { NetBIOS Network Control Block }
    command,          { NetBIOS command }
    retcode,          { Return code }
    lsn,              { Logical session number }
    num: BYTE;        { number of local name ie handle }
    bufptr: POINTER;  { to message buffer }
    len: WORD;        { Message buffer length 65535 maximum in session }
    callname:         { Destination name or info about second buffer in }
      nameorbufinfo;  { a CHAIN SEND command . }
    name: netname;    { Source local name }
    rto,              { Receive timeout in half seconds }
    sto: BYTE;        { Send timeout in half seconds }
    post: POINTER;    { Interrupt completion routine address }
    lanadaptnum: 0..1; { Number of lan adapter }
    cmdcomplete: BYTE; { Command complete flag }
    reserved: ARRAY[1..14] OF BYTE; { reserved for NetBIOS }
  END; { ncb }


VAR
  netbiosactive: BOOLEAN;

  PROCEDURE  nbcall(VAR n: ncbtype);

  IMPLEMENTATION

  PROCEDURE post;  INTERRUPT; { NetBIOS completion routine }

  BEGIN { post }
  END; { post }

  PROCEDURE  nbcall(VAR n: ncbtype);
  VAR
    reg: registers;
  BEGIN { nbcall }
    reg.ES:= SEG(n);
    reg.BX:= OFS(n);
    reg.AX:= $0100;   { don't know why from some c code }
    INTR($5C,reg);
  END; { nbcall }

  PROCEDURE checknetbios;
  VAR
    tvect,tvect2: POINTER;
    ncb: ncbtype;
  BEGIN

    { 0.723 }
    GETINTVEC($5C,tvect);
    GETINTVEC($5D,tvect2);
    netbiosactive:= tvect<>tvect2; { tvect2 should have been unimplemented }

    IF netbiosactive THEN
    BEGIN
      ncb.command:= ncbnetbiosstatus;
      Nbcall(ncb);
      IF (ncb.retcode<> 35) THEN
        netbiosactive:= FALSE
      ELSE
        netbiosactive:= TRUE;
    END; { maybe active }
  END; { checknetbios }

BEGIN { NetBIOS }
  checknetbios;
END. { NetBIOS }

