/*
 * CRITBOOT.C  V 1.01
 *
 * Installs a critical error handler which reboots the computer
 * when an error occurs.
 *
 * Program to run (with optional parameters) is given in command line.
 *
 * Compile: tcc -mt critboot
 *          exe2bin critboot.exe critboot.com
 *
 * Seppo Syrjanen 6 Feb 91
 * syrjanen@cc.Helsinki.FI
 */

#define VERS "V 1.01"

#include <process.h>
#include <dos.h>
#include <errno.h>
#include <io.h>
#include <string.h>

#define DOS_CRITICAL_HANDLER (0x24)

#define puts(s) { _write(0,s,strlen(s)); _write(0,"\r\n",2); }

/* These tricks spare few kbytes of memory */

unsigned _stklen=1024;
unsigned _heaplen=1024;

findfirst() { return 0;};
findnext() { };
long lseek() { };

/* Prototypes for function pointers */

void interrupt (*Old_Int24_handle)();
static unsigned far (*reboot)(void);

/*  Rebooting Int 24 handler */

void interrupt Int24_handle (unsigned bp, unsigned di, unsigned si,
			  unsigned ds, unsigned es, unsigned dx,
			  unsigned cx, unsigned bx, unsigned ax)
{
   static unsigned far *reboot_flag=MK_FP(0x40,0x72);
   reboot=MK_FP(0xF000,0xE05B);  /* Ctrl-Alt-Del */

   *reboot_flag=0x01234;  /* Don't check memory */
   reboot();

#pragma warn -par
}
#pragma warn .par

/* ------------------------------------------------------ */
/* ------------------------------------------------------ */

#define USAGE puts(VERS" Usage: CRITBOOT d:\\path\\program.ext [par1 [par2...]]")

main(int argc, char *argv[])
{

    if (argc == 1) {
        USAGE;
        exit(1);
    };

    Old_Int24_handle = getvect(DOS_CRITICAL_HANDLER);  /* save old handler */
    setvect(DOS_CRITICAL_HANDLER, Int24_handle); /* and install ours */

    if (spawnv(P_WAIT,argv[1],&argv[1])) switch (errno) {
        case 0:
            break;
        case ENOENT:
            puts("Program not found.");
            break;
        case ENOMEM:
            puts("Not enough memory.");
            break;
        default:
            puts("Cannot start program.");
            break;
    }

    setvect(DOS_CRITICAL_HANDLER, Old_Int24_handle);
}
