#if	!defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: pilot.c,v 4.5 1996/03/15 07:41:11 hubert Exp $";
#endif
/*
 * Program:	Main stand-alone Pine File Browser routines
 *
 * Author:	Michael Seibel
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: mikes@cac.washington.edu
 *
 *
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 *
 *
 * BROWSER NOTES:
 *
 * 30 Sep 92 - Stand alone PIne's "Lister of Things" came into being.
 *	       It's built against libpico.a from a command line like:
 *
 *		       cc pilot.c libpico.a -ltermcap -lc -o pilot
 *
 *	       should it become a fleshed out tool, we'll move it into
 *	       the normal build process.
 */

#include        <stdio.h>
#include	"osdep.h"	/* operating system dependent includes */
#include	"pico.h"	/* pine composer definitions */
#include        "estruct.h"	/* global structures and defines */
#include	"efunc.h"	/* function declarations and sans name table */
#include	"edef.h"	/* global definitions */


#define		PILOT_VERSION	"UW PILOT 1.0"


extern char *gethomedir();



/*
 * main standalone browser routine
 */
main(argc, argv)
char    *argv[];
{
    register int    c;
    register int    f;
    register int    n;
    register BUFFER *bp;
    register int    carg;		/* current arg to scan 		*/
    extern   int    pico_new_mail();
    int	     starton = 0;		/* where's dot to begin with?	*/
    int	     i;
    char     bname[NBUFN];		/* buffer name of file to read	*/
    char    *clerr = NULL;		/* garbage on command line	*/
    char     filename[NSTRING], filedir[NSTRING];
 
    timeout = 0;
    Pmaster = NULL;			/* turn OFF composer functionality */
    km_popped = 0;
    opertree[0]     = '\0';
    opertree[NLINE] = '\0';

    strcpy(filedir, gethomedir(NULL));
    gmode |= MDBRONLY;			/* turn on exclusive browser mode */

    /*
     * Read command line flags before initializing, otherwise, we never
     * know to init for f_keys...
     */
    carg = 1;
    while(carg < argc){
	if(argv[carg][0] == '-'){
	    switch(argv[carg][1]){
	      case 'a':
		gmode ^= MDDOTSOK;	/* show dot files */
		break;
	      case 'f':			/* -f for function key use */
		gmode ^= MDFKEY;
		break;
	      case 'g':			/* show-cursor in file browser */
		gmode ^= MDSHOCUR;
		break;
	      case 'm':			/* turn on mouse support */
		gmode ^= MDMOUSE;
		break;
	      case 'n':			/* -n for new mail notification */
		timeout = 180;
		if(argv[carg][2] != '\0')
		  if((timeout = atoi(&argv[carg][2])) < 30)
		    timeout = 180;
		break;
	      case 'o' :		/* operating tree */
		if(argv[carg+1] && argv[carg+1][0] && argv[carg+1][0] != '-'){
		    strncpy(opertree, argv[++carg], NLINE);
		    gmode ^= MDTREE;
		}
		else{
		    printf("Missing or empty argument to -o flag isn't allowed\n");
		    exit(1);
		}
		break;
	      case 'v':			/* single column display */
		gmode ^= MDONECOL;
		break;
	      case 'x':			/* suppress keyhelp */
		sup_keyhelp = !sup_keyhelp;
		break;
	      case 'z':			/* -z to suspend */
		gmode ^= MDSSPD;
		break;
#if	defined(DOS) || defined(OS2)
	      case 'c':			/* -c[nr][fb] colors */
		if(carg + 1 < argc){
		    if(argv[carg][2] == 'n'){
			if(argv[carg][3] == 'f')
			  pico_nfcolor(argv[++carg]);
			else if(argv[carg][3] == 'b')
			  pico_nbcolor(argv[++carg]);
		    }
		    else if(argv[carg][2] == 'r'){
			if(argv[carg][3] == 'f')
			  pico_rfcolor(argv[++carg]);
			else if(argv[carg][3] == 'b')
			  pico_rbcolor(argv[++carg]);
		    }
		}
		else{
		    clerr = "insufficient args for \"-c\"";
		    break;
		}
		break;
#endif
	      default:			/* huh? */
		clerr = argv[carg];
		break;
	    }
	    carg++;
	}
	else { 				/* dir to start in? */
	    strcpy(filedir, argv[carg]);
	    fixpath(filedir, NSTRING);
	    break;
	}
    }

    if(!vtinit())			/* Displays.            */
      exit(1);

    strcpy(bname, "main");		/* default buffer name */
    edinit(bname);			/* Buffers, windows.   */
#if	defined(TERMCAP) || defined(TERMINFO) || defined(VMS)
    if(pico_kbesc == NULL){		/* will arrow keys work ? */
	(*term.t_putchar)('\007');
	emlwrite("Warning: keypad keys may non-functional", NULL);
    }
#endif	/* TERMCAP/TERMINFO/VMS */

    curbp->b_mode |= gmode;		/* and set default modes*/
    if(timeout)
      emlwrite("Checking for new mail every %D seconds", (void *) timeout);

    if(clerr){				/* post any errors on command line */
	if(mpresf)			/* show earlier message though! */
	  sleep(2);
	emlwrite("\007Unknown option: %s", clerr);
    }

    set_browser_title(PILOT_VERSION);
    FileBrowse(filedir, filename, NULL, 0);
    wquit(1, 0);
}
