# $Id: makefile.hpp,v 4.6 1996/03/15 07:41:11 hubert Exp $
#
#   Michael Seibel
#   Networks and Distributed Computing
#   Computing and Communications
#   University of Washington
#   Administration Builiding, AG-44
#   Seattle, Washington, 98195, USA
#   Internet: mikes@cac.washington.edu
#
#   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
#
#
#   Pine and Pico are registered trademarks of the University of Washington.
#   No commercial use of these trademarks may be made without prior written
#   permission of the University of Washington.
#
#   Pine, Pico, and Pilot software and its included text are Copyright
#   1989-1996 by the University of Washington.
#
#   The full text of our legal notices is contained in the file called
#   CPYRIGHT, included with this distribution.
#

#
# Makefile for HP/UX version of the PINE composer library and 
# stand-alone editor pico.
#

#includes symbol info for debugging 
DASHO=		-g
#for normal build
#DASHO=		-O

STDCFLAGS=	-Dhpp -DPOSIX -DJOB_CONTROL -DMOUSE
CFLAGS=		$(EXTRACFLAGS) $(DASHO) $(STDCFLAGS)

# switches for library building
LIBCMD=		ar
LIBARGS=	ru
RANLIB=		:

LIBS=		$(EXTRALIBES) -ltermcap -lV3

OFILES=		attach.o ansi.o basic.o bind.o browse.o buffer.o \
		composer.o display.o file.o fileio.o line.o osdep.o \
		pico.o random.o region.o search.o spell.o tcap.o window.o word.o

CFILES=		attach.c ansi.c basic.c bind.c browse.c buffer.c \
		composer.c display.c file.c fileio.c line.c osdep.c \
		pico.c random.c region.c search.c spell.c tcap.c window.c word.c

HFILES=		estruct.h edef.h efunc.h ebind.h pico.h


#
# dependencies for the Unix versions of pico and libpico.a
#
all:		pico pilot

osdep.c:	os_unix.c
		rm -f osdep.c
		cp os_unix.c osdep.c

osdep.h:	os_unix.h
		rm -f osdep.h
		cp os_unix.h osdep.h

libpico.a:	$& osdep.c osdep.h $(OFILES)
		$(LIBCMD) $(LIBARGS) libpico.a $(OFILES)
		$(RANLIB) libpico.a

pico:		main.c libpico.a
		$(CC) $(CFLAGS) main.c libpico.a $(LIBS) -o pico

pilot:		pilot.c libpico.a
		$(CC) $(CFLAGS) pilot.c libpico.a $(LIBS) -o pilot

.c.o:		; $(CC) -c $(CFLAGS) $*.c

$(OFILES):	$(HFILES)

clean:
		rm -f *.a *.o *~ osdep.c osdep.h

