#if	!defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: os2spell.c,v 4.2 1996/03/15 07:43:51 hubert Exp $";
#endif
/*
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 */

#include <stdio.h>
#include "osdep.h"
#include "estruct.h"
#ifdef	SPELLER
#include "pico.h"
#include "edef.h"

/*
 * spell - fork off an spell checker
 * this is different for OS/2 with ispell; here, the document
 * correction and interface is provided by ispell itself
 */
#define MAXARGS 10
spell(f, n)
{
  char   sp[NLINE];				/* buf holding spell command */
  char   *fn;					/* tmp holder for file name */
  char   *cp;
  char   *args[MAXARGS];			/* ptrs into edit command */
  char   *writetmp();
  int    child, pid, i, done = 0;
  long   l;
  int    stat;
  FILE   *p;

  if(Pmaster == NULL)
    return(-1);

  if((fn = writetmp(0, 0)) == NULL){
    emlwrite("Can't write temp file for spell checker");
    return(-1);
  }
  if((cp = (char *)getenv("SPELL")) == NULL)
    cp = SPELLER;
  strcpy(sp,cp);

  if((fn=writetmp(0, 1)) == NULL){		/* get temp file */
    emlwrite("Problem writing temp file for alt editor", NULL);
    return(-1);
  }

  strcat(sp, " ");
  strcat(sp, fn);

  cp = sp;
  for(i=0; *cp != '\0';i++) {			/* build args array */
    if(i < MAXARGS) {
      args[i] = NULL;			/* in case we break out */
    }
    else{
      emlwrite("Too many args for command!", NULL);
      return(-1);
    }

    while(isspace(*cp))
      if(*cp != '\0')
	cp++;
      else break;

    args[i] = cp;
    while(!isspace(*cp))
      if(*cp != '\0')
	cp++;
      else
	break;

    if(*cp != '\0')
      *cp++ = '\0';
  }

  args[i] = NULL;

  (*Pmaster->raw_io)(0);			/* turn OFF raw mode */

  emlwrite("Invoking spell checker...", NULL);

  if(child=fork()) {			/* wait for the child to finish */
    void (*ohup)() = signal(SIGHUP, SIG_IGN);	/* ignore signals for now */
    void (*oint)() = signal(SIGINT, SIG_IGN);

    while((pid=(int)wait(&stat)) != child)
      ;

    signal(SIGHUP, ohup);	/* restore signals */
    signal(SIGINT, oint);
  }
  else {				/* spawn editor */
    signal(SIGHUP, SIG_DFL);	/* let editor handle signals */
    signal(SIGINT, SIG_DFL);
    if(execvp(args[0], args) < 0)
      exit(1);
  }

  (*Pmaster->raw_io)(1);		/* turn ON raw mode */
  dont_interrupt();

  /*
   * replace edited text with new text 
   */
  curbp->b_flag &= ~BFCHG;		/* make sure old text gets blasted */
  readin(fn, 0);			/* read new text overwriting old */
  unlink(fn);				/* blast temp file */
  curbp->b_flag |= BFCHG;		/* mark dirty for packbuf() */
  ttopen();				/* reset the signals */
  refresh(0, 1);			/* redraw */
  return(0);
}

#endif	/* SPELLER */





