#if !defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: mailcap.c,v 1.15 1994/08/24 00:27:53 mikes Exp $";
#endif
/*----------------------------------------------------------------------

           T H E    P I N E    M A I L   S Y S T E M

   Laurence Lundblade, Mike Seibel and David Miller
   Networks and Distributed Computing
   Computing and Communications
   University of Washington
   4545 Builiding, JE-20
   Seattle, Washington, 98195, USA
   Internet: mikes@cac.washington.edu
             dlm@cac.wasington.edu

   Please address all bugs and comments to "pine-bugs@cac.washington.edu"

   Copyright 1989-1994  University of Washington

    Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee to the University of
   Washington is hereby granted, provided that the above copyright notice
   appears in all copies and that both the above copyright notice and this
   permission notice appear in supporting documentation, and that the name
   of the University of Washington not be used in advertising or publicity
   pertaining to distribution of the software without specific, written
   prior permission.  This software is made available "as is", and
   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  
   Pine and Pico are trademarks of the University of Washington.
   No commercial use of these trademarks may be made without prior
   written permission of the University of Washington.

   Pine is in part based on The Elm Mail System:
    ***********************************************************************
    *  The Elm Mail System  -  Revision: 2.13                             *
    *                                                                     *
    *                   Copyright (c) 1986, 1987 Dave Taylor              *
    *                   Copyright (c) 1988, 1989 USENET Community Trust   *
    ***********************************************************************


   Mailcap support is in part based on Metamail version 2.6:

   Copyright (c) 1991 Bell Communications Research, Inc. (Bellcore)
 
   Permission to use, copy, modify, and distribute this material
   for any purpose and without fee is hereby granted, provided
   that the above copyright notice and this permission notice
   appear in all copies, and that the name of Bellcore not be
   used in advertising or publicity pertaining to this
   material without the specific, prior written permission
   of an authorized representative of Bellcore.  BELLCORE
   MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY
   OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS",
   WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

   ******************************************************
     Metamail -- A tool to help diverse mail readers
                 cope with diverse multimedia mail formats.

     Author:  Nathaniel S. Borenstein, Bellcore

   ******************************************************* 

  ----------------------------------------------------------------------*/

#include "headers.h"

#define STDPATH ".mailcap;/etc/mailcap"
#define PATH_SEPARATOR ';'


/*
 * Structure used by Mailcap routines indicating what to do with various 
 * MIME types.
 */
struct MailcapEntry {
    char *contenttype;
    char *command;
    char *testcommand;
    int needsterminal;
    int copiousoutput;
    int needtofree;
    char *label;
    char *printcommand;
    struct MailcapEntry *next;
};

struct MailcapEntry *Mailcap, *MailcapTail ;


/*
 * mailcap_init - Run down the specified paths gathering mailcap entries.
 *		  Returns with the global Mailcap list built
 */
int
mailcap_init()
{
  char *s, *pathcopy = NULL, *path;
  
  if (path = getenv("MAILCAPS")) {
      pathcopy = cpystr(path);
  }
  else{
#ifdef	DOS
      /*
       * This gets interesting.  Since we don't have any standard location
       * for config/data files, look in the same directory as the PINERC
       * and the same dir as PINE.EXE.  This is similar to the UNIX
       * situation with personal config info coming before 
       * potentially shared config data...
       */
      s = last_cmpnt(ps_global->pinerc);
      strncpy(tmp_20k_buf, ps_global->pinerc, s - ps_global->pinerc);
      sprintf(tmp_20k_buf + (s - ps_global->pinerc), "\\MAILCAP%c%s\\MAILCAP",
	      PATH_SEPARATOR, ps_global->pine_dir);
#else
      build_path(tmp_20k_buf, ps_global->home_dir, STDPATH);
#endif
      pathcopy = cpystr(tmp_20k_buf);
  }

  path = pathcopy;			/* overloaded "path" */

  /*
   * Insert an entry for the image-viewer variable from .pinerc, if present.
   */
  if (ps_global->VAR_IMAGE_VIEWER && *ps_global->VAR_IMAGE_VIEWER) {
    Mailcap = MailcapTail = 
      (struct MailcapEntry *)fs_get(sizeof(struct MailcapEntry));
    Mailcap->contenttype = "image/*" ;
    strcpy(tmp_20k_buf, ps_global->VAR_IMAGE_VIEWER) ;
    strcat(tmp_20k_buf, " %s") ;
    Mailcap->command = cpystr(tmp_20k_buf) ;
    Mailcap->testcommand = NULL ;
    Mailcap->needsterminal = TRUE ;
    Mailcap->copiousoutput = TRUE ;
    Mailcap->label = "Pine Image Viewer" ;
    Mailcap->printcommand = NULL ;
    Mailcap->needtofree = 0;
    Mailcap->next = NULL ;
    dprint(5, (debugfile, "MAILCAP: using image-viewer=%s\n", 
	       ps_global->VAR_IMAGE_VIEWER)) ;
  }

  dprint(7, (debugfile, "MAILCAP: path: %s\n", path));
  while(path) {
    s = strindex(path, PATH_SEPARATOR);
    if (s) *s++ = 0;
    mailcap_process_file(path);
    path = s;
  }
  
  if (pathcopy) fs_give((void **)&pathcopy);
  return(0);
}

mailcap_process_file(file)
     char *file;
{
  struct MailcapEntry *mc;
  
  dprint(2, (debugfile, "MAILCAP: file: \"%s\"\n", file));
  mc = (struct MailcapEntry *)fs_get(sizeof(struct MailcapEntry));
  mc->needtofree = 0;
  mc->next = NULL ;
  while(mailcap_get_entry(file, mc)) {
    if (Mailcap) {
      MailcapTail = MailcapTail->next = mc ;
    } else {
      MailcapTail = Mailcap = mc ;
    }
    mc = (struct MailcapEntry *)fs_get(sizeof(struct MailcapEntry));
    mc->needtofree = 0;
    mc->next = NULL ;
  }
  fs_give((void **)&mc) ;	      /* The last one didn't get used */
}


char *mailcap_parse_command(s, t)
     char *s, **t;
{
  char *s2;
  int quoted = 0;
  s2 = (char *)fs_get(strlen(s)*2);   /* absolute max, if all % signs */
  *t = s2;
  while (s && *s && *s != '\n') {
    if (quoted) {
      if (*s == '%') *s2++ = '%'; /* Quote through next level, ugh! */
      
      *s2++ = *s++;
      quoted = 0;
    } else {
      if (*s == ';') {  
	*s2 = 0;
	dprint(9, (debugfile, "MAILCAP: mailcap_parse_command: %s\n", *t));
	return(++s);
      }
      *s2++ = *s++;  
    } 
  }
  *s2 = 0;
  dprint(9, (debugfile, "MAILCAP: mailcap_parse_command: %s\nMAILCAP: End of Entry\n\n", *t));
  return(NULL);
}
     
mailcap_get_entry(file, mc)
     char *file;
     struct MailcapEntry *mc;
{
  static char *rawentry = NULL, *cur = NULL ;
  char *s, *t, *next;
  
  if (rawentry == NULL) {
    cur = rawentry = read_file(file);     
    if (cur) {
      for (; *cur && isspace((unsigned char) *cur); ++cur) ;
      dprint(2, (debugfile, *cur ? "MAILCAP: Processing file %s\n" : 
	                           "MAILCAP: Empty file %s\n", file)) ;
    } else {
      dprint(2, (debugfile, "MAILCAP: Cannot read file %s\n", file));
      return(0) ;
    } 
  }
  
 nextentry:  
  while (cur && *cur == '#')   /* skip comment */
    cur = strindex(cur, '\n')+1 ;
  s = cur ;
  while (s && (t = strindex(s, '\n')) && t != cur && *(t-1) == '\\') {
    *(t-1) = *t = ' ' ;		/* purge those nasty continuation characters */
    s = t ;
  }
  next = t ? t : s ;
  *next++ = 0 ;
  dprint(9, (debugfile, "MAILCAP: Processing entry: %s\n", cur)) ;
  if (cur == NULL || *cur == 0) {           /* End of File */
    fs_give((void **)&rawentry);
    dprint(7, (debugfile, "MAILCAP: End of file \"%s\"\n", file));
    return(0);
  }
  
  if (!(s = strindex(cur, ';'))) {
    if (t = strindex(cur, '\n'))
      *t++ = 0 ;
    q_status_message1(1,2,4, "Invalid mailcap entry (%s)", cur);
    if (cur = t) goto nextentry;
    fs_give((void **)&rawentry);
    return(0);
  }
  *s++ = 0;
  mc->needsterminal = 0;
  mc->copiousoutput = 0;
  mc->needtofree = 1;
  mc->testcommand = NULL;
  mc->label = NULL;
  mc->printcommand = NULL;
  mc->contenttype = cpystr(strclean(cur));
  dprint(9, (debugfile, "MAILCAP: Content Type: %s\n", cur)) ;
  
  t = mailcap_parse_command(s, &mc->command);

  if (s = t) { 
    while (*s && isspace((unsigned char) *s)) ++s;
    dprint(9, (debugfile, "MAILCAP: flags: %s\n", s)) ;
  } else {
    cur = next ;
    return(1) ;
  }

  while (s) {				/* process flags */
    char *arg, *eq;
    
    t = mailcap_parse_command(s, &arg);
    eq = strindex(arg, '=');
    if (eq) *eq++ = 0;
    arg = strclean(arg);  
    if (!strucmp(arg, "needsterminal")) {
      mc->needsterminal = 1;
    } else if (!strucmp(arg, "copiousoutput")) {
      mc->copiousoutput = 1;
    } else if (eq && !strucmp(arg, "test")) {
      mc->testcommand = eq;
    } else if (eq && !strucmp(arg, "description")) {
      mc->label = eq;
    } else if (eq && !strucmp(arg, "label")) {
      mc->label = eq; /* bogus old name for description */
    } else if (eq && !strucmp(arg, "print")) {
      mc->printcommand = eq;
    } else if (strucmp(arg, "notes")) { /* IGNORE notes field */
      if (*arg) dprint(2, (debugfile, "Ignoring mailcap flag: %s\n", arg));
    }
    s = t;
  }
  cur = next ;
  return(1);
}

char *mailcap_get_command(type, subtype)
     int type ;
     char *subtype ;
{
  char *p ;
  int len ;
  struct MailcapEntry *mc = Mailcap ;

  while (mc) {
    if ((p = strindex(mc->contenttype, '/')) == NULL) {
      /* implicit wildcard */
      len = strlen(mc->contenttype) ;
    } else {
      len = (int) (p - mc->contenttype) ;
    }
    if (!struncmp(mc->contenttype, body_type_names(type), len)
	&& ((p[1] == '*' && p[2] == 0) /* wildcard */
	    || !strucmp(p+1, subtype))) {
      if (mc->testcommand && *mc->testcommand) {
#ifdef	_WINDOWS
	int rv = (WinExec(mc->testcommand,SW_SHOWMINNOACTIVE) < 32) ? 1 : 0;
#else
	int rv = system(mc->testcommand) ;
#endif
	dprint(5, (debugfile, "mailcap_get_command: test of \"%s\" %s(%d)\n",
		   mc->testcommand, rv ? "Failed" : "Passed", rv)) ;
	if (rv)
	  goto next ;
      } 

      dprint(5, (debugfile, 
		 "mailcap_get_command: type=%d, subtype=%s, command=%s\n", 
		 type, subtype, mc->command)) ;
      return(mc->command) ;
    }
  next:
    dprint(9, (debugfile, "mailcap_get_command: %s/%s != %s\n", 
	       body_type_names(type), subtype, mc->contenttype)) ;
    mc = mc->next ;
  }
  return(NULL) ;
}

int mailcap_can_display(type, subtype)
    int type ;
    char *subtype ;
{
    return(mailcap_get_command(type, subtype) ? 1 : 0) ;
}

/*
 * mailcap_build_command - given the the body pointer containing the 
 *                         segment's type/subtype and parms and the
 *                         temporary filename containing the data to
 *			   display, return alloc'd string filled in
 *			   with mailcap's execute command suitable for
 *			   passing to the shell (ala draft mailcap rfc)...
 */
char *
mailcap_build_command(body, filename)
    BODY *body;
    char *filename;
{
    char        *from, *to, *s, *p, *controlstring; 
    int	         prefixed = 0, quoted = 0, UsedBigFile = 0;
    PARAMETER   *parm ;

    if (!(controlstring = mailcap_get_command(body->type, body->subtype))) {
	q_status_message(1,2,4, "Error constructing viewer command.") ;
	dprint(2, (debugfile, 
		   "mailcap_build_command: No command string for %s/%s\n",
		   body_type_names(body->type), body->subtype)) ;
	return(NULL) ;
    }

    for (from = controlstring, to = tmp_20k_buf; *from; ++from) {
	if (prefixed) {
	    prefixed = 0;
	    switch(*from) {
	      case '%':			/* literal percent */
		*to++ = '%';
		break;

	      case 's':			/* insert filename */
		UsedBigFile = 1;
		sstrcpy(&to, filename);
		break;

	      case '{':			/* insert requested MIME param */
		s = strindex(from, '}');
		if (!s) {
		    q_status_message1(1,2,4, 
			  "Ill-formed parameter reference in mailcap file: %s",
				      from);
		    break;
		}

		++from;
		*s = 0;
		for (parm = body->parameter ; parm ; parm = parm->next) {
		    if (!strucmp(from, parm->attribute)) {
			sstrcpy(&to, parm->value) ;
			break ;
		    }
		}

		dprint(2, (debugfile,
			   "mailcap_build_command: parameter %s = \"%s\"\n", 
			   from, parm ? parm->value : "(not found)")) ;
		*s = '}'; /* restore */
		from = s;
		break;

	      case 't':				/* insert MIME type/subtype */
		sstrcpy(&to, body_type_names(body->type));
		sstrcpy(&to, "/");
		sstrcpy(&to, body->subtype);
		break;

		/*
		 * %n and %F are used by metamail to support otherwise
		 * unrecognized multipart Content-Types.  Pine does
		 * not currently implement this feature
		 */
	      case 'n':
	      case 'F':  
		default:  
		dprint(2, (debugfile, 
		   "Ignoring unrecognized format code in mailcap file: %%%c\n",
		   *from));
		break;
	    }
	}
	else if (quoted){
	    quoted = 0;
	    *to++ = *from;
	}
	else if (*from == '%')
	  prefixed = 1;
#ifdef	LATER
	else if (*from == '\\')
	  quoted = 1;
#endif
	else
	  *to++ = *from; 
    }

    *to = '\0';

    /*
     * file not specified, tell the shell redirect it...
     */
    if (!UsedBigFile)
      sprintf(to, " < %s", filename);

    return(cpystr(tmp_20k_buf)) ;
} 
