#line 2 "mswin.h"
/*
 *
 * Program:	Operating system dependent routines - Microsoft Windows 3.1
 *
 *
 * Thomas Unger
 * Networks and Distributed Computing
 * Computing and Communications
 * University of Washington
 * Administration Builiding, AG-44
 * Seattle, Washington, 98195, USA
 * Internet: tunger@cac.washington.edu
 *
 * Please address all bugs and comments to "pine-bugs@cac.washington.edu"
 *
 * Copyright 1991-1994  University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee to the University of
 * Washington is hereby granted, provided that the above copyright notice
 * appears in all copies and that both the above copyright notice and this
 * permission notice appear in supporting documentation, and that the name
 * of the University of Washington not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  This software is made available "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Pine and Pico are trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior
 * written permission of the University of Washington.
 *
 */


#undef OWNRECT


/*
 * Mouse input events. 
 */
typedef struct {
	int		event;
	int		button;
	int		nRow;
	int		nColumn;
	unsigned long	flags;
} MEvent;


/*
 * Type of function expected by mswin_allowcopy and mswin_allowcopycut
 * and used in EditDoCopyData
 */
typedef	int (*getc_t)(int pos);


#define MEVENT_NONE		0x0000
#define MEVENT_MOUSEUP		0x0001
#define MEVENT_MOUSEDOWN	0x0002
#define MEVENT_ANY		0x0003

#define MEVENT_KEY_LBUTTON	0x0001		/* = MK_LBUTTON */
#define MEVENT_KEY_MBUTTON	0x0010		/* = MK_MBUTTON */
#define MEVENT_KEY_RBUTTON	0x0002		/* = MK_RBUTTON */
#define MEVENT_KEY_SHIFT	0x0004		/* = MK_SHIFT */
#define MEVENT_KEY_CONTROL	0x0008		/* = MK_CONTROL */


#define MSWIN_RANGE_START	0x7001
#define MSWIN_KEY_UP		0x7001
#define MSWIN_KEY_DOWN		0x7002
#define MSWIN_KEY_RIGHT		0x7003
#define MSWIN_KEY_LEFT		0x7004
#define MSWIN_KEY_PREVPAGE	0x7005
#define MSWIN_KEY_NEXTPAGE	0x7006
#define MSWIN_KEY_HOME		0x7007
#define MSWIN_KEY_END		0x7008
#define MSWIN_KEY_DELETE	0x7009
#define MSWIN_KEY_F1		0x700a
#define MSWIN_KEY_F2		0x700b
#define MSWIN_KEY_F3		0x700c
#define MSWIN_KEY_F4		0x700d
#define MSWIN_KEY_F5		0x700e
#define MSWIN_KEY_F6		0x700f
#define MSWIN_KEY_F7		0x7010
#define MSWIN_KEY_F8		0x7011
#define MSWIN_KEY_F9		0x7012
#define MSWIN_KEY_F10		0x7013
#define MSWIN_KEY_F11		0x7014
#define MSWIN_KEY_F12		0x7015
#define MSWIN_KEY_NODATA	0x7016
#define MSWIN_RANGE_END		0x7016

#define	MSWIN_PASTE_DISABLE	0
#define	MSWIN_PASTE_FULL	1
#define	MSWIN_PASTE_LINE	2




/*
 * functions from mswin.c
 */

#define assert(x)	if (!(x)) AssertFail (#x, __FILE__, __LINE__, 1);
void			AssertFail	(char *str, char *file, int line, int msgbox);


int		WinGetMEvent (MEvent * pMouse);
void		WinIdle (void);
int		mswin_setdebug (int debug, FILE *debugfile);
int		mswin_setresizecallback (int (*cb)());
int		mswin_clearresizecallback (int (*cb)());
int		mswin_sethelptext (char *pHelpText);
int		mswin_setclosetext (char *pCloseText);
int		mswin_setwindow (char *fontName, char *fontSize, 
			char *windowPosition);
int		mswin_getwindow (char *fontName, char *fontSize, 
			char *windowPosition);
int		mswin_charavail (void);
int		mswin_getc (void);
int		mswin_getc_fast (void);
int		mswin_open (void);
int		mswin_close (void);
int		mswin_showcursor (int show);
int		mswin_move (int row, int column);
int		mswin_getpos (int *row, int *column);
int		mswin_getscreensize (int *row, int *column);
int		mswin_putblock (char *str, int strLen);
int		mswin_puts (char *str);
int		mswin_putc (int c);
int		mswin_outc (char c);
int		mswin_delchar (void);
int		mswin_inschar (int c);
int		mswin_rev (int state);
int		mswin_getrevstate (void);
int		mswin_eeol (void);
int		mswin_eeop (void);
int		mswin_beep (void);
int		mswin_pause (int);
int		mswin_flush (void);
int		mswin_allowpaste (int);
int		mswin_allowcopycut (getc_t);
int		mswin_allowcopy (getc_t);
int		mswin_print_ready (char *docDesc);
int		mswin_print_done (void);
char *		mswin_print_error (int errorcode);
int		mswin_print_char (int c);
int		mswin_print_text (char *text);
int		pico_nfcolor(char *);
int		pico_nbcolor(char *);
int		pico_rfcolor(char *);
int		pico_rbcolor(char *);
int		mswin_fflush (FILE *f);
int		mswin_majorver();
int		mswin_minorver();
char	       *mswin_compilation_date();


/*
 * Memory management stuff, also from mswin.c
 */
typedef unsigned long		MemSize;
typedef void __far	      *	MemPtr;

#define MemAlloc(s)		_MemAlloc (s, __FILE__, __LINE__)
#define malloc(s)		_MemAlloc (s, __FILE__, __LINE__)
#define MemFree(b)		_MemFree (b, __FILE__, __LINE__)
#define free(b)			_MemFree (b, __FILE__, __LINE__)
#define MemRealloc(b,s)		_MemRealloc (b, s, __FILE__, __LINE__)
#define realloc(b,s)		_MemRealloc (b, s, __FILE__, __LINE__)
#define MEM_BLOCK_SIZE_MAX	0xff00

void		MemDebug (int debug, FILE *debugFile);
void __far *	_MemAlloc (MemSize size, char __far * file, int line);
int		_MemFree (void __far *block, char __far *file, int line);
void __far *	_MemRealloc (void __far *block, MemSize size, 
					char __far * file, int line);
MemSize		MemBlkSize (MemPtr block);


/*
 * Signals that are not defined by MS C
 */
#define SIGINT      2   /* Ctrl-C sequence */
#define SIGILL      4   /* illegal instruction - invalid function image */
#define SIGSEGV     11  /* segment violation */
#define SIGTERM     15  /* Software termination signal from kill */
#define SIGABRT     22  /* abnormal termination triggered by abort call */
#define SIGWINCH    28	/* Change in window size. */


#define fflush	mswin_fflush

