/*
 *	Program Name:	imap server (see rfc1064)
 *	Module:         imaputil.c
 *
 *	Author(s):	William J. Yeager
 *			Symbolic Systems Resources Group
 *			Knowledge Systems Laboratory
 *			Departments of Computer Science and Medicine
 *			Stanford University
 *			Stanford, CA  94305
 *
 *	Date:		December 29th, MCMLXXXVIII
 *
 *	Sponsorship:	This work was supported by the Biomedical Research
 *			Technology Program of the National Institutes of Health
 *			under grant number RR-00785.
 *
 *      Copyright (c) 1988 by The Leland Stanford Junior University.
 *
 *  "This program may be distributed without restriction for non-commercial 
 *   use. Any sale or use of this program or adaptations thereof for commercial
 *   purposes is prohibited except under license from the Stanford Office of
 *   Technology Licensing."
 *
 */
/*
 *	utilities required by imap.
 *
 *				Bill Yeager -- Aug. 31, 1987
 *
 *	tod()			returns time of day string ptr.
 */
#include <sys/time.h>
#include "sin.h"
/*
 *
 * Copyright (c) 1988 by The Board of Trustees of the Leland Stanford Junior
 * University.
 *
 * This work was done in the Knowledge Systems Laboratory and supported by the
 * SUMEX-AIM resource grant (RR-00785) from the Biomedical Research Technology
 * Program of the National Institutes of Health.
 *
 * Author: William J. Yeager
 *
 */

#include "requests.h"
#include <ctype.h>
#include <stdio.h>
int timezonesecs,daylight;
char *tod()
  {
    char *ctime();
    struct timeval tp;
    struct timezone tzp;

    gettimeofday(&tp,&tzp);
    timezonesecs = tzp.tz_minuteswest * 60;
    daylight = tzp.tz_dsttime;
    return(ctime(&tp.tv_sec));
  }
getitime()
  {
    struct timeval tp;
    struct timezone tzp;

    gettimeofday(&tp,&tzp);
    return(tp.tv_sec);
  }
/*
 *	case independent compare.
 */
CVU(x)
  char x;
  {
    if (islower(x)) return(x - ' ');
    else
	return(x);
  }
cmdmatch(cmd,str2,n)
  register char *cmd,*str2;
  register n;
  {
    register char c,d;
    register i;

    for (i=0; i<n; ++i) {
	c = *cmd++;
	d = *str2++;
	if (d == 0) return(0);			/* too short */
        if (CVU(c) != CVU(d)) return(0);	/* mismatch */
      }
    return(1);					/* match */
  }
strEqualCI(str1,str2)
  register char *str1,*str2;
  {
    register char c,d;

    while (1) {
	c = *str1++;
	d = *str2++;
	if (c == 0 || d == 0) break;
        if (CVU(c) != CVU(d)) return(0);	/* mismatch */
      }
    if (c == 0 && d == 0) return(1);
    return(0);
  }
lexstrEqualCI(str1,str2)
  register char *str1,*str2;
  {
    register char c,d,c1,c2;

    while (1) {
	c = *str1++;
	d = *str2++;
	if (c == 0 || d == 0) break;
	c1 = CVU(c); c2 = CVU(d);
        if (c1 == c2) continue;		/* str1 STILL = str2 */
	if (c1 < c2) return(-1);	/* str1 < str2 */
	else
	    return(1);			/* str1 > str2 */
      }
    if (c == 0 && d == 0) return(0);
    if (c == 0 && d != 0) return(-1);		/* first shorter */
    return(1);					/* first longer */
  }
/*
 *	looks for strings matching exaclty for n
 *	chars (case independent)
 */
nstrEqualCI(str1,str2,n)
  register char *str1,*str2;
  register n;
  {
    register char c,d;

    if (n <= 0) return(0);
    while (1) {
	c = *str1++;
	d = *str2++;
        n -= 1;
	if (c == 0 || d == 0) return(0);
        if (CVU(c) != CVU(d)) return(0);	/* mismatch */
	if (n == 0) break;			/* matched for n */
      }
    return(1);
  }
/*
 *  skip over leading skippers
 */
skipover(str,skipper)
  register char *str;
  register skipper;
  {
    register char c;
    while (c = *str) {
	if (c != skipper) break;
	++str;
      }
    return((int)str);
  }
    
validendchar(c)
  register c;
  {
    if (c != SP && c != LF) return(0);
    return(1);
  }
backoverSPCRLF(sob,nulled)
  SINOBJ *sob;
  char *nulled;
  {
    register adj;

    if (sob->breakchar == SP) adj = 1;
    else 
      if (sob->breakchar == LF) adj = 2;
      else
	  adj = 0;
    sob->sptr -= adj;
    if (nulled) *nulled = *sob->sptr;		/* return changed char */
    return(adj);
  }
validcommandend(ec)
  register char *ec;
  {
    if (*ec++ != CR) return(0);
    if (*ec != LF) return(0);
    return(1);
  }
/*
 *	append src to dst without NULL ending.
 */
charnappend(dst,src,n)
  register char *src,*dst;
  register n;
  {
    if (n <= 0) return;
    while (n--) *dst++ = *src++;
  }
sansnilcopy(dst,src)
  register char *dst,*src;
  {
    register char c;

    while (c = *src++) *dst++ = c;
    return((int)dst);
  }
char *bytecopy(dst,src,n)
  register char *dst,*src;
  register n;
  {
    while (n-- > 0) *dst++ = *src++;
    return(dst);
  }
/*
 *	Look for SP or CRLF and set a NULL.
 *	return pointer to SP+1,LF or after the NULL.
 */
setnull(ptr,n,usen)
  register char *ptr;
  register n;
  {
    register i;
    char *next;

    if (usen) {
	ptr += n;
	*ptr = 0;
	return((int)ptr+1);
      }
    for (i=0; i<n; ++i,++ptr) {
	if (*ptr == SP) {
	    *ptr = 0;
	    return((int)ptr+1);
	  }
	next = ptr+1;
	if (*ptr == CR && *next == LF) {
	    *ptr = 0;
	    return((int)ptr+1);
	  }
      }
    /*
     *  Hmmm... Nothing found at tail
     */
    --ptr;
    *ptr = 0;
    return((int)ptr);
  }
/*
 *	Find char in string of given length
 */
findcharn(cp,c,len)
  register char *cp;
  int c,len;
  {
    while (len-- > 0)
	if (*cp == c) return((int)cp);
	else	
	    ++cp;
    return(0);
  }
 

/*
 *	clear leading SP and HTAB
 */
char *clearwhitespace(line)
  register char *line;
  {
    register char c;

    while (1) {
	c = *line;
	if (c == HTAB || c == SP) ++line;
	else
	    break;
    }
    return(line);
  }
/*
 * clear white space and decrement the passed length
 */
char *decrwhitespace(line,len)
  register char *line;
  register int *len;
  {
    register char c;

    while (1) {
	c = *line;
	if (c == HTAB || c == SP) {
	   ++line;
	   --*len;
	 }
	else
	    break;
    }
    return(line);
  }

/*
 *	Copy until a CH or maxc chars, whichever comes first.
 *	Return pointer to CH or last char seen.
 */
char *ncopytillCH(fpos,dst,maxc,ch)
  register char *fpos,
		*dst;
  register maxc;
  register char ch;
  {
    register char c;
    register nc= 0;
    while (1) {
	c = *fpos;
	++nc;
	if (nc == maxc) break;			  /* too long */
	if (c == ch) break;			  /* done */
	*dst++ = c;
	++fpos;
    }
    *dst = '\0';				  /* successor of CH */
    return(fpos);				  /* points to CH */
  }
strcpytolowercase(dst,src,maxlen)
  register char *dst,*src;
  register maxlen;
{
  register char c;

  while (c = *src++) {
    if (isupper(c)) *dst++ = c + ' ';
    if (--maxlen <= 0) break;
  }
  if (maxlen >= 1) *dst = '\0';
}
makelowercase(str,maxlen)
  register char *str;
{
  register char c;

  while (c = *str) {
    if (isupper(c)) *str = c + ' ';
    ++str;
    if (--maxlen <= 0) break;
  }
}
/*
 *  Clear trailing SP HTAB CR LF FF
 *  and return a pointer to the first char not in the above list
 */
char *cleartrailingwhitespace(str)
  register char *str;
{
  register len= strlen(str);

  if (len == 0) return(str);
  str += len - 1;
  while (--len > 0)				  /* if final char, break */
    if (!isspace(*str)) return(str);
    else
      --str;
  return(str);
}
/*
 *  Copy n chars into an output buffer, and terminate
 *  it.
 */
StringCopy(obuf,src,len)
  register char *obuf,*src;
  register len;
{
  while (len-- > 0) *obuf++ = *src++;
  *obuf = '\0';
  return((int)obuf);
}

