#include <windows.h>
#include <winsock.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <stdarg.h>
#include <io.h>

/* Useful constants */

#define NIL 0
#define T 1


/* Size of I/O buffers */

#define BUFSIZE 1024


/* Global data */

short port;
char *program;


/* Stream shared by various threads */

typedef struct {
  SOCKET sock;			/* connected socket */
  HANDLE daemon;		/* daemon's thread */
  HANDLE ithread;		/* input thread */
  HANDLE othread;		/* output thread */
  HANDLE ihdl;			/* input from daemon */
  HANDLE ohdl;			/* output to daemon */
} STREAM;


/* Function prototypes */

void main(int argc,char *argv[]);
void server (PVOID data);
void ithread (LPVOID data);
void othread (LPVOID data);

/* Main program
 * Accepts: argument count
 *	    argument vector
 */

void main (int argc,char *argv[])
{
  SOCKET lsock,client;
  struct sockaddr_in fromsock,sock;
  WSADATA wd;
  SECURITY_ATTRIBUTES sa;
  HANDLE hdl;
  DWORD id;
  int i;
  if (argc != 3) {
    puts ("Usage: inetlisn port server_program");
    return;
  }
  port = (short) atoi (argv[1]);
  program = argv[2];
				/* start up Winsock */
  if (i = WSAStartup (MAKEWORD (1,1),&wd)) {
    printf ("WSAStartup failure %d\n",i);
    return;
  }
				/* set up a socket */
  if ((lsock = socket (PF_INET,SOCK_STREAM,0)) == INVALID_SOCKET) {
    printf ("socket failure %d\n",WSAGetLastError ());
    return;
  }
  sock.sin_family = PF_INET;
  sock.sin_port = htons (port);
  sock.sin_addr.s_addr = 0;
				/* bind the socket */
  if (bind (lsock,(struct sockaddr *) &sock,sizeof (sock))) {
    printf ("bind failure %d\n",WSAGetLastError ());
    return;
  }
  if (listen (lsock,1)) {	/* listen for connection */
    printf ("listen failure %d",WSAGetLastError ());
    return;
  }
  sa.nLength = sizeof (sa);	/* use default ACL w/ no inheritance */
  sa.lpSecurityDescriptor = NIL;
  sa.bInheritHandle = NIL;
  while (T) {
    i = sizeof (fromsock);
    if ((client = accept (lsock,(struct sockaddr *) &fromsock,&i)) == 
	INVALID_SOCKET) {
      printf ("accept failure %d\n",WSAGetLastError ());
      break;
    }
    if (!(hdl = CreateThread (&sa,0,(LPTHREAD_START_ROUTINE) server,
			      (LPVOID) client,0,&id)))
      printf ("CreateThread failure %d\n",GetLastError());
    CloseHandle (hdl);
  }
}

/* Server thread
 * Accepts: open TCP/IP socket
 */

void server (PVOID data)
{
  char cmdline[1024];
  SECURITY_ATTRIBUTES sa;
  PROCESS_INFORMATION pi;
  STARTUPINFO si;
  DWORD id;
  HANDLE hdls[3];
  HANDLE ipipe = NIL;
  HANDLE opipe = NIL;
  SOCKET sock = (SOCKET) data;
  STREAM *stream = (STREAM *) malloc (sizeof (STREAM));
  struct hostent *hn;
  struct sockaddr_in from;
  int fromlen = sizeof (from);
  if (!stream) return;		/* couldn't get memory for stream */
				/* initialize stream */
  memset (stream,'\0',sizeof (STREAM));
  sa.nLength = sizeof (sa);	/* use default ACL */
  sa.lpSecurityDescriptor = NIL;
  sa.bInheritHandle = T;	/* inherit handles */
  if (!CreatePipe (&stream->ihdl,&ipipe,&sa,0))
    printf ("Input pipe create failure %d\n",GetLastError ());
  else if (!CreatePipe (&opipe,&stream->ohdl,&sa,0))
    printf ("Output pipe create failure %d\n",GetLastError ());
  else {			/* instantiate daemon */
    si.cb = sizeof (STARTUPINFO);
    si.lpReserved = NULL;
    si.lpTitle = NULL;
    si.lpDesktop = NULL;
    si.dwX = si.dwY = si.dwXSize = si.dwYSize = 0;
    si.wShowWindow = SW_SHOW;
    si.lpReserved2 = NULL;
    si.cbReserved2 = 0;
    si.dwFlags = STARTF_USESTDHANDLES;
    si.hStdInput  = opipe;
    si.hStdOutput = ipipe;
				/* errors go to same place as output */
    DuplicateHandle (GetCurrentProcess (),ipipe,
		     GetCurrentProcess (),&si.hStdError,
		     DUPLICATE_SAME_ACCESS,T,0);
    if (getpeername (sock,(struct sockaddr *) &from,&fromlen))
      sprintf (cmdline,"%s UNKNOWN -1",program);
    else sprintf (cmdline,"%s %s %d",program,
		  (hn = gethostbyaddr ((char *) &from.sin_addr,
				       sizeof (struct in_addr),
				       from.sin_family)) ?
		  hn->h_name : inet_ntoa (from.sin_addr),
		  ntohs (from.sin_port));
    if (!CreateProcess (NIL,cmdline,NIL,NIL,T,0,NIL,NIL,&si,&pi))
      printf ("Create process failure %d\n",GetLastError());
    else {			/* got daemon, note its process */
      stream->daemon = pi.hProcess;
      CloseHandle (pi.hThread);
    } 
    CloseHandle (ipipe);	/* flush our copy of pipes */
    CloseHandle (opipe);
    ipipe = opipe = NIL;
    if (stream->daemon) {	/* only if started daemon */
      sa.bInheritHandle = NIL;	/* no inheritance */
      stream->sock = sock;	/* note client socket */
      if (!(stream->ithread =	/* create threads */
	    CreateThread (&sa,0,(LPTHREAD_START_ROUTINE) ithread,
			  (LPVOID) stream,0,&id))) {
	printf ("Input thread create failure %d\n",GetLastError ());
	stream->sock = INVALID_SOCKET;
      }
      else if (!(stream->othread =
		 CreateThread (&sa,0,(LPTHREAD_START_ROUTINE) othread,
			       (LPVOID) stream,0,&id))) {
	printf ("Output thread create failure %d\n",GetLastError ());
	stream->sock = INVALID_SOCKET;
	TerminateThread (stream->ithread,0);
      }
      else {			/* wait for completion */
	hdls[0] = stream->ithread;
	hdls[1] = stream->othread;
	hdls[2] = stream->daemon;
	switch (WaitForMultipleObjects (3,hdls,NIL,0xffffffff)-WAIT_OBJECT_0) {
	case 0:
	  TerminateThread (stream->othread,0);
	  TerminateProcess (stream->daemon,1);
	  break;
	case 1:
	  TerminateThread (stream->ithread,0);
	  TerminateProcess (stream->daemon,1);
	  break;
	case 2:
	  TerminateThread (stream->othread,0);
	  TerminateThread (stream->ithread,0);
	  break;
	default:
	  printf ("Error %d in WaitForMultipleObjects()\n",GetLastError ());
	  break;
	}
      }
    }
  }
				/* clean up */
  if (ipipe) CloseHandle (ipipe);
  if (opipe) CloseHandle (opipe);
  if (stream->sock) closesocket (stream->sock);
  if (stream->daemon) CloseHandle (stream->daemon);
  if (stream->ithread) CloseHandle (stream->ithread);
  if (stream->othread) CloseHandle (stream->othread);
  if (stream->ihdl) CloseHandle (stream->ihdl);
  if (stream->ohdl) CloseHandle (stream->ohdl);
  free (stream);
  ExitThread (0);
}

/* Input thread
 * Accepts: stream
 */

void ithread (LPVOID data)
{
  STREAM *stream = data;
  BYTE buf[BUFSIZE];
  DWORD i;
  while (ReadFile (stream->ihdl,buf,BUFSIZE,&i,NIL) &&
	 (send (stream->sock,buf,i,0) > 0));
  switch (GetLastError ()) {
  case ERROR_BROKEN_PIPE:
  case WSAECONNABORTED:
    break;
  default:
    printf ("ithread error %ld",GetLastError());
  }
}


/* Output thread
 * Accepts: stream
 */

void othread (LPVOID data)
{
  STREAM *stream = data;
  BYTE buf[1];
  DWORD i;
  while ((i = recv (stream->sock,buf,1,0) > 0) &&
	 WriteFile (stream->ohdl,buf,1,&i,NIL));
}
