/*
 * Program:	Distributed Electronic Mail Manager (AddressBookCell class)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	22 March 1990
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


#import "MailManager.h"

@implementation AddressBookCell

// Create a new AddressBookCell

+ new
{
  self = [super newTextCell:"(*) *"];
  [self setFont:defaultfont];	// set up default font and left-aligned
  [self setAlignment:NX_LEFTALIGNED];
  return self;
}


// Clean up

- free
{
				// free up strings
  if (nickName) fs_give ((void **) &nickName);
  if (fullName) fs_give ((void **) &fullName);
  if (address) fs_give ((void **) &address);
  if (extra) fs_give ((void **) &extra);
  return [super free];
}

// Set its fields

- setNickName:(char *) newNickName fullName:(char *) newFullName
 address:(char *) newAddress extra:(char *) newExtra;
{
  char tmp[TMPLEN];
				// copy the arguments
  nickName = (const char *) cpystr (newNickName);
  fullName = (const char *) cpystr (newFullName);
  address = (const char *) cpystr (newAddress);
  extra = (const char *) cpystr (newExtra);
				// generate title
  sprintf (tmp,"(%s) %s",nickName,fullName);
  [self setStringValue:(const char *) tmp];
  return self;
}


// Return nickname field

- (const char *) nickName
{
  return nickName;
}


// Return name field

- (const char *) fullName
{
  return fullName;
}


// Return address field

- (const char *) address
{
  return address;
}


// Return extra field

- (const char *) extra
{
  return extra;
}


@end
