/*
 * Program:	Easy Distributed Electronic Mail Manager (EasyMail object)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	27 July 1989
 * Last Edited:	22 February 2001
 *
 * The EasyMail software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


#import "EasyMail.h"

@implementation EasyMail

// Initialize EasyMail defaults.  Can't use "initialize" factory method.

+ new
{
  self = [super new];		// instantiate ourselves
				// set all our options
  lockedopen = lockedread = autoread = autoopen = autologin = autoexpunge = T;
				// clear all invalid options
  autozoom = closefinalkill = debug = nolinebreaking = nopersonal = NIL;
  return self;			// return ourselves
}


// Save our preferences (subset of MailManager preferences)

- savePreferences:sender
{
  NXDefaultsVector defaults = {
    {"CheckInterval",(char *) [checkInterval stringValue]},
    {"DefaultCcList",(char *) [defaultCcList stringValue]},
    {"DomainName",(char *) [prefDomainName stringValue]},
    {"LiteralDisplay",[literalDisplay intValue] ? "YES" : "NO"},
    {"MTPServer",(char *) [prefMTPServer stringValue]},
    {"OutBox",(char *) [outBox stringValue]},
    {"PersonalName",(char *) [prefPersonalName stringValue]},
    {"Repository",(char *) [prefRepository stringValue]},
    {"UserName",(char *) [prefUserName stringValue]},
    {NIL}
  };
				// write the new default preferences
  NXWriteDefaults ([NXApp appName],defaults);
  return self;
}

@end
