/* File containing UBBS 3.0 structures

Mofied (continuously!)
OVERVIEW to Userrecords and new filebase format.
(User is implemented fully.  Filebase will be shortly)

The USERBASE is a flat-file-fixed-record base, but the SIZE of each record
must be computed from UBBS.DAT.
UBBS.DAT contains new parameters, including a NUMBER-OF-CONFERENCES
and a NUMBER-OF-DESCRIPTION-LINES field.

The USER RECORD for a given user then consists of TWO parts:

1) the FIXED struct userrecord (below).   Note does NOT contain conference data
2) the FIXED (but length depends on NUMBER-OF-CONFERENCES) extra-record.
   The second record consists of 4 arrays (or strings):


   1) the Lastmsg array.  An array of NUMBER-OF-CONFERENCE longs (32bits each)
   2) the Conference array. A packed array, NUMBER-OF-CONFERENCES/8+1 bytes,
         with each bit being permission to access a conference.
   3) the Expiredconferenced array.  Where the user goes when he expires.
   4) the UserScanConference array.  Which conferences are set to be scanned.

   Thus, the length of the extended record is: (in bytes)

   NUMBER-OF-CONFERENCES*4 (the size of a long)+
      3*(NUMBER-OF-CONFERENCES/8+1)

   Therefore EVERY user record read consists of first reading the fixed
   user structure, and then the extended record.


The Filebase will (shortly) be similar, with the descrip array (currently
450 characters, located at the END of the file structure), being externalized
in a similar way.

Also -- the filebase contains a new file, the .NDX base, which contains among
other things, the bit-vector arrays that zippy search uses to do the blazingly
fast search-by-text (the old Z search).
This is a database file, and does NOT have a discernable structure.
We will provide libraries (C) and utilities for those that wish to
manipulate this additional file directly.

COMMENTS are invited.  If you query some field, or want to see anything
else incorporated -- let us know!

10/3/93.  cdb.

*/

#define VERSION "300"

#define MSGLINES 150

struct   bbslistrecord
{
   unsigned char  name[41];            // bbs name for BB command
   unsigned char  phonenum[14];
   unsigned char  software[11];
   unsigned char  maxbps[11];
   unsigned char  descrip[44];         // added for description of the bbs!
};

struct   pcb12msgrec
{
   unsigned char  statflag;
   unsigned char  msgnum[7];
   unsigned char  msgdate[8];
   unsigned char  msgtime[5];
   unsigned char  to[25];
   unsigned char  from[25];
   unsigned char  subject[25];
   unsigned char  msgpass[12];
   unsigned char  referto[8];
   unsigned char  records[6];
   unsigned char  active;
   unsigned short conf;
   unsigned char  reserved[3];
};

struct nodeflags
{
   unsigned short exittodos: 1;        // Node is set to exit to dos
   unsigned short pagingsysop: 1;      // node is paging sysop
   unsigned short indoor: 1;           // node is executing a door
   unsigned short logoffflag: 2;       // values 0,1,2
   unsigned short nodepage: 1;         // node is being paged or paging
   unsigned short online:   1;         // set when node is online
	unsigned short bbsdown:  1;
   unsigned short permautopost: 1;
};

struct   noderecord
{
   struct   nodeflags f;               // ALL flags are 16-bit bitfield recs
   unsigned char  status;
   unsigned char  nodebeeps;
   unsigned char  lasteventdate[9];
   unsigned char  lasteventtime[6];
   unsigned char  nodeuser[26];
   unsigned char  nodedoor[41];
   unsigned char  nodepw[13];
            short lasteventnumber;
            long  lastnodetime;       // last time stamp
   unsigned short xfertime;           // Time to finish xfers (seconds)
            short groupsummons;        // page flag. contains node paged FROM
            short broadcast;
   unsigned char  msg[5][70];
            short doornumber;
            short lastconf;
  				char  chatcolor;
            char  reserved[32];
};

struct   fileflags
{
   unsigned short deleteflag  :  1;    // file is Killed
   unsigned short freefile    :  1;    // file is free (no dl ratio affect)
   unsigned short invisible   :  1;    // file cannot be listed but is there
   unsigned short killafterdl :  1;    // one download only
   unsigned short alwaysnew   :  1;    // always show in a new file scan
   unsigned short trulyfree   :  1;    // permit to dl even if no time left
   unsigned short rr          :  1;    // generate msgto sysop when dled.
   unsigned short offline     :  1;    // file is offline
};

struct   filerecord
{
   struct fileflags  f;                // 16-bits of field flags
   unsigned char  file[13];            // filename
   unsigned long  filesize;            // size of file (32 bit)
   unsigned char  uploadedby[26];      // user who uploaded file
            short timesdled;           // # times downloaded
   unsigned char  filelocation[41];    // full path to file
            long  lastdl;              // unix date&time of last download
            long  dateoful;            // unix date&time of upload.
   unsigned char  id[5];
   unsigned char  reserved[16];        // reserved
   unsigned char  descrip[450];        // fixed length 10 lines (for now).
};                                     // descrip will be sizeable soon!

struct   dirinfo
{
   char  dirid[5];
   short dirsec;
};

struct   confflags
{
   unsigned short allowalias  :  1;
   unsigned short allowesc    :  1;
   unsigned short echoconf    :  1;
   unsigned short allowupload :  1;
   unsigned short network     :  4;    // Network # this conference
   unsigned short readonly    :  1;    // conference will not permit E,R
   unsigned short warning     :  1;    // conference will show WARNING file
   unsigned short netmail     :  1;
};

struct   confrecord
{
   struct confflags  f;                // 16-bit field
   unsigned char  confname[51];        // increased from 41 chars
            short maxdir;
   unsigned char  msgsfile[41];
   unsigned char  mainmenufile[41];
   unsigned char  sysopmenufile[41];
   unsigned char  newsfile[41];
   unsigned char  uploaddir[31];
            short defaultfiledir;
   unsigned char  doormenu[41];
   unsigned char  doorlst[41];
   unsigned char  bltmenu[41];
   unsigned char  bltlst[41];
   unsigned char  quesmenu[41];
   unsigned char  queslst[41];
   unsigned char  dirmenu[41];
   unsigned char  votingmenu[41];
   unsigned char  votinglst[41];
   unsigned char  warningfile[41];     // warning file path
   unsigned char  tag[41];             // TAG field. used in networks for
                                       // something like an AREAS.BBS. Use
                                       // may vary with network type.
   struct dirinfo dir[300];
};

struct   userflags
{
   unsigned short expert      :  1;
   unsigned short deleteuser  :  1;
   unsigned short clearscreen :  1;
   unsigned short netstatus   :  1;
   unsigned short autopage    :  2;    // 0='N' 1='I' 2='V'
   unsigned short fsdefault   :  2;    // 0='N' 1='A' 2='Y'
   unsigned short abortalways :  1;    // user can ALWAYS abort displayfiles
   unsigned short master      :  1;
   unsigned short noautopost  :  1;    // 1=disallow autoposting
};

struct   userrecord
{
   struct userflags  f;                // 16-bit flag
   unsigned char  name[26];
   unsigned char  userpass[21];
            short security;
   unsigned char  address[35];         // full 35 chars for address!
   unsigned char  city[35];            // 35 more for city/state field
   unsigned char  mothersname[26];     // mothers maiden name (for security)

            long  lastdate;            // last date on UNIX style long (32bits)
            long  newfchk;             // its how many seconds since 1/1/70
   unsigned short downloads;           //     note - 'lasttime' included
   unsigned short uploads;
            short elapsedmins;
   unsigned char  page;
   unsigned char  voice[14];
   unsigned char  data[14];
   unsigned char  protocol;
            short timeson;
   unsigned short doorsent;
   unsigned short msgsent;
            long  expiredate;          // also unix-style date (32bit)
            short expiresec;
            long  birthdate;
   unsigned char  sysopcomment[61];
   unsigned char  fileforuser[41];
            long  kuploaded;
            long  kdownloaded;
            short timestored;
            long  kbytesdled;
            long	credit;
   unsigned char logonmacro[28];       // ubbs macro to execute at login
   unsigned char handle[26];
            long timemask;    
            short lastnode;
            char  compdefault[4];
   unsigned  char reserved[122];         // reserved for future expansion
};

struct doorflags
{
   unsigned short doorwatch :1;
   unsigned short singleuser :1;       // set to have UBBS handle doors that
   unsigned short inuse:1;
   unsigned short tempunavailable:1;
};

struct   doorrecord
{
   struct   doorflags f;
   unsigned char  doorname[21];
   unsigned char  doorfile[41];
            short doorsec;
   unsigned char  doorpass[21];
   unsigned char  doortype[11];
   unsigned char  droppath[41];
            long  timesopened;
};


struct   bltrecord
{
   unsigned char  bltfile[41];
   unsigned char  bltpass[21];
            short bltsec;
};

struct   languagerecord
{
   unsigned char  languagedir[41];     // language file. For multixlingual ubbs
   unsigned char  languagename[41];
};

struct   quesrecord
{
   unsigned char  quesname[21];
   unsigned char  quesfile[41];
   unsigned char  ansfile[41];
            short quessec;
   unsigned char  quespass[21];
};

struct   limitsrecord
{
   short limitssec;
   short limitsmins;
   short kbytesperup;
   short filesperup;
   short doornumber;
   long  kbytesperday;
   short todayxon;                     // number of times online today
};

struct   nouprecord
{
   unsigned char  file[41];
            short upsecurity;
};

struct   comprecord
{
   unsigned char  ext[4];
   unsigned char  viewform[51];
   unsigned char  addform[51];
   unsigned char  getform[51];
   unsigned char  testform[51];
   unsigned char  badtext[16];
};

struct   protrecord
{
   unsigned char  letter;
   unsigned char  batch;
   unsigned char  uload[41];
   unsigned char  dload[41];
   unsigned char  protname[21];
            short atsign;
            short dszlog;
};


struct msgflags
{
   unsigned short active:     1;
   unsigned short private:    1;
   unsigned short rr:         1;
   unsigned short perm:       1;
   unsigned short echoflag:   1;
   unsigned short attached:   1;
   unsigned short hasreplies: 1;

};

struct   msgindexrecord
{
   struct   msgflags f;
            long  record;
   unsigned char  to[72];                 // TO field now 72chars!
   unsigned char  from[72];               // FROM also 72 for internet.
   unsigned char  subject[26];
};

struct   votingrecord
{
   unsigned char  votingname[46];
   unsigned char  datafile[41];
            short votingsec;
   unsigned char  votingpass[21];
   unsigned char  choices[18][71];
};

struct msgrecord
{
   struct   msgflags f;
            long  msgnum;
   unsigned char  from[72];
   unsigned char  to[72];
   unsigned char  msgdate[9],msgtime[6];
   unsigned char  subject[26];
   unsigned char  msgpass[21];
            long  referto;
   unsigned char  datercvd[9],timercvd[6]; // no point in making these longs!
   unsigned char  records;
   unsigned char  reserved[24];           // 256 byte msg record
};

struct   votedrecord
{
   unsigned char  name[26];
   unsigned char  choice;
};

struct filearray
{
   unsigned char  file[13];
            long  record;
};

struct chatrecord
{
   char  p1;
   char  p2;
   char  p3;
   char  color;
};

struct sysflags
{
	unsigned short runmacro: 1;
   unsigned short mainusinghandle : 1;
};

struct ubbssysrecord
{
			   long  modembaud;
			   long  baud;
			   short eight_bit;
   unsigned char  time_on[9];
   unsigned char  date_on[9];
			   short kbytesperup;
			   short filesperup;
			   long  kbytesperday;
			   short grafix;
			   long  userpos;
   			short local_user;
			   short confnum;
   unsigned char  prevdate[9];
   unsigned char  prevtime[6];
			   short disable_remote;
			   short available;
			   long  logon_time;
			   long  secs_session;
			   long  elapsedsecs;
			   long  eventadjust;
   unsigned char  markedfiles[99][13];
   unsigned char  markednum;
   unsigned char  oldfchk[9];
			   short triedtopage;
            short oldsecurity;
   struct   sysflags f;       

	unsigned char  username[26];
   unsigned char  userhandle[26];
   unsigned char  usermixed[26];
   unsigned char  mixedfirst[26];
   
// from here on down, not reread in DOORS

   unsigned char  bbsname[32];
   unsigned char  sysopname[27];
   unsigned char  currenttime[6];
   unsigned char  nodepage;
   unsigned char  nodebeeps;
			   long  timeused;
   unsigned char  eventtime[6];
			   short eventactive;
			   short port;
			   long  timeremaining;
			   short node;
   long           userrecsize;
   long           filerecsize;
            char  reserved[64];  // 64 bytes to grow in    
};

