/***************************************************************************\
*																									 *
*    Multimedia Mixer Software Development Kit Include File						 *
* 																									 *
*    Copyright (c) MediaVision Corporation 1991. All rights reserved			 *
* 																									 *
*																									 *
\***************************************************************************/


///////////////////////////////////////////////////////////////////////////
// MIXERSTATE: 
// this structure maintains the current state of a mixer
//

#define MIXSTATEVER				0x101				
#define MAX_INPUTS	8					// Version 1 maximum inputs
#define MAX_OUTPUTS	2					// Version 1 maximum outputs


typedef struct linestatus_tag {
   WORD  wNumber;   		   	  // This line's ordinal number in the mixer
   WORD  wNumSoftPatches;		  // number of software patches available
   WORD  wPatchNumber;	  		  // the number of the patch currently in use
   WORD  wNumChannels;		     // number of channels (1=mono, 2=stereo)
   WORD  wDeviceNumber; 	     // range (0-xxxGetNumDevs()) if appropriate
	WORD	wReserved;
   DWORD dwDeviceType;	  		  // type of device patched to the input
   DWORD dwConnections;	  		  // show lines connected
   DWORD dwSupport;	           // supported functionality (MIXLINEINFO)
   DWORD	dwAssociation;	 		  // HIWORD=type, LOWORD=device

	DWORD dwVolume;  				 	// volume control
	DWORD dwAutoLevel;        		// Auto Level Control
	DWORD dwBMT;	          		// B-M-T equalization
	DWORD dwCrossover;          	// crossover
	DWORD dwLoudness;		         // loudness equalization
	DWORD dwMute;		          	// silence switch
	DWORD dwReverb;	           	// reverb
	DWORD dwStereoEnhance;       	// stereo enhance
	DWORD dwCustom1;		        	// custom effect #1
	DWORD dwCustom2;		        	// custom effect #2
	DWORD dwCustom3;		        	// custom effect #3
	DWORD dwConnectionsPossible;
	DWORD dwReserved2;		          	

   char  szIOname[MAXPNAMELEN]; // line name 
   char  szPname[MAXPNAMELEN];  // patch name
	} LINESTATUS;
typedef LINESTATUS FAR *LPLINESTATUS;

/// The MIXERSTATE structure is subject to change.
/// Drivers should detect version number changes and
/// act accordingly.
///


typedef struct MVmixer_tag {
	WORD	wSize;
	WORD	wVersion;
   WORD  wMid;                 					  // KFN 7/91 manufacturer id
   WORD  wPid;                					  // KFN 7/91 product id
	WORD	wMixerNumber;
	WORD	wNumInputs;									  // define's array sizes
	WORD	wNumOutputs;

	LINESTATUS LineInStatus[MAX_INPUTS];
	LINESTATUS LineOutStatus[MAX_OUTPUTS];

} MIXERSTATE;
typedef MIXERSTATE FAR *LPMIXERSTATE;

// MIXERSTATE NOTE: 
// Version 1.01: added manufacturer and product ID numbers for use in 
// 				  identifying creator of mixer state when stored in a file.


///////////////////////////////////////////////////////////////////////////


typedef WORD 	HMIXER;
typedef HMIXER FAR *LPHMIXER;


#define BASS(dwValue)	(LOBYTE(HIWORD(dwValue)))
#define MIDR(dwValue)	(HIBYTE(LOWORD(dwValue)))
#define TREB(dwValue)	(LOBYTE(LOWORD(dwValue)))

typedef struct mixercaps_tag {
    WORD    wMid;                  // manufacturer id
    WORD    wPid;                  // product id
    VERSION vDriverVersion;        // version of the driver
    char    szPname[MAXPNAMELEN];  // product name (NULL terminated string)
    WORD    wInputs;	           	  // number of inputs  supported.
    WORD    wOutputs;	           // number of outputs supported.
    WORD    wNumInputPatches;	     // number of input patches supported.
    WORD    wNumOutputPatches;	  // number of output patches supported.
    DWORD   dwSupport;	           // supported functionality
    DWORD   dwReserved;	 
} MIXERCAPS;
typedef MIXERCAPS FAR *LPMIXERCAPS;

#define MIXERCAP_SOFTPATCHSWITCH		0x0001	// supports some software patching
#define MIXERCAP_MANUALPATCHSWITCH	0x0002	// supports some manual   patching

typedef struct mixerlineinfo_tag {
    WORD    wNumber;   		   // This line's ordinal number in the mixer
    DWORD   dwDeviceType;	   // type of device patched to the input
    WORD    wNumSoftPatches;	// number of software patches available
    WORD    wPatchNumber;	   // number of device currently patched 
    WORD    wNumChannels;	   // number of channels on input 
									   // (1=mono, 2=stereo)
    DWORD   dwSupport;	           // supported functionality (MIXLINEINFO)
    DWORD	dwAssociation;	 		  // HIWORD=type, LOWORD=device
    DWORD   dwConnectionsPossible; // lines connectable to
    char    szIOname[MAXPNAMELEN]; // input name (eg "Aux Connector"
    char    szPname[MAXPNAMELEN];  // patch name (eg "Casio Synthesizer")
} MIXERLINEINFO;
typedef MIXERLINEINFO FAR *LPMIXERLINEINFO;


typedef struct patchinfo_tag {
    WORD    wPatchNumber;          // This patch's ordinal number in the mixer
    DWORD   dwDeviceType;       	  // type of device
	 DWORD	dwLineNumbers; 		  // bit-field, lines connectable to
    char    szPname[MAXPNAMELEN];  // patch name (NULL terminated string)
    DWORD	dwAssociation;	 		  // HIWORD=type, LOWORD=device
    DWORD   dwReserved1;		  	  // reserved for future use
} PATCHINFO;
typedef PATCHINFO FAR *LPPATCHINFO;


typedef struct {
	DWORD dwInputDeviceType;
	DWORD dwOutputDeviceType;
	DWORD dwInputAssociation;
	DWORD dwOutputAssociation;
} DEVICECONNECT;
typedef DEVICECONNECT FAR *LPDEVICECONNECT;

typedef struct {
	DWORD 	dwDeviceType;				// aka technology
	WORD		wNumDevices;		  		// return value: # lines with device found
	DWORD		dwLines;						// return value: line map
	DWORD		dwAssociation;				// for exclusive search
	} DEVICELINES;
typedef DEVICELINES FAR *LPDEVICELINES;

/*
	Prudent Windows programming suggests that we register these
	Window messages:  
		WM_MIX_PATCHCHANGED
		WM_MIX_CONNECTIONCHANGED
		WM_MIX_CONTROLCHANGED
		WM_MIX_MUTESTATUSCHANGED

	To handle those messages, you'll need to ask Windows to register them
	with some code that looks like this:

	wmPatchChanged=RegisterWindowMessage("WM_MIX_PATCHCHANGED");
	wmConnectionChanged=RegisterWindowMessage("WM_MIX_CONNECTIONCHANGED");
	wmControlChanged=RegisterWindowMessage("WM_MIX_CONTROLCHANGED");
	wmMixStatusChanged=RegisterWindowMessage("WM_MIX_MUTESTATUSCHANGED");

	Nope, you can't use 'em in yer case statements.

 */

// flags for MIXERLINEINFO dwSupport field
#define MIX_SUPPORT_VOLUME		  0x00000001   // supports volume control
#define MIX_SUPPORT_LRVOLUME    0x00000002   // separate left-right volume control
#define MIX_SUPPORT_ALC			  0x00000004   // supports Auto Level Control
#define MIX_SUPPORT_BMT			  0x00000008   // supports B-M-T equalization
#define MIX_SUPPORT_CROSSOVER	  0x00000010   // supports crossover change
#define MIX_SUPPORT_LOUDNESS	  0x00000020   // supports loudness equalization
#define MIX_SUPPORT_MUTE		  0x00000040   // supports channel mute
#define MIX_SUPPORT_REVERB		  0x00000080   // supports reverb 
#define MIX_SUPPORT_STEREOENHANCE 0x00000100   // supports stereo enhance 
#define MIX_SUPPORT_CUSTOM1	  0x00000200   // supports custom effect #1
#define MIX_SUPPORT_CUSTOM2	  0x00000400   // supports custom effect #2
#define MIX_SUPPORT_CUSTOM3	  0x00000800   // supports custom effect #3
#define MIX_SUPPORT_SOFTPATCH	  0x40000000	// supports software patching 
#define MIX_SUPPORT_MANUALPATCH 0x80000000	// supports manual patching 

// PATCH TYPES for MIXERLINEINFO, PATCHINFO

#define	MIX_NO_CONNECT			  0x00000000  
#define	MIX_CD_AUDIO			  0x00000001  // match MMWIN AUXCAPS_XXX defines
#define	MIX_AUXILLARY			  0x00000002  // for AUXCAPS wTechnology field
#define	MIX_MICROPHONE			  0x00000004
#define	MIX_VIDEOTAPE			  0x00000008
#define	MIX_VIDEODISK			  0x00000010
#define	MIX_INSTRUMENT			  0x00000020
#define	MIX_WAVE					  0x00000040
#define	MIX_TV_TUNER			  0x00000080
#define	MIX_RADIO_TUNER		  0x00000100
#define	MIX_PHONOGRAPH			  0x00000200
#define	MIX_PC_INT_SPKR		  0x00000400
#define	MIX_ANALOG_AUDIO_TAPE  0x00000800
#define	MIX_DIGITAL_AUDIO_TAPE 0x00001000
#define	MIX_TELEPHONE			  0x00002000
#define	MIX_MIXER				  0x00004000  
#define	MIX_EQUALIZER			  0x00008000  
#define	MIX_AMPLIFIER			  0x00010000  
#define	MIX_OTHER				  0x08000000
#define	MIX_HARD_WIRED			  0x20000000	// hard-wired to one line
#define	MIX_USER_CONNECTED	  0x40000000 	// requires user to hook it up
#define	MIX_LISTENER			  0x80000000	// audio devices that accept input
															// (ie amp, pcm record, etc)

// ERROR MESSAGES

#define MIXERR_BASE            512

#define	MIXERR_NOERR			  0	
#define	MIXERR_INVALHANDLE	  MIXERR_BASE+0	
#define	MIXERR_INVALINPUT	  	  MIXERR_BASE+1	//	 \\\\	contiguous
#define	MIXERR_INVALOUTPUT	  MIXERR_BASE+2	//	 ////	contiguous
#define	MIXERR_INVALIDSTATE	  MIXERR_BASE+3	
#define	MIXERR_INVALPATCH		  MIXERR_BASE+4  	// out of range or disabled
#define	MIXERR_PATCHMISMATCH	  MIXERR_BASE+5	
#define	MIXERR_PATCHINUSE		  MIXERR_BASE+6	
#define	MIXERR_NOTSUPPORTED	  MIXERR_BASE+7	
#define	MIXERR_FADEINPROGRESS  MIXERR_BASE+8	
#define	MIXERR_INVALCONNECTION MIXERR_BASE+10	
#define	MIXERR_INVALSTRUCTPTR  MIXERR_BASE+11	
#define	MIXERR_BADMIXERPTR     MIXERR_BASE+12	
#define	MIXERR_ILLEGALSIZE     MIXERR_BASE+13	

// Association Types
// The association types defined below are base values.  Add 0x0 thru 0xf
// to these base values to indicate the device number that is associated.
// New candidates for association types must fulfill the following criteria:
//
//		1) The device must produce audio output.
//
//		2) The device must be software controllable.
//
//		3) The device must either have a Windows low-level driver
// 		or an MCI driver.
//
#define  AT_NO_INFO			  0x0000		// No association info available
// low-level drivers
#define  AT_waveOut			  0x0010		// internal pcm hardware
#define  AT_midiOut			  0x0020		// internal MIDI device
// MCI drivers
#define  AT_mciCD				  0x1010		// internal and external CD devices
#define  AT_mciVDP			  0x1020		// external VideoDisk Player
#define  AT_mciSEQ			  0x1030		// external MIDI device
#define  AT_mciWAVE			  0x1040		// external WAVE  device
#define  AT_mciDAT			  0x1050		// external Digital Audio Tape device (it could happen)
#define  AT_mciVCR			  0x1060		// Panasonic AG-1960 for example
#define	AT_mciTV  		  	  0x1070		//	TV tuner
#define	AT_mciTUNER	  		  0x1080		// AM/FM tuner 
#define	AT_mciPHONO		  	  0x1090		// we may never live to see such an animal
#define  AT_mciAAT			  0x10A0		// external Analog Audio Tape device (it has happened)
#define	AT_mciMIX		  	  0x10B0  	// possibility of mixer chaining!
#define	AT_mciEQU			  0x10C0		// equalizer controllable by software
#define	MIX_mciAMP			  0x10D0		// they exist, only a driver is needed

// general mixer macros
#define BOTH	(MIX_SUPPORT_VOLUME|MIX_SUPPORT_LRVOLUME)
#define MONO	1
#define STEREO	2

#define MIX_DEVICESHORTNAME 6
#define MIX_FADE_OVERRIDE	1

// MIX Messages
#define MM_STATE_FADE_COMPLETED	1

// Add to HIBYTE of wLineNum parameters  
// and to the wPatchNum parm of mixGetPatchInfo
#define MIX_INPUT		0
#define MIX_OUTPUT 	1

// GENERAL FUNCTIONS

WORD FAR PASCAL mixGetNumDevs(void);
WORD FAR PASCAL mixGetDevCaps(WORD wDeviceID,LPMIXERCAPS lpCaps,WORD wSize);
WORD FAR PASCAL mixOpen(LPHMIXER lphMixer,WORD wDeviceID,DWORD dwFlags);
WORD FAR PASCAL mixClose(HMIXER hMixer);
WORD FAR PASCAL mixGetErrorText(WORD wError,LPSTR lpText,WORD wSize);

// MIXER PRESET FUNCTIONS
WORD FAR PASCAL mixMute(WORD wFlags);
WORD FAR PASCAL mixReset(HMIXER hMixer);
WORD FAR PASCAL mixGetState(HMIXER hMixer,LPMIXERSTATE lpMixer, WORD wSize);
WORD FAR PASCAL mixSetState(HMIXER hMixer,LPMIXERSTATE lpMixer, WORD wSize,DWORD dwTime,DWORD dwFlags, DWORD dwCallback);
WORD FAR PASCAL mixGetFadeStatus(HMIXER hMixer,LPDWORD lpdwTime);

// INPUT-TO-OUTPUT CONNECTION FUNCTIONS
WORD FAR PASCAL mixGetConnections(HMIXER hMixer,WORD wLine, LPDWORD lpdwConnections);
WORD FAR PASCAL mixSetConnections(HMIXER hMixer,WORD wLine, DWORD dwConnections);

// LINE FUNCTIONS
WORD FAR PASCAL mixGetControl(HMIXER hMixer, WORD wLineNum, DWORD dwControl, LPDWORD lpdwSetting);
WORD FAR PASCAL mixSetControl(HMIXER hMixer, WORD wLineNum, DWORD dwControl, DWORD dwSetting);
WORD FAR PASCAL mixGetLineInfo(HMIXER hMixer, WORD wLineNum, LPMIXERLINEINFO lpInfo,WORD wSize);

// PATCH FUNCTIONS
WORD FAR PASCAL mixGetPatch(HMIXER hMixer,WORD wLineNum, LPWORD lpwPatchNum);
WORD FAR PASCAL mixSetPatch(HMIXER hMixer,WORD wLine,WORD wPatchNum,LPPATCHINFO lpPatch,WORD wSize);
WORD FAR PASCAL mixGetPatchInfo(HMIXER hMixer,WORD wPatchNum,LPPATCHINFO lpInfo,WORD wSize);

// DEVICE-TYPE ORIENTED FUNCTIONS
WORD FAR PASCAL mixGetDeviceName(DWORD dwDeviceType, LPSTR lpDeviceName,WORD wSize);
WORD FAR PASCAL mixGetDeviceLines(HMIXER hMixer,LPDEVICELINES lpDeviceLines);
WORD FAR PASCAL mixSetDeviceConnections(HMIXER hMixer,LPDEVICECONNECT lpDeviceConnect);
WORD FAR PASCAL mixGetDeviceConnections(HMIXER hMixer,LPDEVICECONNECT lpDeviceConnect);

// TEMPORARY DEVICE LOAD ENTRY
void FAR PASCAL mixWakeUp(void);

// flags for wCrossoverCaps
#define MIXCROSSCAPS_NORMAL_STEREO 	0x0000	 // Left->Left, Right->Right
#define MIXCROSSCAPS_RIGHT_TO_BOTH 	0x0001	 // Right->Left, Right->Right
#define MIXCROSSCAPS_LEFT_TO_BOTH	0x0002	 // Left->Left, Left->Right
#define MIXCROSSCAPS_REVERSE_STEREO 0x0004	 // Left->Right, Right->Left
#define MIXCROSSCAPS_RIGHT_TO_LEFT 	0x0008	 // Right->Left
#define MIXCROSSCAPS_LEFT_TO_RIGHT	0x0010	 // Left->Right


// destined for MMDDK:

#define MAXMIXDRIVERS 4         // max number of mixer device drivers we load


#define MIXDM_BASE				 0x800
#define MIXDM_GETNUMDEVS       MIXDM_BASE+0
#define MIXDM_GETDEVCAPS       MIXDM_BASE+1
#define MIXDM_OPEN             MIXDM_BASE+2
#define MIXDM_CLOSE            MIXDM_BASE+3
#define MIXDM_RESET            MIXDM_BASE+4
#define MIXDM_GETSTATE		    MIXDM_BASE+5
#define MIXDM_SETSTATE		    MIXDM_BASE+6
#define MIXDM_GETCONNECTIONS   MIXDM_BASE+7
#define MIXDM_SETCONNECTIONS   MIXDM_BASE+8
#define MIXDM_GETDEVLINES   	 MIXDM_BASE+9
#define MIXDM_GETDEVCONNECTS   MIXDM_BASE+10
#define MIXDM_SETDEVCONNECTS   MIXDM_BASE+11
#define MIXDM_GETLINEINFO	    MIXDM_BASE+12
#define MIXDM_GETCONTROL		 MIXDM_BASE+13
#define MIXDM_SETCONTROL		 MIXDM_BASE+14
#define MIXDM_GETPATCHINFO	    MIXDM_BASE+15
#define MIXDM_GETPATCH   	    MIXDM_BASE+16
#define MIXDM_SETPATCH 	       MIXDM_BASE+17
#define MIXDM_SHUTDOWN 	       MIXDM_BASE+18
#define MIXDM_GETFADESTATUS    MIXDM_BASE+19
#define MIXDM_MUTE				 MIXDM_BASE+20

#define MIXMUTE_TOGGLE			NULL
#define MIXMUTE_STATUS			1

#define MIXMUTESTATUS_MUTE		TRUE
#define MIXMUTESTATUS_NOMUTE 	FALSE



#define MCIERR_MIX_NO_SUCH_DEVICE	 MCIERR_CUSTOM_DRIVER_BASE+768
