'-----------------------------------------------------------------------------

'              Simple TinyPort demo program in Visual Basic

' Create a new project (.EXE), remove all default form files, add this
' .FRM file to it, declare its Main Form as the Startup Object of the project.

' Don't forget to run TPCONFIG before starting this program!

'-----------------------------------------------------------------------------

VERSION 5.00
Begin VB.Form MainForm
   Caption         =   "TinyTest"
   ClientHeight    =   3870
   ClientLeft      =   2940
   ClientTop       =   1860
   ClientWidth     =   3075
   LinkTopic       =   "Form1"
   ScaleHeight     =   3870
   ScaleWidth      =   3075
   Begin VB.CommandButton ReadButton
      Caption         =   "Read Port"
      Height          =   495
      Left            =   240
      TabIndex        =   0
      Top             =   480
      Width           =   1215
   End
   Begin VB.Label CloseResult
      Height          =   255
      Left            =   1560
      TabIndex        =   8
      Top             =   2520
      Width           =   1095
   End
   Begin VB.Label CloseLabel
      Caption         =   "Close ="
      Height          =   255
      Left            =   360
      TabIndex        =   7
      Top             =   2520
      Width           =   1095
   End
   Begin VB.Label ReadResult
      Height          =   255
      Left            =   1560
      TabIndex        =   6
      Top             =   1920
      Width           =   1095
   End
   Begin VB.Label ReadLabel
      Caption         =   "Read ="
      Height          =   255
      Left            =   360
      TabIndex        =   5
      Top             =   1920
      Width           =   1095
   End
   Begin VB.Label PortLabel
      Caption         =   "Port Data ="
      Height          =   255
      Left            =   360
      TabIndex        =   4
      Top             =   3120
      Width           =   1095
   End
   Begin VB.Label OpenLabel
      Caption         =   "Open ="
      Height          =   255
      Left            =   360
      TabIndex        =   3
      Top             =   1320
      Width           =   1095
   End
   Begin VB.Label OpenResult
      Height          =   255
      Left            =   1560
      TabIndex        =   2
      Top             =   1320
      Width           =   1095
   End
   Begin VB.Label PortData
      Height          =   255
      Left            =   1560
      TabIndex        =   1
      Top             =   3120
      Width           =   1095
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Result As Long
Private hTPort As Long
Private InputByte As Byte

Private Declare Function OpenTinyPort Lib "tinypio.dll" (ByRef hTPort As Long) As Long
Private Declare Function CloseTinyPort Lib "tinypio.dll" (ByVal hTPort As Long) As Long
Private Declare Function GetTinyPortVersion Lib "tinypio.dll" (ByVal hTPort As Long, ByRef Version As Long) As Long
Private Declare Function ReadByte Lib "tinypio.dll" (ByVal hTPort As Long, ByVal Address As Long, ByRef Data As Byte) As Long
Private Declare Function ReadWord Lib "tinypio.dll" (ByVal hTPort As Long, ByVal Address As Long, ByRef Data As Integer) As Long
Private Declare Function ReadDWord Lib "tinypio.dll" (ByVal hTPort As Long, ByVal Address As Long, ByRef Data As Long) As Long
Private Declare Function WriteByte Lib "tinypio.dll" (ByVal hTPort As Long, ByVal Address As Long, ByVal Data As Byte) As Long
Private Declare Function WriteWord Lib "tinypio.dll" (ByVal hTPort As Long, ByVal Address As Long, ByVal Data As Integer) As Long
Private Declare Function WriteDWord Lib "tinypio.dll" (ByVal hTPort As Long, ByVal Address As Long, ByVal Data As Long) As Long


Private Sub ReadButton_Click()
'
' Read a byte from port 768 (300 hex).
'
' Important! TinyPort must have been configured for this port! (Run
' TPCONFIG first!)
'
' The form contains three labels (OpenResult, ReadResult, CloseResult)
' to show the return codes of TinyPort.
' The data read is displayed in a fourth label, PortData.
'
Result = OpenTinyPort(hTPort)
OpenResult.Caption = Result
If Result = 0 Then         ' Open ok
    Result = ReadByte(hTPort, &H300, InputByte)
    ReadResult.Caption = Result
    PortData.Caption = InputByte
    Result = CloseTinyPort(hTPort)
    CloseResult.Caption = Result
    End If
End Sub


