// YtvClockDial.cpp : implementation file
//

#include "stdafx.h"
#include "YtvClockDial.h"
#include "YtvSetAlarm.h"
#include "YtvSetTime.h"
#include "font.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// YtvClockDial
DWORD YtvClockDial::ms_uInstNumber=0;
////////////////////////////////////////////
DWORD YtvClockDial::m_uNextAlarmId=1;
DWORD g_uWM_YTV_ADJUST=RegisterWindowMessage("WM_YTV_ADJUST");
char g_szYtvClockDialInstance[]="YtvClockDialInstance%02u";
char g_szYtvClockDialAutoCreate[]="YtvClockDialAutoCreate";
YtvClockDial::YtvClockDial(): CDialog()
{
	m_bModeless=TRUE;
Init();	
}
YtvClockDial::YtvClockDial(HWND hw,const char* caption)	: CDialog(YtvClockDial::IDD,CWnd::FromHandle(hw))
{
	m_bModeless=FALSE;
	m_pszCaption=(char*)caption;	
Init();	
}
void YtvClockDial::Init()
{
//{{AFX_DATA_INIT(YtvClockDial)
	m_bSetProfTimer = FALSE;
	m_strcomboListTimerCircles = _T("");
	//}}AFX_DATA_INIT
	m_bAdjast=FALSE;
	m_hSheetWnd=NULL; 
	m_pmenu=NULL;
	m_rectFixedPosition.left=0;
	m_rectFixedPosition.right=300;
	m_rectFixedPosition.top=0;
	m_rectFixedPosition.bottom=300;
	m_nLeftClockPos=0;
	m_nTopClockPos=0;
	m_bClockFullScreen=FALSE;
	m_bMoveFixed=FALSE;
	m_bSizeFixed=FALSE;
	m_bDefaultSetting=FALSE;
	m_strPath.Empty();
	ms_uInstNumber++;
	m_strInstNumber.Format(g_szYtvClockDialInstance,ms_uInstNumber);
	m_bYtvClockDialAutoCreate=TRUE;
	m_strPath=m_strInstNumber;
	m_strPath=YtvGetProfileString(m_strInstNumber,"m_strPath",m_strPath);
	m_bDefaultSetting=YtvGetProfileInt(m_strInstNumber,"m_bDefaultSetting",m_bDefaultSetting);
	m_uNextAlarmNumber=1;
	m_nTimeShift=0;	
	m_bModifiedFlag=FALSE;	
}
YtvClockDial::~YtvClockDial()
{

}

void YtvClockDial::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(YtvClockDial)
	DDX_Control(pDX, IDOK, m_btOK);
	DDX_Control(pDX, IDC_SET_PROF_TIMER, m_checkSetProfTimer);
	DDX_Control(pDX, IDC_STATICBMPSOUND, m_stSBMP);
	DDX_Control(pDX, IDC_STSDONOFF, m_stSdOnOff);
	DDX_Control(pDX, IDC_SETTINGS, m_btUpdateAlarms);
	DDX_Control(pDX, IDC_STYTV_LIST_ALARMS, m_stListAlarms); 
    DDX_Control(pDX, IDC_BTYTV_ADDALARM, m_btAddAlarm);
	DDX_Control(pDX, IDC_COMBO_LIST_NUMBER_MIN_CIRCLE, m_comboListTimerCircles);
	DDX_Control(pDX, IDC_START_TIMER, m_btStartTimer);
	DDX_Control(pDX, IDC_YTVDATEPICKER, m_ctrlDate);
	DDX_Control(pDX, IDC_YTVCLOCKDIALC, m_ctrlClock);
	DDX_Control(pDX, IDC_LIST_ALARMS, m_ctrlListAlarms);
	DDX_Check(pDX, IDC_SET_PROF_TIMER, m_bSetProfTimer);
	DDX_CBString(pDX, IDC_COMBO_LIST_NUMBER_MIN_CIRCLE, m_strcomboListTimerCircles);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(YtvClockDial, CDialog)
	//{{AFX_MSG_MAP(YtvClockDial)
	ON_WM_CTLCOLOR()
	ON_UPDATE_COMMAND_UI(IDM_YTVSET24ALARM, OnUpdateYtvset24alarm)
	ON_COMMAND(IDM_YTVSET24ALARM, OnYtvset24alarm)
	ON_BN_CLICKED(IDC_BTYTV_ADDALARM, OnBtytvAddalarm)
	ON_LBN_DBLCLK(IDC_LIST_ALARMS, OnDblclkListAlarms)
	ON_COMMAND(IDM_SET_ANALOG_CLOCK, OnSetAnalogClock)
	ON_UPDATE_COMMAND_UI(IDM_SET_ANALOG_CLOCK, OnUpdateSetAnalogClock)
	ON_UPDATE_COMMAND_UI(IDM_SET_DIGITAL_CLOCK, OnUpdateSetDigitalClock)
	ON_COMMAND(IDM_SET_DIGITAL_CLOCK, OnSetDigitalClock)
	ON_COMMAND(IDM_SET_BACKGROUND_COLOR_ALARM, OnSetBackgroundColorAlarm)
	ON_COMMAND(IDM_SET_BACKGROUND_COLOR_CLOCK, OnSetBackgroundColorClock)
	ON_COMMAND(IDM_SET_CLOCK_LINE_COLOR, OnSetClockLineColor)
	ON_COMMAND(IDM_SET_FOREGROUND_COLOR_ALARM, OnSetForegroundColorAlarm)
	ON_COMMAND(IDM_SET_FOREGROUND_COLOR_CLOCK, OnSetForegroundColorClock)
	ON_COMMAND(IDM_SET_HANDS_ALARM_COLOR, OnSetHandsAlarmColor)
	ON_UPDATE_COMMAND_UI(IDM_SHOW_SECONDS, OnUpdateShowSeconds)
	ON_COMMAND(IDM_SHOW_SECONDS, OnShowSeconds)
	ON_UPDATE_COMMAND_UI(IDM_24_HOURS, OnUpdate24Hours)
	ON_COMMAND(IDM_24_HOURS, On24Hours)
	ON_COMMAND(IDM_BACK_LINE_COLOR_CLOCK, OnBackLineColorClock)
	ON_COMMAND(IDM_BACK_DRAW_COLOR_ALARM, OnBackDrawColorAlarm)
	ON_UPDATE_COMMAND_UI(IDM_MATRIX_DIGITAL, OnUpdateMatrixDigital)
	ON_COMMAND(IDM_MATRIX_DIGITAL, OnMatrixDigital)
	ON_UPDATE_COMMAND_UI(IDM_DIGITAL_FONT, OnUpdateDigitalFont)
	ON_COMMAND(IDM_DIGITAL_FONT, OnDigitalFont)
	ON_UPDATE_COMMAND_UI(IDM_ANALOG_CENTERED, OnUpdateAnalogCentered)
	ON_COMMAND(IDM_ANALOG_CENTERED, OnAnalogCentered)
	ON_UPDATE_COMMAND_UI(IDM_ANALOG_LEFT_ALIGHNED, OnUpdateAnalogLeftAlighned)
	ON_COMMAND(IDM_ANALOG_LEFT_ALIGHNED, OnAnalogLeftAlighned)
	ON_COMMAND(IDM_SET_CLOCK_FONT, OnSetClockFont)
	ON_BN_CLICKED(IDC_SETTINGS, OnSettings)
	ON_COMMAND(IDM_YTV_SET_TIME_SHIFT, OnYtvSetTimeShift)
	ON_UPDATE_COMMAND_UI(IDM_YTV_SET_TIME_SHIFT, OnUpdateYtvSetTimeShift)
	ON_WM_CLOSE()
	ON_WM_SIZE()
	ON_UPDATE_COMMAND_UI(IDM_YTV_SHOW_NEXT_ALARM_TIME, OnUpdateYtvShowNextAlarmTime)
	ON_COMMAND(IDM_YTV_SHOW_NEXT_ALARM_TIME, OnYtvShowNextAlarmTime)
	ON_UPDATE_COMMAND_UI(IDM_YTV_RUN_CLOCK, OnUpdateYtvRunClock)
	ON_COMMAND(IDM_YTV_RUN_CLOCK, OnYtvRunClock)
	ON_UPDATE_COMMAND_UI(IDM_ON_ALARM_SHOW_MESSAGE_BOX, OnUpdateOnAlarmShowMessageBox)
	ON_COMMAND(IDM_ON_ALARM_SHOW_MESSAGE_BOX, OnOnAlarmShowMessageBox)
	ON_COMMAND(IDM_SET_ALARM_MESSAGE_BOX_TEXT, OnSetAlarmMessageBoxText)
	ON_UPDATE_COMMAND_UI(IDM_PLAY_SOUND_AT_ALARM, OnUpdatePlaySoundAtAlarm)
	ON_COMMAND(IDM_PLAY_SOUND_AT_ALARM, OnPlaySoundAtAlarm)
	ON_COMMAND(IDM_SET_ALARM_SOUND, OnSetAlarmSound)
	ON_COMMAND(IDM_CANCEL_SOUND_PLAY, OnCancelSoundPlay)
	ON_UPDATE_COMMAND_UI(IDM_SAY_TIME, OnUpdateSayTime)
	ON_COMMAND(IDM_SAY_TIME, OnSayTime)
	ON_UPDATE_COMMAND_UI(IDM_SAY_ALARM_NAME, OnUpdateSayAlarmName)
	ON_COMMAND(IDM_SAY_ALARM_NAME, OnSayAlarmName)
	ON_UPDATE_COMMAND_UI(IDM_DEFAULT_SETTINGS, OnUpdateDefaultSettings)
	ON_COMMAND(IDM_DEFAULT_SETTINGS, OnDefaultSettings)
	ON_UPDATE_COMMAND_UI(IDM_CURRENT_SETTINGS, OnUpdateCurrentSettings)
	ON_COMMAND(IDM_CURRENT_SETTINGS, OnCurrentSettings)
	ON_UPDATE_COMMAND_UI(IDM_GET_DEFAULT_SETTINGS, OnUpdateGetDefaultSettings)
	ON_COMMAND(IDM_GET_DEFAULT_SETTINGS, OnGetDefaultSettings)
	ON_UPDATE_COMMAND_UI(IDM_GET_CUSTOM_SETTING, OnUpdateGetCustomSetting)
	ON_COMMAND(IDM_GET_CUSTOM_SETTING, OnGetCustomSetting)
	ON_BN_CLICKED(IDC_STATICBMPSOUND, OnStaticbmpsound)
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_UPDATE_COMMAND_UI(IDM_SET_VOICE, OnUpdateSetVoice)
	ON_COMMAND(IDM_SET_VOICE, OnSetVoice)
	ON_UPDATE_COMMAND_UI(IDM_SAY_MESSAGE, OnUpdateSayMessage)
	ON_COMMAND(IDM_SAY_MESSAGE, OnSayMessage)
	ON_COMMAND(IDM_RESET_TIME_SPAN_ALARM, OnResetTimeSpanAlarm)
	ON_COMMAND(IDM_ADD_ALARM, OnAddAlarm)
	ON_COMMAND(IDM_UPDATE_ALARM, OnUpdateAlarm)
	ON_COMMAND(IDM_SET_ROUNDED_TIMER, OnSetRoundedTimer)
	ON_UPDATE_COMMAND_UI(IDM_SET_ROUNDED_TIMER, OnUpdateSetRoundedTimer)
	ON_BN_CLICKED(IDC_START_TIMER, OnStartTimer)
	ON_COMMAND(IDM_SET_ROUNDED_RING_TIMER, OnSetRoundedRingTimer)
	ON_UPDATE_COMMAND_UI(IDM_SET_ROUNDED_RING_TIMER, OnUpdateSetRoundedRingTimer)
	ON_BN_CLICKED(IDC_SET_PROF_TIMER, OnSetProfTimer)
	ON_CBN_EDITCHANGE(IDC_COMBO_LIST_NUMBER_MIN_CIRCLE, OnEditchangeComboListNumberMinCircle)
	ON_UPDATE_COMMAND_UI(IDM_SET_MULTI_PLANK_TIMER, OnUpdateSetMultiPlankTimer)
	ON_COMMAND(IDM_SET_MULTI_PLANK_TIMER, OnSetMultiPlankTimer)
	ON_UPDATE_COMMAND_UI(IDM_TIMER_LEVEL1_COLOR, OnUpdateTimerLevel1Color)
	ON_COMMAND(IDM_TIMER_LEVEL1_COLOR, OnTimerLevel1Color)
	ON_UPDATE_COMMAND_UI(IDM_SET_HANDS_STRPES_LENGTH_WIDTHS, OnUpdateSetHandsStrpesLengthWidths)
	ON_COMMAND(IDM_SET_HANDS_STRPES_LENGTH_WIDTHS, OnSetHandsStrpesLengthWidths)
	ON_UPDATE_COMMAND_UI(IDM_SET_TIME_SPAN_FOR_PERIODS, OnUpdateSetTimeSpanForPeriods)
	ON_COMMAND(IDM_SET_TIME_SPAN_FOR_PERIODS, OnSetTimeSpanForPeriods)
	ON_UPDATE_COMMAND_UI(IDM_TIMER_LEVEL2_COLOR, OnUpdateTimerLevel2Color)
	ON_COMMAND(IDM_TIMER_LEVEL2_COLOR, OnTimerLevel2Color)
	ON_UPDATE_COMMAND_UI(IDM_TIMER_LEVEL0_COLOR, OnUpdateTimerLevel0Color)
	ON_COMMAND(IDM_TIMER_LEVEL0_COLOR, OnTimerLevel0Color)
	ON_WM_MOVE()
	ON_UPDATE_COMMAND_UI(IDM_CLOCK_FULL_SCREEN, OnUpdateClockFullScreen)
	ON_COMMAND(IDM_CLOCK_FULL_SCREEN, OnClockFullScreen)
	ON_UPDATE_COMMAND_UI(IDM_DO_NOT_RESIZE, OnUpdateDoNotResize)
	ON_COMMAND(IDM_DO_NOT_RESIZE, OnDoNotResize)
	ON_UPDATE_COMMAND_UI(IDM_YTV_STOP_MOVE, OnUpdateYtvStopMove)
	ON_COMMAND(IDM_YTV_STOP_MOVE, OnYtvStopMove)
	ON_WM_RBUTTONDOWN()
	ON_UPDATE_COMMAND_UI(IDM_CLOSE_WINDOW_WITHOUT_SAVE, OnUpdateCloseWindowWithoutSave)
	ON_COMMAND(IDM_CLOSE_WINDOW_WITHOUT_SAVE, OnCloseWindowWithoutSave)
	ON_UPDATE_COMMAND_UI(IDM_CLOSEWINDOW_AND_SAVE, OnUpdateClosewindowAndSave)
	ON_COMMAND(IDM_CLOSEWINDOW_AND_SAVE, OnClosewindowAndSave)
	ON_UPDATE_COMMAND_UI(IDM_YTVSTOP_TIMER, OnUpdateYtvstopTimer)
	ON_COMMAND(IDM_YTVSTOP_TIMER, OnYtvstopTimer)
	ON_UPDATE_COMMAND_UI(IDM_USE_PROF_TIMER, OnUpdateUseProfTimer)
	ON_COMMAND(IDM_USE_PROF_TIMER, OnUseProfTimer)
	//}}AFX_MSG_MAP
	ON_REGISTERED_MESSAGE(g_uWM_YTV_ADJUST,YtvAdjust)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// YtvClockDial diagnostics

#ifdef _DEBUG
void YtvClockDial::AssertValid() const
{
	CDialog::AssertValid();
}

void YtvClockDial::Dump(CDumpContext& dc) const
{
	CDialog::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// YtvClockDial message handlers
LRESULT YtvClockDial::YtvAdjust(WPARAM wp, LPARAM lp)
{
    CRect rt;
	DWORD Width,Height;
	m_bAdjast=TRUE;
    GetWindowRect(&rt);
	Width=rt.right-rt.left;
	Height=rt.bottom-rt.top;
	rt.top=m_rectPosition.top-m_mwrect.top+lp;
	rt.left=m_rectPosition.left-m_mwrect.left+wp;
    rt.bottom=rt.top+Height;
	rt.right=rt.left+Width;
    rt.NormalizeRect();    
	//rt.bottom-=rt.top;
	//rt.right-=rt.left;
	m_rectFixedPosition=rt; 
	MoveWindow(&rt);
    m_bAdjast=FALSE;
    return 1;
}
BOOL YtvClockDial::OnInitDialog() 
{
	CDialog::OnInitDialog(); 
	BOOL b;
	
	HICON ic=AfxGetApp()->LoadIcon(IDR_YTVCLOCKDIAL);
	SetIcon(ic,TRUE);
	if(m_pszCaption)
	    SetWindowText(m_pszCaption);
	else
		b=ModifyStyle(WS_OVERLAPPEDWINDOW, WS_DLGFRAME|WS_POPUP, SWP_FRAMECHANGED);
/////////////////////////////////////////////////////////	
   	if(!m_bDefaultSetting)
    {      
	  m_ctrlClock.SetDefaultSetting(FALSE);
	  if(!m_strPath.IsEmpty())
	       m_ctrlClock.SetSectionName(m_strPath);
	  
    }
	else
       m_ctrlClock.SetDefaultSetting(TRUE);
    m_ctrlClock.GetSetting();
	//////////////////////////////////////////////
	m_enTypeofFace=(EN_TYPEOFFACE)m_ctrlClock.GetFaceHandsType();
	m_ctrlClock.SetDeleteAllAlarms(FALSE);
	m_bPlayAlarmSound=m_ctrlClock.GetPlayAlarmSound();
	m_hu=LoadBitmap(AfxGetInstanceHandle(),"REPLAYU");
	m_hf=LoadBitmap(AfxGetInstanceHandle(),"REPLAYF");
	m_hd=LoadBitmap(AfxGetInstanceHandle(),"REPLAYD");
	if(m_bPlayAlarmSound)
	{
		m_stSBMP.SetBitmap(m_hu); 
	}	
	else
    {
		m_stSBMP.SetBitmap(m_hf); 
	}	
    m_bSayAlarmName=m_ctrlClock.GetSayAlarmName();
	m_bSayAlarmTime=m_ctrlClock.GetSayAlarmTime();
	m_bSayMessageText=m_ctrlClock.GetSayMessageText();
	m_bClockRunning=m_ctrlClock.GetRunClock();
	if(!m_bClockRunning)
        OnYtvRunClock(); 
	m_bDisplayAlarmTime=m_ctrlClock.GetDisplayAlarmTime();
	m_bShowMessageBox=m_ctrlClock.GetAlarmMessageBox();
    m_ctrlClock.SetAtAlarmFlashWindowNumberTimes(YtvGetProfileInt(m_szSetting,"AtAlarmFlashWindowNumberTimes",100));
	m_ctrlClock.SetAtAlarmFlashWindow((long)::GetParent(m_hWnd));
	m_ctrlClock.SetFlashTimeInterval(200);
	m_bDigitalFace=!m_ctrlClock.GetAnalogClock();
	m_b12hour=m_ctrlClock.GetSwitch12hours();
	m_bShowSeconds=m_ctrlClock.GetShowSeconds();
	DWORD AlarmId,AlarmNumber,citem;	
	char szAlarmName[257];
	DATE AlarmTimeDate;
	BOOL bActivateAlarm;
	int i=0,j=0,ii,item,i0, timeInterval;
	struct tm t;
	CString Temp,Temp0;
	long lt;
	BSTR AlarmName;
	do{
      memset(szAlarmName,0xff,sizeof(szAlarmName)-1);
	  szAlarmName[sizeof(szAlarmName)-1]='\0';
	  Temp=szAlarmName;
      AlarmName=Temp.AllocSysString();
	  bActivateAlarm=m_ctrlClock.GetAlarmData(j++,(long*)&AlarmId,(long*)&AlarmNumber,&AlarmName,&AlarmTimeDate);
	  if(AlarmId==0)
		  break;
      Temp=AlarmName;
	  SysFreeString(AlarmName);
	  strcpy(szAlarmName,Temp);
	  ii=m_ctrlListAlarms.GetCount();
	  for(i=0;i<ii;i++)
      {
         item=m_ctrlListAlarms.GetItemData(i);
		 if(item/256!=(int)AlarmId)
			 continue;
         Temp0=bActivateAlarm?"Enabled":"Disabled";
         timeInterval=m_ctrlClock.GetChangeTimeInterval(AlarmId,AlarmNumber);
		 if(timeInterval>0)
		 {
            timeInterval/=m_ctrlClock.GetPartOfSecondTick();
			time(&lt);
			t=*localtime(&lt);
		    t.tm_hour+=timeInterval/3600;
			timeInterval-=(timeInterval/3600)*3600;
		    t.tm_min+=timeInterval/60;
			t.tm_sec+=timeInterval%60;
			if(t.tm_sec>=60)
            {   
				t.tm_min++;
                t.tm_sec-=60;
			}
            if(t.tm_min>=60)
			{
				t.tm_hour++;
				t.tm_min-=60;
            }
			if(t.tm_hour>=24)
				t.tm_hour-=24;
			Temp.Format("Alarm#%u,%s, Time Span Ends at %02u:%02u:%02u",AlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
         }
		 else
         {
	        lt=(long)AlarmTimeDate;
	        t=*localtime(&lt);
	        Temp.Format("Alarm#%u,%s, Set at Time %02u:%02u:%02u",AlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
         }
		 i0=m_ctrlListAlarms.InsertString(i+1,Temp);
	     citem=AlarmId*256+AlarmNumber;
	     m_ctrlListAlarms.SetItemData(i0,citem); 
	     m_uNextAlarmId=max(m_uNextAlarmId,AlarmId)+1;
		 break;
      }
	  if(i<ii)
		  continue;
      i=m_ctrlListAlarms.AddString(szAlarmName);
	  m_ctrlListAlarms.SetItemData(i,AlarmId*256);
	  Temp0=bActivateAlarm?"Enabled":"Disabled";
	  timeInterval=m_ctrlClock.GetChangeTimeInterval(AlarmId,AlarmNumber);
	  if(timeInterval>0)
	  {
            timeInterval/=m_ctrlClock.GetPartOfSecondTick();
			time(&lt);
			t=*localtime(&lt);
		    t.tm_hour+=timeInterval/3600;
			timeInterval-=(timeInterval/3600)*3600;
		    t.tm_min+=timeInterval/60;
			t.tm_sec+=timeInterval%60;
			if(t.tm_sec>=60)
            {   
				t.tm_min++;
                t.tm_sec-=60;
			}
            if(t.tm_min>=60)
			{
				t.tm_hour++;
				t.tm_min-=60;
            }
			if(t.tm_hour>=24)
				t.tm_hour-=24;
			Temp.Format("Alarm#%u,%s, Time Span Ends at %02u:%02u:%02u",AlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
      }
	  else
      {
	    lt=(long)AlarmTimeDate;
	    t=*localtime(&lt);
	    Temp.Format("Alarm#%u,%s, Set at Time %02u:%02u:%02u",AlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
      }
	  i=m_ctrlListAlarms.AddString(Temp);
	  citem=AlarmId*256+AlarmNumber;
	  m_ctrlListAlarms.SetItemData(i,citem); 
	  m_uNextAlarmId=max(m_uNextAlarmId,AlarmId)+1;
    }while(1);
	SysFreeString(AlarmName);
	///////////////////////////////////////////////////////
    m_bSetProfTimer=m_ctrlClock.GetProfTimer();
	if(!m_bSetProfTimer)
    {
        m_bSetProfTimer=TRUE;
        m_ctrlClock.SetProfTimer(m_bSetProfTimer);
    }
    FillTimeSpans();    
	m_bClockFullScreen=YtvGetProfileInt(m_strInstNumber,"m_bClockFullScreen",m_bClockFullScreen);
	m_rectFixedPosition.left=YtvGetProfileInt(m_strInstNumber,"m_rectFixedPosition.left",m_rectFixedPosition.left);
	m_rectFixedPosition.right=YtvGetProfileInt(m_strInstNumber,"m_rectFixedPosition.right",m_rectFixedPosition.right);
	m_rectFixedPosition.top=YtvGetProfileInt(m_strInstNumber,"m_rectFixedPosition.top",m_rectFixedPosition.top);
	m_rectFixedPosition.bottom=YtvGetProfileInt(m_strInstNumber,"m_rectFixedPosition.bottom",m_rectFixedPosition.bottom);
	m_bMoveFixed=YtvGetProfileInt(m_strInstNumber,"m_bMoveFixed",m_bMoveFixed);
	m_bSizeFixed=YtvGetProfileInt(m_strInstNumber,"m_bSizeFixed",m_bSizeFixed);    
	UpdateData(FALSE);
	if(!m_pmenu)
		  m_pmenu=GetMenu();
	b=m_menu.LoadMenu(IDR_YTVCLOCKDIAL);
	if(!b)
		return FALSE;
    m_bClockFullScreen=!m_bClockFullScreen;
	OnClockFullScreen(); 
    if(m_bMoveFixed)
    {
       m_bMoveFixed=FALSE;//it will alternate
       OnYtvStopMove();//it will alternate
    }
	if(m_bSizeFixed)
    {
       m_bSizeFixed=FALSE;//it will alternate
       OnDoNotResize();//it will alternate
    }
	RECT rt;
	//m_ctrlClock.GetWindowRect(&rt);
	m_checkSetProfTimer.GetWindowRect(&rt);
	ScreenToClient(&rt);
	m_pointOldClockPos.x=rt.left;
    m_pointOldClockPos.y=rt.bottom;
	//m_pointOldClockPos.y=rt.top;
	GetWindowRect(&rt);
	SizeControls(rt.right-rt.left, rt.bottom-rt.top);
	SetWindowPos(NULL,m_rectFixedPosition.left,m_rectFixedPosition.top,m_rectFixedPosition.right-m_rectFixedPosition.left+1,m_rectFixedPosition.bottom-m_rectFixedPosition.top+1,SWP_NOZORDER);
	//MoveWindow(m_rectFixedPosition.left,m_rectFixedPosition.top,m_rectFixedPosition.right-m_rectFixedPosition.left+1,m_rectFixedPosition.bottom-m_rectFixedPosition.top+1);
    if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
	return TRUE;	
}
void YtvClockDial::FillTimeSpans()
{
	
	int ind=0,id,nm;
	short nummin;
	m_comboListTimerCircles.ResetContent();
	do{
        nummin=m_ctrlClock.GetNumberTicksSections(ind);
		nm=nummin;
		m_strcomboListTimerCircles.Format("%02d level - %02d min",ind+1,nm);
        id=m_comboListTimerCircles.AddString(m_strcomboListTimerCircles);
        m_comboListTimerCircles.SetItemData(ind,nummin);
		ind++;
    }while(ind<20);
	m_comboListTimerCircles.GetLBText(0,m_strcomboListTimerCircles);
}
BOOL YtvClockDial::NotTimer()
{
if(m_enTypeofFace!=TIMER_RAY_ROUNDED && m_enTypeofFace!=TIMER_RING_ROUNDED && m_enTypeofFace!=TIMER_MULTI_PLANK)
   return TRUE;
else
   return FALSE;
}
HBRUSH YtvClockDial::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: Change any attributes of the DC here
	
	// TODO: Return a different brush if the default is not desired
	return hbr;
}

BEGIN_EVENTSINK_MAP(YtvClockDial, CDialog)
    //{{AFX_EVENTSINK_MAP(YtvClockDial)
	ON_EVENT(YtvClockDial, IDC_YTVCLOCKDIALC, 5 /* CurrentAlarm */, OnCurrentAlarmYtvclockalarm, VTS_DATE VTS_I4 VTS_I4 VTS_BSTR)
	ON_EVENT(YtvClockDial, IDC_YTVCLOCKDIALC, 6 /* DateChanged */, OnDateChangedYtvclockalarm, VTS_DATE)
	ON_EVENT(YtvClockDial, IDC_YTVCLOCKDIALC, 2 /* AlarmStart */, OnAlarmStartYtvclockalarm, VTS_DATE VTS_I4)
	ON_EVENT(YtvClockDial, IDC_YTVCLOCKDIALC, 3 /* AlarmEnd */, OnAlarmEndYtvclockalarm, VTS_DATE VTS_I4)
	ON_EVENT(YtvClockDial, IDC_YTVCLOCKDIALC, 7 /* TimeExpired */, OnTimeExpiredYtvclockalarm, VTS_I4)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void YtvClockDial::OnUpdateYtvset24alarm(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnYtvset24alarm() 
{
	// TODO: Add your command handler code here
	time_t tm=time(NULL);	
	m_ctrlClock.SetAlarm24hours(tm);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}

void YtvClockDial::OnBtytvAddalarm() 
{
	// TODO: Add your control notification handler code here
    YtvSetAlarm dlg;
	long l;
	struct tm t;
	CString Temp,Temp0;
	int i,ii=m_ctrlListAlarms.GetCount(),item, citem;
    dlg.m_bActivateAlarm=TRUE;
	dlg.m_bDeleteAllAlarms=FALSE;
	dlg.m_bDeleteAlarmGroup=FALSE;
	dlg.m_bDeleteAlarm=FALSE;
	dlg.m_uAlarmNumber=m_uNextAlarmNumber;
	if(dlg.DoModal()==IDCANCEL)
		return;  
	m_bModifiedFlag=TRUE;
    m_ctrlClock.SetAlarmId(m_uNextAlarmId);
    m_ctrlClock.SetAlarmName(dlg.m_strAlarmName);
    m_ctrlClock.SetAlarmNumber(dlg.m_uAlarmNumber);
	citem=dlg.m_uAlarmNumber+m_uNextAlarmId*256;
	if(dlg.m_bDeleteAllAlarms)
	{
		m_ctrlClock.SetDeleteAllAlarms(FALSE);
		this->m_ctrlListAlarms.ResetContent();
		return;
    }
	if(dlg.m_bDeleteAlarmGroup)
    {
        m_ctrlClock.SetDeleteAlarm(m_uNextAlarmId);
        for(i=ii-1;i>=0;i--)
        {
			item=m_ctrlListAlarms.GetItemData(i);
			if((DWORD)(item/256)==m_uNextAlarmId)
                 m_ctrlListAlarms.DeleteString(i);
        }
		return;
    }
	if(dlg.m_bDeleteAlarm)
    {
        m_ctrlClock.SetDeleteAlarm24Hours(FALSE);
		for(i=ii-1;i>=0;i--)
        {
			item=m_ctrlListAlarms.GetItemData(i);
			if(item==citem)
                 m_ctrlListAlarms.DeleteString(i);
        }
		return; 
    }
	time(&l);
	memcpy(&t,localtime(&l),sizeof(struct tm));
	t.tm_hour=dlg.m_vHour.iVal;
	t.tm_min=dlg.m_vMinute.iVal;
	t.tm_sec=dlg.m_vSecond.iVal;
    //l=mktime(&t);	
	m_ctrlClock.SetActivateCurAlarm(dlg.m_bActivateAlarm);
	m_ctrlClock.SetAlarm24hours((double)l); 
    i=m_ctrlListAlarms.AddString(dlg.m_strAlarmName);
	m_ctrlListAlarms.SetItemData(i,m_uNextAlarmId*256);
	Temp0=dlg.m_bActivateAlarm?"Enabled":"Disabled";
	if(dlg.m_bMaxTimeIntervalAlarm>0)
    {
		m_ctrlClock.SetMaxTimeInterval((double)dlg.m_ctimeinterval.GetTime());
	    t=*localtime(&l);
		t.tm_hour+=dlg.m_ctimeinterval.GetHour();
		t.tm_min+=dlg.m_ctimeinterval.GetMinute();
		t.tm_sec+=dlg.m_ctimeinterval.GetSecond();
		if(t.tm_sec>=60)
        {   
				t.tm_min++;
                t.tm_sec-=60;
		}
        if(t.tm_min>=60)
		{
				t.tm_hour++;
				t.tm_min-=60;
        }
		if(t.tm_hour>=24)
				t.tm_hour-=24;
		Temp.Format("Alarm#%u,%s, Time Span Ends at %02u:%02u:%02u",dlg.m_uAlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
	}
	else
        Temp.Format("Alarm#%u,%s, Set at Time %02u:%02u:%02u",dlg.m_uAlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
    i=m_ctrlListAlarms.AddString(Temp);
	m_ctrlListAlarms.SetItemData(i,citem); 
	m_uNextAlarmId++;
	m_uNextAlarmNumber=1;

	
}

void YtvClockDial::OnDblclkListAlarms() 
{
	// TODO: Add your control notification handler code here
	YtvSetAlarm dlg;
	struct tm t;
	long l,TimeSpan;
	VARIANT tempv;
	CString Temp,Temp0;
	int i,i1,i0,item0,Number,Id,ii=m_ctrlListAlarms.GetCount(),item, citem;
	if(ii==0)
		return;
    dlg.m_bActivateAlarm=TRUE;
	dlg.m_bDeleteAlarmGroup=FALSE;
	dlg.m_bDeleteAlarm=FALSE;
	dlg.m_bDeleteAllAlarms=FALSE;
	dlg.m_uAlarmNumber=m_uNextAlarmNumber;
	i0=m_ctrlListAlarms.GetCurSel();
	if(i0==LB_ERR)
		return;
	item0=m_ctrlListAlarms.GetItemData(i0);
    Number=item0%256;
	Id=item0/256;
	if(Number==0)
    {
      for(i=0;i<ii;i++)
      {
        item=m_ctrlListAlarms.GetItemData(i);
		if(Id!=item/256)
           continue;
		if(Number<item%256)
		{
			Number=item%256; 
			i1=i;
		}	
      }
	  dlg.m_uAlarmNumber=Number+1;
	  if(Number>0)
	  {
		  m_ctrlListAlarms.GetText(i1, Temp0);
		  i=Temp0.Find(",Disabled,");
	      if(i>=0)
		    dlg.m_bActivateAlarm=FALSE;
      }
	  m_ctrlListAlarms.GetText(i0,dlg.m_strAlarmName);
    }
	else
    {
      citem=item0/256;
	  citem*=256;
	  i1=i0;
	  dlg.m_uAlarmNumber=Number;
      m_ctrlListAlarms.GetText(i0, Temp0);
	  i=Temp0.Find(",Disabled,");
	  if(i>=0)
		  dlg.m_bActivateAlarm=FALSE;
      for(i=0; i<ii;i++)
      {
		  item=m_ctrlListAlarms.GetItemData(i);
		  if(citem==item)
          {
			  m_ctrlListAlarms.GetText(i,dlg.m_strAlarmName);
			  i0=i;
			  break;
          }
      }
    }
	if(Number>0)
    {
       m_ctrlListAlarms.GetText(i1,Temp0);
	   i=Temp0.Find(", Set at Time ");
	   if(i>=0)
       {
          tempv.vt=VT_I2;
          i+=strlen(", Set at Time ");
		  Temp0=Temp0.Mid(i);		  
		  tempv.iVal=atoi(Temp0);
		  dlg.m_vHour=tempv;
		  i=Temp0.Find(':')+1;
		  Temp0=Temp0.Mid(i);
          tempv.iVal=atoi(Temp0);
		  dlg.m_vMinute=tempv;
		  i=Temp0.Find(':')+1;
          Temp0=Temp0.Mid(i);
          tempv.iVal=atoi(Temp0);
		  dlg.m_vSecond=tempv;
	   }
	   else
       {
		  i=Temp0.Find(" Ends at "); 
          if(i>=0)
          {
             i+=strlen(" Ends at ");
             Temp0=Temp0.Mid(i);
			 tempv.vt=VT_I2;
		     tempv.iVal=atoi(Temp0);
             TimeSpan=m_ctrlClock.GetChangeTimeInterval(Id,dlg.m_uAlarmNumber)/m_ctrlClock.GetPartOfSecondTick(); 
			 if(TimeSpan<=0)
				 TimeSpan=0;
			 long lti;
			 time(&lti);
			 t=*localtime(&lti);
			 t.tm_hour=TimeSpan/3600;
			 TimeSpan-=(TimeSpan/3600)*3600;
             t.tm_min=TimeSpan/60;
			 t.tm_sec=TimeSpan%60;
		     dlg.m_vHour=tempv;
		     i=Temp0.Find(':')+1;
		     Temp0=Temp0.Mid(i);
             tempv.iVal=atoi(Temp0);
		     dlg.m_vMinute=tempv;
		     i=Temp0.Find(':')+1;
             Temp0=Temp0.Mid(i);
             tempv.iVal=atoi(Temp0);
			 dlg.m_bMaxTimeIntervalAlarm=TRUE;			 
			 dlg.m_ictimeinterval=mktime(&t);
          }
       }
	}

	if(dlg.DoModal()==IDCANCEL)
		return;    
	m_bModifiedFlag=TRUE;
    m_ctrlClock.SetAlarmId(Id);
    m_ctrlClock.SetAlarmName(dlg.m_strAlarmName);
    m_ctrlClock.SetAlarmNumber(dlg.m_uAlarmNumber);
	citem=dlg.m_uAlarmNumber+Id*256;
	if(dlg.m_bDeleteAllAlarms)
	{
		m_ctrlClock.SetDeleteAllAlarms(FALSE);
		m_ctrlListAlarms.ResetContent();
		return;
    }
	if(dlg.m_bDeleteAlarmGroup)
    {
        m_ctrlClock.SetDeleteAlarm(Id);
		for(i=ii-1;i>=0;i--)
        {
			item=m_ctrlListAlarms.GetItemData(i);
			if((item/256)==Id)
                 m_ctrlListAlarms.DeleteString(i);
        }
		return;
    }
	if(dlg.m_bDeleteAlarm)
    {
        m_ctrlClock.SetDeleteAlarm24Hours(FALSE);
		for(i=ii-1;i>=0;i--)
        {
			item=m_ctrlListAlarms.GetItemData(i);
			if(item==citem)
                 m_ctrlListAlarms.DeleteString(i);
        }
		return; 
    }
	time(&l);
	memcpy(&t,localtime(&l),sizeof(struct tm));
	t.tm_hour=dlg.m_vHour.iVal;
	t.tm_min=dlg.m_vMinute.iVal;
	t.tm_sec=dlg.m_vSecond.iVal;
	m_ctrlClock.SetActivateCurAlarm(dlg.m_bActivateAlarm);
	m_ctrlClock.SetAlarm24hours(mktime(&t)); 
    m_ctrlListAlarms.DeleteString(i0);
    m_ctrlListAlarms.InsertString(i0,dlg.m_strAlarmName);
	m_ctrlListAlarms.SetItemData(i0,Id*256);
	Temp0=dlg.m_bActivateAlarm?"Enabled":"Disabled";
	if(dlg.m_bMaxTimeIntervalAlarm>0)
    {
		m_ctrlClock.SetChangeTimeInterval(Id,dlg.m_uAlarmNumber,dlg.m_ctimeinterval.GetTime());
	    t=*localtime(&l);
		t.tm_hour+=dlg.m_ctimeinterval.GetHour();
		t.tm_min+=dlg.m_ctimeinterval.GetMinute();
		t.tm_sec+=dlg.m_ctimeinterval.GetSecond();
		if(t.tm_sec>=60)
        {   
				t.tm_min++;
                t.tm_sec-=60;
		}
        if(t.tm_min>=60)
		{
				t.tm_hour++;
				t.tm_min-=60;
        }
		if(t.tm_hour>=24)
				t.tm_hour=0;
		Temp.Format("Alarm#%u,%s, Time Span Ends at %02u:%02u:%02u",dlg.m_uAlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
	}
	else
	    Temp.Format("Alarm#%u,%s, Set at Time %02u:%02u:%02u",dlg.m_uAlarmNumber,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
    Number=0;
	i1=i0;
	for(i=0;i<ii;i++)
    {
       item=m_ctrlListAlarms.GetItemData(i);
	   if(item==citem)
		   break;
	   if(item/256==Id)
         if(item%256>Number)
         {
           Number=item%256;
		   i1=i;
         }

    }
	if(i<ii)
    {
		m_ctrlListAlarms.DeleteString(i);
		m_ctrlListAlarms.InsertString(i,Temp);
		m_ctrlListAlarms.SetItemData(i,citem);
    }
	else
    {
    	i=m_ctrlListAlarms.InsertString(i1+1,Temp);
	    m_ctrlListAlarms.SetItemData(i1+1,citem);
    }
//	m_ctrlListAlarms.SetCurSel(i);
}

void YtvClockDial::OnSetAnalogClock() 
{
	// TODO: Add your command handler code here
    m_bDigitalFace=FALSE;
    if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
	m_ctrlClock.SetAnalogClock(!m_bDigitalFace);
}

void YtvClockDial::OnUpdateSetAnalogClock(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(!m_bDigitalFace);	
}

void YtvClockDial::OnUpdateSetDigitalClock(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_bDigitalFace);
}

void YtvClockDial::OnSetDigitalClock() 
{
	// TODO: Add your command handler code here
	m_bDigitalFace=TRUE;
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
	m_ctrlClock.SetAnalogClock(!m_bDigitalFace);

}

void YtvClockDial::OnSetBackgroundColorAlarm() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
    m_clrBackgroundAlarm=m_ctrlClock.GetAlarmBackColor();
	dlg.m_cc.rgbResult=	m_clrBackgroundAlarm;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrBackgroundAlarm=dlg.m_cc.rgbResult;
	m_ctrlClock.SetAlarmBackColor(m_clrBackgroundAlarm);
}
UINT CALLBACK YtvCCHookProcDial(
  HWND hdlg,      // handle to the dialog box window
  UINT uiMsg,     // message identifier
  WPARAM wParam,  // message parameter
  LPARAM lParam   // message parameter
)
{
  return 0;
}

void YtvClockDial::OnSetBackgroundColorClock() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
    m_clrBackgroundClock=m_ctrlClock.GetClockBackColor();
	dlg.m_cc.rgbResult=	m_clrBackgroundClock;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrBackgroundClock=dlg.m_cc.rgbResult;
	m_ctrlClock.SetClockBackColor(m_clrBackgroundClock);
}

void YtvClockDial::OnSetClockLineColor() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrForeLineClock=m_ctrlClock.GetClockForeLineColor();
	dlg.m_cc.rgbResult=	m_clrForeLineClock;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrForeLineClock=dlg.m_cc.rgbResult;
	m_ctrlClock.SetClockForeLineColor(m_clrForeLineClock);
}

void YtvClockDial::OnSetForegroundColorAlarm() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrForegroundAlarm=m_ctrlClock.GetAlarmForeColor();
	dlg.m_cc.rgbResult=	m_clrForegroundAlarm;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrForegroundAlarm=dlg.m_cc.rgbResult;
	m_ctrlClock.SetAlarmForeColor(m_clrForegroundAlarm);
}

void YtvClockDial::OnSetForegroundColorClock() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrForegroundClock=m_ctrlClock.GetClockForeColor();
	dlg.m_cc.rgbResult=	m_clrForegroundClock;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrForegroundClock=dlg.m_cc.rgbResult;
	m_ctrlClock.SetClockForeColor(m_clrForegroundClock);
}

void YtvClockDial::OnSetHandsAlarmColor() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrForeLineAlarm=m_ctrlClock.GetAlarmForeLineColor();
	dlg.m_cc.rgbResult=	m_clrForeLineAlarm;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrForeLineAlarm=dlg.m_cc.rgbResult;
	m_ctrlClock.SetAlarmForeLineColor(m_clrForeLineAlarm);
}
void YtvClockDial::OnBackLineColorClock() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrBackLineClock=m_ctrlClock.GetClockBackLineColor();	
	dlg.m_cc.rgbResult=	m_clrBackLineClock;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrBackLineClock=dlg.m_cc.rgbResult;
	m_ctrlClock.SetClockBackLineColor(m_clrBackLineClock);	
}

void YtvClockDial::OnBackDrawColorAlarm() 
{
	// TODO: Add your command handler code here
	CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrBackLineAlarm=m_ctrlClock.GetAlarmBackLineColor();
	dlg.m_cc.rgbResult=	m_clrBackLineAlarm;
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrBackLineAlarm=dlg.m_cc.rgbResult;
	m_ctrlClock.SetAlarmBackLineColor(m_clrBackLineAlarm);
}
void YtvClockDial::OnUpdateShowSeconds(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bShowSeconds);
}

void YtvClockDial::OnShowSeconds() 
{
	// TODO: Add your command handler code here
    
	m_bShowSeconds=m_bShowSeconds?FALSE:TRUE;
	m_ctrlClock.SetShowSeconds(m_bShowSeconds);
}

void YtvClockDial::OnUpdate24Hours(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(!m_b12hour);
}

void YtvClockDial::On24Hours() 
{
	// TODO: Add your command handler code here
	m_b12hour=m_b12hour?FALSE:TRUE;
	m_ctrlClock.SetSwitch12hours(m_b12hour);
}



void YtvClockDial::OnUpdateMatrixDigital(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_enTypeofFace==DIGITAL_SEGMENT);	
}

void YtvClockDial::OnMatrixDigital() 
{
	// TODO: Add your command handler code here
	m_enTypeofFace=DIGITAL_SEGMENT;
	OnSetDigitalClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}

void YtvClockDial::OnUpdateDigitalFont(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_enTypeofFace==DIGITAL_FONT);	
}

void YtvClockDial::OnDigitalFont() 
{
	// TODO: Add your command handler code here
	m_enTypeofFace=DIGITAL_FONT;
	OnSetDigitalClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
    if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}

void YtvClockDial::OnUpdateAnalogCentered(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_enTypeofFace==ANALOG_CENTERED);	
}

void YtvClockDial::OnAnalogCentered() 
{
	// TODO: Add your command handler code here
	m_enTypeofFace=ANALOG_CENTERED;
	OnSetAnalogClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}

void YtvClockDial::OnUpdateAnalogLeftAlighned(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_enTypeofFace==ANALOG_LEFT);
}

void YtvClockDial::OnAnalogLeftAlighned() 
{
	// TODO: Add your command handler code here
    m_enTypeofFace=ANALOG_LEFT;
	OnSetAnalogClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}
UINT CALLBACK YtvCFHookProcDial(
  HWND hdlg,      // handle to the dialog box window
  UINT uiMsg,     // message identifier
  WPARAM wParam,  // message parameter
  LPARAM lParam   // message parameter
)
{
	return 0;
}
void YtvClockDial::OnSetClockFont() 
{
	// TODO: Add your command handler code here
	CFontDialog dlg;
    static COleFont fn=m_ctrlClock.GetFont(); 
	LOGFONT lf;
	lf.lfUnderline = FALSE;
    lf.lfStrikeOut = FALSE;
    lf.lfItalic    = FALSE;
    lf.lfEscapement = FALSE;
    lf.lfOrientation = FALSE;
    lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
    lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfCharSet      = ANSI_CHARSET;
    lf.lfQuality      = DRAFT_QUALITY;
    lf.lfWeight      = FW_NORMAL;
    lf.lfPitchAndFamily = VARIABLE_PITCH | FF_SWISS;
	lf.lfHeight=40;
	lf.lfWidth=25;
	dlg.m_cf.lStructSize=sizeof(CHOOSEFONT);
	dlg.m_cf.lpLogFont=&lf;
/*	dlg.m_cf.Flags=CF_NOSTYLESEL|CF_NOFACESEL|CF_INITTOLOGFONTSTRUCT|CF_ENABLEHOOK|CF_EFFECTS; 
	dlg.m_cf.lpfnHook=YtvCFHookProcDial;
	dlg.m_cf.lpLogFont->lfItalic=fn.GetItalic();
	dlg.m_cf.lpLogFont->lfUnderline=fn.GetUnderline();
	dlg.m_cf.lpLogFont->lfStrikeOut=fn.GetStrikethrough();
	dlg.m_cf.lpLogFont->lfWeight=fn.GetWeight();
	dlg.m_cf.lpLogFont->lfCharSet=(unsigned char)fn.GetCharset();
	strcpy(dlg.m_cf.lpLogFont->lfFaceName,fn.GetName());*/
	if(dlg.DoModal()==IDCANCEL)
		return;
	fn.SetName(dlg.m_cf.lpLogFont->lfFaceName);
	union tagCY el;
	el.int64=abs(dlg.m_cf.lpLogFont->lfHeight);
	fn.SetSize(el);	
	fn.SetItalic(dlg.m_cf.lpLogFont->lfItalic);
	fn.SetUnderline(dlg.m_cf.lpLogFont->lfUnderline);	
	fn.SetStrikethrough(dlg.m_cf.lpLogFont->lfStrikeOut);
	fn.SetWeight((short)dlg.m_cf.lpLogFont->lfWeight);	
	fn.SetCharset(dlg.m_cf.lpLogFont->lfCharSet);
	m_ctrlClock.SetFont(fn);

}

void YtvClockDial::OnSettings() 
{
	// TODO: Add your control notification handler code here
	OnDblclkListAlarms(); 
}

void YtvClockDial::OnYtvSetTimeShift() 
{
	// TODO: Add your command handler code here
	m_nTimeShift=m_ctrlClock.GetPlusMinusHours();
	YtvSetTime dlg;
	dlg.m_nPlMiHours=m_nTimeShift;
	if(dlg.DoModal()==IDCANCEL)
		return;
	m_nTimeShift=dlg.m_nPlMiHours;
    m_ctrlClock.SetPlusMinusHours(m_nTimeShift);
}

void YtvClockDial::OnUpdateYtvSetTimeShift(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(m_nTimeShift);	
}



void YtvClockDial::OnCurrentAlarmYtvclockalarm(DATE DateTime, long AlarmId, long AlarmNumber, LPCTSTR AlarmName) 
{
	// TODO: Add your control notification handler code here
	//time_t tl=(time_t)DateTime;
	//struct tm ldate=*localtime(&tl);
	if(!IsWindow(m_ctrlListAlarms.m_hWnd))
		return;
	DWORD item, citem=AlarmId*256+AlarmNumber;
	int i,ii=m_ctrlListAlarms.GetCount();
	for(i=0; i<ii;i++)
    {
       item=m_ctrlListAlarms.GetItemData(i);
	   if(item!=citem)
		   continue;
	   m_ctrlListAlarms.SetCurSel(i);
    }

//	m_ctrlDate.SetTime(tl);
}

void YtvClockDial::OnDateChangedYtvclockalarm(DATE Date) 
{
	// TODO: Add your control notification handler code here
	time_t tl=(time_t)Date;
	m_ctrlDate.SetTime(tl);
}

void YtvClockDial::OnAlarmStartYtvclockalarm(DATE DateTime, long AlarmId) 
{
	// TODO: Add your control notification handler code here
	m_stSBMP.SetBitmap(m_hd);
}

void YtvClockDial::OnAlarmEndYtvclockalarm(DATE DateTime, long AlarmId) 
{
	// TODO: Add your control notification handler code here
	m_stSBMP.SetBitmap(m_hd);
}
void YtvClockDial::MaxRestoreClock()
{
    if(m_bClockFullScreen)
    {
       m_comboListTimerCircles.ShowWindow(SW_HIDE);
	   m_btStartTimer.ShowWindow(SW_HIDE);
	   m_stSBMP.ShowWindow(SW_HIDE);
	   m_ctrlDate.ShowWindow(SW_HIDE);
	   m_ctrlListAlarms.ShowWindow(SW_HIDE);
	   m_btUpdateAlarms.ShowWindow(SW_HIDE);
	   m_stListAlarms.ShowWindow(SW_HIDE);
       m_stSdOnOff.ShowWindow(SW_HIDE);
	   m_btAddAlarm.ShowWindow(SW_HIDE);
	   m_ctrlListAlarms.ShowWindow(SW_HIDE);
	   m_checkSetProfTimer.ShowWindow(SW_HIDE);
	   m_btOK.ShowWindow(SW_HIDE);
    }
	else
    {
       m_comboListTimerCircles.ShowWindow(SW_SHOW);
	   m_btStartTimer.ShowWindow(SW_SHOW);
	   m_stSBMP.ShowWindow(SW_SHOW);
	   m_ctrlDate.ShowWindow(SW_SHOW);
	   m_ctrlListAlarms.ShowWindow(SW_SHOW);
	   m_btUpdateAlarms.ShowWindow(SW_SHOW);
	   m_stListAlarms.ShowWindow(SW_SHOW);
       m_stSdOnOff.ShowWindow(SW_SHOW);
	   m_btAddAlarm.ShowWindow(SW_SHOW);
	   m_ctrlListAlarms.ShowWindow(SW_SHOW);
	   m_checkSetProfTimer.ShowWindow(SW_SHOW);
	   m_btOK.ShowWindow(SW_SHOW);
    }
}
void YtvClockDial::SizeControls(int cx, int cy)
{
    if(!IsWindow(m_ctrlListAlarms.m_hWnd))
		return;
	if(!IsWindow(m_ctrlClock.m_hWnd))
		return;
	if(m_bMoveFixed)
	  SetWindowPos(NULL,m_rectFixedPosition.left,m_rectFixedPosition.top,m_rectFixedPosition.right-m_rectFixedPosition.left+1,m_rectFixedPosition.bottom-m_rectFixedPosition.top+1,SWP_NOZORDER|SWP_NOSIZE);
	if(m_bSizeFixed)
	  SetWindowPos(NULL,m_rectFixedPosition.left,m_rectFixedPosition.top,m_rectFixedPosition.right-m_rectFixedPosition.left+1,m_rectFixedPosition.bottom-m_rectFixedPosition.top+1,SWP_NOZORDER|SWP_NOMOVE);
	if(cx<=0 || cy<=0)
		return;
	RECT rt0;
	m_ctrlListAlarms.GetWindowRect(&rt0);
	ScreenToClient(&rt0);
	rt0.bottom=cy;
    m_ctrlListAlarms.MoveWindow(&rt0);
	m_ctrlClock.GetWindowRect(&rt0);
	ScreenToClient(&rt0);
	rt0.bottom=cy;
	rt0.right=cx;
    MaxRestoreClock();
	if(m_bClockFullScreen)
	{
		rt0.left=m_nLeftClockPos;
        rt0.top=m_nTopClockPos;
    }
	else
    {
        rt0.left=m_pointOldClockPos.x;
		rt0.top=m_pointOldClockPos.y;
    }
	m_ctrlClock.MoveWindow(&rt0);
	m_ctrlClock.UpdateWindow();
	Invalidate();
}
void YtvClockDial::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);	
	// TODO: Add your message handler code here
	if(SIZE_MINIMIZED==nType)
		return;
	if(m_bAdjast)
		return;
    if(IsWindow(m_hWnd))
	   SizeControls(cx, cy);
	GetWindowRect(&m_rectPosition);
}

void YtvClockDial::OnUpdateYtvShowNextAlarmTime(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bDisplayAlarmTime);
}

void YtvClockDial::OnYtvShowNextAlarmTime() 
{
	// TODO: Add your command handler code here
    m_bDisplayAlarmTime=m_bDisplayAlarmTime?FALSE:TRUE;
	m_ctrlClock.SetDisplayAlarmTime(m_bDisplayAlarmTime);
}

void YtvClockDial::OnUpdateYtvRunClock(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bClockRunning);
}

void YtvClockDial::OnYtvRunClock() 
{
	// TODO: Add your command handler code here
     m_ctrlClock.SetRunClock(!m_bClockRunning);
	 m_bClockRunning=m_ctrlClock.GetRunClock();
}

void YtvClockDial::OnUpdateOnAlarmShowMessageBox(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bShowMessageBox);	
}

void YtvClockDial::OnOnAlarmShowMessageBox() 
{
	// TODO: Add your command handler code here
	m_bShowMessageBox=m_bShowMessageBox?FALSE:TRUE;
	m_ctrlClock.SetAlarmMessageBox(m_bShowMessageBox);
}

void YtvClockDial::OnSetAlarmMessageBoxText() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.CreateMessageTextBoxDialog();

}

void YtvClockDial::OnUpdatePlaySoundAtAlarm(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(m_bPlayAlarmSound);	
}

void YtvClockDial::OnPlaySoundAtAlarm() 
{
	// TODO: Add your command handler code here
	m_bPlayAlarmSound=m_bPlayAlarmSound?FALSE:TRUE;
    m_ctrlClock.SetPlayAlarmSound(m_bPlayAlarmSound);
	if(m_bPlayAlarmSound)
	{
		m_stSBMP.SetBitmap(m_hu); 
	}	
	else
    {
		m_stSBMP.SetBitmap(m_hf); 
	}	
}

void YtvClockDial::OnSetAlarmSound() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.SetSoundPropertiesDial(); 
}

void YtvClockDial::OnCancelSoundPlay() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.CancelPlayAlarmSound();
}

void YtvClockDial::OnUpdateSayTime(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bSayAlarmTime);
}

void YtvClockDial::OnSayTime() 
{
	// TODO: Add your command handler code here
	m_bSayAlarmTime=m_bSayAlarmTime?FALSE:TRUE;
	m_ctrlClock.SetSayAlarmTime(m_bSayAlarmTime);
}

void YtvClockDial::OnUpdateSayAlarmName(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bSayAlarmName);
}

void YtvClockDial::OnSayAlarmName() 
{
	// TODO: Add your command handler code here
	m_bSayAlarmName=m_bSayAlarmName?FALSE:TRUE;
	m_ctrlClock.SetSayAlarmName(m_bSayAlarmName);
}

void YtvClockDial::OnUpdateDefaultSettings(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_bDefaultSetting);
}

void YtvClockDial::OnDefaultSettings() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.SetDefaultSetting(TRUE);
    m_bDefaultSetting=m_ctrlClock.WriteSetting();
}

void YtvClockDial::OnUpdateCurrentSettings(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(!m_bDefaultSetting);
}

void YtvClockDial::OnCurrentSettings() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.SetDefaultSetting(FALSE);
	if(!m_strPath.IsEmpty())
        m_ctrlClock.SetSectionName(m_strPath);
    m_bDefaultSetting=m_ctrlClock.WriteSetting();
}

void YtvClockDial::OnUpdateGetDefaultSettings(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_bDefaultSetting);
}

void YtvClockDial::OnGetDefaultSettings() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.SetDefaultSetting(TRUE);
	m_bDefaultSetting=m_ctrlClock.GetSetting();
    m_strPath=m_ctrlClock.GetSectionName();
}

void YtvClockDial::OnUpdateGetCustomSetting(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(!m_bDefaultSetting);
}

void YtvClockDial::OnGetCustomSetting() 
{
	
    BOOL b=m_ctrlClock.MakeSectionListDial(FALSE);
	m_strPath=m_ctrlClock.GetSectionName();

}

void YtvClockDial::OnStaticbmpsound() 
{
	// TODO: Add your control notification handler code here
    HBITMAP hbm=m_stSBMP.GetBitmap();
    if(hbm!=m_hd)
    {
       OnPlaySoundAtAlarm();
	   return;
    }
	OnCancelSoundPlay();
	if(m_bPlayAlarmSound)
	{
		m_stSBMP.SetBitmap(m_hu); 
	}	
	else
    {
		m_stSBMP.SetBitmap(m_hf); 
	}	


}

void YtvClockDial::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CRect rt;
	m_stSBMP.GetWindowRect(&rt);
    ScreenToClient(&rt);
	if(rt.bottom>point.y && rt.top<point.y
		&& rt.left<point.x && rt.right>point.x)
		OnStaticbmpsound();
	CDialog::OnLButtonUp(nFlags, point);
}

void YtvClockDial::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnLButtonDblClk(nFlags, point);
}

void YtvClockDial::OnUpdateSetVoice(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnSetVoice() 
{
	// TODO: Add your command handler code here
	m_ctrlClock.SetVoiceDial();
}

void YtvClockDial::OnUpdateSayMessage(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bSayMessageText);
}

void YtvClockDial::OnSayMessage() 
{
	// TODO: Add your command handler code here
	m_bSayMessageText=m_bSayMessageText?FALSE:TRUE;
	m_ctrlClock.SetSayMessageText(m_bSayMessageText);
}

void YtvClockDial::OnTimeExpiredYtvclockalarm(long AlarmId) 
{
	// TODO: Add your control notification handler code here
	
}

void YtvClockDial::OnResetTimeSpanAlarm() 
{
	// TODO: Add your command handler code here
	int	i0=m_ctrlListAlarms.GetCurSel();
	if(i0==LB_ERR)
		return;
	int item0=m_ctrlListAlarms.GetItemData(i0);
    int Number=item0%256;
	if(Number==0)
		return;
	int Id=item0/256;
	m_ctrlClock.SetResetTimeAlarm(Id,Number);
	int Span=m_ctrlClock.GetTimeSpanAlarm(Id,Number);
	if(Span<=0)
		return;
	Span/=m_ctrlClock.GetTimeTickInterval();
	CString Temp;
    m_ctrlListAlarms.GetText(i0,Temp); 
    m_ctrlListAlarms.DeleteString(i0);
	long lt;
	time(&lt);
	struct tm t=*localtime(&lt);
	t.tm_hour+=Span/3600;
	Span-=(Span/3600)*3600;
	t.tm_min+=Span/60;
	t.tm_sec+=Span%60;
	if(t.tm_sec>=60)
    {   
				t.tm_min++;
                t.tm_sec-=60;
	}
    if(t.tm_min>=60)
	{
				t.tm_hour++;
				t.tm_min-=60;
    }
	if(t.tm_hour>=24)
				t.tm_hour-=24;
	int pos=Temp.Find("Enabled");
	CString Temp0=pos>=0?"Enabled":"Disabled";
    Temp.Format("Alarm#%u,%s, Time Span Ends at %02u:%02u:%02u",Number,Temp0,t.tm_hour,t.tm_min,t.tm_sec);
    m_ctrlListAlarms.InsertString(i0,Temp);
	m_ctrlListAlarms.SetItemData(i0,item0);
}

void YtvClockDial::OnAddAlarm() 
{
	// TODO: Add your command handler code here
	OnBtytvAddalarm(); 
}

void YtvClockDial::OnUpdateAlarm() 
{
	// TODO: Add your command handler code here
	OnDblclkListAlarms(); 
}

void YtvClockDial::HideShowOnTimer(BOOL bShowWhenTimer)
{
 if(bShowWhenTimer && m_bClockFullScreen==FALSE)
 {
   m_btStartTimer.ShowWindow(SW_SHOW);
   m_checkSetProfTimer.ShowWindow(SW_SHOW);
   m_comboListTimerCircles.ShowWindow(SW_SHOW);
 }
 else
 {
   m_btStartTimer.ShowWindow(SW_HIDE);
   m_checkSetProfTimer.ShowWindow(SW_HIDE);
   m_comboListTimerCircles.ShowWindow(SW_HIDE);
 }
}
void YtvClockDial::OnSetRoundedTimer() 
{
	// TODO: Add your command handler code here
	
	m_enTypeofFace=TIMER_RAY_ROUNDED;
	m_btStartTimer.ShowWindow(SW_SHOW);
	OnSetAnalogClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnUpdateSetRoundedTimer(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	pCmdUI->SetRadio(m_enTypeofFace==TIMER_RAY_ROUNDED);
}

void YtvClockDial::OnStartTimer() 
{
	// TODO: Add your control notification handler code here
	BOOL b=m_ctrlClock.GetStartTime(0,0,0,0);
	if(b)
    {
		m_ctrlClock.SetStartTime(-1,0,0,0,FALSE);
        m_btStartTimer.SetWindowText("Start Timer");
    }
	else
    {
		m_ctrlClock.SetStartTime(-1,0,0,0,TRUE);
        m_btStartTimer.SetWindowText("Stop Timer");
    }
}

void YtvClockDial::OnSetRoundedRingTimer() 
{
	// TODO: Add your command handler code here
	m_enTypeofFace=TIMER_RING_ROUNDED;
	m_btStartTimer.ShowWindow(SW_SHOW);
	OnSetAnalogClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}

void YtvClockDial::OnUpdateSetRoundedRingTimer(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_enTypeofFace==TIMER_RING_ROUNDED);
}

void YtvClockDial::OnSetProfTimer() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
    m_ctrlClock.SetProfTimer(m_bSetProfTimer);
    UpdateData(FALSE);
}

void YtvClockDial::OnEditchangeComboListNumberMinCircle() 
{
	// TODO: Add your control notification handler code here
	
}

void YtvClockDial::OnUpdateSetMultiPlankTimer(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_enTypeofFace==TIMER_MULTI_PLANK);
}

void YtvClockDial::OnSetMultiPlankTimer() 
{
	// TODO: Add your command handler code here
	m_enTypeofFace=TIMER_MULTI_PLANK;
	m_btStartTimer.ShowWindow(SW_SHOW);
	OnSetAnalogClock();
	m_ctrlClock.SetFaceHandsType(m_enTypeofFace);
	if(NotTimer())
   	     HideShowOnTimer(FALSE);
	else
		 HideShowOnTimer(TRUE);
}


void YtvClockDial::OnUpdateSetHandsStrpesLengthWidths(CCmdUI* pCmdUI) 
{
		
}

void YtvClockDial::OnSetHandsStrpesLengthWidths() 
{
	BOOL b=m_ctrlClock.SetLengthsHandsStripesWidths(FALSE);//Modal dialog
	
}

void YtvClockDial::OnUpdateSetTimeSpanForPeriods(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnSetTimeSpanForPeriods() 
{
	// TODO: Add your command handler code here
	BOOL b=m_ctrlClock.SetTimeSpansDial(FALSE);//Modal dialog
	FillTimeSpans();
}

void YtvClockDial::OnUpdateTimerLevel2Color(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}
void YtvClockDial::SetTimerColors(unsigned short colornumber)
{
    CColorDialog dlg;
	dlg.m_cc.Flags=CC_ANYCOLOR|CC_RGBINIT|CC_ENABLEHOOK;
	dlg.m_cc.lpfnHook=YtvCCHookProcDial;
	m_clrpTimerColor[colornumber]=m_ctrlClock.GetTimerColors(colornumber);
	dlg.m_cc.rgbResult=	m_clrpTimerColor[colornumber];
	if(dlg.DoModal()==IDCANCEL)
		return;
    m_clrpTimerColor[colornumber]=dlg.m_cc.rgbResult;
	m_ctrlClock.SetTimerColors(colornumber,m_clrpTimerColor[colornumber]);
}
void YtvClockDial::OnTimerLevel2Color() 
{
	// TODO: Add your command handler code here
	SetTimerColors(2);
}
void YtvClockDial::OnUpdateTimerLevel1Color(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnTimerLevel1Color() 
{
	// TODO: Add your command handler code here
		SetTimerColors(1);
}

void YtvClockDial::OnUpdateTimerLevel0Color(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnTimerLevel0Color() 
{
	// TODO: Add your command handler code here
	SetTimerColors(0);
}

void YtvClockDial::OnMove(int x, int y) 
{
	CDialog::OnMove(x, y);	
	// TODO: Add your message handler code here
	if(m_bAdjast)
		return;
	if(IsWindow(m_hWnd))
	   SizeControls(0, 0);
	CWnd *pmw=AfxGetMainWnd();
	pmw->GetWindowRect(&m_mwrect);
	GetWindowRect(&m_rectPosition);
}

BOOL YtvClockDial::Create(HWND hParentWnd,const char* caption) 
{
	// TODO: Add your specialized code here and/or call the base class
    m_pszCaption=(char*)caption;
	return CDialog::Create(IDD, CWnd::FromHandle(hParentWnd));
}
void YtvClockDial::OnUpdateClockFullScreen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bClockFullScreen);
}

void YtvClockDial::OnClockFullScreen() 
{
	// TODO: Add your command handler code here
	if(m_bClockFullScreen)
	{
		m_bClockFullScreen=FALSE;
	    SetMenu(&m_menu);	       
    }
	else
    {
		SetMenu(m_pmenu);
		m_bClockFullScreen=TRUE;		
    }
	DrawMenuBar(); 
   	RECT rt;
	GetWindowRect(&rt);
    SizeControls(rt.right-rt.left+1, rt.bottom-rt.top+1);
	ModifyStyle(0, 0,SWP_FRAMECHANGED);
	Invalidate();
}
void YtvClockDial::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
//	Exit();
	CDialog::OnClose();
}
void YtvClockDial::Exit()
{
    if(m_strPath.IsEmpty())
	{
		
	
    }
    else
	   	YtvWriteProfileString(m_strInstNumber,"m_strPath",m_strPath);
	YtvWriteProfileInt(m_strInstNumber,"m_bDefaultSetting",m_bDefaultSetting);
	//m_ctrlClock.SetDefaultSetting(FALSE);
	GetWindowRect(&m_rectFixedPosition);    
	YtvWriteProfileInt(m_strInstNumber,"m_rectFixedPosition.left",m_rectFixedPosition.left);
	YtvWriteProfileInt(m_strInstNumber,"m_rectFixedPosition.right",m_rectFixedPosition.right);
	YtvWriteProfileInt(m_strInstNumber,"m_rectFixedPosition.top",m_rectFixedPosition.top);
	YtvWriteProfileInt(m_strInstNumber,"m_rectFixedPosition.bottom",m_rectFixedPosition.bottom);
	YtvWriteProfileInt(m_strInstNumber,"m_bMoveFixed",m_bMoveFixed);
	YtvWriteProfileInt(m_strInstNumber,"m_bSizeFixed",m_bSizeFixed);	
	YtvWriteProfileInt(m_strInstNumber,"m_bClockFullScreen",m_bClockFullScreen);
	YtvWriteProfileInt(m_strInstNumber,g_szYtvClockDialAutoCreate,m_bYtvClockDialAutoCreate);
}
void YtvClockDial::OnOK() 
{
	// TODO: Add extra validation here
	Exit();
	if(!m_bModeless)
		CDialog::OnOK();   
    else
	    DestroyWindow();
}
void YtvClockDial::OnCancel() 
{
	// TODO: Add extra validation here
	if(!m_bModeless)
	    CDialog::OnCancel();
	else
		DestroyWindow();
}
void YtvClockDial::PreSubclassWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CDialog::PreSubclassWindow();
}

BOOL YtvClockDial::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: Add your specialized code here and/or call the base class
/*	if(!m_pszCaption)
    {
		cs.style=WS_CLIPCHILDREN|WS_VISIBLE|WS_DLGFRAME|WS_THICKFRAME|WS_POPUP;
    }*///does not work in dialog
	return CDialog::PreCreateWindow(cs);
}

void YtvClockDial::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class	
	CDialog::PostNcDestroy();
	if(m_bModeless)
	   delete this;
}

void YtvClockDial::OnUpdateDoNotResize(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bSizeFixed);
}

void YtvClockDial::OnDoNotResize() 
{
	// TODO: Add your command handler code here
	BOOL b;
	if(m_bSizeFixed)
	{
		m_bSizeFixed=FALSE;
        b=ModifyStyle(0,WS_THICKFRAME,SWP_FRAMECHANGED);
    }
	else  
	{
		m_bSizeFixed=TRUE;
		GetWindowRect(&m_rectFixedPosition);  
        b=ModifyStyle(WS_THICKFRAME,0,SWP_FRAMECHANGED);
    } 
}

void YtvClockDial::OnUpdateYtvStopMove(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bMoveFixed);
}

void YtvClockDial::OnYtvStopMove() 
{
	// TODO: Add your command handler code here
	BOOL b;
	if(m_bMoveFixed)
	{
		m_bMoveFixed=FALSE;
		b=ModifyStyle( WS_DLGFRAME|WS_POPUP,WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX, SWP_FRAMECHANGED);		
    }
	else
	{
		m_bMoveFixed=TRUE;
		GetWindowRect(&m_rectFixedPosition);  
		b=ModifyStyle(WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX, WS_DLGFRAME|WS_POPUP,SWP_FRAMECHANGED);
    }
	
}

void YtvClockDial::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	HMENU hMenu=CreatePopupMenu();
	CMenu menu;
/*	typedef struct tagTPMPARAMS { 
    UINT cbSize; 
    RECT rcExclude; 
} */TPMPARAMS tpm; 
	menu.LoadMenu(IDR_YTVCLOCKDIAL);
	POINT pt=point;
    ClientToScreen(&pt);
	BOOL b;
	 if(m_bClockFullScreen && MK_RBUTTON==nFlags)
	 {
      b=AppendMenu(hMenu,MF_POPUP,(DWORD)menu.m_hMenu,"Clock Window Menu");
	  if(b)
      {
       tpm.cbSize=sizeof(TPMPARAMS);
	   GetWindowRect(&tpm.rcExclude);
	   b=TrackPopupMenuEx(hMenu,TPM_LEFTBUTTON,pt.x, pt.y, m_hWnd, NULL);//&tpm);
       if(b)
       {
             //return;
       }
	  }
	  //DeleteMenu(hMenu,(DWORD)m_menu.m_hMenu,MF_BYCOMMAND);
     }
	 DestroyMenu(hMenu);

	CDialog::OnRButtonDown(nFlags, point);
}

void YtvClockDial::OnUpdateCloseWindowWithoutSave(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnCloseWindowWithoutSave() 
{
	// TODO: Add your command handler code here
	OnCancel();
}

void YtvClockDial::OnUpdateClosewindowAndSave(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnClosewindowAndSave() 
{
	// TODO: Add your command handler code here
	OnOK();
}

void YtvClockDial::OnUpdateYtvstopTimer(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void YtvClockDial::OnYtvstopTimer() 
{
	// TODO: Add your command handler code here
	 OnStartTimer();	
}

void YtvClockDial::OnUpdateUseProfTimer(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bSetProfTimer);
}

void YtvClockDial::OnUseProfTimer() 
{
	// TODO: Add your command handler code here
	OnSetProfTimer(); 
}
