<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

    
<% PageUtils.jspStart(request); %>



<% 
// Added this after finding an apparent bug in Tomcat: the page was cutting itself off after
// exactly 8K of output; this is the default buffer, so I increase the buffer here (this should
// absolutely not be necessary, but it does seem to fix the problem):
%>
<% // @ // REMOVING because later version of Tomcat choked on it: oh, Tomcat...  page buffer="200" %>



<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>
 
<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES,request); %>
<% PageUtils.setSubsection(WorkRollConstants.SUBSECTION_ISSUES_ACTIVE,request); %>

<%@ include file="../global/topInclude.jsp" %>
<%! 
      
%>

<%

%>
      
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<SCRIPT src=../global/HashMap.js></script>

<%@ include file="../global/headInclude.jsp" %>

<%@ include file="js/issuesHeadInclude.jsp" %>

<%@ include file="../global/objectsJs.jsp" %>
<%@ include file="../global/validationJs.jsp" %>

<SCRIPT src=../global/Calendar.js></script>

<script>

var minimumInitialRows=top.issues.keys().length
minimumInitialRows+=Math.max(minimumInitialRows*0.35,75)
minimumInitialRows=parseInt(minimumInitialRows)

</script>

<SCRIPT src=js/ListManager.js></script>

<script language="JavaScript">

<%@ include file="js/msToLabelsMap.jsp" %>
<%
// write status constants, map:
String[] constantNames=AbstractIssue.STATUS_JS_CONSTANT_NAMES;
int[] constantValues=AbstractIssue.STATUS_CODES;
String[] constantLabels=AbstractIssue.STATUS_LABELS;
%>
var statusCodesToLabelsMap=new HashMap()
<%
for (int i=0; i<constantNames.length; i++)
{
	%>
	var <%=constantNames[i]%>=<%=constantValues[i]%>
	statusCodesToLabelsMap.put(<%=constantNames[i]%>,"<%=constantLabels[i]%>")
	<%
}


// write priority constants, map:
constantNames=AbstractIssue.PRIORITY_JS_CONSTANT_NAMES;
constantValues=AbstractIssue.PRIORITY_CODES;
constantLabels=AbstractIssue.PRIORITY_LABELS;
%>
var priorityCodesToLabelsMap=new HashMap()
<%
for (int i=0; i<constantNames.length; i++)
{
	%>
	var <%=constantNames[i]%>=<%=constantValues[i]%>
	priorityCodesToLabelsMap.put(<%=constantNames[i]%>,"<%=constantLabels[i]%>")
	<%
}

%>

ListManager.init(top.issues.values())


function addIssue()
{
	return openDialog("issues/issueInput.jsp?mode=add", "addWin", 550, 325, false, true)
}
function editIssue(issueId)
{
	return openDialog("issues/issueInput.jsp?mode=edit&issueId="+issueId, "editWin", 550, 325, false, true)
}
function closeIssue(issueId,byUser,toUser)
{
	return openDialog("issues/closeIssue.jsp?id="+issueId+"&by="+escape(byUser)+"&to="+escape(toUser), "closeWin", 265, 325, false, true)
}
function reloadPage()
{
		var url=""
			+"list.jsp?"
			+"sl="+ListManager.isDisplaySingleLine+"&"
			+"asc="+ListManager.isAscendingSort+"&"
			+"siid="+ListManager.selectedIssueId+"&"
			+"sn="+ListManager.lastSortName
		top.location.replace(url)
}

function docKeypress()
{
	var code=event.keyCode
	//alert(code)
	
	if (ListManager.selectedRowIdx>0)
	{
		if (code==13) // enter
		{
			ListManager.openIssueDialog(ListManager.selectedRowIdx)
		}
		/*
		else if (code==45 || code==95) // minus key (w/shift or not)
		{
			//ListManager.highlightIssue(ListManager.selectedRowIdx-1)
		}
		else if (code==61 || code==43) // plus key (w/shift or not)
		{
			//ListManager.highlightIssue(ListManager.selectedRowIdx+1)
		}
		*/
	}
}
   
function returnFalse()
{
	return false
}



//////////// SORT FUNCTIONS: /////////////

// sort by the native sorting scheme for the field type:
function _genericSort(o1, o2, fieldName)
{
	var ret
	
	var o1=(o1==null?"":o1)
	var o2=(o2==null?"":o2)
	
	var v1=o1[fieldName]
	if (!v1 || v1==null)
	{
		v1=""
	}
	var v2=o2[fieldName]
	if (!v2 || v2==null)
	{
		v2=""
	}
	
	if (v1==v2)
	{
		ret=0
	}
	else
	{
		ret=(v1<v2?-1:1)
	}
	return ret
}
// sort by date (JS sometimes messes up Date comparisons, but comparing getTime() values always works):
function _dateSort(o1, o2, fieldName)
{
	if (o1[fieldName]==o2[fieldName])
	{
		return 0
	}
	return (o1[fieldName]<o2[fieldName]?-1:1)
}
// sort, for example, issues by assigned-to full name (as opposed to assignedToUserId):
function _alphaSortByObjectField(o1,o2,hashMap,primaryFieldName,secondaryFieldName)
{
	var f1=hashMap.get(o1[primaryFieldName])
	var f2=hashMap.get(o2[primaryFieldName])
	return _genericSort(f1,f2,secondaryFieldName)
}

// ISSUE sorters //
function idSort(o1,o2)
{
	return _genericSort(o1,o2,"id")
}
function assignedToUserFullnameSort(o1,o2)
{
	return _alphaSortByObjectField(o1,o2,top.users,"assignedToUserId","fullname")
}
function assignedByUserFullnameSort(o1,o2)
{
	return _alphaSortByObjectField(o1,o2,top.users,"assignedByUserId","fullname")
}
function statusSort(o1,o2)
{
	return _genericSort(o1,o2,"status")
}
function prioritySort(o1,o2)
{
	return _genericSort(o1,o2,"priority")
}
function projectNameSort(o1,o2)
{
	return _alphaSortByObjectField(o1,o2,top.projects,"projectId","name")
}
function instanceNameSort(o1,o2)
{
	return _alphaSortByObjectField(o1,o2,top.instances,"instanceId","name")
}
function openDateSort(o1,o2)
{
	return _dateSort(o1,o2,"openDate")
}
function dueDateSort(o1,o2)
{
	return _dateSort(o1,o2,"dueDate")
}
function descriptionSort(o1,o2)
{
	return _genericSort(o1,o2,"descriptionText")
}




function init()
{
	document.body.style.overflowX="hidden"
	//document.body.style.overflowY="scroll"
	ListManager.dataTableObj=document.getElementById("dataTable")
	//ListManager.addBlankRows()
	ListManager.setRowStyles()
	//ListManager.currentSort=openDateSort
	//ListManager.sort()
	//ListManager.updateList()
	ListManager.sortAndRedisplay(top.initialSortAscending,top.initialSortName,false)
	document.onkeypress=docKeypress
	document.getElementById("mainDiv").style.display="block"
	ListManager.listIsVisible=true
	//ListManager.highlightIssueById(ListManager.selectedIssueId)
}

</script> 


  

<style type="text/css">

BODY {background:#ffffff url(../images/listBg.gif); overflow-x:hidden; overflow-y:scroll; }
a {color:#870000;}
#mainDiv {position:absolute; top:0px; left:18px; width:770px;  }
#noIssuesIndicator {display:none; position:absolute; top:10px; left:185px; width:460px; text-align:center; border:1px solid #a2a278; background-color:#e2e2b1; padding:4px; font-family:arial,helvetica; font-size:11px; color:#000000; }

.buttonClass {color:#ffffff; }
.dataCellWidthConstraint {position:relative; top:0px; left:0px; overflow:hidden;}
.dataCellLeft {border-bottom:1px solid #A2A278; padding:3px; padding-top:3px; padding-bottom:3px; overflow:hidden; font-size:11px; font-family:arial,helvetica; }
.dataCell {border-left:1px solid #A2A278; border-bottom:1px solid #A2A278; padding:3px; padding-top:3px; padding-bottom:3px; overflow:hidden; font-size:11px; font-family:arial,helvetica; }
.dataCellHighlighted {border-bottom:1px solid #A2A278; border-left:1px solid #A2A278; padding:3px; padding-top:3px; padding-bottom:3px; overflow:hidden; font-size:11px; font-family:arial,helvetica; }
</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=noIssuesIndicator>

<%
if (controller.getSessionInfo().getCurrentFilter()==null)
{
	%>
	There are no active (non-closed) issues to view.  To add an issue, click the "add" button above.
	<%
}
if (controller.getSessionInfo().getCurrentFilter()!=null)
{
	%>
	<I>This list is filtered.</I> (See filter details at the bottom of the page.) As filtered, this list contains no active (non-closed) issues. To modify or remove the filter, click "modify this filter" or "remove this filter" below.  To add an issue, click the "add" button above.
	<%
}
%>
<BR>
</div>


<div id=mainDiv style="display:none;">



<div id=issuesListDiv>
<script>
ListManager.writeInitialTableHTML(false)
</script>
</div>




</div>


<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

