<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>
   
<%@ include file="../global/topInclude.jsp" %>

<%! 

%>

<%

boolean showInstallCompleteMsg=controller.getParamAsBoolean("icf", false);

String currProdKey=null;
try
{
	currProdKey=new String(controller.getCurrentInstallationConfig().getProductKey());
}
catch (Exception e){}
if (currProdKey==null)
{
	currProdKey="";
}
%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>



<%
if (showInstallCompleteMsg)
{
	%>

	<font class=bodyFont>
	<BR>
	<div style="border:1px solid #000000; padding:4px; background-color:#124340; width:410px; color:#ffcc00; ">


	<B>The WorkRoll installation process is complete.</B><BR><BR>
	
	If you have already purchased WorkRoll, you should enter your product key by clicking the "View/enter/update product key" link below.<BR><BR>
	
	If you wish to make additional configuration changes (such as adding more users, projects, or instances, or enabling e-mail-related features), you may do so from this page (which is always available, to administrators only, by clicking the "admin" link in the top navigation bar of every WorkRoll screen).<BR><BR>
	
	If you wish to start entering issues now, click <a href="../issues/index.jsp"><span style="text-decoration:none; color:#ff9900;">here</span></a> (or, from any WorkRoll screen, click the "issues" link at the top of the screen). To make changes to the user account that WorkRoll created for you during the instlalation process, click <a href="../userprefs/prefs.jsp"><span style="text-decoration:none; color:#ff9900;">here</span></a> (or, from any WorkRoll screen, click the "account" link at the top of the screen).<BR><BR>
	
	Finally, remember that technical support is always available to WorkRoll users (registered and unregistered) via the "support" link that appears in the top righthand corner of every WorkRoll screen.<BR><BR>

	Thank you for installing workRoll!<BR>

	</div>
	</font>
	<BR>
	
	<%
}
%>


<span class=standardTextBlockWidth>

<font class=bodyFont>

<span class=firstSentenceFont>The changes you make here</span> affect all users.  Please choose a task below:<%=HtmlUtils.doubleLB(request)%>
<font color=#000000>
<ul>

<li><a href=generalConfig.jsp>General preferences</a><%=HelpManager.helpLink("generalPreferences",request)%>

<li><a href=emailConfig.jsp>Configure/test mail-server settings</a><%=HelpManager.helpLink("configureMailServer",request)%>

<li>Users: <a href=addUsers.jsp>add</a> |
<a href=users.jsp>edit</a> |
<a href=userSummaries.jsp>view summaries</a><%=HelpManager.helpLink("user",request)%>

<li>Projects: <a href=addProjects.jsp>add</a> |
<a href=projects.jsp>edit</a> |
<a href=projectSummaries.jsp>view summaries</a><%=HelpManager.helpLink("project",request)%>

<li>Instances: <a href=addInstances.jsp>add</a> |
<a href=instances.jsp>edit</a><%=HelpManager.helpLink("instance",request)%>

<li><a href=updateKey.jsp>View/enter/update product key</a><%=HelpManager.helpLink("productKey",request)%>

<li><a href=<%=controller.getPurchaseLink()%> target=_blank>Purchase WorkRoll license</a> at WorkRoll.com

<li><a href=<%=controller.getUpgradeLink()%> target=_blank>Purchase WorkRoll upgrade</a> at WorkRoll.com

<li><a href=systemSummary.jsp>System summary</a>

</ul>
</font>
<%=HtmlUtils.doubleLB(request)%>

<br></font>
</span>

</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

