f// ViewTree.cpp : implementation of the CViewTree class
//

#include "stdafx.h"
#include "WinExp.h"

#include "Doc.h"
#include "ViewTree.h"
#include "ViewList.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CViewTree

IMPLEMENT_DYNCREATE(CViewTree, CTreeView)

BEGIN_MESSAGE_MAP(CViewTree, CTreeView)
	//{{AFX_MSG_MAP(CViewTree)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_NOTIFY_REFLECT(TVN_ITEMEXPANDING, OnItemexpanding)
	ON_NOTIFY_REFLECT(TVN_SELCHANGING, OnSelchanging)
	ON_COMMAND(ID_IMAGE, OnImage)
	ON_WM_TIMER()
	ON_NOTIFY_REFLECT(TVN_KEYDOWN, OnKeydown)
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewTree construction/destruction

CViewTree::CViewTree()
{
	m_bRefuseSelection = FALSE;
}

CViewTree::~CViewTree()
{
}

/////////////////////////////////////////////////////////////////////////////
BOOL CViewTree::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName,
						 DWORD dwStyle, const RECT& rect, 
						 CWnd* pParentWnd, UINT nID, 
						 CCreateContext* pContext) 
{
	dwStyle |= TVS_HASBUTTONS | TVS_HASLINES | TVS_LINESATROOT;	
	return CWnd::Create(lpszClassName, lpszWindowName, 
					dwStyle, rect, pParentWnd, nID, pContext);
}

/////////////////////////////////////////////////////////////////////////////
BOOL CViewTree::PreCreateWindow(CREATESTRUCT& cs)
{
	return CTreeView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CViewTree drawing

void CViewTree::OnDraw(CDC* pDC)
{
	CWinExpDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}

/////////////////////////////////////////////////////////////////////////////
// CViewTree diagnostics

#ifdef _DEBUG
void CViewTree::AssertValid() const
{
	CTreeView::AssertValid();
}

void CViewTree::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}

CWinExpDoc* CViewTree::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinExpDoc)));
	return (CWinExpDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CViewTree message handlers

/////////////////////////////////////////////////////////////////////////////
void CViewTree::OnInitialUpdate()
{
	CTreeView::OnInitialUpdate();

	CTreeCtrl& cTheTree = GetTreeCtrl();

	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();

	cTheTree.SetImageList(pFWnd->m_pSmallImageList, LVSIL_NORMAL);

	cTheTree.SetImageList(pFWnd->m_pStateImageList, TVSIL_STATE);

	// let all views paint then do the real init
	SetTimer(ID_DELAYTIMER, 100, NULL); // init 100mS later
}

///////////////////////////////////////////////////
void CViewTree::OnTimer(UINT nIDEvent) 
{
	CTreeView::OnTimer(nIDEvent);

	if (nIDEvent == ID_DELAYTIMER)
	{
		KillTimer(ID_DELAYTIMER); // just use it for one tick
		FillEmptyTree();
	}
}

///////////////////////////////////////////////////
void CViewTree::FillEmptyTree(void)
{
	// The real Explorer has a more sophisticated approach
	//	so that the tree can be built quickly. Also, it uses
	//	a thread (note progressive painting in Explorer).
	CWaitCursor cWait;

	CTreeCtrl& cTheTree = GetTreeCtrl();

	// form the one and only tree root - the desktop
	TV_INSERTSTRUCT	strInsert;

	// must use a selectedimage even if same
	strInsert.item.mask = TVIF_TEXT |
							TVIF_PARAM | 
							TVIF_IMAGE | 
							TVIF_SELECTEDIMAGE |
							TVIF_STATE;

	// make all the same - null state
	UINT uIndex = INDEXTOSTATEIMAGEMASK(0);
	strInsert.item.state = uIndex;
	strInsert.item.stateMask = TVIS_STATEIMAGEMASK;

	// a root item - so parent is NULL
	strInsert.hParent = NULL;

	// make the Desktop as the single root from the TreeCtrl's perspective
	// this solves a nasty problem: if no selection has been made yet
	//	and the window is hidden and re-exposed, MFC sends a Selchanged
	//	message causing the first item in the tree to get selection
	//	In our case this means causing a disk scan - not desired

	// index of the image in the list
	strInsert.item.iImage = IDI_DESKTOP - IDI_REMOVE;
	strInsert.item.iSelectedImage = strInsert.item.iImage;
	strInsert.item.lParam = (LPARAM) NULL;
	strInsert.item.pszText = (LPSTR)"Desktop";
	m_hDesktop = cTheTree.InsertItem(&strInsert);
	// all drives have this as their parent
	strInsert.hParent = m_hDesktop;

	// do the "drive type" work

	// get bitmask: LSB = A; LSB+1 = B; and so on
	DWORD dwDrives = ::GetLogicalDrives();
	UINT uType;
	char szDrive[20]; 

	szDrive[1] = ':';
	szDrive[2] = '\0';
	// do all 32 just for kicks
	for(int i = 0; i < 32; i++)
	{
		szDrive[0] = 'A' + (char)i;
		DWORD dwTemp = dwDrives;
		if (dwTemp & 1)
		{
			// my struct - see defines.h
			HITEMHELPER * pHelper = new HITEMHELPER;
			//TRACE("making new HITEMHELPER\n");
			memset(pHelper, 0, sizeof(HITEMHELPER));
			strInsert.item.lParam = (LPARAM)pHelper;

			pHelper->bIsARoot = TRUE;
			HTREEITEM hItemTemp;
			strInsert.item.pszText = (LPSTR)szDrive;
			ASSERT(strlen(szDrive)== 2);
			char szTemp[5];
			strcpy(szTemp, szDrive);
			strcat(szTemp, "\\.");
			uType = ::GetDriveType((LPCTSTR)szTemp);

			//CString sString = GetVolumeString(i, szTemp);

			pHelper->uDrivetype = uType;

			/* a reminder - similar order as bitmap numbers
			#define DRIVE_REMOVABLE   2
			#define DRIVE_FIXED       3
			#define DRIVE_REMOTE      4
			#define DRIVE_CDROM       5
			*/
			switch(uType)
			{
			case DRIVE_REMOVABLE:
				{
					strInsert.item.iImage = 
							IDI_REMOVE - IDI_REMOVE;
					break;
				}
			case DRIVE_FIXED:
				{
					strInsert.item.iImage = 
							IDI_FIXED - IDI_REMOVE;
					break;
				}
			case DRIVE_REMOTE:
				{
					strInsert.item.iImage = 
							IDI_REMOTE - IDI_REMOVE;
					break;
				}
			case DRIVE_CDROM:
				{
					strInsert.item.iImage = 
							IDI_CD - IDI_REMOVE;
					break;
				}
			default :
				{
					strInsert.item.iImage = 
							IDI_REMOVE - IDI_REMOVE;
					break;
				}
			}

			strInsert.item.iSelectedImage = strInsert.item.iImage;

			hItemTemp = cTheTree.InsertItem(&strInsert);

			// make this app start fast. just give it
			//	the appearance of real children and
			//	resolve it later if expanded
			AddPhonyChild(hItemTemp);
		}
		dwDrives = dwDrives >> 1;
	}

	//expand the Desktop
	cTheTree.Expand(m_hDesktop, TVE_EXPAND);
	//NOT cTheTree.SetItemState(m_hDesktop, TVIS_EXPANDED, TVIS_EXPANDED);

	cTheTree.SelectItem(m_hDesktop);
} 

/////////////////////////////////////////////////////////////////////////////
void CViewTree::AddPhonyChild(HTREEITEM hItem)
{
	CTreeCtrl& cTheTree = GetTreeCtrl();
	TV_ITEM strTvItem;

	strTvItem.mask = TVIF_HANDLE | TVIF_PARAM;
	strTvItem.hItem = hItem;

	cTheTree.GetItem(&strTvItem);
	HITEMHELPER * pHelper = (HITEMHELPER *)strTvItem.lParam;
	ASSERT(pHelper);
	ASSERT(pHelper->bHasPhonyChild == FALSE);
	pHelper->bHasPhonyChild = TRUE;

	TV_INSERTSTRUCT	strInsert;

	// must use a selectedimage even if same
	strInsert.item.mask = TVIF_PARAM | TVIF_TEXT;
	strInsert.hParent = hItem;
	strInsert.item.lParam = (LPARAM)NULL;
	strInsert.item.pszText = (LPSTR)"Phony";

	cTheTree.InsertItem(&strInsert);
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// NOTE: not all of the stuff in NM_TREEVIEW is valid.
	//	Only the itemNew .state and .hItem and .lParam are.

	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	UINT uState = pNMTreeView->itemNew.state;
	// isolate the expanded once flag
	uState &= TVIS_EXPANDEDONCE;

	// bias the result to 0 = good (1 is to refuse the present action)
	LRESULT lRes = 0;
	CTreeCtrl& cTheTree = GetTreeCtrl();

	// search for TVM_EXPAND in the Help for "action" definitions
	if ((pNMTreeView->action & TVE_EXPAND) && 
		(uState == 0) && // do if never before expanded
		pNMTreeView->itemNew.hItem != m_hDesktop) // desktop was done ages ago
	{
		// I do a GetItem just so I can do the ASSERT
		// and get the drive string in case of AfxMessageBox
		TV_ITEM strTvItem;
		char szText[MAX_PATH+1];
		strTvItem.mask = TVIF_CHILDREN | TVIF_TEXT;
		strTvItem.hItem = pNMTreeView->itemNew.hItem;
		strTvItem.pszText = (LPSTR)szText;
		strTvItem.cchTextMax = MAX_PATH;
		cTheTree.GetItem(&strTvItem);

		ASSERT(strTvItem.cChildren == 1); // cChildren is a code - not a count

		HITEMHELPER * pHelper = (HITEMHELPER *)pNMTreeView->itemNew.lParam;
		ASSERT(pHelper);

		// test if removable media is in
		BOOL bContinue = IsDriveReady(pHelper, szText);

		// continue if non-removable or removable is in
		if (bContinue)
		{
			if (pHelper->bHasPhonyChild)
			{
				pHelper->bHasPhonyChild = FALSE;
				HTREEITEM hChild;
				hChild = cTheTree.GetNextItem(
								pNMTreeView->itemNew.hItem,TVGN_CHILD);
				BOOL bDel = cTheTree.DeleteItem(hChild);
				//TRACE("Deleting Phony Child under %s\n", ItemToPath(pNMTreeView->itemNew.hItem));
				ASSERT(bDel);
			}

			CWaitCursor cWait;

			PopulateExpandingParent(pNMTreeView->itemNew.hItem);

			// never to this again
			pNMTreeView->itemNew.mask = TVIF_STATE;
			pNMTreeView->itemNew.stateMask |= TVIS_EXPANDEDONCE;
			pNMTreeView->itemNew.state |= TVIS_EXPANDEDONCE;
			cTheTree.SetItem(&(pNMTreeView->itemNew)); // NOT SetItemState 
		}
		else
		{
			lRes = 1;
		}
	}
	// what if collapsing - do not want to cause a scan of a parent
	//	if its child has present selection
	else if (pNMTreeView->action & TVE_COLLAPSE)
	{
		HTREEITEM hSel = cTheTree.GetSelectedItem();
		if (hSel != NULL)
		{
			CString sSelItem = ItemToPath(hSel);
			int nSelLen = sSelItem.GetLength();
			CString sCollapseItem = ItemToPath(pNMTreeView->itemNew.hItem);
			int nCollapseLen = sCollapseItem.GetLength();
			sSelItem = sSelItem.Left(nCollapseLen);
			// test if the collpasing parent is wholly contained in the 
			//	path of the child but do not do if both are the same
			//	as this is the double-click collapse technique
			if(sSelItem == sCollapseItem &&
				nCollapseLen != nSelLen) // last clause
			{
				// this flag will be examined in OnSelchanged
				m_bRefuseSelection = TRUE;
				TRACE("m_bRefuseSelection = TRUE\n");
			}
		}
	}
	*pResult = lRes;
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	// this empty handler just here to let you experiment

	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::FillFromTreeSelect(CString sFolder)
{
	TV_ITEM strTvItem;
	char szText[MAX_PATH+1]; 
	strTvItem.mask =  TVIF_TEXT;
	strTvItem.hItem = m_hDesktop;
	strTvItem.pszText = (LPSTR)szText;
	strTvItem.cchTextMax = MAX_PATH;
	CTreeCtrl& cTheTree = GetTreeCtrl();
	cTheTree.GetItem(&strTvItem);

	HTREEITEM hItem = cTheTree.GetSelectedItem();

	cTheTree.Expand(hItem, TVE_EXPAND);

	HTREEITEM hChild;
	hChild = cTheTree.GetNextItem(hItem, TVGN_CHILD);
	
	BOOL bGotHit = FALSE;
	while (hChild != NULL && !bGotHit)
	{
		strTvItem.hItem = hChild;
		cTheTree.GetItem(&strTvItem);

		CString sTest = strTvItem.pszText;
		if (sTest == sFolder)
		{
			bGotHit = TRUE;
		}
		else
		{
			hChild = cTheTree.GetNextItem(hChild, TVGN_NEXT);
		}
	}

	if (bGotHit)
	{
		cTheTree.SelectItem(hChild);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CWaitCursor cwait;

	LRESULT lres = 0;

	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	CViewList * pView = (CViewList*)pFWnd->m_wndSplitter.GetPane(PANE_ROW_ZERO, eListWinPane);
	ASSERT(pView != NULL);

	if (pNMTreeView->itemNew.hItem == m_hDesktop)
	{
		// get list
		pView->EmptyListAndPath();
		CListCtrl& cTheList = pView->GetListCtrl();

		// what item got selected?
		TV_ITEM strTvItem;
		char szText[MAX_PATH+1]; 
		strTvItem.mask =  TVIF_TEXT | TVIF_IMAGE;
		strTvItem.hItem = pNMTreeView->itemNew.hItem;
		strTvItem.pszText = (LPSTR)szText;
		strTvItem.cchTextMax = MAX_PATH;
		CTreeCtrl& cTheTree = GetTreeCtrl();
		cTheTree.GetItem(&strTvItem);

		HTREEITEM hChild;
		hChild = cTheTree.GetNextItem(pNMTreeView->itemNew.hItem, TVGN_CHILD);
		
		int i = 0;
		while (hChild != NULL)
		{
			strTvItem.hItem = hChild;

			cTheTree.GetItem(&strTvItem);
			
			// make list entry

			//prep a structure for the list
			LV_ITEM lvitem;
			// text and image
			lvitem.mask = LVIF_TEXT | LVIF_IMAGE;
			// must be zero for the 0th column
			lvitem.iSubItem = 0;
			// text 
			lvitem.pszText = strTvItem.pszText;
			// point to the row number
			lvitem.iItem = i;	  
			// image - same list at the tree's
			lvitem.iImage = strTvItem.iImage;
			// do the insert
			int nRet = cTheList.InsertItem(&lvitem); 
			// a check
			ASSERT(nRet != -1);

			// fill other columns with stuff

			// do col 1
			BOOL bRet = cTheList.SetItemText(nRet, eSize, "");	 
			ASSERT(bRet);

			// do col 2
			bRet = cTheList.SetItemText(nRet, eType, "");	 
			ASSERT(bRet);

			// do col 3
			bRet = cTheList.SetItemText(nRet, eModified, "");	 
			ASSERT(bRet);

			hChild = cTheTree.GetNextItem(hChild, TVGN_NEXT);
			i++;
		}
	}
	else
	{
		CString sPath = ItemToPath(pNMTreeView->itemNew.hItem);

		if (sPath.GetLength()) // will be NULL if at desktop
		{
			BOOL bContinue = TRUE;
			// are we at a root?
			if (sPath.GetLength() == 2)
			{
				HITEMHELPER * pHelper = (HITEMHELPER *)pNMTreeView->itemNew.lParam;
				ASSERT(pHelper);
				bContinue = IsDriveReady(pHelper, (const char *)sPath);
			}

			if (bContinue)
			{
				pView->FillList(sPath);
			}
			else
			{
				lres = 1;
			}
		}
	}

	*pResult = lres;
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::OnImage() 
{
	// get tree
	CTreeCtrl& cTheTree = GetTreeCtrl();

	HTREEITEM hItem = cTheTree.GetRootItem();
	if (hItem)
	{
		hItem = cTheTree.GetChildItem(hItem);
		while (hItem)
		{
			UINT uState = cTheTree.GetItemState(hItem, TVIS_STATEIMAGEMASK);
			uState &= TVIS_STATEIMAGEMASK;
			uState = uState >> 12;
			UINT uNewState = 1;
			if(uState)
			{
				uNewState = 0;
			}
			uNewState = INDEXTOSTATEIMAGEMASK(uNewState);
			cTheTree.SetItemState(hItem, uNewState, TVIS_STATEIMAGEMASK);
			hItem = cTheTree.GetNextSiblingItem(hItem);
		}
	}
}

////////////////////////////////////////////////////////////////////////////
void CViewTree::OnCloseCleanTree(void) 
{
	// typically called by OnClose in mainframe
	//	also called in this view for F5 or Refresh command
	CWaitCursor	wait;

	CTreeCtrl& cTheTree = GetTreeCtrl();
	CTreeCtrl*	pControl;
	pControl = &cTheTree;
	ASSERT(pControl);

	HTREEITEM hRoot = pControl->GetRootItem();	

	RecurseCleanTree(pControl, hRoot);
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::RecurseCleanTree(CTreeCtrl* pControl, HTREEITEM hItem)
{
	// get the current item.  if it has a non-NULL lParam, delete it
	//	recurse to children or move to next sibling

	TV_ITEM strTvItem;
	HITEMHELPER* pFreeMe;

	strTvItem.hItem = hItem;
	strTvItem.mask = TVIF_HANDLE | TVIF_CHILDREN | TVIF_PARAM;

	while (strTvItem.hItem != NULL)
	{
		pControl->GetItem(&strTvItem);

		pFreeMe = (HITEMHELPER*) strTvItem.lParam;
		if (pFreeMe != NULL)
		{
			//ASSUMPTION - this is a pointer from a new
			delete pFreeMe;
		}

		if (strTvItem.cChildren > 0)
		{
			RecurseCleanTree(pControl, pControl->GetChildItem(strTvItem.hItem));
		}

		strTvItem.hItem = pControl->GetNextSiblingItem(strTvItem.hItem);
	}

	return;
}

/////////////////////////////////////////////////////////////////////////////
// assumes szRoot is two characters e.g. "c:"
BOOL CViewTree::IsDriveReady(HITEMHELPER * pHelper, const char * szRoot)
{
	BOOL bContinue = TRUE;
	if (  (pHelper->bIsARoot) && 
		 ((pHelper->uDrivetype == DRIVE_REMOVABLE) ||
		  (pHelper->uDrivetype == DRIVE_CDROM)))
	{
		char szDriveName[5];
		strcpy(szDriveName, szRoot);
		strcat(szDriveName, "\\.");
		toupper(szDriveName[0]);

RETRY_LABEL:
		DWORD dwHold = ::GetFileAttributes(szDriveName);

		// If no error, media must be in drive.
		if (dwHold == 0xFFFFFFFF)
		{
			bContinue = FALSE;

			CString sMsg;
			sMsg.Format("%c:\\ is not accessible\n\n"
						"The device is not ready.                               \n\n"
						"(Install media or \nHit F5 to Refresh.)", szDriveName[0]);
			if (AfxMessageBox(sMsg, MB_ICONSTOP | MB_RETRYCANCEL) == IDRETRY)
			{
				goto RETRY_LABEL;
			}
		}
	}
	return bContinue;
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::PopulateExpandingParent(HTREEITEM hItem)
{
	CTreeCtrl& cTheTree = GetTreeCtrl();

	CString sPath = ItemToPath(hItem);

	CPtrList pList; // name of sub directories filled by FindSubs
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	pFWnd->FindSubItems(sPath, &pList, FILE_ATTRIBUTE_DIRECTORY);
		
	TV_INSERTSTRUCT	strInsert;

	strInsert.item.mask = TVIF_TEXT | TVIF_PARAM |
							TVIF_IMAGE | TVIF_SELECTEDIMAGE;

	// images
	strInsert.item.iImage = IDI_FOLDCLS - IDI_REMOVE;
	strInsert.item.iSelectedImage = IDI_FOLDOPEN - IDI_REMOVE;
	// the new item has a parent (not root)
	strInsert.hParent = hItem;
	// want alpha sorting
	strInsert.hInsertAfter = TVI_SORT; 

	while (pList.GetCount())
	{
		SUBITEM * pItem = (SUBITEM *)pList.GetHead();

		strInsert.item.pszText = (LPSTR)pItem->szName;

		// all tree items get this struct
		HITEMHELPER * pHelper = new HITEMHELPER;
		memset(pHelper, 0, sizeof(HITEMHELPER));
		strInsert.item.lParam = (LPARAM)pHelper;

		HTREEITEM hItemTemp = cTheTree.InsertItem(&strInsert);

		CString sPathTemp = sPath;
		sPathTemp += '\\';
		sPathTemp += strInsert.item.pszText;
		BOOL bSubs = AreThereSubDirs(sPathTemp);
		if (bSubs)
		{
			AddPhonyChild(hItemTemp);
		}
		delete pItem;
		pList.RemoveHead();		
	}
}

/////////////////////////////////////////////////////////////////////////////
CString CViewTree::ItemToPath(HTREEITEM hItem)
{
	// initially set hParent to hItem to get this guy's parent
	//	then work on up the line to DISK root (e.g. c:)

	// BUT dont include the TREE root - Desktop

	CTreeCtrl& cTheTree = GetTreeCtrl();

	TV_ITEM strTvItem;

	strTvItem.mask = TVIF_HANDLE | TVIF_TEXT;
	strTvItem.hItem = hItem;
	char szText[MAX_PATH+1];
	strTvItem.pszText = (LPSTR)szText;

	strTvItem.cchTextMax = MAX_PATH;

	HTREEITEM hParent = hItem;
	CString sPath = "";
	do
	{
		cTheTree.GetItem(&strTvItem);
		hParent = cTheTree.GetParentItem(hParent);
		if(hParent != NULL)
		{
			strTvItem.hItem = hParent;
			CString sTemp = szText;

			// make strings like Explorer - no directory
			//	is ever displayed in all CAPS
			CString sTemp2 = sTemp;
			sTemp2.MakeUpper();
			if(sTemp == sTemp2)
			{
				sTemp.MakeLower();
				sTemp.SetAt(0,sTemp2.GetAt(0));
			}
			else
			{
				; // use as is
			}

			sTemp.MakeReverse();
			sTemp += "\\";
			sPath += sTemp;
		}
	}
	while (hParent != NULL);
	sPath = sPath.Left(sPath.GetLength()-1); // remove final slash
	sPath.MakeReverse();
	return sPath;
}

/////////////////////////////////////////////////////////////////////////////
// return TRUE if there are any sub dirs (other than . and ..)
BOOL CViewTree::AreThereSubDirs(CString sStart)
{    
	BOOL bRet = FALSE;
	CString sTemp;
	CString mystart = sStart; // internal copy - source does not end in backslash
    mystart += "\\*"; // now search for any directory
	WIN32_FIND_DATA result;
	HANDLE retval = ::FindFirstFile(mystart, &result);
	if (retval != INVALID_HANDLE_VALUE)
	{
		if (result.cFileName[0] != '.'  && 
		   (result.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
		{
			bRet = TRUE;
		}	
		while (::FindNextFile(retval, &result) && !bRet)
		{
			if (result.cFileName[0] != '.'  && 
			   (result.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{		
				bRet = TRUE;
			}	
		}
		::FindClose(retval);
	}
	return bRet;
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::OnKeydown(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_KEYDOWN* pTVKeyDown = (TV_KEYDOWN*)pNMHDR;

	switch (pTVKeyDown->wVKey)
	{
	case 0x74: // F5
		{
			ResetTree();
			break;
		}
	case 0x9: // tab
		{
			CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
			CViewList * pListView = (CViewList*)pFWnd->m_wndSplitter.GetPane(PANE_ROW_ZERO, eListWinPane);
			ASSERT(pListView != NULL);
			pListView->SetFocus();
			CListCtrl& cTheList = pListView->GetListCtrl();
			POSITION pos = cTheList.GetFirstSelectedItemPosition();
			if (pos == NULL)
			{
				if (cTheList.GetItemCount())
				{
					cTheList.SetItemState(0, LVIS_FOCUSED, LVIS_FOCUSED);
				}
			}

			break;
		}
	default :
		{
			break;
		}
	}
	
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
void CViewTree::ResetTree(void) 
{
	CTreeCtrl& cTheTree = GetTreeCtrl();
	OnCloseCleanTree();
	cTheTree.DeleteAllItems();
	FillEmptyTree();
}














