// vec.h : main header file for the VEC DLL
#if !defined VEC_H
#define VEC_H

typedef BOOL (*CallBackProgress)(int progress_range_0_100, 
	 const char* operationName);
typedef int (*CallBackSc)(int);

BOOL vec_vectorize(HBITMAP hBmp,int pixelPerMeter, 
	const char* parameters, CallBackProgress callBackProgr = NULL);

void vec_stop();
int  vec_getProgress(char* buffOperationName, int buffSize);	
BOOL vec_isVectorizationTerminated();

void vec_setSc(CallBackSc);
#endif // !defined VEC_H


/*********************    Comments    **************************/
/*
	vec_vectorize(...) 
				the main function
				hBmp - 1 bit per pixel ( black and white ) DIB
				pixelPerMeter - pixel per meter
				parameters - settings in text form ( null terminated string ).
				See the file ReadMeSDK.txt for details.
	
	callBackProgr(int progress_range_0_100, const char* operationName) 
				Callback function to set the progress control.
				If it returns FALSE then the vectorization terminates.
				It is used in the sample application to vectorize in the
				primary thread of the process.

	vec_stop()  
				sets the global stop flag to stop the computations.
				At the next control point of the computations 
				the vectorization terminates. Here the control points 
				are points in the code of the vectorization engine 
				where the global stop flag is analized and also the 
				progress callback function called.

	vec_getProgress(...)  
				returns the progress in the range 0 - 100
				as well as the name of the current operation in 
				the buffer "buffOperationName".

	vec_isVectorizationTerminated() 
				returns TRUE if the vectorization is finished.
				Used to close the progress dialog in the sample 
				application.

    The sample application contains 2 implementations of the vectorization:
		1) in a separate thread. See the function: 
			void CUItoSDKView::OnVectorizeInNewThread()
		2) in the primary thread of the process. See the function:
			void CUItoSDKDoc::OnVectorize()
 */