
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PWCTREE_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PWCTREE_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.


#define USE_STATIC_

#ifdef USE_STATIC_
#define PWCTREE_API
#else

 #ifdef EXPORT_DLL_SYMBOLS

	#ifdef PWCTREE_EXPORTS
	#define PWCTREE_API __declspec(dllexport)
	#else
	#define PWCTREE_API __declspec(dllimport)
	#endif

 #else

	#define PWCTREE_API 

 #endif

#endif

#if !defined PWCTREE
#define PWCTREE
// This class is exported from the pwCtree.dll

enum PwCtreeType{pw_OutLine, pw_Frame};

struct PWCTREE_API PwCtree {

	struct DPOINT {	double x,y;};

	struct Holes
	{
		Holes(){m_pHoleDescription = NULL; m_pNextHole = NULL; };
		~Holes();

		PwCtree* m_pHoleDescription;
		Holes* m_pNextHole;
	};

	// we allocate a buffer m_buffer and copy data 
	// from buffer to m_bufferin the constructor
	PwCtree();	
	~PwCtree();

	void setTypeAsOutLine(){ m_type = pw_OutLine;};
	void setTypeAsFrame()  { m_type = pw_Frame;};	

	//data fields

	// if m_type = OutLine then this is an extern outline 
	// for some shape and the holes 
	//are holes in usual sense (holes do not intersect with the extern outline). 
	//If m_type = Frame then this is an internal boundary of a shape
	// and is not an external bound of any shape. 
	// In this case m_pHoles describes external bounds of 
	// shapes inside this frame.
	//These shapes can intersect with the frame.
	PwCtreeType m_type;
	Holes* m_pHoles;// in such a way holes are described
	Holes* m_pHolesTail;

	//allocate and returns the new added tail
	Holes* addTail();

	// allocates m_buffer of dirNumber elements and copy there 
	// data from buffer. Does other initialization stuff.
	bool init (unsigned char* buffer, int dirNumber, int initPos,
		int bmWidth);

	int m_isValid;
	int m_bounds[4]; 

	//the following parameters define a curve in bmp representation
	//buffer to store directions
	int				m_dirNumber;	
	unsigned char*  m_buffer;
	int				m_initPos;//we use position in 
	//an array like an artificial bitmap instead of x,y coordinates
	int				m_bmWidth;// we need bmp width to convert
	// positions into x,y coordinates and back;

	RGBQUAD			m_rgbqColor;//color of outline

	// bezier data
	int		m_bezierPointsNum;	
	DPOINT*	m_pPointBezier;
	
   
	bool newBezier(int dim);
	// it deletes old m_pPointBezier and  alloc new one
	// array of dimension dim. Returns true if successful	

};

void PWCTREE_API scaleBezier(PwCtree* pTree, double scale );
void PWCTREE_API scaleBezierXY(PwCtree* pTree, double scaleX
							 , double scaleY);


// flip and shift vertically by bmHeight
void PWCTREE_API flipShiftCTree(PwCtree* pTree, 
			int bmWidth, int bmHeight );

void PWCTREE_API mergeIntoPalette(PwCtree* pTree, 
			RGBQUAD* palette, int entryNum );

PWCTREE_API PwCtree * pwctr_newPwCtree( );
 
void PWCTREE_API pwctr_deletePwCtree(PwCtree* pTree );

PWCTREE_API bool pwctr_saveOL(const char* fname, PwCtree* pTree, 
							  int bmWidth, int bmHeight);
PWCTREE_API bool  pwctr_loadOL(PwCtree*&pTree, 
							  int &bmWidth, int &bmHeight, const char* fname);

#endif //PWCTREE


