VERSION 5.00
Object = "{C0A58BC3-1600-4C2C-8DDB-2DD7FDE5CA63}#1.0#0"; "vbalIml200_75B4A91C.ocx"
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmPropEd 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Property Editor Demo"
   ClientHeight    =   5865
   ClientLeft      =   840
   ClientTop       =   2130
   ClientWidth     =   6885
   Icon            =   "PropEd.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   391
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   459
   Begin iGrid250_75B4A91C.iGrid grdProp 
      Height          =   4875
      Left            =   3180
      TabIndex        =   5
      Top             =   480
      Width           =   3555
      _ExtentX        =   6271
      _ExtentY        =   8599
      FocusRect       =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin vbalIml200_75B4A91C.vbalImageList ImgList 
      Left            =   2100
      Top             =   2940
      _ExtentX        =   953
      _ExtentY        =   953
      IconSizeX       =   15
      IconSizeY       =   15
      ColourDepth     =   4
      Size            =   20400
      Images          =   "PropEd.frx":0442
      Version         =   131072
      KeyCount        =   20
      Keys            =   $"PropEd.frx":5412
   End
   Begin VB.OptionButton optAlph 
      Caption         =   "Alphabetic view"
      Height          =   255
      Left            =   3240
      TabIndex        =   2
      Top             =   5520
      Value           =   -1  'True
      Width           =   1635
   End
   Begin VB.OptionButton optCat 
      Caption         =   "Categorized view"
      Height          =   255
      Left            =   5100
      TabIndex        =   1
      Top             =   5520
      Width           =   1635
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Label1 properties:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   1
      Left            =   3180
      TabIndex        =   0
      Top             =   120
      Width           =   1545
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Test object (Label1):"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   0
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   1785
   End
   Begin VB.Label Label1 
      BackColor       =   &H00808000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Label1"
      ForeColor       =   &H00FFFFFF&
      Height          =   1815
      Left            =   120
      TabIndex        =   3
      Top             =   480
      Width           =   2775
   End
End
Attribute VB_Name = "frmPropEd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CATEGORY_APPEARANCE = "Appearance"
Private Const CATEGORY_MISC = "Misc"
Private Const CATEGORY_BEHAVIOR = "Behavior"
Private Const CATEGORY_POSITION = "Position"
   
Private Sub Form_Load()
   Dim i As Integer

   With grdProp
      .Redraw = False
   
      .Header.Visible = False
      .FocusRect = False
      .ImageList = ImgList
      .DefaultRowHeight = 3 + 15 * 15 / Screen.TwipsPerPixelY
      .DrawRowText = False
      .ShowControlsInAllCells = True
      .UseXPStyles = False
      
      .AddCol sKey:="group", _
         lWidth:=20, bVisible:=False
      .AddCol(sKey:="prop").eTextFlags = igTextVCenter Or igTextSingleLine
      .AddCol(sKey:="value").eTextFlags = igTextVCenter Or igTextSingleLine
      .AddCol(sKey:="category", bRowTextCol:=True).eTextFlags = igTextVCenter Or igTextSingleLine
      
      .AddRow
      .CellValue(.RowCount, "prop") = "(Name)"
      .CellValue(.RowCount, "value") = Label1.Name
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Alignment"
      With .Combos.Add("Justify")
         .AddItem sItemText:="0 - Left Justify", vItemValue:=0
         .AddItem sItemText:="1 - Right Justify", vItemValue:=1
         .AddItem sItemText:="2 - Center", vItemValue:=2
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "Justify"
      .CellValue(.RowCount, "value") = Label1.Alignment
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Appearance"
      With .Combos.Add("Appearance")
         .AddItem sItemText:="0 - Flat", vItemValue:=0
         .AddItem sItemText:="1 - 3D", vItemValue:=1
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "Appearance"
      .CellValue(.RowCount, "value") = Label1.Appearance
      .CellValue(.RowCount, "category") = CATEGORY_APPEARANCE
      
      .AddRow
      .CellValue(.RowCount, "prop") = "AutoSize"
      With .Combos.Add("True/False")
         .AddItem sItemText:="True", vItemValue:=True
         .AddItem sItemText:="False", vItemValue:=False
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "True/False"
      .CellValue(.RowCount, "value") = Label1.AutoSize
      .CellValue(.RowCount, "category") = CATEGORY_POSITION
      
      .AddRow
      .CellValue(.RowCount, "prop") = "BackColor"
      With .Combos.Add("Colors")
         .AddItem sItemText:="Black", vItemValue:=RGB(0, 0, 0), iIconIndex:=ImgList.ItemIndex("BLACK")
         .AddItem sItemText:="Dark Red", vItemValue:=RGB(128, 0, 0), iIconIndex:=ImgList.ItemIndex("DARKRED")
         .AddItem sItemText:="Dark Green", vItemValue:=RGB(0, 128, 0), iIconIndex:=ImgList.ItemIndex("DARKGREEN")
         .AddItem sItemText:="Ochre", vItemValue:=RGB(128, 128, 0), iIconIndex:=ImgList.ItemIndex("OCHRE")
         .AddItem sItemText:="Dark Blue", vItemValue:=RGB(0, 0, 128), iIconIndex:=ImgList.ItemIndex("DARKBLUE")
         .AddItem sItemText:="Purple", vItemValue:=RGB(128, 0, 128), iIconIndex:=ImgList.ItemIndex("PURPLE")
         .AddItem sItemText:="Turquoise", vItemValue:=RGB(0, 128, 128), iIconIndex:=ImgList.ItemIndex("TURQUOISE")
         .AddItem sItemText:="Silver", vItemValue:=RGB(192, 192, 192), iIconIndex:=ImgList.ItemIndex("SILVER")
         .AddItem sItemText:="Gray", vItemValue:=RGB(128, 128, 128), iIconIndex:=ImgList.ItemIndex("GRAY")
         .AddItem sItemText:="Red", vItemValue:=RGB(255, 0, 0), iIconIndex:=ImgList.ItemIndex("RED")
         .AddItem sItemText:="Green", vItemValue:=RGB(0, 255, 0), iIconIndex:=ImgList.ItemIndex("GREEN")
         .AddItem sItemText:="Yellow", vItemValue:=RGB(255, 255, 0), iIconIndex:=ImgList.ItemIndex("YELLOW")
         .AddItem sItemText:="Blue", vItemValue:=RGB(0, 0, 255), iIconIndex:=ImgList.ItemIndex("BLUE")
         .AddItem sItemText:="Magenta", vItemValue:=RGB(255, 0, 255), iIconIndex:=ImgList.ItemIndex("MAGENTA")
         .AddItem sItemText:="Cyan", vItemValue:=RGB(0, 255, 255), iIconIndex:=ImgList.ItemIndex("CYAN")
         .AddItem sItemText:="White", vItemValue:=RGB(255, 255, 255), iIconIndex:=ImgList.ItemIndex("WHITE")
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "Colors"
      .CellValue(.RowCount, "value") = Label1.BackColor
      .CellValue(.RowCount, "category") = CATEGORY_APPEARANCE
      
      .AddRow
      .CellValue(.RowCount, "prop") = "BackStyle"
      With .Combos.Add("BackStyle")
         .AddItem sItemText:="0 - Transparent", vItemValue:=0
         .AddItem sItemText:="1 - Opaque", vItemValue:=1
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "BackStyle"
      .CellValue(.RowCount, "value") = Label1.BackStyle
      .CellValue(.RowCount, "category") = CATEGORY_APPEARANCE
      
      .AddRow
      .CellValue(.RowCount, "prop") = "BorderStyle"
      With .Combos.Add("BorderStyle")
         .AddItem sItemText:="0 - None", vItemValue:=0
         .AddItem sItemText:="1 - Fixed Single", vItemValue:=1
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "BorderStyle"
      .CellValue(.RowCount, "value") = Label1.BorderStyle
      .CellValue(.RowCount, "category") = CATEGORY_APPEARANCE
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Caption"
      .CellValue(.RowCount, "value") = Label1.Caption
      .CellTextFlags(.RowCount, "value") = igTextWordBreak
      .CellValue(.RowCount, "category") = CATEGORY_APPEARANCE
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Enabled"
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "True/False"
      .CellValue(.RowCount, "value") = Label1.Enabled
      .CellValue(.RowCount, "category") = CATEGORY_BEHAVIOR
      
      .AddRow
      .CellValue(.RowCount, "prop") = "ForeColor"
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "Colors"
      .CellValue(.RowCount, "value") = Label1.ForeColor
      .CellValue(.RowCount, "category") = CATEGORY_APPEARANCE
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Height"
      .CellValue(.RowCount, "value") = Label1.Height
      .CellValue(.RowCount, "category") = CATEGORY_POSITION
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Left"
      .CellValue(.RowCount, "value") = Label1.Left
      .CellValue(.RowCount, "category") = CATEGORY_POSITION
      
      .AddRow
      .CellValue(.RowCount, "prop") = "MousePointer"
      With .Combos.Add("MousePointer")
         .AddItem sItemText:="0 - Default", vItemValue:=0
         .AddItem sItemText:="1 - Arrow", vItemValue:=1
         .AddItem sItemText:="2 - Cross", vItemValue:=2
         .AddItem sItemText:="3 - I-Beam", vItemValue:=3
         .AddItem sItemText:="4 - Icon", vItemValue:=4
         .AddItem sItemText:="5 - Size", vItemValue:=5
         .AddItem sItemText:="6 - Size NE SW", vItemValue:=6
         .AddItem sItemText:="7 - Size N S", vItemValue:=7
         .AddItem sItemText:="8 - Size NW SE", vItemValue:=8
         .AddItem sItemText:="9 - Size W E", vItemValue:=9
         .AddItem sItemText:="10 - Up Arrow", vItemValue:=10
         .AddItem sItemText:="11 - Hourglass", vItemValue:=11
         .AddItem sItemText:="12 - No Drop", vItemValue:=12
         .AddItem sItemText:="13 - Arrow and Hourglass", vItemValue:=13
         .AddItem sItemText:="14 - Arrow and Question", vItemValue:=14
         .AddItem sItemText:="15 - Size All", vItemValue:=15
      End With
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "MousePointer"
      .CellValue(.RowCount, "value") = Label1.MousePointer
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Tag"
      .CellValue(.RowCount, "value") = Label1.Tag
      .CellTextFlags(.RowCount, "value") = igTextWordBreak
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AddRow
      .CellValue(.RowCount, "prop") = "ToolTipText"
      .CellValue(.RowCount, "value") = Label1.ToolTipText
      .CellTextFlags(.RowCount, "value") = igTextWordBreak
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Top"
      .CellValue(.RowCount, "value") = Label1.Top
      .CellValue(.RowCount, "category") = CATEGORY_POSITION
      
      .AddRow
      .CellValue(.RowCount, "prop") = "UseMnemonic"
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "True/False"
      .CellValue(.RowCount, "value") = Label1.UseMnemonic
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AddRow
      .CellValue(.RowCount, "prop") = "Width"
      .CellValue(.RowCount, "value") = Label1.Width
      .CellValue(.RowCount, "category") = CATEGORY_POSITION
      
      .AddRow
      .CellValue(.RowCount, "prop") = "WordWrap"
      .CellType(.RowCount, "value") = igCellCombo
      .CellTypeFlags(.RowCount, "value") = igComboBtnFlat
      .CellCtrlKey(.RowCount, "value") = "True/False"
      .CellValue(.RowCount, "value") = Label1.WordWrap
      .CellValue(.RowCount, "category") = CATEGORY_MISC
      
      .AutoWidthCol "prop"
      optAlph_Click
      
      .Redraw = True
   End With
   
   gpCheckShowTips Me
End Sub

Private Sub pSetProp(sPropName As String, vPropValue As Variant)
   Dim iRow As Long
   
   With grdProp
      For iRow = 1 To .RowCount
         If .CellValue(iRow, "prop") = sPropName Then
            .CellValue(iRow, "value") = vPropValue
            Exit For
         End If
      Next
   End With
End Sub

Private Sub grdProp_AfterCommitEdit(ByVal lRow As Long, ByVal lCol As Long)
   Select Case grdProp.CellValue(lRow, "prop")
   Case "Alignment": Label1.Alignment = grdProp.CellValue(lRow, "value")
   Case "Appearance": Label1.Appearance = grdProp.CellValue(lRow, "value")
   Case "AutoSize"
      Label1.AutoSize = grdProp.CellValue(lRow, "value")
      If Label1.AutoSize Then
         pSetProp "Height", Label1.Height
         pSetProp "Width", Label1.Width
      End If
   Case "BackColor": Label1.BackColor = grdProp.CellValue(lRow, "value")
   Case "BackStyle": Label1.BackStyle = grdProp.CellValue(lRow, "value")
   Case "BorderStyle": Label1.BorderStyle = grdProp.CellValue(lRow, "value")
   Case "Caption":
      ' Label1.Caption = grdProp.CellValue(lRow, "value") - don't need - see the TextEditChange Event
      grdProp.AutoHeightRow lRow
   Case "Enabled": Label1.Enabled = grdProp.CellValue(lRow, "value")
   Case "ForeColor": Label1.ForeColor = grdProp.CellValue(lRow, "value")
   Case "Height": Label1.Height = grdProp.CellValue(lRow, "value")
   Case "Left": Label1.Left = grdProp.CellValue(lRow, "value")
   Case "MousePointer": Label1.MousePointer = grdProp.CellValue(lRow, "value")
   Case "Tag":
      Label1.Tag = grdProp.CellValue(lRow, "value")
      grdProp.AutoHeightRow lRow
   Case "ToolTipText":
      Label1.ToolTipText = grdProp.CellValue(lRow, "value")
      grdProp.AutoHeightRow lRow
   Case "Top": Label1.Top = grdProp.CellValue(lRow, "value")
   Case "UseMnemonic": Label1.UseMnemonic = grdProp.CellValue(lRow, "value")
   Case "WordWrap": Label1.WordWrap = grdProp.CellValue(lRow, "value")
   Case "Width": Label1.Width = grdProp.CellValue(lRow, "value")
   End Select
End Sub

Private Sub grdProp_CancelEdit(ByVal lRow As Long, ByVal lCol As Long)
   If grdProp.CellValue(lRow, "prop") = "Caption" Then
      Label1.Caption = grdProp.CellValue(lRow, "value")
   End If
End Sub

Private Sub grdProp_CellSelectionChange(ByVal lRow As Long, ByVal lCol As Long, ByVal bSelected As Boolean)
   With grdProp
      If .RowIsGroup(lRow) Then
         If .RowTag(lRow) = "-" Then
            .CellIcon(lRow, lCol) = ImgList.ItemIndex(IIf(bSelected, "minus_white", "minus_black"))
         Else
            .CellIcon(lRow, lCol) = ImgList.ItemIndex(IIf(bSelected, "plus_white", "plus_black"))
         End If
      End If
   End With
End Sub

Private Sub grdProp_DblClick(ByVal lRow As Long, ByVal lCol As Long, bRequestEdit As Boolean)
   Dim iRow As Long
   
   If (lRow = 0) Or (lCol = 0) Then Exit Sub

   With grdProp
   
      If .RowIsGroup(lRow) Then
         ' Group row - collapse/expand
         .Redraw = False
         If .RowTag(lRow) = "-" Then
            ' collapse
            .CellIcon(lRow, .ColCount) = ImgList.ItemIndex("plus_white")
            .RowTag(lRow) = "+"
            For iRow = lRow + 1 To .RowCount
               If .RowIsGroup(iRow) Then Exit For
               .RowVisible(iRow) = False
            Next
         Else
            ' expand
            .CellIcon(lRow, .ColCount) = ImgList.ItemIndex("minus_white")
            .RowTag(lRow) = "-"
            For iRow = lRow + 1 To .RowCount
               If .RowIsGroup(iRow) Then Exit For
               .RowVisible(iRow) = True
            Next
         End If
         .Redraw = True
      
      Else
      
         If .CellType(lRow, lCol) = igCellCombo Then
            Dim ii As Long
            With .Combos(.CellCtrlKey(lRow, lCol))
               ii = .ValueIndex(grdProp.CellValue(lRow, lCol))
               ii = (ii + 1) Mod .ListCount
               grdProp.CellValue(lRow, lCol) = .ItemValue(ii)
            End With
            grdProp_AfterCommitEdit lRow, lCol
            bRequestEdit = False
         End If
      
      End If
      
   End With
End Sub

Private Sub grdProp_BeforeCommitEdit(ByVal lRow As Long, ByVal lCol As Long, eResult As EEditResults, ByVal sNewText As String, vNewValue As Variant, ByVal lConvErr As Long)
   Select Case grdProp.CellValue(lRow, "prop")
   Case "Height", "Width"
      If vNewValue <= 0 Or vNewValue > 200 Then
         MsgBox "Must be a value from 1 to 200!"
         eResult = igEditResProceed
      End If
   Case "Left", "Top"
      If vNewValue < -10 Or vNewValue > 100 Then
         MsgBox "Must be a value from -10 to 100!"
         eResult = igEditResProceed
      End If
   End Select
End Sub

Private Sub grdProp_MouseDown(ByVal Button As Integer, Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean, ByVal bUnderControl As Boolean)
   If lRow <> 0 And lCol <> 0 Then
      If grdProp.RowIsGroup(lRow) Then
         If (2 <= X) And (X <= 13) Then
            grdProp_DblClick lRow, lCol, False
         End If
      End If
   End If
End Sub

Private Sub grdProp_RequestEdit(ByVal lRow As Long, ByVal lCol As Long, ByVal iKeyAscii As Integer, bCancel As Boolean, sText As String, lMaxLength As Long, eTextEditOpt As iGrid250_75B4A91C.ETextEditFlags)
   If grdProp.ColKey(lCol) <> "value" Then
      bCancel = True
      Exit Sub
   End If
   
   Select Case grdProp.CellValue(lRow, "prop")
   Case "(Name)"
      MsgBox "Read-only at run-time"
      bCancel = True
   Case "Left", "Top"
      If Not (IsNumeric(sText) Or sText = "-") Then
         bCancel = True
      End If
   Case "Width", "Height"
      If Not IsNumeric(sText) Then
         bCancel = True
      End If
   End Select
End Sub

Private Sub grdProp_TextEditChange(ByVal lRow As Long, ByVal lCol As Long)
   If grdProp.CellValue(lRow, "prop") = "Caption" Then
      Label1.Caption = grdProp.TextEditText
   End If
End Sub

Private Sub grdProp_TextEditKeyPress(ByVal lRow As Long, ByVal lCol As Long, KeyAscii As Integer)
   Select Case grdProp.CellValue(lRow, "prop")
   
   Case "Height", "Width"
      
      Select Case KeyAscii
      Case &H20 To &H2F, Is >= &H3A
         ' Only numeric keys and control keys
         KeyAscii = 0
      End Select
   
   Case "Left", "Top"
      
      ' The following block of code allows to enter only positive or negative integer values
      Select Case KeyAscii
      Case &H30 To &H39
         If grdProp.TextEditSelStart = 0 And InStr(grdProp.TextEditText, "-") > 0 Then
            KeyAscii = 0
         End If
      Case &H2D   ' "minus"
         If grdProp.TextEditSelStart > 0 Or InStr(grdProp.TextEditText, "-") > 0 Then
            KeyAscii = 0
         End If
      Case &H20 To &H2C, &H2E, &H2F, Is >= &H3A
         ' Only numeric keys, "minus" key and control keys
         KeyAscii = 0
      End Select
   
   End Select
End Sub

Private Sub optAlph_Click()
   Dim iRow As Long, i As Integer

   With grdProp
      .Redraw = False
   
      .ColVisible("group") = False
      
      iRow = .RowCount
      Do While iRow > 0
         If .RowIsGroup(iRow) Then
            .RemoveRow iRow
         Else
            .RowVisible(iRow) = True
         End If
         iRow = iRow - 1
      Loop
      
'      With .SortObject
'         .ColCount = 1
'         .SortCol(1) = grdProp.ColIndex("prop")
'         '.SortOrder(1) = igSortAsc    by default in the current version
'         '.SortType(1)=igSortByValue   by default too
'      End With
' In the v2.10 you can replace the code above on the following statement:
      .Sort "prop"
      
      .ColWidth("value") = .Width - .ColWidth("prop") - .VScrollBar.Thickness - 8
      For i = 1 To .Combos.Count
         .Combos(i).SetWidth .ColWidth("value")
      Next
      
      .Redraw = True
   End With
End Sub

Private Sub optCat_Click()
   Dim iRow As Long
   Dim CurValue As Variant
   Dim GroupFont As StdFont
   Dim i As Integer

   Set GroupFont = New StdFont
   GroupFont.Name = grdProp.Font.Name
   GroupFont.Size = grdProp.Font.Size
   GroupFont.Bold = True

   With grdProp
      .Redraw = False
      
      .ColVisible("group") = True
      
'      With .SortObject
'         .ColCount = 2
'         .SortCol(1) = grdProp.ColIndex("category")
'         .SortOrder(1) = igSortAsc
'         .SortType(1) = igSortByValue
'         .SortCol(2) = grdProp.ColIndex("prop")
'         .SortOrder(2) = igSortAsc
'         .SortType(2) = igSortByValue
'      End With
' In the v2.10 you can replace the code above on the following statement:
      .Sort Array("category", "prop")
      
      iRow = 1
      Do While iRow <= .RowCount
         If CurValue <> .CellValue(iRow, "category") Then
            CurValue = .CellValue(iRow, "category")
            .AddRow vRowBefore:=iRow, bGroupRow:=True
            .CellValue(iRow, .ColCount) = .CellText(iRow + 1, "category")
            .RowTag(iRow) = "-"
            .CellFont(iRow, .ColCount) = GroupFont
            .CellIcon(iRow, .ColCount) = ImgList.ItemIndex("minus_black")
            iRow = iRow + 1
         End If
         iRow = iRow + 1
      Loop
      
      .ColWidth("value") = .Width - .ColWidth("prop") - .ColWidth("group") _
         - .VScrollBar.Thickness - 8
      For i = 1 To .Combos.Count
         .Combos(i).SetWidth .ColWidth("value")
      Next
      
      .Redraw = True
   End With
End Sub
