VERSION 5.00
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmCustomDraw 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "iGrid Custom Daw Demo"
   ClientHeight    =   6735
   ClientLeft      =   3045
   ClientTop       =   1335
   ClientWidth     =   7065
   Icon            =   "CustomDraw.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   449
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   471
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   6600
      Top             =   5340
   End
   Begin iGrid250_75B4A91C.iGrid iGrid1 
      Height          =   2595
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   6840
      _ExtentX        =   12065
      _ExtentY        =   4577
      FocusRect       =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin iGrid250_75B4A91C.iGrid iGrid2 
      Height          =   2295
      Left            =   120
      TabIndex        =   3
      Top             =   4320
      Width           =   6840
      _ExtentX        =   12065
      _ExtentY        =   4048
      FocusRect       =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label3 
      Caption         =   $"CustomDraw.frx":0442
      Height          =   435
      Left            =   120
      TabIndex        =   5
      Top             =   3840
      Width           =   6795
   End
   Begin VB.Label Label2 
      Caption         =   $"CustomDraw.frx":04FF
      Height          =   435
      Left            =   120
      TabIndex        =   4
      Top             =   360
      Width           =   6795
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Dynamic Custom Draw Cells:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   1
      Left            =   120
      TabIndex        =   2
      Top             =   3600
      Width           =   2430
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Static Custom Draw Cells:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   0
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   2205
   End
End
Attribute VB_Name = "frmCustomDraw"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CIRCLE_DIAMETER = 28
Private Const D_ANGLE = 18
Private Const D_PROGRESS = 5


' Clip region functions
Private Declare Function GetClipRgn Lib "gdi32" (ByVal hdc As Long, ByVal Rgn As Long) As Long
Private Declare Function SelectClipRgn Lib "gdi32" (ByVal hdc As Long, ByVal Rgn As Long) As Long

' Custom draw functions, types and constants
Const TRANSPARENT = 1

Private Const DT_BOTTOM = &H8
Private Const DT_RIGHT = &H2
Private Const DT_SINGLELINE = &H20
Private Const DT_VCENTER = &H4
Private Const DT_CENTER = &H1

Private Const PS_SOLID = 0

Private Type RECT
   Left As Long
   Top As Long
   Right As Long
   Bottom As Long
End Type

Private Declare Function CreateEllipticRgn Lib "gdi32" _
   (ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function CreatePen Lib "gdi32" _
   (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Private Declare Function CreateRectRgn Lib "gdi32" _
   (ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function DrawText Lib "user32" Alias "DrawTextA" _
   (ByVal hdc As Long, ByVal lpStr As String, ByVal nCount As Long, _
   lpRect As RECT, ByVal wFormat As Long) As Long
Private Declare Function Ellipse Lib "gdi32" (ByVal hdc As Long, _
   ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function FillRgn Lib "gdi32" _
   (ByVal hdc As Long, ByVal hRgn As Long, ByVal hBrush As Long) As Long
Private Declare Function Pie Lib "gdi32" (ByVal hdc As Long, _
   ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long, _
   ByVal X3 As Long, ByVal Y3 As Long, ByVal X4 As Long, ByVal Y4 As Long) As Long
Private Declare Function SelectObject Lib "gdi32" _
   (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function SetBkMode Lib "gdi32" _
   (ByVal hdc As Long, ByVal nBkMode As Long) As Long
Private Declare Function SetTextColor Lib "gdi32" _
   (ByVal hdc As Long, ByVal crColor As Long) As Long

' Auxiliary functions
Private Declare Function OleTranslateColor Lib "OLEPRO32.DLL" _
   (ByVal OLE_COLOR As Long, ByVal HPALETTE As Long, pccolorref As Long) As Long

Private m_CellFont1 As StdFont
Private m_CellFont2 As StdFont
Private m_PBFont As StdFont
Private m_hFont1 As Long
Private m_hFont2 As Long
Private m_hPBFont As Long

Private Sub Form_Load()
   Dim iRow As Long
   Dim FontInt As IFont
   
   ' Preparing fonts for custom draw cells
   Set m_CellFont1 = New StdFont
   With m_CellFont1
      .Name = "Arial"
      .Size = 10
      .Bold = True
   End With
   Set m_CellFont2 = New StdFont
   With m_CellFont2
      .Name = "Tahoma"
      .Size = 10
   End With
   Set FontInt = m_CellFont1
   m_hFont1 = FontInt.hFont
   Set FontInt = m_CellFont2
   m_hFont2 = FontInt.hFont
   
   Set m_PBFont = New StdFont
   With m_PBFont
      .Name = "Courier New"
      .Size = 10
      .Bold = True
   End With
   Set FontInt = m_PBFont
   m_hPBFont = FontInt.hFont

   ' iGrid1 definition
   With iGrid1
      .Redraw = False
      
      .Editable = False
      .HighlightSelCells = False
      .FocusRect = True
      .Font.Size = 10
      
      .AddCol(sHeader:="Description", lWidth:=210).eTextFlags = igTextWordBreak
      .AddCol(sHeader:="Custom Draw Cell", lWidth:=180).eType = igCellCustomDraw
      .RowCount = 3
      
      .CellValue(1, 1) = "Three circles: a red circle, a yellow circle and a green circle"
      .CellValue(2, 1) = "A blue ellipse which expands to the hole cell"
      .CellValue(3, 1) = "Several fonts in the same cell"
      
      For iRow = 1 To .RowCount
         .AutoHeightRow iRow
      Next
      
      .Redraw = True
   End With
   
   ' iGrid2 definition
   With iGrid2
      .Redraw = False
      
      .Editable = False
      .FocusRect = True
      .Font.Size = 10
      
      .AddCol(sHeader:="Description", lWidth:=210).eTextFlags = igTextWordBreak
      .AddCol(sHeader:="Custom Draw Cell", lWidth:=180).eType = igCellCustomDraw
      .RowCount = 2
      
      .CellValue(1, 1) = "Progress bar example": .CellValue(1, 2) = D_PROGRESS
      .CellValue(2, 1) = "Another dynamically drawn cell": .CellValue(2, 2) = D_ANGLE
      
      For iRow = 1 To .RowCount
         .AutoHeightRow iRow
      Next
      
      .Redraw = True
   End With
   
   Timer1.Enabled = True
End Sub

Private Sub iGrid1_ColHeaderClick(ByVal lCol As Long, bDoDefault As Boolean, ByVal Shift As Integer, ByVal X As Long, ByVal Y As Long)
   bDoDefault = False
End Sub

Private Sub iGrid1_CustomDrawCell(ByVal lRow As Long, ByVal lCol As Long, ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   Select Case lRow
   Case 1: pDraw3Circles hdc, lLeft, lTop, lRight, lBottom, bSelected
   Case 2: pDrawBlueEllipse hdc, lLeft, lTop, lRight, lBottom, bSelected
   Case 3: pCustomDrawText hdc, lLeft, lTop, lRight, lBottom, bSelected
   End Select
End Sub

Private Sub pDraw3Circles(ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   Dim hRgn As Long, hBrush As Long
   Dim i As Long
   
   For i = 0 To 2
      hRgn = CreateEllipticRgn(lLeft + 1 + i * (CIRCLE_DIAMETER + 3), lTop + 1, lLeft + 1 + i * (CIRCLE_DIAMETER + 3) + CIRCLE_DIAMETER, lTop + 1 + CIRCLE_DIAMETER)
      hBrush = CreateSolidBrush(Choose(i + 1, vbRed, vbYellow, vbGreen))
      FillRgn hdc, hRgn, hBrush
      DeleteObject hRgn
      DeleteObject hBrush
   Next
End Sub

Private Sub pDrawBlueEllipse(ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   Dim hRgn As Long, hBrush As Long
   
   hRgn = CreateEllipticRgn(lLeft + 1, lTop + 1, lRight - 2, lBottom - 2)
   hBrush = CreateSolidBrush(vbBlue)
   FillRgn hdc, hRgn, hBrush
   DeleteObject hRgn
   DeleteObject hBrush
End Sub

Private Sub pCustomDrawText(ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   Dim s As String
   Dim R As RECT
   Dim hOldFont As Long
   
   SetBkMode hdc, TRANSPARENT
   SetTextColor hdc, TranslateColor(IIf(bSelected, vbHighlightText, vbWindowText))
   
   R.Right = lRight - 3
   
   hOldFont = SelectObject(hdc, m_hFont1)
   s = "Files count:"
   R.Left = lLeft + 2
   R.Top = lTop + 1
   R.Bottom = R.Top + 17
   DrawText hdc, s, Len(s), R, DT_BOTTOM + DT_SINGLELINE
   s = "Total size:"
   R.Top = lTop + 17
   R.Bottom = R.Top + 17
   DrawText hdc, s, Len(s), R, DT_BOTTOM + DT_SINGLELINE
   Call SelectObject(hdc, hOldFont)
   
   hOldFont = SelectObject(hdc, m_hFont2)
   s = "3'159 files"
   R.Top = lTop + 1
   R.Bottom = R.Top + 17
   DrawText hdc, s, Len(s), R, DT_RIGHT + DT_BOTTOM + DT_SINGLELINE
   s = "1'517'486 bytes"
   R.Top = lTop + 17
   R.Bottom = R.Top + 17
   DrawText hdc, s, Len(s), R, DT_RIGHT + DT_BOTTOM + DT_SINGLELINE
   Call SelectObject(hdc, hOldFont)
End Sub

Private Sub pDrawProgressBar(ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   Dim lPBRight As Long
   Dim hRgn As Long, hBrush As Long
   Dim X1 As Long, X2 As Long
   Dim Y1 As Long, Y2 As Long
   Dim hPrevClipRgn As Long, hPBClipRgn As Long
   Dim R As RECT, s As String
   Dim hOldFont As Long
   Dim lPBValue As Long
   
   lPBValue = iGrid2.CellValue(1, 2)
   
   hRgn = CreateRectRgn(lLeft, lTop, lRight, lBottom)
   hBrush = CreateSolidBrush(TranslateColor(vbWindowBackground))
   FillRgn hdc, hRgn, hBrush
   DeleteObject hRgn
   DeleteObject hBrush
   
   lPBRight = lRight - 2
   X1 = lLeft + 1
   X2 = lLeft + (lPBRight - X1) * lPBValue / 100
   Y1 = lTop + 2
   Y2 = lBottom - 3
   hRgn = CreateRectRgn(X1, Y1, X2, Y2)
   hBrush = CreateSolidBrush(TranslateColor(vbHighlight))
   FillRgn hdc, hRgn, hBrush
   DeleteObject hRgn
   DeleteObject hBrush
   
   SetBkMode hdc, TRANSPARENT
   R.Left = X1
   R.Top = Y1
   R.Right = lPBRight
   R.Bottom = Y2
   s = lPBValue & "%"
   hOldFont = SelectObject(hdc, m_hPBFont)
   
   GetClipRgn hdc, hPrevClipRgn
   hPBClipRgn = CreateRectRgn(X1, Y1, X2, Y2)
   SelectClipRgn hdc, hPBClipRgn
   DeleteObject hPBClipRgn
   SetTextColor hdc, TranslateColor(vbHighlightText)
   DrawText hdc, s, Len(s), R, DT_CENTER + DT_VCENTER + DT_SINGLELINE
   SelectClipRgn hdc, hPrevClipRgn

   GetClipRgn hdc, hPrevClipRgn
   hPBClipRgn = CreateRectRgn(X2, Y1, lPBRight, Y2)
   SelectClipRgn hdc, hPBClipRgn
   DeleteObject hPBClipRgn
   SetTextColor hdc, TranslateColor(vbWindowText)
   DrawText hdc, s, Len(s), R, DT_CENTER + DT_VCENTER + DT_SINGLELINE
   SelectClipRgn hdc, hPrevClipRgn
   
   Call SelectObject(hdc, hOldFont)
End Sub

Private Sub pDrawStopWatch(ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   Const RADIUS = 30
   Const DEGREE_TO_RADIAN = 1.74532925199433E-02
   
   Dim hRgn As Long
   Dim X1 As Long, X2 As Long
   Dim Y1 As Long, Y2 As Long
   Dim X1_2 As Long
   Dim hPen As Long, hOldPen As Long
   Dim hBrush As Long, hOldBrush As Long
   Dim lAngle As Long
   
   lAngle = iGrid2.CellValue(2, 2)
   
   X1_2 = (lRight - 2 - (lLeft + 1)) \ 2
   X1 = lLeft + 1 + X1_2 - RADIUS
   X2 = lLeft + 1 + X1_2 + RADIUS
   Y1 = lTop + 1
   Y2 = Y1 + 2 * RADIUS
   
   hPen = CreatePen(PS_SOLID, 1, vbBlack)
   hOldPen = SelectObject(hdc, hPen)
   
   hBrush = CreateSolidBrush(vbRed)
   hOldBrush = SelectObject(hdc, hBrush)
   Ellipse hdc, X1, Y1, X2, Y2
   SelectObject hdc, hOldBrush
   DeleteObject hBrush
   
   hBrush = CreateSolidBrush(vbBlue)
   hOldBrush = SelectObject(hdc, hBrush)
   Pie hdc, X1, Y1, X2, Y2, _
      X2, Y1 + RADIUS, _
      lLeft + 1 + X1_2 + RADIUS * Cos(lAngle * DEGREE_TO_RADIAN), Y1 + RADIUS - RADIUS * Sin(lAngle * DEGREE_TO_RADIAN)
   SelectObject hdc, hOldBrush
   DeleteObject hBrush
   
   SelectObject hdc, hOldPen
   DeleteObject hPen
End Sub

Private Sub iGrid1_CustomDrawCellGetSize(ByVal lRow As Long, ByVal lCol As Long, lWidth As Long, lHeight As Long)
   Select Case lRow
   Case 1
      lWidth = (CIRCLE_DIAMETER + 3) * 3
      lHeight = 30
   Case 2
      lWidth = 25
      lHeight = 40
   Case 3
      lWidth = 205
      lHeight = 35
   End Select
End Sub

' Converts Automation color to Windows color
Private Function TranslateColor(ByVal oClr As OLE_COLOR) As Long
   OleTranslateColor oClr, 0, TranslateColor
End Function

Private Sub iGrid2_ColHeaderClick(ByVal lCol As Long, bDoDefault As Boolean, ByVal Shift As Integer, ByVal X As Long, ByVal Y As Long)
   bDoDefault = False
End Sub

Private Sub iGrid2_CustomDrawCell(ByVal lRow As Long, ByVal lCol As Long, ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   ' -------- Drawing code
   Select Case lRow
   Case 1: pDrawProgressBar hdc, lLeft, lTop, lRight, lBottom, bSelected
   Case 2: pDrawStopWatch hdc, lLeft, lTop, lRight, lBottom, bSelected
   End Select
End Sub

Private Sub iGrid2_CustomDrawCellGetSize(ByVal lRow As Long, ByVal lCol As Long, lWidth As Long, lHeight As Long)
   Select Case lRow
   Case 1
      lWidth = 200
      lHeight = 19
   Case 2
      lWidth = 63
      lHeight = 63
   End Select
End Sub

Private Sub Timer1_Timer()
   Dim lNewPBVal As Long
   Dim lNewAngle As Long
   
   lNewPBVal = iGrid2.CellValue(1, 2) + D_PROGRESS
   If lNewPBVal > 100 Then lNewPBVal = D_PROGRESS
   
   iGrid2.CellValue(1, 2) = lNewPBVal  ' When you change cell value,
                                       ' iGrid raises the CustomDrawCell event
                                       ' for custom draw cells
   
   lNewAngle = iGrid2.CellValue(2, 2) + D_ANGLE
   If lNewAngle > 360 Then lNewAngle = lNewAngle - 360
   
   iGrid2.CellValue(2, 2) = lNewAngle
End Sub
