{ NONE OPTIMIZED - MAYBE HAVE FEW BUGS }
UNIT XPTHEMES;
INTERFACE
USES grafx2,gx_glob,pnglib,stream32,gx_font,crt;
CONST
{ --- BUTTON names constant --- }
         START=1;
         CLOSE=2;
         MAXIMIZE=3;
         RESTORE=4;
         MINIMIZE=5;
         HELP=6;
         SCROLLUP=7;
         SCROLLDOWN=8;
         SCROLLLEFT=9;
         SCROLLRIGHT=10;
         CHECK=11;
         UNCHECK=12;
         RADIO_CHECKED=13;
         RADIO_UNCHECKED=14;
{ --- ALL BUTTON status constant --- }
         NONE=0;
         NORMAL=1;
         SELECT=2;
         PRESSED=3;
         INACTIVE=5;
         ACTIVE=4;
         { for TASKBAR button only }
         SELECT_PRESSED=4;
         HILIGHTED=5;

SCROLLRGBval:array[1..17,1..3] of byte=(
(237,237,229),(242,241,236),(245,242,237),(244,243,238),(245,244,240),
(246,245,240),(248,247,243),(248,249,244),(249,249,247),(251,252,247),
(251,251,249),(251,251,249),(253,254,249),(254,255,250),(255,254,251),
(254,254,252),(237,237,229));

VAR tahoma,trebuchet: Txfn;
    Wincolor,Lightcolor,Darkcolor:longint;

{ PROCEDURES }
Procedure XPtheme_init(s:string;scr:tgrafx);
Procedure XPtheme_done;

Procedure Draw_button(x,y:integer;name,status:byte;scr:tgrafx);
Procedure Draw_smallbutton(x,y:integer;name,status:byte;scr:tgrafx);
Procedure Draw_commandbutton(x,y:integer;size:word;status:byte;msg:string;scr:tgrafx);
Procedure Draw_tabbutton(x,y:integer;size:word;status:byte;msg:string;scr:tgrafx);
Procedure Draw_Hscrollbutton(x,y:integer;size:word;status:byte;scr:tgrafx);
Procedure Draw_Vscrollbutton(x,y:integer;size:word;status:byte;scr:tgrafx);
Procedure Draw_Taskbarbutton(x:integer;size:word;status:byte;title:string;scr:tgrafx);

Procedure Draw_taskbar(tray:word;scr:tgrafx);
Procedure Draw_progressbar(x,y:integer;size,csize:byte;scr:tgrafx);
Procedure Draw_Hscrollbar(x1,y,x2:integer;status:byte;scr:tgrafx);
Procedure Draw_Vscrollbar(x,y1,y2:integer;status:byte;scr:tgrafx);

Procedure Draw_Activewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
Procedure Draw_smallActivewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
Procedure Draw_inActivewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
Procedure Draw_smallinActivewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
Procedure Draw_winbox(x1,y1,x2,y2:integer;wc,tc:longint;title:string;scr:tgrafx);

Procedure Texture_screen(tex:timage;scr:tgrafx);
Procedure Texture_window(a,b,c,d:integer;tex:timage;scr:tgrafx);

Procedure Draw_icon(x,y:integer;s:string;scr:tgrafx);
Procedure Drawscale_icon(x,y:integer;scale:byte;s:string;scr:tgrafx);

Procedure Rrect(x1,y1,x2,y2: integer;r : byte;color:longint;scr:tgrafx);
Procedure Rbar(x1,y1,x2,y2: integer;r : byte;color:longint;scr:tgrafx);
Procedure TABpanel(m,n,p,q:integer;scr:tgrafx);
Procedure WINrect(m,n,p,q:integer;scr:tgrafx);
Procedure WINbar(m,n,p,q:integer;color:longint;scr:tgrafx);
Procedure WINhline(x,y,d:integer;scr:tgrafx);
Procedure WINvline(x,y,d:integer;scr:tgrafx);
Procedure WINrect3d(m,n,p,q:integer;d:byte;c:boolean;scr:tgrafx);

Procedure READstring(x,y:integer;col:longint;max:byte;var s:string;font:txfn;scr:tgrafx);
Procedure WINdowtext(x,y:integer;c:longint;s:string;fnt:txfn;scr:tgrafx);
Procedure Gwriteln(a,b:integer;c:longint;space:word;s:string;fnt:txfn;scr:tgrafx);
Procedure Textwrap(a,b:integer;size:word;c:longint;space:byte;s:string;fnt:txfn;scr:tgrafx);
Procedure Change_colorscheme(R,G,B:shortint;WC,LC,DC:longint;Scr:Tgrafx);

IMPLEMENTATION
var
  point  : array[0..255] of word;
  size_last_circle : word;
  skininuse:byte;
  RVAL,GVAL,BVAL : shortint;
  GR,GG,GB : shortint;
  currentSkin:string;
  Schemedefault : boolean;
{ ------- Variables for WINDOWS XP THEMES ------- }
  button:array[1..14,1..3] of timage;
  commandbutton:array[1..3,1..5] of timage;
  taskbarbutton:array[1..3,1..5] of timage;
  Tabbutton:array[1..3,1..3] of timage;
  HScrollbutton:array[1..4,1..3] of timage;
  VScrollbutton:array[1..4,1..3] of timage;
  Tl_a,TR_a,DL_a,DR_a,TM_a,DM_a,L_a,R_a,           { ACTIVE WINDOWS }
  Tl_ia,TR_ia,DL_ia,DR_ia,TM_ia,DM_ia,L_ia,R_ia,   { INACTIVE WINDOWS }
  Clo,max,res,min,hel,     { INACTIVE WINDOW BUTTON }
  sc_u,sc_d,sc_l,sc_r,     { INACTIVE SCROLL BUTTON }
  tabl,tabm,tabr,          { INACTIVE TAB BUTTON }
  PB_l,PB_r,PB_mc,PB_mk,   { PROGRESS BAR }
  TB_l,TB_r,TB_m           { TASKBAR } : timage;


Procedure XPtheme_init(s:string;scr:tgrafx);
var
    img,xptheme:timage;
    scrmem:tgxmem;
    fileread : tfilestream32;

function getpath(s:string):string;
var n:byte;
begin
    n:=length(s);
    repeat dec(n) until s[n]='\';
    getpath:=copy(s,1,n);
end;

function getfilename(s:string):string;
var n:byte;
begin
    n:=length(s);
    repeat dec(n) until s[n]='\';
    getfilename:=copy(s,n+1,length(s));
end;


procedure getcell(a,b,c,d:word; var cel:timage);

begin
     scrmem.get(a,b,c,d,cel);
     cel.flags:=2;
     cel.transcol:=scrmem.rgb(GR,GG,GB);
end;
begin
      currentSkin:=s;
      if getfilename(s)='xpblue.skn' then
      begin skininuse:=1;
      If schemedefault then
         begin
            wincolor:=scr.rgb(236,233,216);
            lightcolor:=scr.rgb(255,255,255);
            darkcolor:=scr.rgb(203,199,174);
         end;
      end;
      if getfilename(s)='xpgreen.skn' then
      begin skininuse:=2;
      If schemedefault then
         begin
            wincolor:=scr.rgb(236,233,216);
            lightcolor:=scr.rgb(255,255,255);
            darkcolor:=scr.rgb(172,168,153);
         end;
      end;
      if getfilename(s)='xpsilver.skn' then
      begin skininuse:=3;
      If schemedefault then
         begin
            wincolor:=scr.rgb(224,223,227);
            lightcolor:=scr.rgb(255,255,255);
            darkcolor:=scr.rgb(157,157,161);
         end;
      end;

      fileread.init(getpath(s)+'tahoma.xfn',stopenread);
      tahoma.init(fileread);
      fileread.done;
      fileread.init(getpath(s)+'trebucbd.xfn',stopenread);
      trebuchet.init(fileread);
      fileread.done;

      fileread.init(s,stopenread);
      loadpng(fileread,xptheme,scr.mode.bpp,lddefault);

      openimage(img,758,83,scr.mode.bpp,0,0);
      scrmem.init(img);
      scrmem.draw(0,0,xptheme,0);
If RVAL<0 Then
   scrmem.fillrect(0,0,scrmem.maxx,scrmem.maxy,scrmem.rgb(abs(RVAL),0,0),fillsub) Else
   scrmem.fillrect(0,0,scrmem.maxx,scrmem.maxy,scrmem.rgb(RVAL,0,0),filladd);
If GVAL<0 Then
   scrmem.fillrect(0,0,scrmem.maxx,scrmem.maxy,scrmem.rgb(0,abs(GVAL),0),fillsub) Else
   scrmem.fillrect(0,0,scrmem.maxx,scrmem.maxy,scrmem.rgb(0,GVAL,0),filladd);
If BVAL<0 Then
   scrmem.fillrect(0,0,scrmem.maxx,scrmem.maxy,scrmem.rgb(0,0,abs(BVAL)),fillsub) Else
   scrmem.fillrect(0,0,scrmem.maxx,scrmem.maxy,scrmem.rgb(0,0,BVAL),filladd);

{ - GET CELL FOR TEXTURE - }
{ START BUTTON }
      getcell(0,0,97,29,button[start,normal]);
      getcell(98,0,195,29,button[start,select]);
      getcell(196,0,293,29,button[start,pressed]);
{ CLOSE BUTTON }
      getcell(337,0,357,20,button[close,normal]);
      getcell(379,0,399,20,button[close,select]);
      getcell(358,0,378,20,button[close,pressed]);
      getcell(400,0,420,20,clo);
{ MAXIMIZE BUTTON }
      getcell(421,0,441,20,button[maximize,normal]);
      getcell(463,0,483,20,button[maximize,select]);
      getcell(442,0,462,20,button[maximize,pressed]);
      getcell(484,0,504,20,max);
{ RESTORE BUTTON }
      getcell(505,0,525,20,button[restore,normal]);
      getcell(547,0,567,20,button[restore,select]);
      getcell(526,0,546,20,button[restore,pressed]);
      getcell(568,0,588,20,res);
{ MINIMIZE BUTTON }
      getcell(589,0,609,20,button[minimize,normal]);
      getcell(631,0,651,20,button[minimize,select]);
      getcell(610,0,630,20,button[minimize,pressed]);
      getcell(652,0,672,20,min);
{ HELP BUTTON }
      getcell(673,0,693,20,button[help,normal]);
      getcell(715,0,735,20,button[help,select]);
      getcell(694,0,714,20,button[help,pressed]);
      getcell(736,0,756,20,hel);
{ PROGRESS BAR }
      getcell(0,64,3,80,PB_l);
      getcell(20,64,25,80,PB_r);
      getcell(4,64,11,80,pb_mc);
      getcell(12,64,19,80,pb_mk);
{ SCROLL UP }
      getcell(0,30,15,46,button[scrollup,normal]);
      getcell(16,30,31,46,button[scrollup,select]);
      getcell(32,30,47,46,button[scrollup,pressed]);
      getcell(321,30,336,46,sc_u);
{ SCROLL DOWN }
      getcell(0,47,15,63,button[scrollDOWN,normal]);
      getcell(16,47,31,63,button[scrollDOWN,select]);
      getcell(32,47,47,63,button[scrollDOWN,pressed]);
      getcell(321,47,336,63,sc_d);
{ SCROLL LEFT }
      getcell(48,30,64,45,button[scrollLEFT,normal]);
      getcell(48,46,64,61,button[scrollLEFT,select]);
      getcell(48,62,64,77,button[scrollLEFT,pressed]);
      getcell(340,50,356,65,sc_l);
{ SCROLL RIGHT }
      getcell(65,30,81,45,button[scrollRIGHT,normal]);
      getcell(65,46,81,61,button[scrollRIGHT,select]);
      getcell(65,62,81,77,button[scrollRIGHT,pressed]);
      getcell(357,50,373,65,sc_r);
{ CHECK }
      getcell(82,30,94,42,button[check,normal]);
      getcell(95,30,107,42,button[check,select]);
      getcell(108,30,120,42,button[check,pressed]);
{ UNCHECK }
      getcell(82,43,94,55,button[UNcheck,normal]);
      getcell(95,43,107,55,button[UNcheck,select]);
      getcell(108,43,120,55,button[UNcheck,pressed]);
{ RADIO UNCHECKED }
      getcell(82,56,94,68,button[radio_UNchecked,normal]);
      getcell(95,56,107,68,button[radio_UNchecked,select]);
      getcell(108,56,120,68,button[radio_UNchecked,pressed]);
{ RADIO CHECKED }
      getcell(82,69,94,81,button[radio_checked,normal]);
      getcell(95,69,107,81,button[radio_checked,select]);
      getcell(108,69,120,81,button[radio_checked,pressed]);
{ LEFT COMMAND BUTTON }
      getcell(121,30,124,52,commandbutton[1,normal]);
      getcell(149,30,152,52,commandbutton[1,select]);
      getcell(177,30,180,52,commandbutton[1,pressed]);
      getcell(205,30,208,52,commandbutton[1,active]);
      getcell(233,30,236,52,commandbutton[1,inactive]);
{ MIDDLE COMMAND BUTTON }
      getcell(125,30,144,52,commandbutton[2,normal]);
      getcell(153,30,172,52,commandbutton[2,select]);
      getcell(181,30,200,52,commandbutton[2,pressed]);
      getcell(209,30,228,52,commandbutton[2,active]);
      getcell(237,30,256,52,commandbutton[2,inactive]);
{ RIGHT COMMAND BUTTON }
      getcell(145,30,148,52,commandbutton[3,normal]);
      getcell(173,30,176,52,commandbutton[3,select]);
      getcell(201,30,204,52,commandbutton[3,pressed]);
      getcell(229,30,232,52,commandbutton[3,active]);
      getcell(257,30,260,52,commandbutton[3,inactive]);
{ ACTIVE WINDOW }
      getcell(337,21,351,49,tl_a);
      getcell(372,21,386,49,tr_a);
      getcell(337,50,339,69,l_a);
      getcell(384,50,386,69,r_a);
      getcell(337,70,351,72,dl_a);
      getcell(372,70,386,72,dr_a);
      getcell(352,21,371,49,tm_a);
      getcell(352,70,371,72,dm_a);
{ INACTIVE WINDOW }
      getcell(387,21,401,49,tl_ia);
      getcell(422,21,436,49,tr_ia);
      getcell(387,50,389,69,l_ia);
      getcell(434,50,436,69,r_ia);
      getcell(387,70,401,72,dl_ia);
      getcell(422,70,436,72,dr_ia);
      getcell(402,21,421,49,tm_ia);
      getcell(402,70,421,72,dm_ia);
{ TAB LEFT BUTTON }
      getcell(437,21,439,42,tabbutton[1,1]);
      getcell(463,21,465,42,tabbutton[1,2]);
      getcell(489,21,491,42,tabbutton[1,3]);
      getcell(515,21,517,42,tabl);
{ TAB MIDDLE BUTTON }
      getcell(440,21,459,42,tabbutton[2,1]);
      getcell(466,21,485,42,tabbutton[2,2]);
      getcell(492,21,511,42,tabbutton[2,3]);
      getcell(518,21,537,42,tabm);
{ TAB RIGHT BUTTON }
      getcell(460,21,462,42,tabbutton[3,1]);
      getcell(486,21,488,42,tabbutton[3,2]);
      getcell(512,21,514,42,tabbutton[3,3]);
      getcell(538,21,540,42,tabr);

{ HSCROLL BUTTON LEFT }
      getcell(437,43,439,59,hscrollbutton[1,1]);
      getcell(461,43,463,59,hscrollbutton[1,2]);
      getcell(485,43,487,59,hscrollbutton[1,3]);
{ HSCROLL BUTTON MIDDLE }
      getcell(440,43,449,59,hscrollbutton[2,1]);
      getcell(464,43,473,59,hscrollbutton[2,2]);
      getcell(488,43,497,59,hscrollbutton[2,3]);
{ HSCROLL BUTTON RIGHT }
      getcell(458,43,460,59,hscrollbutton[3,1]);
      getcell(482,43,484,59,hscrollbutton[3,2]);
      getcell(506,43,508,59,hscrollbutton[3,3]);
{ HSCROLL BUTTON }
      getcell(450,43,457,59,hscrollbutton[4,1]);
      getcell(474,43,481,59,hscrollbutton[4,2]);
      getcell(498,43,505,59,hscrollbutton[4,3]);

{ VSCROLL BUTTON UP }
      getcell(261,30,277,32,vscrollbutton[1,1]);
      getcell(278,30,294,32,vscrollbutton[1,2]);
      getcell(295,30,311,32,vscrollbutton[1,3]);
{ VSCROLL BUTTON MIDLE }
      getcell(261,33,277,42,vscrollbutton[2,1]);
      getcell(278,33,294,42,vscrollbutton[2,2]);
      getcell(295,33,311,42,vscrollbutton[2,3]);
{ VSCROLL BUTTON DOWN }
      getcell(261,51,277,53,vscrollbutton[3,1]);
      getcell(278,51,294,53,vscrollbutton[3,2]);
      getcell(295,51,311,53,vscrollbutton[3,3]);
{ VSCROLL BUTTON }
      getcell(261,43,277,50,vscrollbutton[4,1]);
      getcell(278,43,294,50,vscrollbutton[4,2]);
      getcell(295,43,311,50,vscrollbutton[4,3]);

{ TASKBAR BUTTON LEFT }
      getcell(541,21,542,43,TASKBARbutton[1,1]); { normal }
      getcell(613,21,614,43,TASKBARbutton[1,2]); { select }
      getcell(565,21,566,43,TASKBARbutton[1,3]); { pressed }
      getcell(589,21,590,43,TASKBARbutton[1,4]); { Select_Pressed }
      getcell(637,21,638,43,TASKBARbutton[1,5]); { Hilighted }
{ TASKBAR BUTTON MIDDLE }
      getcell(543,21,562,43,TASKBARbutton[2,1]); { normal }
      getcell(615,21,634,43,TASKBARbutton[2,2]); { select }
      getcell(567,21,586,43,TASKBARbutton[2,3]); { pressed }
      getcell(591,21,610,43,TASKBARbutton[2,4]); { Select_Pressed }
      getcell(639,21,658,43,TASKBARbutton[2,5]); { Hilighted }
{ TASKBAR BUTTON RIGHT }
      getcell(563,21,564,43,TASKBARbutton[3,1]); { normal }
      getcell(635,21,636,43,TASKBARbutton[3,2]); { select }
      getcell(587,21,588,43,TASKBARbutton[3,3]); { pressed }
      getcell(611,21,612,43,TASKBARbutton[3,4]); { Select_Pressed }
      getcell(659,21,660,43,TASKBARbutton[3,5]); { Hilighted }

{ TASKBAR }
      getcell(294,0,313,29,tb_l);
      getcell(314,0,316,29,tb_m);
      getcell(317,0,336,29,tb_r);
{ ------------------------ }
      scrmem.close;
      closeimage(img);
      closeimage(xptheme);
end;

Procedure XPtheme_done;
var m,n:byte;
begin
for m:=1 to 14 do for n:=1 to 3 do closeimage(button[m,n]);
for m:=1 to 3 do for n:=1 to 5 do closeimage(commandbutton[m,n]);
for m:=1 to 3 do for n:=1 to 5 do closeimage(taskbarbutton[m,n]);
for m:=1 to 3 do for n:=1 to 3 do closeimage(tabbutton[m,n]);
for m:=1 to 4 do for n:=1 to 3 do closeimage(Hscrollbutton[m,n]);
for m:=1 to 4 do for n:=1 to 3 do closeimage(vscrollbutton[m,n]);
closeimage(clo);  closeimage(max);  closeimage(res);  closeimage(min);
closeimage(hel);  closeimage(pb_l);  closeimage(pb_r);  closeimage(pb_mc);
closeimage(pb_mk);  closeimage(tb_l);  closeimage(tb_m);  closeimage(tb_r);
closeimage(sc_u);  closeimage(sc_d);  closeimage(sc_l);  closeimage(sc_r);
closeimage(Tl_a);  closeimage(TR_a);  closeimage(DL_a);  closeimage(DR_a);
closeimage(TM_a);  closeimage(DM_a);  closeimage(L_a);  closeimage(R_a);
closeimage(Tl_ia);  closeimage(TR_ia);  closeimage(DL_ia);  closeimage(DR_ia);
closeimage(TM_ia);  closeimage(DM_ia);  closeimage(L_ia);  closeimage(R_ia);
closeimage(Tabl);  closeimage(Tabm);  closeimage(Tabr);
  tahoma.close;
  trebuchet.close;
end;
Procedure Draw_button(x,y:integer;name,status:byte;scr:tgrafx);
begin
if (name in [1..14]) and ((status=inactive) or (status in [1..3])) then begin
if name=1 then scr.draw(0,scr.maxy-29,button[name,status],drdefault) else
  begin
     if status=inactive then
        begin
           case name of
              close:scr.draw(x,y,clo,drdefault);
              maximize:scr.draw(x,y,max,drdefault);
              restore:scr.draw(x,y,res,drdefault);
              minimize:scr.draw(x,y,min,drdefault);
              help:scr.draw(x,y,hel,drdefault);
              Scrollup:scr.draw(x,y,sc_u,drdefault);
              Scrolldown:scr.draw(x,y,sc_d,drdefault);
              Scrollleft:scr.draw(x,y,sc_l,drdefault);
              Scrollright:scr.draw(x,y,sc_r,drdefault);
           end;
        end else begin
   scr.draw(x,y,button[name,status],drdefault);
  end;
  end;
  end;
end;
Procedure Draw_smallbutton(x,y:integer;name,status:byte;scr:tgrafx);
  begin
if (name in [2..6]) and ((status=inactive) or (status in [1..3])) then begin
     if status=inactive then
        begin
           case name of
              close:scr.scale(x,y,12,12,clo,drdefault);
              maximize:scr.scale(x,y,12,12,max,drdefault);
              restore:scr.scale(x,y,12,12,res,drdefault);
              minimize:scr.scale(x,y,12,12,min,drdefault);
              help:scr.scale(x,y,12,12,hel,drdefault);
           end;
        end else begin
   scr.scale(x,y,12,12,button[name,status],drdefault);
  end;
  end;
end;
Procedure Draw_commandbutton(x,y:integer;size:word;status:byte;msg:string;scr:tgrafx);
var n:byte;
begin
if status in [1..5] then begin
if size<28 then size:=28;
     scr.draw(x,y,commandbutton[1,status],drdefault);
     scr.draw(x+size-3,y,commandbutton[3,status],drdefault);
     scr.draw(x+size-23,y,commandbutton[2,status],drdefault);
     for n:=0 to ((size-8) div 20)-1 do scr.draw(x+4+(n*20),y,commandbutton[2,status],drdefault);
     tahoma.setattributes(2,2,4);
     if status=inactive then
     tahoma.write(scr,x+(size div 2),y+10,msg,scr.rgb(160,160,160))
     else
     tahoma.write(scr,x+(size div 2),y+10,msg,scr.rgb(5,5,5))
end;
end;
Procedure Draw_tabbutton(x,y:integer;size:word;status:byte;msg:string;scr:tgrafx);
var n:byte;
begin
if (status in [1..3]) or (status=inactive) then begin
    if size<28 then size:=28;
    tahoma.setattributes(2,2,4);
    if status=inactive then begin
    scr.draw(x,y,tabl,drdefault);
    scr.draw(x+size-2,y,tabr,drdefault);
    scr.draw(x+size-22,y,tabm,drdefault);
    for n:=0 to ((size-6) div 20)-1 do scr.draw(x+3+(n*20),y,tabm,drdefault);
    tahoma.write(scr,x+(size div 2),y+11,msg,scr.rgb(160,160,160))
    end else begin
    scr.draw(x,y,tabbutton[1,status],drdefault);
    scr.draw(x+size-2,y,tabbutton[3,status],drdefault);
    scr.draw(x+size-22,y,tabbutton[2,status],drdefault);
    for n:=0 to ((size-6) div 20)-1 do scr.draw(x+3+(n*20),y,tabbutton[2,status],drdefault);
    tahoma.write(scr,x+(size div 2),y+11,msg,scr.rgb(5,5,5))
    end;
end;
end;
Procedure Draw_Hscrollbutton(x,y:integer;size:word;status:byte;scr:tgrafx);
var n:byte;
begin
if status in [1..3] then begin
     if size<28 then size:=28;
     scr.Draw(x,y,hscrollbutton[1,status],drdefault);
     scr.draw(x+size-2,y,hscrollbutton[3,status],drdefault);
     scr.draw(x+size-12,y,hscrollbutton[2,status],drdefault);
     for n:=0 to ((size-6) div 10)-1 do scr.draw(x+3+(n*10),y,hscrollbutton[2,status],drdefault);
     scr.draw(x+((size div 2)-4),y,hscrollbutton[4,status],drdefault);
end;
end;
Procedure Draw_Vscrollbutton(x,y:integer;size:word;status:byte;scr:tgrafx);
var n:byte;
begin
if status in [1..3] then begin
     if size<28 then size:=28;
     scr.Draw(x,y,vscrollbutton[1,status],drdefault);
     scr.draw(x,y+size-2,vscrollbutton[3,status],drdefault);
     scr.draw(x,y+size-12,vscrollbutton[2,status],drdefault);
     for n:=0 to ((size-6) div 10)-1 do scr.draw(x,y+3+(n*10),vscrollbutton[2,status],drdefault);
     scr.draw(x,y+((size div 2)-4),vscrollbutton[4,status],drdefault);
end;
end;
Procedure Draw_Taskbarbutton(x:integer;size:word;status:byte;title:string;scr:tgrafx);
var n:byte;
    y:integer;
begin
if status in [1..5] then begin
     If X<102 then x:=102;
     if size<28 then size:=28;
     y:=scr.maxy-25;
     scr.draw(x,y,taskbarbutton[1,status],drdefault);
     scr.draw(x+size-3,y,taskbarbutton[3,status],drdefault);
     scr.draw(x+size-23,y,taskbarbutton[2,status],drdefault);
     for n:=0 to ((size-2) div 20)-1 do scr.draw(x+2+(n*20),y,taskbarbutton[2,status],drdefault);
     tahoma.setattributes(0,0,4);
     tahoma.write(scr,x+6,y+5,title,scr.rgb(142,165,173));

case skininuse of
1:tahoma.write(scr,x+5,y+5,title,scr.rgb(255,255,255));
2:if status in [1..2] then tahoma.write(scr,x+5,y+5,title,scr.rgb(42,65,73)) else
 tahoma.write(scr,x+5,y+5,title,scr.rgb(255,255,255));
3:if ((status=1) or (status=3)) then tahoma.write(scr,x+5,y+5,title,scr.rgb(42,65,73)) else
 tahoma.write(scr,x+5,y+5,title,scr.rgb(255,255,255));
end;
end;
end;

Procedure Draw_taskbar(tray:word;scr:tgrafx);
var n:byte;
begin
       scr.draw(0,scr.maxy-29,button[start,normal],drdefault);
       for n:=0 to (scr.maxx-98-tray) div 20 do
       scr.draw(n*20+98,scr.maxy-29,Tb_l,drdefault);
       scr.draw(scr.maxx-tray,scr.maxy-29,Tb_m,drdefault);
       for n:=0 to tray div 20 do
       scr.draw(n*20+(scr.maxx+3-tray),scr.maxy-29,Tb_r,drdefault);
end;

Procedure Draw_progressbar(x,y:integer;size,csize:byte;scr:tgrafx);
var n:byte;
begin
     if csize>0 then dec(csize);dec(size);
     if csize>size then csize:=size;
     scr.draw(x,y,pb_l,drdefault);
     for n:=0 to size do scr.draw(x+4+(n*pb_mk.sizex),y,pb_mk,drdefault);
     scr.draw(x+4+((size+1)*pb_mk.sizex),y,pb_r,drdefault);
     if csize>0 then
     for n:=0 to csize do scr.draw(x+4+(n*pb_mc.sizex),y,pb_mc,drdefault);
end;
Procedure Draw_Hscrollbar(x1,y,x2:integer;status:byte;scr:tgrafx);
var n:byte;
begin
if (status=normal) or (status=inactive) then begin
    for n:=1 to 17 do
    scr.hline(x1,(y-1)+n,x2-x1,scr.rgb(SCROLLRGBval[n,1],SCROLLRGBval[n,2],SCROLLRGBval[n,3]));
    draw_button(x1,y+1,scrollleft,status,scr);
    draw_button(x2-17,y+1,scrollright,status,scr);
    end;
end;

Procedure Draw_Vscrollbar(x,y1,y2:integer;status:byte;scr:tgrafx);
var n:byte;
begin
if (status=normal) or (status=inactive) then begin
    for n:=1 to 17 do
    scr.vline((x-1)+n,y1,y2-y1,scr.rgb(SCROLLRGBval[n,1],SCROLLRGBval[n,2],SCROLLRGBval[n,3]));
    draw_button(x+1,y1,scrollup,status,scr);
    draw_button(x+1,y2-17,scrolldown,status,scr);
end;
end;

Procedure Draw_Activewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
var n:byte;
    right:integer;
begin
    if sizex<104 then sizex:=104;
    if sizey<52 then sizey:=52;
if ((b1 in [2..6]) or (b1=0)) and ((b2 in [2..6]) or (b2=0)) and
   ((b3 in [2..6]) or (b3=0)) and ((b4 in [2..6]) or (b4=0)) then begin
     right:=x+sizex;
     scr.setpattern(ptDefault);
     scr.fillrect(x+3,y+29,x+sizex-3,y+sizey-3,wincolor,filldefault);
     scr.draw(x,y,tl_a,drdefault);
     scr.draw(x+sizex-14,y,tr_a,drdefault);
     scr.draw(x,y+27+sizey-tl_a.sizey,dl_a,drdefault);
     scr.draw(x+sizex-14,y+27+sizey-tl_a.sizey,dr_a,drdefault);
     scr.draw(x+sizex-34,y,tm_a,drdefault);
     scr.draw(x+sizex-34,y+27+sizey-tl_a.sizey,dm_a,drdefault);
     scr.draw(x,y+sizey-22,l_a,drdefault);
     scr.draw(x+sizex-2,y+sizey-22,r_a,drdefault);
     for n:=0 to ((sizex-tl_a.sizex*2) div 20)-1 do begin
     scr.draw(x+tl_a.sizex+(n*20),y,tm_a,drdefault);
     scr.draw(x+tl_a.sizex+(n*20),y+27+sizey-tl_a.sizey,dm_a,drdefault);
     end;
     for n:=0 to ((sizey-tl_a.sizey-dl_a.sizey) div 20)-1 do begin
     scr.draw(x,y+tl_a.sizey+(n*20),l_a,drdefault);
     scr.draw(x+sizex-2,y+tl_a.sizey+(n*20),r_a,drdefault);
     end;

     trebuchet.setattributes(0,0,4);
     if skininuse=3 then begin
     trebuchet.write(scr,x+11,y+7,title,scr.rgb(162,162,162));
     trebuchet.write(scr,x+10,y+6,title,scr.rgb(25,25,25));
     end else begin
     trebuchet.write(scr,x+11,y+7,title,scr.rgb(102,95,133));
     trebuchet.write(scr,x+10,y+6,title,scr.rgb(255,255,255));
     end;
     Draw_button(right-27,y+5,b4,normal,scr);
     Draw_button(right-50,y+5,b3,normal,scr);
     Draw_button(right-73,y+5,b2,normal,scr);
     Draw_button(right-96,y+5,b1,normal,scr);
end;
end;

Procedure Draw_smallActivewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
var n:byte;
    right:integer;
begin
    if sizex<104 then sizex:=104;
    if sizey<52 then sizey:=52;
if ((b1 in [2..6]) or (b1=0)) and ((b2 in [2..6]) or (b2=0)) and
   ((b3 in [2..6]) or (b3=0)) and ((b4 in [2..6]) or (b4=0)) then begin
     right:=x+sizex;
     scr.setpattern(ptDefault);
     scr.fillrect(x+3,y+18,x+sizex-3,y+sizey-3,wincolor,filldefault);
     scr.scale(x,y,8,18,tl_a,drdefault);
     scr.scale(x+sizex-7,y,8,18,tr_a,drdefault);
     scr.draw(x,y+27+sizey-tl_a.sizey,dl_a,drdefault);
     scr.draw(x+sizex-14,y+27+sizey-tl_a.sizey,dr_a,drdefault);
     scr.scale(x+sizex-27,y,20,18,tm_a,drdefault);
     scr.draw(x+sizex-34,y+27+sizey-tl_a.sizey,dm_a,drdefault);
     scr.draw(x,y+sizey-22,l_a,drdefault);
     scr.draw(x+sizex-2,y+sizey-22,r_a,drdefault);
     for n:=0 to ((sizex-tl_a.sizex) div 20)-1 do begin
     scr.scale(x+8+(n*20),y,20,18,tm_a,drdefault);
     scr.draw(x+tl_a.sizex+(n*20),y+27+sizey-tl_a.sizey,dm_a,drdefault);
     end;
     for n:=0 to ((sizey-18-dl_a.sizey) div 20)-1 do begin
     scr.draw(x,y+18+(n*20),l_a,drdefault);
     scr.draw(x+sizex-2,y+18+(n*20),r_a,drdefault);
     end;

     Draw_smallbutton(right-17,y+3,b4,normal,scr);
     Draw_smallbutton(right-31,y+3,b3,normal,scr);
     Draw_smallbutton(right-45,y+3,b2,normal,scr);
     Draw_smallbutton(right-59,y+3,b1,normal,scr);
     tahoma.setattributes(0,0,4);
     if skininuse=3 then begin
     tahoma.write(scr,x+8,y+4,title,scr.rgb(162,162,162));
     tahoma.write(scr,x+7,y+3,title,scr.rgb(25,25,25));
     end else begin
     tahoma.write(scr,x+8,y+4,title,scr.rgb(102,95,133));
     tahoma.write(scr,x+7,y+3,title,scr.rgb(255,255,255));
     end;

end;
end;

Procedure Draw_inActivewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
var n:byte;
    right:integer;
begin
    if sizex<104 then sizex:=104;
    if sizey<52 then sizey:=52;
if ((b1 in [2..6]) or (b1=0)) and ((b2 in [2..6]) or (b2=0)) and
   ((b3 in [2..6]) or (b3=0)) and ((b4 in [2..6]) or (b4=0)) then begin
     right:=x+sizex;
     scr.setpattern(ptDefault);
     scr.fillrect(x+3,y+29,x+sizex-3,y+sizey-3,wincolor,filldefault);
     scr.draw(x,y,tl_ia,drdefault);
     scr.draw(x+sizex-14,y,tr_ia,drdefault);
     scr.draw(x,y+27+sizey-tl_a.sizey,dl_ia,drdefault);
     scr.draw(x+sizex-14,y+27+sizey-tl_a.sizey,dr_ia,drdefault);
     scr.draw(x+sizex-34,y,tm_ia,drdefault);
     scr.draw(x+sizex-34,y+27+sizey-tl_a.sizey,dm_ia,drdefault);
     scr.draw(x,y+sizey-22,l_ia,drdefault);
     scr.draw(x+sizex-2,y+sizey-22,r_ia,drdefault);
     for n:=0 to ((sizex-tl_a.sizex*2) div 20)-1 do begin
     scr.draw(x+tl_a.sizex+(n*20),y,tm_ia,drdefault);
     scr.draw(x+tl_a.sizex+(n*20),y+27+sizey-tl_a.sizey,dm_ia,drdefault);
     end;
     for n:=0 to ((sizey-tl_a.sizey-dl_a.sizey) div 20)-1 do begin
     scr.draw(x,y+tl_a.sizey+(n*20),l_ia,drdefault);
     scr.draw(x+sizex-2,y+tl_a.sizey+(n*20),r_ia,drdefault);
     end;

     trebuchet.setattributes(0,0,4);

     if skininuse=3 then begin
     trebuchet.write(scr,x+11,y+7,title,scr.rgb(162,162,162));
     trebuchet.write(scr,x+10,y+6,title,scr.rgb(145,145,145));
     end else begin
     trebuchet.write(scr,x+11,y+7,title,scr.rgb(142,135,173));
     trebuchet.write(scr,x+10,y+6,title,scr.rgb(255,255,255));
     end;
     Draw_button(right-27,y+5,b4,inactive,scr);
     Draw_button(right-50,y+5,b3,inactive,scr);
     Draw_button(right-73,y+5,b2,inactive,scr);
     Draw_button(right-96,y+5,b1,inactive,scr);
end;
end;
Procedure Draw_smallinActivewindow(x,y:integer;sizex,sizey:word;b1,b2,b3,b4:byte;title:string;scr:tgrafx);
var n:byte;
    right:integer;
begin
    if sizex<104 then sizex:=104;
    if sizey<52 then sizey:=52;
if ((b1 in [2..6]) or (b1=0)) and ((b2 in [2..6]) or (b2=0)) and
   ((b3 in [2..6]) or (b3=0)) and ((b4 in [2..6]) or (b4=0)) then begin
     right:=x+sizex;
     scr.setpattern(ptDefault);
     scr.fillrect(x+3,y+18,x+sizex-3,y+sizey-3,wincolor,filldefault);
     scr.scale(x,y,8,18,tl_ia,drdefault);
     scr.scale(x+sizex-7,y,8,18,tr_ia,drdefault);
     scr.draw(x,y+27+sizey-tl_a.sizey,dl_ia,drdefault);
     scr.draw(x+sizex-14,y+27+sizey-tl_a.sizey,dr_ia,drdefault);
     scr.scale(x+sizex-27,y,20,18,tm_ia,drdefault);
     scr.draw(x+sizex-34,y+27+sizey-tl_a.sizey,dm_ia,drdefault);
     scr.draw(x,y+sizey-22,l_ia,drdefault);
     scr.draw(x+sizex-2,y+sizey-22,r_ia,drdefault);
     for n:=0 to ((sizex-tl_a.sizex) div 20)-1 do begin
     scr.scale(x+8+(n*20),y,20,18,tm_ia,drdefault);
     scr.draw(x+tl_a.sizex+(n*20),y+27+sizey-tl_a.sizey,dm_ia,drdefault);
     end;
     for n:=0 to ((sizey-18-dl_a.sizey) div 20)-1 do begin
     scr.draw(x,y+18+(n*20),l_ia,drdefault);
     scr.draw(x+sizex-2,y+18+(n*20),r_ia,drdefault);
     end;

     Draw_smallbutton(right-17,y+3,b4,inactive,scr);
     Draw_smallbutton(right-31,y+3,b3,inactive,scr);
     Draw_smallbutton(right-45,y+3,b2,inactive,scr);
     Draw_smallbutton(right-59,y+3,b1,inactive,scr);
     tahoma.setattributes(0,0,4);
     if skininuse=3 then begin
     tahoma.write(scr,x+8,y+4,title,scr.rgb(162,162,162));
     tahoma.write(scr,x+7,y+3,title,scr.rgb(145,145,145));
     end else begin
     tahoma.write(scr,x+8,y+4,title,scr.rgb(142,135,173));
     tahoma.write(scr,x+7,y+3,title,scr.rgb(255,255,255));
     end;
end;
end;
Procedure Texture_screen(tex:timage;scr:tgrafx);
var m,n:word;
begin
      for m:=0 to (scr.maxx div tex.sizex) do
      for n:=0 to (scr.maxy div tex.sizey) do
      scr.draw(m*tex.sizex,n*tex.sizey,tex,drdefault);
end;

Procedure Texture_window(a,b,c,d:integer;tex:timage;scr:tgrafx);
var m,n:word;
    img,get:timage;
    scrmem:tgxmem;
begin
      openimage(img,c-a,d-b,scr.mode.bpp,0,0);
      scrmem.init(img);
      for m:=0 to ((c-a) div tex.sizex) do
      for n:=0 to ((d-b) div tex.sizey) do
      scrmem.draw(m*tex.sizex,n*tex.sizey,tex,drdefault);
      scrmem.get(0,0,c-a-1,d-b-1,get);
      scr.draw(a,b,get,drdefault);
      scrmem.close;
      closeimage(img);
      closeimage(get);
end;
Procedure Draw_icon(x,y:integer;s:string;scr:tgrafx);
var
    fileread: tfilestream32;
    img: timage;
begin
  fileread.init(s,stopenread);
  check4fail(loadpng(fileread,img,scr.mode.bpp,lddefault));
  scr.draw(x,y,img,drdefault);
  closeimage(img);
end;

Procedure Drawscale_icon(x,y:integer;scale:byte;s:string;scr:tgrafx);
var
    fileread: tfilestream32;
    img1: timage;
begin
  fileread.init(s,stopenread);
  check4fail(loadpng(fileread,img1,scr.mode.bpp,lddefault));
  scr.scale(x,y,scale,scale,img1,drdefault);
  closeimage(img1);
end;
procedure calccircle(r : integer);assembler;
asm
  mov   bx,r
  cmp   bx,size_last_circle
  je    @end                  {if the last circle had the same size, exit}

  mov   size_last_circle,bx
  mov   di,bx
  add   di,di
  mov   word ptr point,0
  mov   word ptr point[di],bx
  mov   si,1
  sub   si,bx                 { d := 1-r               }
  xor   cx,cx                 { x := 0                 }
  mov   ax,bx                 { y := r                 }
  or    ax,ax
  jbe   @end

  xor   di,di
  add   bx,bx

@start:                       { while y > x do begin   }
  or    si,si                 { if d < 0 then begin    }
  jns   @next
    mov   dx,cx
    add   dx,dx
    add   dx,3
    add   si,dx               { inc(d,x shl 1 + 3)     }
    inc   cx                  { inc(x)                 }
    sub   bx,2
    jmp   @stop               { end                    }
  @next:                      { else begin             }
    mov   dx,cx
    sub   dx,ax
    add   dx,dx
    add   dx,3
    add   si,dx               { inc(d,(x-y) shl 1 + 3) }
    inc   cx                  { inc(x)                 }
    sub   bx,2
    dec   ax                  { dec(y)                 }
    add   di,2
  @stop:                      { end                    }
  mov   word ptr point[di],cx { point[r-y] := x        }
  mov   word ptr point[bx],ax { point[r-x] := y        }
  cmp   ax,cx
  jg    @start
  @end:
end;
procedure rrect(x1,y1,x2,y2: integer;r : byte;color:longint;scr:tgrafx);
var
  i,sizex  : word;
  x,y      : word;
begin
  sizex := abs(x2-x1);
  calccircle(r);
  scr.hline(x1+r-point[0],y1,sizex-(r-point[0])*2+1,color);
  scr.vline(x1,y1+r,y2-y1-r*2,color);
  scr.hline(x1+r-point[0],y2,sizex-(r-point[0])*2+1,color);
  scr.vline(x2,y1+r,y2-y1-r*2,color);
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    scr.putpixel(x1+x,y1+y,color);
    scr.putpixel(x2-x,y1+y,color);
  end;
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    scr.putpixel(x1+x,y2-y,color);
    scr.putpixel(x2-x,y2-y,color);
  end;
end;
procedure rbar(x1,y1,x2,y2: integer;r : byte;color:longint;scr:tgrafx);
var
  i,sizex  : word;
  x,y      : word;
begin
  sizex := abs(x2-x1);
  calccircle(r);
  scr.hline(x1+r-point[0],y1,sizex-(r-point[0])*2+1,color);
  scr.vline(x1,y1+r,y2-y1-r*2,color);
  scr.hline(x1+r-point[0],y2,sizex-(r-point[0])*2+1,color);
  scr.vline(x2,y1+r,y2-y1-r*2,color);
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    scr.putpixel(x1+x,y1+y,color);
    scr.putpixel(x2-x,y1+y,color);
  end;
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    scr.putpixel(x1+x,y2-y,color);
    scr.putpixel(x2-x,y2-y,color);
  end;
  for y := 1 to r do
  scr.patternline(x1+r-point[y-1]+1,y1+y,sizex-(r*2-point[y-1]*2)-1,color,filldefault);
  scr.fillrect(x1+1,y1+r+1,x2-1,y2-r-1,color,filldefault);
  for y := r downto 1 do
  scr.patternline(x1+r-point[y-1]+1,y2-y,sizex-(r*2-point[y-1]*2)-1,color,filldefault);
end;

procedure TABpanel(m,n,p,q:integer;scr:tgrafx);
begin
    scr.rect(m+2,n+2,p+2,q+2,scr.rgb(227,224,209),0);
    scr.rect(m+1,n+1,p+1,q+1,scr.rgb(208,206,191),0);
    scr.rect(m,n,p,q,scr.rgb(145,155,156),0);
    scr.rect(m+1,n+1,p-1,q-1,scr.rgb(252,252,254),0);
    scr.fillrect(m+2,n+2,p-2,q-2,scr.rgb(249,249,249),filldefault);
end;

procedure WINbar(m,n,p,q:integer;color:longint;scr:tgrafx);
begin
    scr.fillrect(m,n,p,q,scr.rgb(255,255,255),filldefault);
    scr.fillrect(m+3,n+3,p-3,q-3,color,filldefault);
    scr.rect(m,n,p,q,scr.rgb(227,224,209),0);
    scr.rect(m+2,n+2,p-2,q-2,scr.rgb(242,240,227),0);
    scr.vline(m+1,n+1,q-2-n,scr.rgb(173,167,153));
    scr.hline(m+1,n+1,p-2-m,scr.rgb(173,167,153));
    scr.vline(m+2,n+2,q-4-n,scr.rgb(113,111,99));
    scr.hline(m+2,n+2,p-4-m,scr.rgb(113,111,99));
end;
procedure winrect(m,n,p,q:integer;scr:tgrafx);
begin
    scr.rect(m,n,p,q,darkcolor,0);
    scr.vline(m+1,n+1,q-2-n,lightcolor);
    scr.hline(m+1,n+1,p-m-1,lightcolor);
    scr.hline(m,q+1,p-m+1,lightcolor);
    scr.vline(p+1,n,q-n+2,lightcolor);
end;

procedure winvline(x,y,d:integer;scr:tgrafx);
begin
   scr.vline(x,y,d,darkcolor);
   scr.vline(x+1,y,d,lightcolor);
end;
procedure winhline(x,y,d:integer;scr:tgrafx);
begin
   scr.hline(x,y,d,darkcolor);
   scr.hline(x,y+1,d,lightcolor);
end;

procedure winrect3d(m,n,p,q:integer;d:byte;c:boolean;scr:tgrafx);
var i:byte;
procedure w3d(m,n,p,q:integer;c:boolean;scr1:tgrafx);
begin
if c=true then begin
    scr1.rect(m,n,p,q,lightcolor,0);
    scr1.vline(p,n,q-n+1,darkcolor);
    scr1.hline(m,q,p-m+1,darkcolor);
    end;
if c=false then begin
    scr1.rect(m,n,p,q,darkcolor,0);
    scr1.vline(p,n,q-n+1,lightcolor);
    scr1.hline(m,q,p-m+1,lightcolor);
    end;
end;
begin
  for i:=1 to d do w3d(m+i,n+i,p-i,q-i,c,scr);
end;

Procedure readstring(x,y:integer;col:longint;max:byte;var s:string;font:txfn;scr:tgrafx);
      Var
        oldx:integer;
        lne:string;
        c:char;
        cl:longint;
      Begin
        max:=max-1;
        font.setattributes(0,0,4);
        oldx:=x;
        lne:='';s:='';
        cl:=scr.getpixel(x,y);
        font.write(scr,x,y,'_',col);
        Repeat
          c:=readkey;
          If not(c in [#13,#27,#8,#0])then
            Begin
            if length(lne)<=max then begin
               font.write(scr,x,y,'_',cl);
               font.write(scr,x,y,c,col);
               inc(x,font.width(c));
               font.write(scr,x,y,'_',col);
               lne:=lne+c;
           End;
            end
          Else
           Begin
             Case c of
             #8:Begin
             if x>oldx then begin
                  font.write(scr,x,y,'_',cl);
                  dec(x,font.width(lne[length(lne)]));
                  font.write(scr,x,y,lne[length(lne)],cl);
                  font.write(scr,x,y,'_',col);
                  lne:=copy(lne,1,length(lne)-1);
                  end;
               End;
             End;
           End;
        Until c=#13;
        font.write(scr,x,y,'_',cl);
        s:=lne;
      End;
procedure Draw_winbox(x1,y1,x2,y2:integer;wc,tc:longint;title:string;scr:tgrafx);
const r=6;
var
  i,sizex  : word;
  x,y      : word;
begin
  sizex := abs(x2-x1);
  calccircle(r);
  tahoma.setattributes(0,0,4);
  scr.hline(x1+r-point[0],y1,r,wc);
  tahoma.write(scr,x1+12,y1-7,title,tc);
  scr.line(x1+tahoma.width(title)+15,y1,x2-5,y1,wc,0);
  scr.vline(x1,y1+r,y2-y1-r*2,wc);
  scr.hline(x1+r-point[0],y2,sizex-(r-point[0])*2+1,wc);
  scr.vline(x2,y1+r,y2-y1-r*2,wc);
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    scr.putpixel(x1+x,y1+y,wc);
    scr.putpixel(x2-x,y1+y,wc);
  end;
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    scr.putpixel(x1+x,y2-y,wc);
    scr.putpixel(x2-x,y2-y,wc);
  end;
end;

procedure WINdowtext(x,y:integer;c:longint;s:string;fnt:txfn;scr:tgrafx);
var n:byte;
begin
    s:=s+' ';
    fnt.setattributes(0,0,4);
    n:=1;
    repeat
    if (s[n]='#') and (s[n+1]<>'#') then begin
    scr.hline(x,y+fnt.maxcharheight-1,fnt.width(s[n+1]),c);
    inc(n);
    end else begin
    fnt.write(scr,x,y,s[n],c);
    inc(x,fnt.width(s[n]));
    inc(n);
   end;
    until n=length(s);
end;



Procedure gwriteln(a,b:integer;c:longint;space:word;s:string;fnt:txfn;scr:tgrafx);
var c1,d1:word;i:byte;
begin
c1:=a;d1:=b;
  for i:=1 to length(s) do
     begin
        if s[i]<>'|' then
            begin
                fnt.write(scr,c1,d1,s[i],c);
                inc(c1,fnt.width(s[i]));
            end;
        if s[i]='|' then
            begin
                c1:=a;
                inc(d1,space);
            end;
     end;
end;
procedure textwrap(a,b:integer;size:word;c:longint;space:byte;s:string;fnt:txfn;scr:tgrafx);
var maxw:word;
    stmp:string;
    i:byte;
begin
    s:=s+' ';
repeat
    maxw:=0;i:=0;
    repeat
       inc(i);
       inc(maxw,fnt.width(s[i]));
    until maxw>=size;
    repeat dec(i); until s[i]=' ';
      stmp:='';
      stmp:=copy(s,1,i-1);
      delete(s,1,length(stmp));
      if stmp[1]=' ' then delete(stmp,1,1);
      fnt.write(scr,a,b,stmp,c);
      inc(b,space);
until s='';
end;

Procedure Change_colorscheme(R,G,B:shortint;WC,LC,DC:longint;Scr:Tgrafx);
Begin
     XPtheme_done;
     RVAL:=R;GVAL:=G;BVAL:=B;
     If (Wincolor<>WC) or (Lightcolor<>LC) or (Darkcolor<>DC) then
     Schemedefault:=FALSE ELSE Schemedefault:=TRUE;
     Wincolor:=WC;
     Lightcolor:=LC;
     Darkcolor:=DC;
     GR:=R;
     GG:=G;
     GB:=B;
     if GR<0 then GR:=0;
     if GG<0 then GG:=0;
     if GB<0 then GB:=0;
     XPtheme_init(currentSKIN,scr);
end;

BEGIN
    Schemedefault:=TRUE;
END.