program ThumbNail;
{$APPTYPE CONSOLE}
uses
  SysUtils,
  PDF,
  Graphics;

var
  MyPDF: TPDFDocument;
  I, J: Integer;
begin
  try
    MyPDF := TPDFDocument.Create(nil);
    try
      MyPDF.AutoLaunch := True;
      MyPDF.Compression := ctFlate;
      MyPDF.FileName := 'Data\PDFFiles\ThumbNail.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [Thumbnail]';
      MyPDF.OnePass := True;
      MyPDF.PageMode:=pmUseThumbs;
      MyPDF.BeginDoc;
      J:=MyPDF.AddImage('Data\Images\logo.jpg',itcJpeg);
      try
        for I := 1 to 100 do
        begin
          if I <> 1 then MyPDF.NewPage;
          MyPDF.CurrentPage.Thumbnail := J;
        end;
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
    finally
      MyPDF.Free;
    end;
  except
    on E: Exception do
      Writeln(E.message);
  end;
end.

