program AcroForm;
{$APPTYPE CONSOLE}
uses
  SysUtils,
  PDF,
  Graphics,
  Classes;

var
  MyPDF: TPDFDocument;
  Btn1, Btn2: TPDFButton;
  Ed: TPDFEdit;
  CB: TPDFCheckBox;
  RB: TPDFRadioButton;
  HV1, HV2: TPDFVisibeControlAction;
begin
  try
    MyPDF := TPDFDocument.Create(nil);
    try
      MyPDF.FileName := 'Data\PDFFiles\AcroForm.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [AcroForm]';
      MyPDF.AutoLaunch := True;
      MyPDF.Compression := ctFlate;
      MyPDF.BeginDoc;
      with MyPDF.CurrentPage do
      begin
        Width := 140;
        Height := 120;
        SetGrayStroke(0);
        SetGrayFill(0.7);
        Rectangle(10, 10, 130, 20);
        FillAndStroke;
        SetGrayFill(1);
        Rectangle(10, 20, 130, 110);
        FillAndStroke;
        SetGrayFill(0);
        BeginText;
        SetActiveFont('Arial', [], 8);
        TextOut(35, 45, 0, 'Subscribe');
        TextOut(35, 60, 0, 'Unsubscribe');
        SetActiveFont('Arial', [], 10);
        SetTextRenderingMode(2);
        SetLineWidth(0.3);
        SetGrayFill(1);
        TextBox(Rect(10, 10, 130, 18), 'llionsoft News', hjCenter, vjCenter);
        EndText;
        Ed := CreateControl(TPDFEdit, 'email', Rect(20, 30, 120, 43)) as TPDFEdit;
        Ed.Text := 'Your Email';
        CB := CreateControl(TPDFCheckBox, 'html', Rect(20, 75, 120, 85)) as TPDFCheckBox;
        CB.Caption := 'Send HTML Version';
        RB := CreateControl(TPDFRadioButton, 'action', Rect(20, 45, 30, 55)) as TPDFRadioButton;
        RB.ExportValue := 'sign';
        RB.Checked := True;
        Btn1 := CreateControl(TPDFButton, 'Btn1', Rect(20, 90, 65, 105)) as TPDFButton;
        Btn1.Caption := 'Send';
        Btn1.OnMouseUp := MyPDF.CreateAction(TPDFSubmitFormAction);
        TPDFSubmitFormAction(Btn1.OnMouseUp).URL := 'http://www.llion.net/subscription.php';
        TPDFSubmitFormAction(Btn1.OnMouseUp).SubmitType := stPost;
        HV1 := MyPDF.CreateAction(TPDFVisibeControlAction) as TPDFVisibeControlAction;
        RB.OnMouseUp := HV1;
        HV1.Controls.Add(CB);
        HV1.Visible := True;
        RB := CreateControl(TPDFRadioButton, 'action', Rect(20, 60, 30, 70)) as TPDFRadioButton;
        RB.ExportValue := 'delete';
        HV2 := MyPDF.CreateAction(TPDFVisibeControlAction) as TPDFVisibeControlAction;
        RB.OnMouseUp := HV2;
        HV2.Controls.Add(CB);
        HV2.Visible := False;
        Btn2 := CreateControl(TPDFButton, 'Btn2', Rect(70, 90, 120, 105)) as TPDFButton;
        Btn2.Caption := 'Reset';
        Btn2.OnMouseUp := MyPDF.CreateAction(TPDFResetFormAction);
        Btn2.OnMouseUp := HV1;
      end;
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
    finally
      MyPDF.Free;
    end;
  except
    on E: Exception do
      Writeln(E.message);
  end;
end.

