// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PDF.pas' rev: 6.00

#ifndef PDFHPP
#define PDFHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ShellAPI.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <jpeg.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Pdf
{
//-- type declarations -------------------------------------------------------
struct TDoublePoint
{
	Extended x;
	Extended y;
} ;

struct TTextCTM
{
	Extended a;
	Extended b;
	Extended c;
	Extended d;
	Extended x;
	Extended y;
} ;

#pragma option push -b-
enum TCCITTClass { CCITT31D, CCITT32D, CCITT42D };
#pragma option pop

typedef void __fastcall (__closure *TCCITTProcedure)(Graphics::TBitmap* BM, Classes::TStream* AStream, TCCITTClass CCITTClass);

#pragma option push -b-
enum TPDFPageType { ptPage, ptXForm, ptAnnotation };
#pragma option pop

#pragma option push -b-
enum TPDFLineJoin { ljMiter, ljRound, ljBevel };
#pragma option pop

#pragma option push -b-
enum TPDFLineCap { lcButtEnd, lcRound, lcProjectingSquare };
#pragma option pop

#pragma option push -b-
enum TCJKFont { cjkChinaTrad, cjkChinaSimpl, cjkJapan, cjkKorean };
#pragma option pop

#pragma option push -b-
enum TPDFSubmitType { stGet, stPost, stFDF };
#pragma option pop

#pragma option push -b-
enum TViewerPreference { vpHideToolBar, vpHideMenuBar, vpHideWindowUI, vpFitWindow, vpCenterWindow };
#pragma option pop

typedef Set<TViewerPreference, vpHideToolBar, vpCenterWindow>  TViewerPreferences;

#pragma option push -b-
enum TAnnotationFlag { afInvisible, afHidden, afPrint, afNoZoom, afNoRotate, afNoView, afReadOnly };
#pragma option pop

typedef Set<TAnnotationFlag, afInvisible, afReadOnly>  TAnnotationFlags;

typedef Byte TEncripKey[5];

#pragma option push -b-
enum THorJust { hjLeft, hjCenter, hjRight };
#pragma option pop

#pragma option push -b-
enum TVertJust { vjUp, vjCenter, vjDown };
#pragma option pop

#pragma option push -b-
enum TCompressionType { ctNone, ctFlate };
#pragma option pop

#pragma option push -b-
enum TImageCompressionType { itcFlate, itcJpeg, itcCCITT3, itcCCITT32d, itcCCITT4 };
#pragma option pop

#pragma option push -b-
enum TPDFCriptoOption { coPrint, coModifyStructure, coCopyInformation, coModifyAnnotation };
#pragma option pop

typedef Set<TPDFCriptoOption, coPrint, coModifyAnnotation>  TPDFCtiptoOptions;

#pragma option push -b-
enum TPageLayout { plSinglePage, plOneColumn, plTwoColumnLeft, plTwoColumnRight };
#pragma option pop

#pragma option push -b-
enum TPageMode { pmUseNone, pmUseOutlines, pmUseThumbs, pmFullScreen };
#pragma option pop

#pragma option push -b-
enum TPDFPageRotate { pr0, pr90, pr180, pr270 };
#pragma option pop

class DELPHICLASS TPDFException;
class PASCALIMPLEMENTATION TPDFException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall TPDFException(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall TPDFException(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall TPDFException(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall TPDFException(int Ident, const System::TVarRec * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall TPDFException(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall TPDFException(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall TPDFException(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall TPDFException(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFException(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFControlHint;
class PASCALIMPLEMENTATION TPDFControlHint : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FCaption;
	Graphics::TFontCharset FCharset;
	
public:
	__property AnsiString Caption = {read=FCaption, write=FCaption};
	__property Graphics::TFontCharset Charset = {read=FCharset, write=FCharset, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPDFControlHint(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFControlHint(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFControlFont;
class PASCALIMPLEMENTATION TPDFControlFont : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FSize;
	AnsiString FName;
	Graphics::TColor FColor;
	Graphics::TFontCharset FCharset;
	Graphics::TFontStyles FStyle;
	void __fastcall SetCharset(const Graphics::TFontCharset Value);
	void __fastcall SetSize(const int Value);
	
public:
	__fastcall TPDFControlFont(void);
	__property AnsiString Name = {read=FName, write=FName};
	__property Graphics::TFontCharset Charset = {read=FCharset, write=SetCharset, nodefault};
	__property Graphics::TFontStyles Style = {read=FStyle, write=FStyle, nodefault};
	__property int Size = {read=FSize, write=SetSize, nodefault};
	__property Graphics::TColor Color = {read=FColor, write=FColor, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFControlFont(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TPDFPageSize { psUserDefined, psLetter, psA4, psA3, psLegal, psB5, psC5, ps8x11, psB4, psA5, psFolio, psExecutive, psEnvB4, psEnvB5, psEnvC6, psEnvDL, psEnvMonarch, psEnv9, psEnv10, psEnv11 };
#pragma option pop

class DELPHICLASS TPDFDocInfo;
class PASCALIMPLEMENTATION TPDFDocInfo : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	AnsiString Producer;
	int ID;
	AnsiString FKeywords;
	AnsiString FTitle;
	AnsiString FCreator;
	AnsiString FAuthor;
	AnsiString FSubject;
	System::TDateTime FCreationDate;
	void __fastcall SetAuthor(const AnsiString Value);
	void __fastcall SetCreationDate(const System::TDateTime Value);
	void __fastcall SetCreator(const AnsiString Value);
	void __fastcall SetKeywords(const AnsiString Value);
	void __fastcall SetSubject(const AnsiString Value);
	void __fastcall SetTitle(const AnsiString Value);
	
public:
	__property System::TDateTime CreationDate = {read=FCreationDate, write=SetCreationDate};
	
__published:
	__property AnsiString Author = {read=FAuthor, write=SetAuthor};
	__property AnsiString Creator = {read=FCreator, write=SetCreator};
	__property AnsiString Keywords = {read=FKeywords, write=SetKeywords};
	__property AnsiString Subject = {read=FSubject, write=SetSubject};
	__property AnsiString Title = {read=FTitle, write=SetTitle};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPDFDocInfo(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPDFDocInfo(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


#pragma option push -b-
enum TTextAnnotationIcon { taiComment, taiKey, taiNote, taiHelp, taiNewParagraph, taiParagraph, taiInsert };
#pragma option pop

class DELPHICLASS TPDFControls;
class DELPHICLASS TPDFControl;
class PASCALIMPLEMENTATION TPDFControls : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TPDFControl* operator[](int Index) { return Items[Index]; }
	
private:
	Classes::TList* FControls;
	int __fastcall GetCount(void);
	TPDFControl* __fastcall GetControl(int Index);
	
public:
	__fastcall TPDFControls(void);
	__fastcall virtual ~TPDFControls(void);
	int __fastcall Add(TPDFControl* Control);
	int __fastcall IndexOf(TPDFControl* Control);
	void __fastcall Delete(TPDFControl* Control);
	void __fastcall Clear(void);
	__property int Count = {read=GetCount, nodefault};
	__property TPDFControl* Items[int Index] = {read=GetControl/*, default*/};
};


class DELPHICLASS TPDFAction;
class DELPHICLASS TPDFDocument;
typedef DynamicArray<int >  PDF__63;

class DELPHICLASS TPDFAcroForm;
class PASCALIMPLEMENTATION TPDFAcroForm : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int AcroID;
	TPDFDocument* FOwner;
	TPDFControls* FFields;
	Classes::TList* FFonts;
	Classes::TList* FRadioGroups;
	void __fastcall Save(void);
	bool __fastcall GetEmpty(void);
	
public:
	__fastcall TPDFAcroForm(TPDFDocument* AOwner);
	void __fastcall Clear(void);
	__fastcall virtual ~TPDFAcroForm(void);
	__property bool Empty = {read=GetEmpty, nodefault};
};


class DELPHICLASS TPDFPages;
class DELPHICLASS TPDFPage;
class PASCALIMPLEMENTATION TPDFPages : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TPDFPage* operator[](int Index) { return Items[Index]; }
	
private:
	bool IsWaterMarks;
	TPDFDocument* FOwner;
	Classes::TList* FPages;
	int __fastcall GetCount(void);
	TPDFPage* __fastcall GetPage(int Index);
	void __fastcall Clear(void);
	
public:
	__fastcall TPDFPages(TPDFDocument* AOwner, bool WM);
	__fastcall virtual ~TPDFPages(void);
	TPDFPage* __fastcall Add(void);
	int __fastcall IndexOf(TPDFPage* Page);
	void __fastcall Delete(TPDFPage* Page);
	__property int Count = {read=GetCount, nodefault};
	__property TPDFPage* Items[int Index] = {read=GetPage/*, default*/};
};


class DELPHICLASS TPDFActions;
class PASCALIMPLEMENTATION TPDFActions : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TPDFAction* operator[](int Index) { return Items[Index]; }
	
private:
	TPDFDocument* FOwner;
	Classes::TList* FActions;
	int __fastcall GetCount(void);
	TPDFAction* __fastcall GetAction(int Index);
	void __fastcall Clear(void);
	
public:
	__fastcall TPDFActions(TPDFDocument* AOwner);
	__fastcall virtual ~TPDFActions(void);
	int __fastcall Add(TPDFAction* Action);
	int __fastcall IndexOf(TPDFAction* Action);
	void __fastcall Delete(TPDFAction* Action);
	__property int Count = {read=GetCount, nodefault};
	__property TPDFAction* Items[int Index] = {read=GetAction/*, default*/};
};


class DELPHICLASS TPDFFonts;
class DELPHICLASS TPDFFont;
class PASCALIMPLEMENTATION TPDFFont : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FontID;
	int FontDescriptorID;
	int FontFileID;
	AnsiString FontName;
	AnsiString RealName;
	Graphics::TFontStyles RealStyle;
	Graphics::TFontCharset RealCharset;
	bool Standart;
	AnsiString AliasName;
	Byte StdID;
	bool IsCJK;
	TCJKFont CJKType;
	short FWidth[256];
	bool WidthLoaded;
	void __fastcall Save(TPDFDocument* Doc);
	void __fastcall LoadingWidth(void);
	Word __fastcall GetWidth(int Index);
	
public:
	__fastcall TPDFFont(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFFont(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPDFFonts : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TPDFFont* operator[](int Index) { return Items[Index]; }
	
private:
	TPDFDocument* FOwner;
	Classes::TList* FFonts;
	TPDFFont* FLast;
	int FLastIndex;
	int __fastcall GetCount(void);
	TPDFFont* __fastcall GetFont(int Index);
	void __fastcall EmbiddingFontFiles(void);
	
public:
	__fastcall TPDFFonts(TPDFDocument* AOwner);
	__fastcall virtual ~TPDFFonts(void);
	void __fastcall Delete(int Index);
	void __fastcall Clear(void);
	TPDFFont* __fastcall Add(void);
	int __fastcall IndexOf(AnsiString FontName, Graphics::TFontStyles FontStyle, Graphics::TFontCharset FontCharset);
	AnsiString __fastcall CheckFont(AnsiString FontName, Graphics::TFontStyles FontStyle, Graphics::TFontCharset FontCharset);
	__property int Count = {read=GetCount, nodefault};
	__property TPDFFont* Items[int Index] = {read=GetFont/*, default*/};
};


class DELPHICLASS TPDFImages;
class DELPHICLASS TPDFImage;
class PASCALIMPLEMENTATION TPDFImages : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TPDFImage* operator[](int Index) { return Items[Index]; }
	
private:
	TPDFDocument* FOwner;
	Classes::TList* FImages;
	int __fastcall GetCount(void);
	TPDFImage* __fastcall GetImage(int Index);
	
public:
	__fastcall TPDFImages(TPDFDocument* AOwner);
	__fastcall virtual ~TPDFImages(void);
	void __fastcall Delete(int Index);
	void __fastcall Clear(void);
	TPDFImage* __fastcall Add(Graphics::TGraphic* Image, TImageCompressionType Compression)/* overload */;
	TPDFImage* __fastcall Add(AnsiString FileName, TImageCompressionType Compression)/* overload */;
	__property int Count = {read=GetCount, nodefault};
	__property TPDFImage* Items[int Index] = {read=GetImage/*, default*/};
};


class DELPHICLASS TPDFOutlines;
class DELPHICLASS TPDFOutlineNode;
class PASCALIMPLEMENTATION TPDFOutlines : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TPDFOutlineNode* operator[](int Index) { return Item[Index]; }
	
private:
	int OutlinesID;
	Classes::TList* FList;
	TPDFDocument* FOwner;
	int __fastcall GetCount(void);
	TPDFOutlineNode* __fastcall GetItem(int Index);
	TPDFOutlineNode* __fastcall Add(TPDFOutlineNode* Node)/* overload */;
	TPDFOutlineNode* __fastcall AddChild(TPDFOutlineNode* Node)/* overload */;
	TPDFOutlineNode* __fastcall AddChildFirst(TPDFOutlineNode* Node)/* overload */;
	TPDFOutlineNode* __fastcall AddFirst(TPDFOutlineNode* Node)/* overload */;
	TPDFOutlineNode* __fastcall Insert(TPDFOutlineNode* Node)/* overload */;
	
public:
	void __fastcall Clear(void);
	void __fastcall Delete(TPDFOutlineNode* Node);
	TPDFOutlineNode* __fastcall GetFirstNode(void);
	TPDFOutlineNode* __fastcall Add(TPDFOutlineNode* Node, AnsiString Title, TPDFAction* Action, Graphics::TFontCharset Charset = (Graphics::TFontCharset)(0x0))/* overload */;
	TPDFOutlineNode* __fastcall AddChild(TPDFOutlineNode* Node, AnsiString Title, TPDFAction* Action, Graphics::TFontCharset Charset = (Graphics::TFontCharset)(0x0))/* overload */;
	TPDFOutlineNode* __fastcall AddChildFirst(TPDFOutlineNode* Node, AnsiString Title, TPDFAction* Action, Graphics::TFontCharset Charset = (Graphics::TFontCharset)(0x0))/* overload */;
	TPDFOutlineNode* __fastcall AddFirst(TPDFOutlineNode* Node, AnsiString Title, TPDFAction* Action, Graphics::TFontCharset Charset = (Graphics::TFontCharset)(0x0))/* overload */;
	TPDFOutlineNode* __fastcall Insert(TPDFOutlineNode* Node, AnsiString Title, TPDFAction* Action, Graphics::TFontCharset Charset = (Graphics::TFontCharset)(0x0))/* overload */;
	__fastcall TPDFOutlines(TPDFDocument* AOwner);
	__fastcall virtual ~TPDFOutlines(void);
	__property int Count = {read=GetCount, nodefault};
	__property TPDFOutlineNode* Item[int Index] = {read=GetItem/*, default*/};
};


class DELPHICLASS TPDFRadioGroup;
typedef TMetaClass*TPDFActionClass;

class PASCALIMPLEMENTATION TPDFDocument : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
public:
	TPDFPage* operator[](int Index) { return Page[Index]; }
	
private:
	DynamicArray<int >  IDOffset;
	int CurID;
	int EncriptID;
	int PagesID;
	int CatalogID;
	int XREFOffset;
	TPDFAcroForm* FAcroForm;
	AnsiString FFileName;
	TPDFPages* FPages;
	TPDFPages* FWaterMarks;
	TPDFActions* FActions;
	TPDFFonts* FFonts;
	TPDFImages* FImages;
	Classes::TList* FRadioGroups;
	Classes::TStream* FStream;
	TCompressionType FCompression;
	TPDFDocInfo* FDocumentInfo;
	TPageLayout FPageLayout;
	TPageMode FPageMode;
	TPDFPage* FCurrentPage;
	TPDFOutlines* FOutlines;
	bool FProtectionEnabled;
	AnsiString FUserPassword;
	AnsiString FOwnerPassword;
	TPDFCtiptoOptions FProtectionOptions;
	Byte FKey[5];
	unsigned FPFlags;
	AnsiString FileID;
	Classes::TStringList* FNotEmbeddedFont;
	Classes::TStream* FOutputStream;
	int FJPEGQuality;
	bool FPrinting;
	bool FAborted;
	bool FAutoLaunch;
	int FResolution;
	TViewerPreferences FViewerPreferences;
	TPDFAction* FOpenDocumentAction;
	bool FACURL;
	bool FOnePass;
	TCCITTProcedure FCCITT;
	void __fastcall CalcKey(void);
	void __fastcall SaveXREF(void);
	void __fastcall SaveTrailer(void);
	void __fastcall SaveDocumentInfo(void);
	void __fastcall SetFileName(const AnsiString Value);
	void __fastcall SetCompression(const TCompressionType Value);
	void __fastcall SetDocumentInfo(const TPDFDocInfo* Value);
	void __fastcall SaveToStream(AnsiString st, bool CR = true);
	int __fastcall GetNextID(void);
	void __fastcall SetPageLayout(const TPageLayout Value);
	void __fastcall SetPageMode(const TPageMode Value);
	void __fastcall SetOwnerPassword(const AnsiString Value);
	void __fastcall SetProtectionEnabled(const bool Value);
	void __fastcall SetProtectionOptions(const TPDFCtiptoOptions Value);
	void __fastcall SetUserPassword(const AnsiString Value);
	void __fastcall GenFileID(void);
	AnsiString __fastcall CalcOwnerPassword();
	AnsiString __fastcall CalcUserPassword();
	void __fastcall SetNotEmbeddedFont(const Classes::TStringList* Value);
	int __fastcall GetPageCount(void);
	TPDFPage* __fastcall GetPage(int Index);
	void __fastcall SetOutputStream(const Classes::TStream* Value);
	void __fastcall SetJPEGQuality(const int Value);
	void __fastcall SetAutoLaunch(const bool Value);
	Graphics::TCanvas* __fastcall GetCanvas(void);
	int __fastcall GetPageHeight(void);
	int __fastcall GetPageNumber(void);
	int __fastcall GetPageWidth(void);
	TPDFPage* __fastcall GetWaterMark(int Index);
	void __fastcall AppendAction(const TPDFAction* Action);
	void __fastcall SetOpenDocumentAction(const TPDFAction* Value);
	void __fastcall StartObj(int &ID);
	void __fastcall CloseHObj(void);
	void __fastcall CloseObj(void);
	void __fastcall StartStream(void);
	void __fastcall CloseStream(void);
	void __fastcall SetOnePass(const bool Value);
	void __fastcall ClearAll(void);
	void __fastcall DeleteAllRadioGroups(void);
	TPDFRadioGroup* __fastcall CreateRadioGroup(AnsiString Name);
	
public:
	__fastcall virtual TPDFDocument(Classes::TComponent* AOwner);
	__fastcall virtual ~TPDFDocument(void);
	void __fastcall Abort(void);
	void __fastcall BeginDoc(void);
	void __fastcall EndDoc(void);
	void __fastcall NewPage(void);
	void __fastcall SetCurrentPage(int Index);
	int __fastcall GetCurrentPageIndex(void);
	int __fastcall AddImage(Graphics::TGraphic* Image, TImageCompressionType Compression)/* overload */;
	int __fastcall AddImage(AnsiString FileName, TImageCompressionType Compression)/* overload */;
	int __fastcall CreateWaterMark(void);
	TPDFAction* __fastcall CreateAction(TMetaClass* CClass);
	__property TPDFAction* OpenDocumentAction = {read=FOpenDocumentAction, write=SetOpenDocumentAction};
	__property TPDFOutlines* Outlines = {read=FOutlines};
	__property TPDFPage* CurrentPage = {read=FCurrentPage};
	__property int PageCount = {read=GetPageCount, nodefault};
	__property TPDFPage* Page[int Index] = {read=GetPage/*, default*/};
	__property TPDFPage* WaterMark[int Index] = {read=GetWaterMark};
	__property bool Printing = {read=FPrinting, nodefault};
	__property bool Aborted = {read=FAborted, nodefault};
	__property Graphics::TCanvas* Canvas = {read=GetCanvas};
	__property Classes::TStream* OutputStream = {read=FOutputStream, write=SetOutputStream};
	__property int PageHeight = {read=GetPageHeight, nodefault};
	__property int PageWidth = {read=GetPageWidth, nodefault};
	__property int PageNumber = {read=GetPageNumber, nodefault};
	__property TCCITTProcedure OnCCITTProcedure = {read=FCCITT, write=FCCITT};
	
__published:
	__property bool AutoLaunch = {read=FAutoLaunch, write=SetAutoLaunch, nodefault};
	__property AnsiString FileName = {read=FFileName, write=SetFileName};
	__property TCompressionType Compression = {read=FCompression, write=SetCompression, nodefault};
	__property TPDFDocInfo* DocumentInfo = {read=FDocumentInfo, write=SetDocumentInfo};
	__property TPageLayout PageLayout = {read=FPageLayout, write=SetPageLayout, nodefault};
	__property TPageMode PageMode = {read=FPageMode, write=SetPageMode, nodefault};
	__property bool ProtectionEnabled = {read=FProtectionEnabled, write=SetProtectionEnabled, nodefault};
	__property TPDFCtiptoOptions ProtectionOptions = {read=FProtectionOptions, write=SetProtectionOptions, nodefault};
	__property AnsiString OwnerPassword = {read=FOwnerPassword, write=SetOwnerPassword};
	__property AnsiString UserPassword = {read=FUserPassword, write=SetUserPassword};
	__property Classes::TStringList* NonEmbeddedFont = {read=FNotEmbeddedFont, write=SetNotEmbeddedFont};
	__property int JPEGQuality = {read=FJPEGQuality, write=SetJPEGQuality, nodefault};
	__property int Resolution = {read=FResolution, write=FResolution, nodefault};
	__property TViewerPreferences ViewerPreferences = {read=FViewerPreferences, write=FViewerPreferences, nodefault};
	__property bool AutoCreateURL = {read=FACURL, write=FACURL, nodefault};
	__property bool OnePass = {read=FOnePass, write=SetOnePass, nodefault};
};


class PASCALIMPLEMENTATION TPDFAction : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TPDFDocument* FOwner;
	int ActionID;
	TPDFAction* FNext;
	void __fastcall Prepare(void);
	virtual void __fastcall Save(void) = 0 ;
	
public:
	__fastcall virtual TPDFAction(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFAction(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFURLAction;
class PASCALIMPLEMENTATION TPDFURLAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	AnsiString FURL;
	virtual void __fastcall Save(void);
	void __fastcall SetURL(const AnsiString Value);
	
public:
	__property AnsiString URL = {read=FURL, write=SetURL};
public:
	#pragma option push -w-inl
	/* TPDFAction.Create */ inline __fastcall virtual TPDFURLAction(void) : TPDFAction() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFURLAction(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFJavaScriptAction;
class PASCALIMPLEMENTATION TPDFJavaScriptAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	AnsiString FJavaScript;
	virtual void __fastcall Save(void);
	void __fastcall SetJavaScript(const AnsiString Value);
	
public:
	__property AnsiString JavaScript = {read=FJavaScript, write=SetJavaScript};
public:
	#pragma option push -w-inl
	/* TPDFAction.Create */ inline __fastcall virtual TPDFJavaScriptAction(void) : TPDFAction() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFJavaScriptAction(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFGoToPageAction;
class PASCALIMPLEMENTATION TPDFGoToPageAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	int FTopOffset;
	int FPageIndex;
	virtual void __fastcall Save(void);
	void __fastcall SetPageIndex(const int Value);
	void __fastcall SetTopOffset(const int Value);
	
public:
	__property int PageIndex = {read=FPageIndex, write=SetPageIndex, nodefault};
	__property int TopOffset = {read=FTopOffset, write=SetTopOffset, nodefault};
public:
	#pragma option push -w-inl
	/* TPDFAction.Create */ inline __fastcall virtual TPDFGoToPageAction(void) : TPDFAction() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFGoToPageAction(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFVisibeControlAction;
class PASCALIMPLEMENTATION TPDFVisibeControlAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	bool FVisible;
	TPDFControls* FControls;
	virtual void __fastcall Save(void);
	
public:
	__fastcall virtual TPDFVisibeControlAction(void);
	__fastcall virtual ~TPDFVisibeControlAction(void);
	__property bool Visible = {read=FVisible, write=FVisible, nodefault};
	__property TPDFControls* Controls = {read=FControls};
};


class DELPHICLASS TPDFSubmitFormAction;
class PASCALIMPLEMENTATION TPDFSubmitFormAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	TPDFControls* FFields;
	Classes::TList* FRG;
	bool FIncludeEmptyFields;
	AnsiString FURL;
	TPDFSubmitType FSubmitType;
	virtual void __fastcall Save(void);
	void __fastcall SetURL(const AnsiString Value);
	
public:
	__fastcall virtual TPDFSubmitFormAction(void);
	__fastcall virtual ~TPDFSubmitFormAction(void);
	__property TPDFControls* IncludeFields = {read=FFields};
	__property AnsiString URL = {read=FURL, write=SetURL};
	__property bool SendEmpty = {read=FIncludeEmptyFields, write=FIncludeEmptyFields, nodefault};
	__property TPDFSubmitType SubmitType = {read=FSubmitType, write=FSubmitType, nodefault};
};


class DELPHICLASS TPDFResetFormAction;
class PASCALIMPLEMENTATION TPDFResetFormAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	TPDFControls* FFields;
	Classes::TList* FRG;
	virtual void __fastcall Save(void);
	
public:
	__fastcall virtual TPDFResetFormAction(void);
	__fastcall virtual ~TPDFResetFormAction(void);
	__property TPDFControls* ResetFields = {read=FFields};
};


class DELPHICLASS TPDFImportDataAction;
class PASCALIMPLEMENTATION TPDFImportDataAction : public TPDFAction 
{
	typedef TPDFAction inherited;
	
private:
	AnsiString FFileName;
	virtual void __fastcall Save(void);
	void __fastcall SetFileName(const AnsiString Value);
	
public:
	__property AnsiString FileName = {read=FFileName, write=SetFileName};
public:
	#pragma option push -w-inl
	/* TPDFAction.Create */ inline __fastcall virtual TPDFImportDataAction(void) : TPDFAction() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFImportDataAction(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFCustomAnnotation;
class PASCALIMPLEMENTATION TPDFCustomAnnotation : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TPDFPage* FOwner;
	int AnnotID;
	int FLeft;
	int FTop;
	int FRight;
	int FBottom;
	TAnnotationFlags FFlags;
	AnsiString FBorderStyle;
	Graphics::TColor FBorderColor;
	int __fastcall CalcFlags(void);
	virtual void __fastcall Save(void) = 0 ;
	Types::TRect __fastcall GetBox();
	void __fastcall SetBox(const Types::TRect &Value);
	
public:
	__fastcall TPDFCustomAnnotation(TPDFPage* AOwner);
	__property Types::TRect Box = {read=GetBox, write=SetBox};
	__property AnsiString BorderStyle = {read=FBorderStyle, write=FBorderStyle};
	__property TAnnotationFlags Flags = {read=FFlags, write=FFlags, nodefault};
	__property Graphics::TColor BorderColor = {read=FBorderColor, write=FBorderColor, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFCustomAnnotation(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPDFControl : public TPDFCustomAnnotation 
{
	typedef TPDFCustomAnnotation inherited;
	
private:
	bool FRequired;
	bool FReadOnly;
	AnsiString FName;
	TPDFAction* FOnMouseDown;
	TPDFAction* FOnMouseExit;
	TPDFAction* FOnMouseEnter;
	TPDFAction* FOnMouseUp;
	TPDFAction* FOnLostFocus;
	TPDFAction* FOnSetFocus;
	Graphics::TColor FColor;
	TPDFControlFont* FFont;
	AnsiString FFN;
	TPDFControlHint* FHint;
	void __fastcall SetName(const AnsiString Value);
	void __fastcall SetOnMouseDown(const TPDFAction* Value);
	void __fastcall SetOnMouseEnter(const TPDFAction* Value);
	void __fastcall SetOnMouseExit(const TPDFAction* Value);
	void __fastcall SetOnMouseUp(const TPDFAction* Value);
	void __fastcall SetOnLostFocus(const TPDFAction* Value);
	void __fastcall SetOnSetFocus(const TPDFAction* Value);
	void __fastcall SetColor(const Graphics::TColor Value);
	AnsiString __fastcall CalcActions();
	
public:
	__fastcall virtual TPDFControl(TPDFPage* AOwner, AnsiString AName);
	__fastcall virtual ~TPDFControl(void);
	__property bool ReadOnly = {read=FReadOnly, write=FReadOnly, nodefault};
	__property bool Required = {read=FRequired, write=FRequired, nodefault};
	__property AnsiString Name = {read=FName, write=SetName};
	__property Graphics::TColor Color = {read=FColor, write=SetColor, nodefault};
	__property TPDFControlFont* Font = {read=FFont};
	__property TPDFControlHint* Hint = {read=FHint};
	__property TPDFAction* OnMouseUp = {read=FOnMouseUp, write=SetOnMouseUp};
	__property TPDFAction* OnMouseDown = {read=FOnMouseDown, write=SetOnMouseDown};
	__property TPDFAction* OnMouseEnter = {read=FOnMouseEnter, write=SetOnMouseEnter};
	__property TPDFAction* OnMouseExit = {read=FOnMouseExit, write=SetOnMouseExit};
	__property TPDFAction* OnSetFocus = {read=FOnSetFocus, write=SetOnSetFocus};
	__property TPDFAction* OnLostFocus = {read=FOnLostFocus, write=SetOnLostFocus};
};


typedef TMetaClass*TPDFControlClass;

class PASCALIMPLEMENTATION TPDFRadioGroup : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TPDFControls* FButtons;
	TPDFDocument* FOwner;
	int GroupID;
	AnsiString FName;
	void __fastcall Save(void);
	
public:
	__fastcall TPDFRadioGroup(TPDFDocument* AOwner, AnsiString Name);
	__fastcall virtual ~TPDFRadioGroup(void);
};


class DELPHICLASS TPDFButton;
class PASCALIMPLEMENTATION TPDFButton : public TPDFControl 
{
	typedef TPDFControl inherited;
	
private:
	AnsiString FCaption;
	virtual void __fastcall Save(void);
	
protected:
	TPDFPage* FUp;
	TPDFPage* FDown;
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TPDFButton(TPDFPage* AOwner, AnsiString AName);
	__property AnsiString Caption = {read=FCaption, write=FCaption};
public:
	#pragma option push -w-inl
	/* TPDFControl.Destroy */ inline __fastcall virtual ~TPDFButton(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFInputControl;
class PASCALIMPLEMENTATION TPDFInputControl : public TPDFControl 
{
	typedef TPDFControl inherited;
	
private:
	TPDFJavaScriptAction* FOnOtherControlChanged;
	TPDFJavaScriptAction* FOnKeyPress;
	TPDFJavaScriptAction* FOnBeforeFormatting;
	TPDFJavaScriptAction* FOnChange;
	void __fastcall SetOnOtherControlChanged(const TPDFJavaScriptAction* Value);
	void __fastcall SetOnKeyPress(const TPDFJavaScriptAction* Value);
	void __fastcall SetOnBeforeFormatting(const TPDFJavaScriptAction* Value);
	void __fastcall SetOnChange(const TPDFJavaScriptAction* Value);
	HIDESBASE AnsiString __fastcall CalcActions();
	
public:
	__property TPDFJavaScriptAction* OnKeyPress = {read=FOnKeyPress, write=SetOnKeyPress};
	__property TPDFJavaScriptAction* OnBeforeFormatting = {read=FOnBeforeFormatting, write=SetOnBeforeFormatting};
	__property TPDFJavaScriptAction* OnChange = {read=FOnChange, write=SetOnChange};
	__property TPDFJavaScriptAction* OnOtherControlChanged = {read=FOnOtherControlChanged, write=SetOnOtherControlChanged};
public:
	#pragma option push -w-inl
	/* TPDFControl.Create */ inline __fastcall virtual TPDFInputControl(TPDFPage* AOwner, AnsiString AName) : TPDFControl(AOwner, AName) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TPDFControl.Destroy */ inline __fastcall virtual ~TPDFInputControl(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFCheckBox;
class PASCALIMPLEMENTATION TPDFCheckBox : public TPDFInputControl 
{
	typedef TPDFInputControl inherited;
	
private:
	bool FChecked;
	AnsiString FCaption;
	virtual void __fastcall Save(void);
	
protected:
	TPDFPage* FCheck;
	TPDFPage* FUnCheck;
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TPDFCheckBox(TPDFPage* AOwner, AnsiString AName);
	__property bool Checked = {read=FChecked, write=FChecked, nodefault};
	__property AnsiString Caption = {read=FCaption, write=FCaption};
public:
	#pragma option push -w-inl
	/* TPDFControl.Destroy */ inline __fastcall virtual ~TPDFCheckBox(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFRadioButton;
class PASCALIMPLEMENTATION TPDFRadioButton : public TPDFInputControl 
{
	typedef TPDFInputControl inherited;
	
private:
	TPDFRadioGroup* FRG;
	bool FChecked;
	AnsiString FExportValue;
	virtual void __fastcall Save(void);
	void __fastcall SetExportValue(const AnsiString Value);
	
protected:
	TPDFPage* FCheck;
	TPDFPage* FUnCheck;
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TPDFRadioButton(TPDFPage* AOwner, AnsiString AName);
	__property AnsiString ExportValue = {read=FExportValue, write=SetExportValue};
	__property bool Checked = {read=FChecked, write=FChecked, nodefault};
public:
	#pragma option push -w-inl
	/* TPDFControl.Destroy */ inline __fastcall virtual ~TPDFRadioButton(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFEdit;
class PASCALIMPLEMENTATION TPDFEdit : public TPDFInputControl 
{
	typedef TPDFInputControl inherited;
	
private:
	AnsiString FText;
	bool FIsPassword;
	bool FShowBorder;
	bool FMultiline;
	int FMaxLength;
	THorJust FJustification;
	virtual void __fastcall Save(void);
	void __fastcall SetMaxLength(const int Value);
	
protected:
	TPDFPage* FShow;
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TPDFEdit(TPDFPage* AOwner, AnsiString AName);
	__property AnsiString Text = {read=FText, write=FText};
	__property bool Multiline = {read=FMultiline, write=FMultiline, nodefault};
	__property bool IsPassword = {read=FIsPassword, write=FIsPassword, nodefault};
	__property bool ShowBorder = {read=FShowBorder, write=FShowBorder, nodefault};
	__property int MaxLength = {read=FMaxLength, write=SetMaxLength, nodefault};
	__property THorJust Justification = {read=FJustification, write=FJustification, nodefault};
public:
	#pragma option push -w-inl
	/* TPDFControl.Destroy */ inline __fastcall virtual ~TPDFEdit(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFComboBox;
class PASCALIMPLEMENTATION TPDFComboBox : public TPDFInputControl 
{
	typedef TPDFInputControl inherited;
	
private:
	bool FEditEnabled;
	Classes::TStringList* FItems;
	AnsiString FText;
	virtual void __fastcall Save(void);
	
protected:
	TPDFPage* FShow;
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TPDFComboBox(TPDFPage* AOwner, AnsiString AName);
	__fastcall virtual ~TPDFComboBox(void);
	__property Classes::TStringList* Items = {read=FItems};
	__property bool EditEnabled = {read=FEditEnabled, write=FEditEnabled, nodefault};
	__property AnsiString Text = {read=FText, write=FText};
};


class DELPHICLASS TPDFTextAnnotation;
class PASCALIMPLEMENTATION TPDFTextAnnotation : public TPDFCustomAnnotation 
{
	typedef TPDFCustomAnnotation inherited;
	
private:
	AnsiString FText;
	AnsiString FCaption;
	TTextAnnotationIcon FTextAnnotationIcon;
	bool FOpened;
	Graphics::TFontCharset FCharset;
	virtual void __fastcall Save(void);
	
public:
	__property AnsiString Caption = {read=FCaption, write=FCaption};
	__property AnsiString Text = {read=FText, write=FText};
	__property TTextAnnotationIcon TextAnnotationIcon = {read=FTextAnnotationIcon, write=FTextAnnotationIcon, nodefault};
	__property bool Opened = {read=FOpened, write=FOpened, nodefault};
	__property Graphics::TFontCharset Charset = {read=FCharset, write=FCharset, nodefault};
public:
	#pragma option push -w-inl
	/* TPDFCustomAnnotation.Create */ inline __fastcall TPDFTextAnnotation(TPDFPage* AOwner) : TPDFCustomAnnotation(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFTextAnnotation(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPDFActionAnnotation;
class PASCALIMPLEMENTATION TPDFActionAnnotation : public TPDFCustomAnnotation 
{
	typedef TPDFCustomAnnotation inherited;
	
private:
	TPDFAction* FAction;
	virtual void __fastcall Save(void);
	void __fastcall SetAction(const TPDFAction* Value);
	
public:
	__property TPDFAction* Action = {read=FAction, write=SetAction};
public:
	#pragma option push -w-inl
	/* TPDFCustomAnnotation.Create */ inline __fastcall TPDFActionAnnotation(TPDFPage* AOwner) : TPDFCustomAnnotation(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFActionAnnotation(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPDFPage : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TPDFDocument* FOwner;
	Classes::TList* FAnnot;
	TTextCTM FMatrix;
	TPDFPages* FForms;
	bool FIsForm;
	int FRes;
	Extended D2P;
	Classes::TStringList* FContent;
	int FHeight;
	int FWidth;
	TPDFPageSize FPageSize;
	Extended FX;
	Extended FY;
	TPDFPageRotate FRotate;
	Classes::TList* FLinkedFont;
	Classes::TList* FLinkedImages;
	int ResourceID;
	int PageID;
	int ContentID;
	bool FEBold;
	bool FEItalic;
	bool FEUnderLine;
	bool FEStrike;
	TTextCTM FCTM;
	TTextCTM FF;
	Extended FCurrentFontSize;
	int FCurrentFontIndex;
	Extended FHorizontalScaling;
	Extended FCharSpace;
	Extended FWordSpace;
	Extended FRise;
	int FRender;
	bool FFontInited;
	bool FTextInited;
	Extended FTextLeading;
	int FSaveCount;
	Extended FTextAngle;
	Extended FRealAngle;
	Printers::TPrinterOrientation FOrientation;
	bool Factions;
	Graphics::TMetafile* FMF;
	Graphics::TCanvas* FCanvas;
	int FWaterMark;
	int FThumbnail;
	bool FRemoveCR;
	bool FEmulationEnabled;
	void __fastcall SetHeight(const int Value);
	void __fastcall SetWidth(const int Value);
	void __fastcall SetPageSize(TPDFPageSize Value);
	void __fastcall Save(void);
	void __fastcall AppendAction(AnsiString Action);
	Extended __fastcall IntToExtX(Extended AX);
	Extended __fastcall IntToExtY(Extended AY);
	Extended __fastcall ExtToIntX(Extended AX);
	Extended __fastcall ExtToIntY(Extended AY);
	void __fastcall DrawArcWithBezier(Extended CenterX, Extended CenterY, Extended RadiusX, Extended RadiusY, Extended StartAngle, Extended SweepRange, bool UseMoveTo = true);
	void __fastcall SetRotate(const TPDFPageRotate Value);
	void __fastcall RawSetTextPosition(Extended X, Extended Y);
	void __fastcall RawTextOut(Extended X, Extended Y, Extended Orientation, AnsiString TextStr);
	void __fastcall RawLineTo(Extended X, Extended Y);
	void __fastcall RawMoveTo(Extended X, Extended Y);
	void __fastcall RawRect(Extended X, Extended Y, Extended W, Extended H);
	TDoublePoint __fastcall RawArc(Extended X1, Extended Y1, Extended x2, Extended y2, Extended x3, Extended y3, Extended x4, Extended y4)/* overload */;
	TDoublePoint __fastcall RawArc(Extended X1, Extended Y1, Extended x2, Extended y2, Extended BegAngle, Extended EndAngle)/* overload */;
	TDoublePoint __fastcall RawPie(Extended X1, Extended Y1, Extended x2, Extended y2, Extended x3, Extended y3, Extended x4, Extended y4)/* overload */;
	TDoublePoint __fastcall RawPie(Extended X1, Extended Y1, Extended x2, Extended y2, Extended BegAngle, Extended EndAngle)/* overload */;
	void __fastcall RawCircle(Extended X, Extended Y, Extended R);
	void __fastcall RawEllipse(Extended x1, Extended y1, Extended x2, Extended y2);
	void __fastcall RawRectRotated(Extended X, Extended Y, Extended W, Extended H, Extended Angle);
	void __fastcall RawShowImage(int ImageIndex, Extended x, Extended y, Extended w, Extended h, Extended angle);
	void __fastcall RawConcat(Extended A, Extended B, Extended C, Extended D, Extended E, Extended F);
	void __fastcall RawTranslate(Extended XT, Extended YT);
	void __fastcall DeleteAllAnnotations(void);
	void __fastcall RawCurveto(Extended X1, Extended Y1, Extended X2, Extended Y2, Extended X3, Extended Y3);
	void __fastcall ConcatTextMatrix(Extended A, Extended B, Extended C, Extended D, Extended X, Extended Y);
	void __fastcall SetTextMatrix(Extended A, Extended B, Extended C, Extended D, Extended X, Extended Y);
	void __fastcall ResetTextCTM(void);
	void __fastcall SetOrientation(const Printers::TPrinterOrientation Value);
	int __fastcall GetHeight(void);
	int __fastcall GetWidth(void);
	void __fastcall CreateCanvas(void);
	void __fastcall DeleteCanvas(void);
	void __fastcall CloseCanvas(void);
	void __fastcall SetWaterMark(const int Value);
	void __fastcall SetThumbnail(const int Value);
	void __fastcall PrepareID(void);
	
public:
	__fastcall TPDFPage(TPDFDocument* AOwner);
	__fastcall virtual ~TPDFPage(void);
	TPDFCustomAnnotation* __fastcall SetAnnotation(const Types::TRect &ARect, AnsiString Title, AnsiString Text, Graphics::TColor Color, TAnnotationFlags Flags, bool Opened, Graphics::TFontCharset Charset = (Graphics::TFontCharset)(0x0));
	TPDFCustomAnnotation* __fastcall SetUrl(const Types::TRect &ARect, AnsiString URL);
	TPDFCustomAnnotation* __fastcall SetAction(const Types::TRect &ARect, TPDFAction* Action);
	TPDFCustomAnnotation* __fastcall SetLinkToPage(const Types::TRect &ARect, int PageIndex, int TopOffset);
	TPDFControl* __fastcall CreateControl(TMetaClass* CClass, AnsiString ControlName, const Types::TRect &Box);
	void __fastcall BeginText(void);
	void __fastcall EndText(void);
	void __fastcall RotateText(Extended Degrees);
	void __fastcall SetActiveFont(AnsiString FontName, Graphics::TFontStyles FontStyle, Extended FontSize, Graphics::TFontCharset FontCharset = (Graphics::TFontCharset)(0x0));
	void __fastcall SetCharacterSpacing(Extended Spacing);
	void __fastcall SetHorizontalScaling(Extended Scale);
	void __fastcall SetLineCap(TPDFLineCap LineCap);
	void __fastcall SetLineJoin(TPDFLineJoin LineJoin);
	void __fastcall SetMiterLimit(Extended MiterLimit);
	void __fastcall SetTextPosition(Extended X, Extended Y);
	void __fastcall SetTextRenderingMode(int Mode);
	void __fastcall SetTextRise(Extended Rise);
	void __fastcall SetWordSpacing(Extended Spacing);
	void __fastcall SkewText(Extended Alpha, Extended Beta);
	void __fastcall TextOut(Extended X, Extended Y, Extended Orientation, AnsiString TextStr);
	void __fastcall TextShow(AnsiString TextStr);
	Extended __fastcall GetTextWidth(AnsiString Text);
	void __fastcall TextBox(const Types::TRect &Rect, AnsiString Text, THorJust Hor, TVertJust Vert);
	void __fastcall Clip(void);
	void __fastcall EoClip(void);
	void __fastcall EoFill(void);
	void __fastcall EoFillAndStroke(void);
	void __fastcall Fill(void);
	void __fastcall FillAndStroke(void);
	void __fastcall NewPath(void);
	void __fastcall ClosePath(void);
	void __fastcall Stroke(void);
	void __fastcall LineTo(Extended X, Extended Y);
	void __fastcall MoveTo(Extended X, Extended Y);
	void __fastcall Curveto(Extended X1, Extended Y1, Extended X2, Extended Y2, Extended X3, Extended Y3);
	void __fastcall Rectangle(Extended X1, Extended Y1, Extended X2, Extended Y2);
	void __fastcall Circle(Extended X, Extended Y, Extended R);
	void __fastcall Ellipse(Extended X1, Extended Y1, Extended X2, Extended Y2);
	TDoublePoint __fastcall Arc(Extended X1, Extended Y1, Extended x2, Extended y2, Extended x3, Extended y3, Extended x4, Extended y4)/* overload */;
	TDoublePoint __fastcall Arc(Extended X1, Extended Y1, Extended x2, Extended y2, Extended BegAngle, Extended EndAngle)/* overload */;
	void __fastcall Pie(Extended X1, Extended Y1, Extended x2, Extended y2, Extended x3, Extended y3, Extended x4, Extended y4)/* overload */;
	void __fastcall Pie(Extended X1, Extended Y1, Extended x2, Extended y2, Extended BegAngle, Extended EndAngle)/* overload */;
	void __fastcall RectRotated(Extended X, Extended Y, Extended W, Extended H, Extended Angle);
	void __fastcall RoundRect(int X1, int Y1, int X2, int Y2, int X3, int Y3);
	void __fastcall GStateRestore(void);
	void __fastcall GStateSave(void);
	void __fastcall NoDash(void);
	void __fastcall SetCMYKColor(Extended C, Extended M, Extended Y, Extended K);
	void __fastcall SetCMYKColorFill(Extended C, Extended M, Extended Y, Extended K);
	void __fastcall SetCMYKColorStroke(Extended C, Extended M, Extended Y, Extended K);
	void __fastcall SetRGBColor(Extended R, Extended G, Extended B);
	void __fastcall SetRGBColorFill(Extended R, Extended G, Extended B);
	void __fastcall SetRGBColorStroke(Extended R, Extended G, Extended B);
	void __fastcall SetDash(AnsiString DashSpec);
	void __fastcall SetFlat(int FlatNess);
	void __fastcall SetGray(Extended Gray);
	void __fastcall SetGrayFill(Extended Gray);
	void __fastcall SetGrayStroke(Extended Gray);
	void __fastcall SetLineWidth(Extended lw);
	void __fastcall Concat(Extended A, Extended B, Extended C, Extended D, Extended E, Extended F);
	void __fastcall Scale(Extended SX, Extended SY);
	void __fastcall Rotate(Extended Angle);
	void __fastcall Translate(Extended XT, Extended YT);
	void __fastcall ShowImage(int ImageIndex, Extended x, Extended y, Extended w, Extended h, Extended angle);
	void __fastcall Comment(AnsiString st);
	void __fastcall PlayMetaFile(Graphics::TMetafile* MF)/* overload */;
	void __fastcall PlayMetaFile(Graphics::TMetafile* MF, Extended x, Extended y, Extended XScale, Extended YScale)/* overload */;
	__property Printers::TPrinterOrientation Orientation = {read=FOrientation, write=SetOrientation, nodefault};
	__property TPDFPageSize Size = {read=FPageSize, write=SetPageSize, nodefault};
	__property int Height = {read=GetHeight, write=SetHeight, nodefault};
	__property int Width = {read=GetWidth, write=SetWidth, nodefault};
	__property TPDFPageRotate PageRotate = {read=FRotate, write=SetRotate, nodefault};
	__property int WaterMark = {read=FWaterMark, write=SetWaterMark, nodefault};
	__property int Thumbnail = {read=FThumbnail, write=SetThumbnail, nodefault};
	__property bool TextInited = {read=FTextInited, nodefault};
};


class PASCALIMPLEMENTATION TPDFOutlineNode : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int OutlineNodeID;
	Classes::TList* FChild;
	TPDFOutlines* FOwner;
	TPDFOutlineNode* FParent;
	TPDFOutlineNode* FPrev;
	TPDFOutlineNode* FNext;
	AnsiString FTitle;
	bool FExpanded;
	Graphics::TFontCharset FCharset;
	TPDFAction* FAction;
	void __fastcall SetTitle(const AnsiString Value);
	int __fastcall GetCount(void);
	bool __fastcall GetHasChildren(void);
	TPDFOutlineNode* __fastcall GetItem(int Index);
	void __fastcall Save(void);
	void __fastcall SetExpanded(const bool Value);
	void __fastcall SetCharset(const Graphics::TFontCharset Value);
	void __fastcall SetAction(const TPDFAction* Value);
	
public:
	void __fastcall Delete(void);
	void __fastcall DeleteChildren(void);
	__fastcall TPDFOutlineNode(TPDFOutlines* AOwner);
	__fastcall virtual ~TPDFOutlineNode(void);
	TPDFOutlineNode* __fastcall GetFirstChild(void);
	TPDFOutlineNode* __fastcall GetLastChild(void);
	TPDFOutlineNode* __fastcall GetNext(void);
	TPDFOutlineNode* __fastcall GetNextChild(TPDFOutlineNode* Node);
	TPDFOutlineNode* __fastcall GetNextSibling(void);
	TPDFOutlineNode* __fastcall GetPrev(void);
	TPDFOutlineNode* __fastcall GetPrevChild(TPDFOutlineNode* Node);
	TPDFOutlineNode* __fastcall GetPrevSibling(void);
	__property TPDFAction* Action = {read=FAction, write=SetAction};
	__property AnsiString Title = {read=FTitle, write=SetTitle};
	__property int Count = {read=GetCount, nodefault};
	__property bool HasChildren = {read=GetHasChildren, nodefault};
	__property TPDFOutlineNode* Item[int Index] = {read=GetItem};
	__property bool Expanded = {read=FExpanded, write=SetExpanded, nodefault};
	__property Graphics::TFontCharset Charset = {read=FCharset, write=SetCharset, nodefault};
};


class PASCALIMPLEMENTATION TPDFImage : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TImageCompressionType FCT;
	AnsiString ImageName;
	int PictureID;
	int FHeight;
	int FWidth;
	Classes::TMemoryStream* Data;
	int FBitPerPixel;
	bool GrayScale;
	bool Saved;
	void __fastcall Save(TPDFDocument* Doc);
	
public:
	__fastcall TPDFImage(Graphics::TGraphic* Image, TImageCompressionType Compression, TPDFDocument* Doc)/* overload */;
	__fastcall TPDFImage(AnsiString FileName, TImageCompressionType Compression, TPDFDocument* Doc)/* overload */;
	__fastcall virtual ~TPDFImage(void);
	__property int Height = {read=FHeight, nodefault};
	__property int Width = {read=FWidth, nodefault};
	__property int BitPerPixel = {read=FBitPerPixel, nodefault};
};


#pragma option push -b-
enum GTypeItem { gtiPen, gtiFont, gtiBrush };
#pragma option pop

#pragma pack(push, 4)
struct THTItem
{
	HGDIOBJ Handle;
	unsigned Index;
	GTypeItem TP;
} ;
#pragma pack(pop)

typedef THTItem *PHTItem;

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Pdf */
using namespace Pdf;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PDF
