VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form frmMDIDoc 
   Caption         =   "Document"
   ClientHeight    =   3600
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3930
   Icon            =   "MDIDoc.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3600
   ScaleWidth      =   3930
   Begin VB.Timer tmr 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   3600
      Top             =   360
   End
   Begin RichTextLib.RichTextBox rtf 
      Height          =   3495
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   3855
      _ExtentX        =   6800
      _ExtentY        =   6165
      _Version        =   393217
      HideSelection   =   0   'False
      ScrollBars      =   3
      TextRTF         =   $"MDIDoc.frx":0452
   End
End
Attribute VB_Name = "frmMDIDoc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Private Enum eTextMode
    TM_PLAINTEXT = 1
    TM_RICHTEXT = 2                ' /* default behavior */
    TM_SINGLELEVELUNDO = 4
    TM_MULTILEVELUNDO = 8          ' /* default behavior */
    TM_SINGLECODEPAGE = 16
    TM_MULTICODEPAGE = 32          ' /* default behavior */
End Enum

Private Const WM_USER = &H400
Private Const WM_PASTE = &H302
Private Const WM_COPY = &H301
Private Const WM_CUT = &H300

Private Const EM_LINEINDEX = &HBB&
Private Const EM_CANUNDO = &HC6
Private Const EM_UNDO = &HC7
Private Const EM_LINEFROMCHAR = &HC9&
Private Const EM_CANPASTE = (WM_USER + 50)
Private Const EM_HIDESELECTION = (WM_USER + 63)
Private Const EM_REQUESTRESIZE = (WM_USER + 65)
Private Const EM_SETUNDOLIMIT = (WM_USER + 82)
Private Const EM_REDO = (WM_USER + 84)
Private Const EM_CANREDO = (WM_USER + 85)
Private Const EM_GETUNDONAME = (WM_USER + 86)
Private Const EM_GETREDONAME = (WM_USER + 87)
Private Const EM_STOPGROUPTYPING = (WM_USER + 88)
Private Const EM_SETTEXTMODE = (WM_USER + 89)
Private Const EM_GETTEXTMODE = (WM_USER + 90)
Private Const EM_AUTOURLDETECT = (WM_USER + 91)

Private m_cb As CuteControlsLibCtl.CuteBar

Implements IMDIDocument


Private Sub Form_Resize()
    On Error Resume Next
    rtf.Move 0, 0, ScaleWidth, ScaleHeight
End Sub

Private Function IMDIDocument_CommandHandler(id As Integer) As Boolean
    
    IMDIDocument_CommandHandler = True
    Select Case id
    ' File
    Case id_SaveAs: FileSaveAs
    Case id_Save: FileSave Me.Caption
    Case id_Print: FilePrint
    
    ' Edit
    Case id_Undo: EditUndo
    Case id_Redo: EditRedo
    Case id_Cut: EditCut
    Case id_Copy: EditCopy
    Case id_Paste: EditPaste
    Case id_eSelAll: EditSelectAll
    Case id_eClear: EditClear
    Case id_Find: EditFind ""
    Case id_FindNext: EditFindNext
        
    ' Insert
    Case id_Date: InsertDate
    Case id_Time: InsertTime
    Case id_Picture: InsertPicture
    
    ' Format
    Case id_FontName: FormatFont
    Case id_FontSize: FormatFont
    Case id_Bold: FormatBold
    Case id_Italic: FormatItalic
    Case id_Underline: FormatUnderline
    Case id_Left: FormatAlign 0
    Case id_Center: FormatAlign 1
    Case id_Right: FormatAlign 2
    Case id_Bullets: FormatBullets
        
    Case Else
        IMDIDocument_CommandHandler = False
End Select
    
    UpdateToolbar
    tmr.Enabled = False
End Function
Private Sub UpdateFonts()
Dim i As Integer

    With m_cb.Bars(name_barFormat).Items(name_FontName).ComboBox
        For i = 0 To Screen.FontCount - 1
            If .ListText(i) = rtf.SelFontName Then
                .ListIndex = i
            End If
        Next
    End With
    
    With m_cb.Bars(name_barFormat).Items(name_FontSize).ComboBox
        For i = 0 To Screen.FontCount - 1
            If Val(.ListText(i)) = rtf.SelFontSize Then
                .ListIndex = i
            End If
        Next
    End With
End Sub


Private Sub UpdateToolbar()
    With m_cb.Bars(name_barStandard)

      .Items(name_Cut).Enabled = (rtf.SelLength <> 0)
      .Items(name_Copy).Enabled = (rtf.SelLength <> 0)
      .Items(name_Paste).Enabled = (SendMessage(rtf.hwnd, EM_CANPASTE, 0, 0) = 1)
      .Items(name_Undo).Enabled = (SendMessage(rtf.hwnd, EM_CANUNDO, 0, 0) = 1)
      .Items(name_Redo).Enabled = (SendMessage(rtf.hwnd, EM_CANREDO, 0, 0) = 1)
         
  End With
  
  With m_cb.Bars(name_barFormat)
  
      .Items(name_Bold).State = IIf(IsNull(rtf.SelBold) Or rtf.SelBold, ccItemPressed, ccItemUnpressed)
      .Items(name_Italic).State = IIf(IsNull(rtf.SelItalic) Or rtf.SelItalic, ccItemPressed, ccItemUnpressed)
      .Items(name_Underline).State = IIf(IsNull(rtf.SelUnderline) Or rtf.SelUnderline, ccItemPressed, ccItemUnpressed)
      
      .Items(name_Left).State = IIf(rtf.SelAlignment = 0, ccItemPressed, ccItemUnpressed)
      .Items(name_Center).State = IIf(rtf.SelAlignment = 2, ccItemPressed, ccItemUnpressed)
      .Items(name_Right).State = IIf(rtf.SelAlignment = 1, ccItemPressed, ccItemUnpressed)

      .Items(name_Bullets).State = IIf(IsNull(rtf.SelBullet), ccItemUnpressed, IIf(rtf.SelBullet, ccItemPressed, ccItemUnpressed))
'        .Items(name_FontName).ComboBox.text = IIf(IsNull(rtf.SelFontName), "", rtf.SelFontName)
'        .Items(name_FontSize).ComboBox.text = IIf(IsNull(rtf.SelFontSize), "", rtf.SelFontSize)
  End With
  
      UpdateFonts
  UpdatePosition
    tmr.Enabled = False
End Sub
Private Sub UpdatePosition()
Dim lCol As Long, lLine As Long, lLineIndex As Long
Dim lSelStart As Long, lSelEnd As Long

  lLine = SendMessage(rtf.hwnd, EM_LINEFROMCHAR, -1, 0&)
  
  lSelStart = rtf.SelStart
  lSelEnd = rtf.SelStart + rtf.SelLength

  If lSelStart < lSelEnd Then lSelStart = lSelEnd
   
  lLineIndex = SendMessage(rtf.hwnd, EM_LINEINDEX, -1, 0&)
  lCol = lSelStart - lLineIndex
  
    With frmWordpad.StatusBar1.Panels
      .Item(2).text = "Row: " & Str(lLine + 1)    ' Row
      .Item(3).text = "Col: " & Str(lCol + 1)    ' Colomn
   End With
End Sub

Private Function IMDIDocument_InitDoc(cb As CuteControlsLibCtl.CuteBar, sFIle As String, bNew As Boolean) As Boolean
Dim bRet As Boolean
    If Not cb Is Nothing Then
        Set m_cb = cb
        bRet = True
    End If
    If bNew Then
        rtf.text = ""
    Else
        ' open file
        rtf.LoadFile sFIle
    End If
    rtf.DataChanged = False
    Caption = sFIle
    Me.Show
    
    IMDIDocument_InitDoc = bRet
End Function

Private Function FileSave(Optional sSaveAsName As String) As Boolean
    On Error GoTo ehFileSave 'set error trap
    
    If IsMissing(sSaveAsName) Or sSaveAsName = "" Then
        'if no save name specified
        If InStr(Me.Caption, "(untitled)") > 0 Then
            'if no previous name existed
            sSaveAsName = "rtfdoc.rtf"
            If Not frmWordpad.cdlg.VBGetSaveFileName(sSaveAsName, _
                "RichEdit Document", True, "Rich Text File(*.rtf)|*.rtf", , _
                App.Path, "Save As...", "RTF", Me.hwnd) Then
                FileSave = False
                Exit Function
            End If
        Else
            ' set SaveAsName to the name that
            ' the file was already given
            sSaveAsName = Me.Caption
        End If
    End If
    
    ' save file
    rtf.SaveFile CStr(sSaveAsName)
    
    ' change the caption to reflect name
    Me.Caption = CStr(sSaveAsName)
    
    ' set return value to true
    FileSave = True
    rtf.DataChanged = False
    Exit Function
ehFileSave:
    ' set return value to false
    FileSave = False
    Exit Function
End Function

Private Sub FileSaveAs()
Dim sSaveAsName As String

    On Error GoTo ehFileSaveAs 'set error trap
    
    sSaveAsName = "rtfdoc.rtf"
    If Not frmWordpad.cdlg.VBGetSaveFileName(sSaveAsName, _
        "RichEdit Document", True, "Rich Text File(*.rtf)|*.rtf", , _
        App.Path, "Save As...", "RTF", Me.hwnd) Then
        Exit Sub
    End If
    
    ' save file
    rtf.SaveFile CStr(sSaveAsName)
    
    ' change the caption to reflect name
    Me.Caption = CStr(sSaveAsName)
    
    ' set return value to true
    rtf.DataChanged = False
    
ehFileSaveAs:
    Exit Sub
End Sub

Private Sub FilePrint()
Dim flags As Long
Dim hdc As Long

    On Error GoTo ehFilePrint ' set error trap
    With frmWordpad.cdlg
        ' show printer dialog
        
        If .VBPrintDlg(hdc, IIf(rtf.SelLength = 0, eprAll, eprSelection)) = True Then
            ' print selection was selected
            If rtf.SelLength <> 0 Then
                rtf.SelPrint hdc
            Else
                ' print all was selected
                rtf.SelLength = 0
                rtf.SelPrint hdc
            End If
        End If
    End With
ehFilePrint: 'cancel pressed
    Exit Sub
End Sub

Private Sub EditRedo()
    SendMessage rtf.hwnd, EM_REDO, 0, 0
End Sub

Private Sub EditUndo()
Dim hr As Long
    hr = SendMessage(rtf.hwnd, EM_GETUNDONAME, 0&, 0&)
    ' Debug.Print hr, Choose(hr + 1, "Unknown", "Typing", "Delete", "Drag Drop", "Cut", "Paste")
    SendMessage rtf.hwnd, EM_UNDO, 0, 0
End Sub

Private Sub EditCut()
    SendMessage rtf.hwnd, WM_CUT, 0, 0
'    rtf.SetFocus
End Sub

Private Sub EditCopy()
    SendMessage rtf.hwnd, WM_COPY, 0, 0
End Sub

Private Sub EditPaste()
    SendMessage rtf.hwnd, WM_PASTE, 0, 0
End Sub

Private Sub EditClear()
    rtf.SelText = ""
End Sub

Private Sub EditSelectAll()
    rtf.SelStart = 0
    rtf.SelLength = Len(rtf.text)
End Sub

Private Sub EditFind(strSearch As String)
    frmFindForm.txtFind = strSearch 'set find text
    frmFindForm.Show
End Sub

Private Sub EditFindNext()
    frmFindForm.cboSearch.ListIndex = 2
    If frmFindForm.txtFind <> "" Then
        frmFindForm.cmdFindNext.Value = True
    End If
    frmFindForm.Show
End Sub

Private Sub EditReplace(strSearch As String)
    With frmFindForm
        .txtFind = strSearch 'set find text
        .txtReplace.Enabled = True 'enable replace
        .lblReplace.Enabled = True 'enable replace
        .Show vbModal 'show modally
    End With
End Sub

Private Sub InsertDate()
    rtf.SelText = Format(Now, "Long Date")
End Sub

Private Sub InsertTime()
    rtf.SelText = Format$(Now, "Hh:Nn:Ss")
End Sub

Private Sub InsertPicture()
' thanks to "Joachim Thiele" www.N-H-P.de
On Error Resume Next
Dim sFIle As String

    If frmWordpad.cdlg.VBGetOpenFileName(sFIle, "Picture File", True, False, False, True, "Picture Files(*.BMP;*.GIF;*.JPG)|*.BMP;*.GIF;*.JPG", , App.Path, "Insert Picture", , Me.hwnd) Then
        Clipboard.Clear
        DoEvents
        Clipboard.SetData LoadPicture(sFIle)
        If Clipboard.GetFormat(vbCFBitmap) = True Then ' Bitmap
            rtf.SetFocus
            EditPaste
        Else
            MsgBox "No Picture selected!"
        End If
    End If
    
End Sub

Private Sub FormatFont()
Dim fnt As New StdFont
Dim clr As Long

    On Error Resume Next
    With rtf
        fnt.Name = .SelFontName
        fnt.Strikethrough = .SelStrikeThru
        fnt.Bold = .SelBold
        fnt.Italic = .SelItalic
        fnt.Underline = .SelUnderline
        fnt.Size = .SelFontSize
        clr = .SelColor
        If frmWordpad.cdlg.VBChooseFont(fnt, , Me.hwnd, clr, 5, 72, CF_ScreenFonts Or CF_EFFECTS) Then
                .SelFontName = fnt.Name
                .SelBold = fnt.Bold
                .SelColor = clr
                .SelItalic = fnt.Italic
                .SelUnderline = fnt.Underline
                .SelFontSize = fnt.Size
                .SelStrikeThru = fnt.Strikethrough
        End If
    End With
    Set fnt = Nothing
End Sub

Private Sub FormatBold()
    With rtf
        If (IsNull(.SelBold) = True) Or (.SelBold = False) Then
            ' selection is bold or mixed, so set bold
            .SelBold = True
        ElseIf .SelBold = True Then
            'selection is bold, so toggle it
            .SelBold = False
        End If
        .SetFocus
    End With
End Sub

Private Sub FormatItalic()
    With rtf
        If (IsNull(.SelItalic) = True) Or (.SelItalic = False) Then
            ' selection is italic or mixed, so set italic
            .SelItalic = True
        ElseIf .SelItalic = True Then
            'selection is italic, so toggle it
            .SelItalic = False
        End If
'        .SetFocus
    End With
End Sub

Private Sub FormatUnderline()
    With rtf
        If (IsNull(.SelUnderline) = True) Or (.SelUnderline = False) Then
            ' selection is Underline or mixed, so set italic
            .SelUnderline = True
        ElseIf .SelUnderline = True Then
            'selection is Underline, so toggle it
            .SelUnderline = False
        End If
'        .SetFocus
    End With
End Sub


Private Sub FormatAlign(intIndex As Integer)
    Select Case intIndex
        Case 0 'left
            'set alignment
            rtf.SelAlignment = rtfLeft
        Case 1 'center
            'set alignment
            rtf.SelAlignment = rtfCenter
        Case 2 'right
            'set images
            'set alignment
            rtf.SelAlignment = rtfRight
    End Select
End Sub

Private Sub FormatBullets()
    With rtf
        If (IsNull(.SelBullet) = True) Or (.SelBullet = False) Then
            ' selection is mixed or not bulleted
            ' so set it.
            .SelBullet = True
        ElseIf .SelBullet = True Then
            ' selection is bold, toggle it
            .SelBullet = False
            .SelHangingIndent = False
        End If
    End With
End Sub

Private Sub rtf_SelChange()
   ' tmr.Enabled = False
   ' tmr.Enabled = True
   UpdateToolbar
End Sub

Private Sub tmr_Timer()
    UpdateToolbar
End Sub
