////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// PropBarDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "PropBarDlg.h"
#include "Bar.h"
#include "BarPropPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropBarDlg dialog


CPropBarDlg::CPropBarDlg(CWnd* pParent)
	: CDialog(CPropBarDlg::IDD, pParent)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	//{{AFX_DATA_INIT(CPropBarDlg)
	//}}AFX_DATA_INIT
    m_pBarProp = NULL;
    m_bLoaded = FALSE;

    Create(IDD_BARPROP_DLG, pParent);
}

CPropBarDlg::~CPropBarDlg()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    DestroyWindow();
}

void CPropBarDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropBarDlg)
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPropBarDlg, CDialog)
	//{{AFX_MSG_MAP(CPropBarDlg)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChange)
	ON_EN_CHANGE(IDC_EDIT_IWIDTH, OnChange)
	ON_EN_CHANGE(IDC_EDIT_IHEIGHT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChange)
	ON_EN_CHANGE(IDC_EDIT_BWIDTH, OnChange)
	ON_EN_CHANGE(IDC_EDIT_BHEIGHT, OnChange)
	ON_BN_CLICKED(IDC_RADIO_BAR_STYLE_3D, OnChange)
	ON_BN_CLICKED(IDC_RADIO_BAR_STYLE_FLAT, OnChange)
	ON_BN_CLICKED(IDC_RADIO_DCK_ANY, OnClickedRadio_dck_any)
	ON_BN_CLICKED(IDC_RADIO_DCK_BOTTOM, OnClickedRadio_dck_bottom)
	ON_BN_CLICKED(IDC_RADIO_DCK_LEFT, OnClickedRadio_dck_left)
	ON_BN_CLICKED(IDC_RADIO_DCK_LOCKED, OnClickedRadio_dck_lock)
	ON_BN_CLICKED(IDC_RADIO_DCK_RIGHT, OnClickedRadio_dck_right)
	ON_BN_CLICKED(IDC_RADIO_DCK_TOP, OnClickedRadio_dck_top)
	ON_BN_CLICKED(IDC_RADIO_DCKS_BOTTOM, OnChange)
	ON_BN_CLICKED(IDC_RADIO_DCKS_FLOAT, OnChange)
	ON_BN_CLICKED(IDC_RADIO_DCKS_LEFT, OnChange)
	ON_BN_CLICKED(IDC_RADIO_DCKS_RIGHT, OnChange)
	ON_BN_CLICKED(IDC_RADIO_DCKS_TOP, OnChange)
	ON_BN_CLICKED(IDC_RADIO_GRIPNONE, OnChange)
	ON_BN_CLICKED(IDC_RADIO_GRIPSINGLE, OnChange)
	ON_BN_CLICKED(IDC_CHECK_VISIBLE, OnChange)
	ON_BN_CLICKED(IDC_CHECK_COMBO_RO, OnChange)
	ON_BN_CLICKED(IDC_CHECK_BAR_USEILIST, OnChange)
	ON_BN_CLICKED(IDC_CHECK_BAR_HIDECONTROLS, OnChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropBarDlg message handlers

BOOL CPropBarDlg::OnInitDialog() 
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
    //Spin Controls
    CSpinButtonCtrl spinItem;
    spinItem.Attach(::GetDlgItem(m_hWnd,IDC_SPIN1));
    spinItem.SetRange(0,128);
    spinItem.Detach();
    spinItem.Attach(::GetDlgItem(m_hWnd,IDC_SPIN2));
    spinItem.SetRange(0,128);
    spinItem.Detach();
    spinItem.Attach(::GetDlgItem(m_hWnd,IDC_SPIN3));
    spinItem.SetRange(0,128);
    spinItem.Detach();
    spinItem.Attach(::GetDlgItem(m_hWnd,IDC_SPIN4));
    spinItem.SetRange(0,128);
    spinItem.Detach();

#ifdef FUTURE_RELEASE_20
    CComboBox ComboBox;
    ComboBox.Attach(GetDlgItem(IDC_COMBO_BAR_CURSORS));

    int i  = 0;
    ComboBox.InsertString(i,_T("ccDefault"));
    ComboBox.InsertString(i++,_T("ccArrow"));
    ComboBox.InsertString(i++,_T("ccCross"));
    ComboBox.InsertString(i++,_T("ccIBeam"));
    ComboBox.InsertString(i++,_T("ccIcon"));
    ComboBox.InsertString(i++,_T("ccSize"));
    ComboBox.InsertString(i++,_T("ccSizeNESW"));
    ComboBox.InsertString(i++,_T("ccSizeNS"));
    ComboBox.InsertString(i++,_T("ccSizeNWSE"));
    ComboBox.InsertString(i++,_T("ccSizeEW"));
    ComboBox.InsertString(i++,_T("ccUpArrow"));
    ComboBox.InsertString(i++,_T("ccHourglass"));
    ComboBox.InsertString(i++,_T("ccNoDrop"));
    ComboBox.InsertString(i++,_T("ccArrowHourglass"));
    ComboBox.InsertString(i++,_T("ccArrowQuestion"));
    ComboBox.InsertString(i++,_T("ccSizeAll"));
    ComboBox.Detach();

#endif

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropBarDlg::ReadProp(IBar* pIBar, BAR_PROPRETIES* pBarProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IBar> spBar = pIBar;

    CComBSTR Name;
    if(FAILED(spBar->get_Name(&Name)))
        return FALSE;
    pBarProp->Name = Name.Copy();

    long ID = -1;
    if(FAILED(spBar->get_ID(&ID)))
        return FALSE;
    pBarProp->Id = ID;

    VARIANT_BOOL bVisible = VARIANT_TRUE;
    if(FAILED(spBar->get_Visible(&bVisible)))
        return FALSE;
    pBarProp->Visible = bVisible ? TRUE: FALSE;
    
    enBarStyle BarStyle = ccFlatBar;
    if(FAILED(spBar->get_Style(&BarStyle)))
        return FALSE;             
     pBarProp->Style = BarStyle;

    enGripStyle Grip = ccGripSingle;
    if(FAILED(spBar->get_GripStyle(&Grip)))
        return FALSE;             
    pBarProp->Grip = Grip;

    VARIANT_BOOL bHide = VARIANT_TRUE;
    if(FAILED(spBar->get_HideControls(&bHide)))
        return FALSE;           
    pBarProp->HideCtrls = bHide ? TRUE:FALSE;

    VARIANT_BOOL bUse = VARIANT_FALSE;
    if(FAILED(spBar->get_UseImageList(&bUse)))
        return FALSE;           
    pBarProp->UseIList = bUse ? TRUE:FALSE;

    short height = 22;
    if(FAILED(spBar->get_ItemHeight(&height)))
        return FALSE; 
    pBarProp->ItemHeight = (int)height;

    short width = 20;
    if(FAILED(spBar->get_ItemWidth(&width)))
        return FALSE;      
    pBarProp->ItemWidth = (int)width;

    short iheight = 16;
    if(FAILED(spBar->get_ImageHeight(&iheight)))
        return FALSE;
    pBarProp->ImageHeight = (int) iheight;

    short iwidth = 15;
    if(FAILED(spBar->get_ImageWidth(&iwidth)))
        return FALSE;
    pBarProp->ImageWidth = (int) iwidth;

    long dStyle = 0;
    if(FAILED(spBar->get_DockingStyle(&dStyle)))
        return FALSE;
    pBarProp->DockStyle = dStyle;
    
    enDockState DockState;
    if(FAILED(spBar->get_DockState(&DockState)))
        return FALSE;
    pBarProp->DockState = DockState;

    return TRUE;
}

BOOL CPropBarDlg::SetProp(IBar* pIBar, BAR_PROPRETIES* pBarProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IBar> spBar = pIBar;

    CComBSTR Name = pBarProp->Name.AllocSysString();
    if(FAILED(spBar->put_Name(Name)))
        return FALSE;

    long ID = pBarProp->Id;
    if(FAILED(spBar->put_ID(ID)))
        return FALSE;

    VARIANT_BOOL bVisible = pBarProp->Visible ? VARIANT_TRUE:VARIANT_FALSE;
    if(FAILED(spBar->put_Visible(bVisible)))
        return FALSE;
    
    enBarStyle BarStyle = (enBarStyle) pBarProp->Style;
    if(FAILED(spBar->put_Style(BarStyle)))
        return FALSE;             

    enGripStyle Grip = (enGripStyle)pBarProp->Grip;
    if(FAILED(spBar->put_GripStyle(Grip)))
        return FALSE;             

    VARIANT_BOOL bHide = pBarProp->HideCtrls ? VARIANT_TRUE:VARIANT_FALSE ;
    if(FAILED(spBar->put_HideControls(bHide)))
        return FALSE;           

    VARIANT_BOOL bUse = pBarProp->UseIList ? VARIANT_TRUE:VARIANT_FALSE;
    if(FAILED(spBar->put_UseImageList(bUse)))
        return FALSE;           

    short height = (short) pBarProp->ItemHeight;
    if(FAILED(spBar->put_ItemHeight(height)))
        return FALSE; 

    short width = (short)pBarProp->ItemWidth;
    if(FAILED(spBar->put_ItemWidth(width)))
        return FALSE;      

    short iheight = (short) pBarProp->ImageHeight;
    if(FAILED(spBar->put_ImageHeight(iheight)))
        return FALSE;

    short iwidth = (short) pBarProp->ImageWidth;
    if(FAILED(spBar->put_ImageWidth(iwidth)))
        return FALSE;

    long dStyle = (long) pBarProp->DockStyle;
    if(FAILED(spBar->put_DockingStyle(dStyle)))
        return FALSE;
    
    enDockState DockState = (enDockState) pBarProp->DockState;
    if(FAILED(spBar->put_DockState(DockState)))
        return FALSE;

    pBarProp->bDirty = FALSE;
    return TRUE;
}


void CPropBarDlg::OnChange() 
{
   if (m_pBarProp && m_bLoaded)
   {
       m_pBarProp->bDirty = TRUE;
	   Update(m_pBarProp);
       ::PostMessage(::GetParent(m_hWnd),WM_MODIFIED, NULL, NULL);
   }
}

BOOL CPropBarDlg::ShowData(BAR_PROPRETIES* pBarProp)
{
    m_pBarProp = pBarProp;
    m_bLoaded = FALSE;  // Prop page SetDirty update protection
    SetDlgItemText(IDC_EDIT_NAME, pBarProp->Name);
    // Set ID
    SetDlgItemInt(IDC_EDIT_ID, pBarProp->Id);

    // Set Visible
    CheckDlgButton(IDC_CHECK_VISIBLE,           // Set the check box
                  pBarProp->Visible ? BST_CHECKED : BST_UNCHECKED);
    // Set Bar Style
    CheckDlgButton(IDC_RADIO_BAR_STYLE_FLAT,           // Set the check box
                  pBarProp->Style == ccFlatBar ? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_BAR_STYLE_3D,           // Set the check box
                  pBarProp->Style == cc3Dbar ? BST_CHECKED : BST_UNCHECKED);

    // Set Grip Type
    CheckDlgButton(IDC_RADIO_GRIPSINGLE,           // Set the check box
                  pBarProp->Grip == ccGripSingle ? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_GRIPNONE,           // Set the check box
                  pBarProp->Grip == ccGripNone ? BST_CHECKED : BST_UNCHECKED);

    // Set Hide Controls
    CheckDlgButton(IDC_CHECK_BAR_HIDECONTROLS,           // Set the check box
                  pBarProp->HideCtrls ? BST_CHECKED : BST_UNCHECKED);

    // Set Use ImageList
    CheckDlgButton(IDC_CHECK_BAR_USEILIST,           // Set the check box
                  pBarProp->UseIList ? BST_CHECKED : BST_UNCHECKED);

#ifdef ENABLE_BAR_CURSORS
    // Set bar mouse pointer type
    enMousePointer enMouse = ccDefault;
    pIBar->get_MousePointer(&enMouse);             
    CComboBox ComboBox;
    ComboBox.Attach(GetDlgItem(IDC_COMBO_BAR_CURSORS));
    int nSelect =(int)enMouse;
    ComboBox.SetCurSel(nSelect);    
    ComboBox.Detach();
#endif

    // Set Button Size
    SetDlgItemInt(IDC_EDIT_BHEIGHT, pBarProp->ItemHeight);
    SetDlgItemInt(IDC_EDIT_BWIDTH, pBarProp->ItemWidth);

    // Set Image Size
    SetDlgItemInt(IDC_EDIT_IHEIGHT, pBarProp->ImageHeight);
    SetDlgItemInt(IDC_EDIT_IWIDTH, pBarProp->ImageWidth);

    // Set Dock Style
    long dStyle = pBarProp->DockStyle;

    // Define docking style
    BOOL bDockL,bDockR,bDockB,bDockT,bDockA,bDockO;
    CheckDlgButton(IDC_RADIO_DCK_LEFT,           // Set the check box
                   bDockL = dStyle & ccDSLeft ? BST_CHECKED : BST_UNCHECKED);

    CheckDlgButton(IDC_RADIO_DCK_RIGHT,           // Set the check box
                   bDockR = dStyle & ccDSRight ? BST_CHECKED : BST_UNCHECKED);

    CheckDlgButton(IDC_RADIO_DCK_BOTTOM,           // Set the check box
                   bDockB = dStyle & ccDSBottom ? BST_CHECKED : BST_UNCHECKED);

    CheckDlgButton(IDC_RADIO_DCK_TOP,           // Set the check box
                   bDockT = dStyle & ccDSTop ? BST_CHECKED : BST_UNCHECKED);

    CheckDlgButton(IDC_RADIO_DCK_ANY,           // Set the check box
                   bDockA = dStyle & ccDSAny ? BST_CHECKED : BST_UNCHECKED);

    CheckDlgButton(IDC_RADIO_DCK_LOCKED,           // Set the check box
                   bDockO = dStyle & ccPositionLocked ? BST_CHECKED : BST_UNCHECKED);

    BOOL bDock = bDockL | bDockR | bDockB | bDockT | bDockA | bDockO ;

    // Clear all  the dock states boxes
    CheckDlgButton(IDC_RADIO_DCKS_TOP, BST_UNCHECKED );
    CheckDlgButton(IDC_RADIO_DCKS_LEFT, BST_UNCHECKED );
    CheckDlgButton(IDC_RADIO_DCKS_RIGHT, BST_UNCHECKED );
    CheckDlgButton(IDC_RADIO_DCKS_BOTTOM, BST_UNCHECKED );
    CheckDlgButton(IDC_RADIO_DCKS_FLOAT, BST_UNCHECKED );

    // Set Dock State properties
    int control = IDC_RADIO_DCKS_TOP;
    enDockState DockState = (enDockState)pBarProp->DockState;

	switch (DockState)
	{
	case ccDLeft:
        control = IDC_RADIO_DCKS_LEFT;
		break;
	case ccDTop:
        control = IDC_RADIO_DCKS_TOP;
		break;
	case ccDRight:
        control = IDC_RADIO_DCKS_RIGHT;
		break;
	case ccDBottom:
        control = IDC_RADIO_DCKS_BOTTOM;
		break;
	case ccDFloating:
            control = IDC_RADIO_DCKS_FLOAT;
		break;
    }
    CheckDlgButton(control, BST_CHECKED );           // Set the check box
    m_bLoaded = TRUE;

    return TRUE;
}

BOOL CPropBarDlg::Update(BAR_PROPRETIES *pBarProp)
{
   if (!pBarProp || !pBarProp->bDirty) return FALSE;

   TCHAR buffer[256];
   GetDlgItemText(IDC_EDIT_NAME,buffer,sizeof(buffer));
   pBarProp->Name = buffer; // CString copy

   int ID = GetDlgItemInt(IDC_EDIT_ID);
   pBarProp->Id = ID;

   BOOL bChk = IsDlgButtonChecked(IDC_CHECK_VISIBLE ) == BST_CHECKED;
   pBarProp->Visible = bChk;

   bChk = IsDlgButtonChecked(IDC_RADIO_BAR_STYLE_FLAT) == BST_CHECKED;
   enBarStyle Style = ccFlatBar;
   if (bChk == FALSE) Style = cc3Dbar;
   pBarProp->Style = Style;

   bChk = IsDlgButtonChecked(IDC_CHECK_BAR_HIDECONTROLS ) == BST_CHECKED;
   pBarProp->HideCtrls = bChk;

   bChk = IsDlgButtonChecked(IDC_CHECK_BAR_USEILIST ) == BST_CHECKED;
   pBarProp->UseIList = bChk;

   int bheight = GetDlgItemInt(IDC_EDIT_BHEIGHT);
   pBarProp->ItemHeight = bheight;

   int bwidth = GetDlgItemInt(IDC_EDIT_BWIDTH);
   pBarProp->ItemWidth= bwidth;

   int iheight = GetDlgItemInt(IDC_EDIT_IHEIGHT);
   pBarProp->ImageHeight = iheight;

   int iwidth = GetDlgItemInt(IDC_EDIT_IWIDTH);
   pBarProp->ImageWidth = iwidth;

   bChk = IsDlgButtonChecked(IDC_RADIO_GRIPSINGLE) == BST_CHECKED;
   pBarProp->Grip = bChk ? ccGripSingle : ccGripNone;

   int dStyle = 0;
   if (IsDlgButtonChecked(IDC_RADIO_DCK_LOCKED) == BST_CHECKED)
        dStyle |=ccPositionLocked;
   else if (IsDlgButtonChecked(IDC_RADIO_DCK_ANY) == BST_CHECKED)
        dStyle |= ccDSAny;
   else
    {
        if (IsDlgButtonChecked(IDC_RADIO_DCK_LEFT) == BST_CHECKED)
            dStyle |= ccDSLeft;
        if (IsDlgButtonChecked(IDC_RADIO_DCK_RIGHT) == BST_CHECKED)
            dStyle |= ccDSRight;
        if (IsDlgButtonChecked(IDC_RADIO_DCK_TOP) == BST_CHECKED)
            dStyle |= ccDSTop;
        if (IsDlgButtonChecked(IDC_RADIO_DCK_BOTTOM) == BST_CHECKED)
            dStyle |= ccDSBottom;
    }
    pBarProp->DockStyle = dStyle;

    // Set Dock State properties
    enDockState DockState = ccDTop;

    if (IsDlgButtonChecked(IDC_RADIO_DCKS_LEFT) == BST_CHECKED)
	    DockState = ccDLeft;
    if (IsDlgButtonChecked(IDC_RADIO_DCKS_TOP) == BST_CHECKED)
	    DockState = ccDTop;
    if (IsDlgButtonChecked(IDC_RADIO_DCKS_RIGHT) == BST_CHECKED)
	    DockState = ccDRight;
    if (IsDlgButtonChecked(IDC_RADIO_DCKS_BOTTOM) == BST_CHECKED)
	    DockState = ccDBottom;
    if (IsDlgButtonChecked(IDC_RADIO_DCKS_FLOAT) == BST_CHECKED)
	    DockState = ccDFloating;

    pBarProp->DockState = DockState;

    return TRUE;
}

void CPropBarDlg::OnClickedRadio_dck_any()
{
    CheckDlgButton(IDC_RADIO_DCK_LOCKED, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_LEFT, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_TOP, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_RIGHT, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_BOTTOM, BST_UNCHECKED);
    OnChange();
}

void CPropBarDlg::OnClickedRadio_dck_bottom()
{
    CheckDlgButton(IDC_RADIO_DCK_LOCKED, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_ANY, BST_UNCHECKED);
    OnChange();
}

void CPropBarDlg::OnClickedRadio_dck_left()
{
    CheckDlgButton(IDC_RADIO_DCK_LOCKED, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_ANY, BST_UNCHECKED);
    OnChange();
}

void CPropBarDlg::OnClickedRadio_dck_right()
{
    CheckDlgButton(IDC_RADIO_DCK_LOCKED, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_ANY, BST_UNCHECKED);
    OnChange();
}

void CPropBarDlg::OnClickedRadio_dck_top()
{
    CheckDlgButton(IDC_RADIO_DCK_LOCKED, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_ANY, BST_UNCHECKED);
    OnChange();
}

void CPropBarDlg::OnClickedRadio_dck_lock()
{
    CheckDlgButton(IDC_RADIO_DCK_LEFT, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_TOP, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_RIGHT, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_BOTTOM, BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_DCK_ANY, BST_UNCHECKED);
    OnChange();
}

/*
LRESULT CBarPropPage::OnSelchangeCombo_bar_cursors(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
    CComPtr<IBar> spBarActive;
    GetActiveBar(m_nBarActive,&spBarActive);
    if (spBarActive)
    {
        CComboBox ComboBox;
        ComboBox.Attach(GetDlgItem(IDC_COMBO_BAR_CURSORS));
        enMousePointer nSelect = ccDefault;
        nSelect = (enMousePointer)ComboBox.GetCurSel();
        ComboBox.Detach();
        spBarActive->put_MousePointer(nSelect);
        SetDirty(TRUE);
    }
	return 0;
}
*/
