////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// ItemCollection.cpp : Implementation of CIItemCollection
#include "stdafx.h"
#include "CuteControls.h"
#include "ItemCollection.h"
#include "BarButton.h"
#include "Combo.h"
#include "Edit.h"
#include "CuteBar.h"

template <>
HRESULT VCUE::GenericCopy<IItem*, VCUE::ContItmObj>::copy(destination_type* pTo, const source_type* pFrom)
{
    HRESULT hr = E_INVALIDARG;
    if (pFrom == NULL && *pFrom == NULL)
		return hr;

   return (*pFrom)->QueryInterface(IID_IDispatch,(void**)pTo);
};

template <>
HRESULT VCUE::GenericCopy<VARIANT, VCUE::ContItmObj>::copy(destination_type* pTo, const source_type* pFrom)
{
    CComVariant var;
    
    HRESULT hr = E_INVALIDARG;
    if (pFrom == NULL && *pFrom == NULL)
		return hr;

    var.vt = VT_UNKNOWN;
    hr = (*pFrom)->QueryInterface(IID_IUnknown,(void**)&var.punkVal);

    if (FAILED(hr))
    {
        var.vt = VT_DISPATCH;
        hr = (*pFrom)->QueryInterface(IID_IDispatch,(void**)&var.pdispVal);
    }

	return var.Detach(pTo);
};

/////////////////////////////////////////////////////////////////////////////
// CIItemCollection
CIItemCollection::CIItemCollection()
{
   m_pMainControl = NULL;
}

CIItemCollection::~CIItemCollection()
{
    RemoveAll();
}

STDMETHODIMP CIItemCollection::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IItemCollection
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

HRESULT CIItemCollection::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
//    HRESULT hr = IPersistStreamInitImpl<CIItemCollection>::
//                            IPersistStreamInit_Load( pStm, pMap);
    HRESULT hr = S_OK;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        if (!RestoreObjects(pStm))
            hr = E_FAIL;
    }
    catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }

    return hr;
}
HRESULT CIItemCollection::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap)
{
//    HRESULT hr = IPersistStreamInitImpl<CIItemCollection>::
//                            IPersistStreamInit_Save( pStm, fClearDirty, pMap);
    HRESULT hr = S_OK;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {        
        if (!SaveObjects(pStm,fClearDirty))
            hr = E_FAIL;
    }
    catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }
   return hr;
}


BOOL CIItemCollection::RestoreObjects(LPSTREAM pStm)
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    BOOL bRet = TRUE;

	int size = 0;
    pStm->Read(&size, sizeof(size),NULL);
    
    for ( int i =0 ; i < size ; i++)
	{
        ItemColl::ContObj pObj;
        CComPtr<IUnknown> pIItem;   

        HRESULT hr = CreateObject(&pObj,&pIItem);
        if (FAILED(hr))
        {
            bRet = FALSE;
            break;
        }
        pObj->AddRef(); // Prevent from deleting object after leaving function

        pObj->SetMainControl(m_pMainControl);

        CComPtr<IPersistStream> spPersistStm;
        if(FAILED( pObj->QueryInterface(IID_IPersistStream,(void**)&spPersistStm)))
        {
            bRet = FALSE;
            break;
        }

        if(FAILED(spPersistStm->Load(pStm)))
        {
            bRet = FALSE;
            break;
        }
   
        m_coll.push_back(pObj);
    }

    return bRet;
}

BOOL CIItemCollection::SaveObjects(LPSTREAM pStm,BOOL fClearDirty)
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    BOOL bRet = TRUE;

    ItemColl::ContainerType::iterator iter = m_coll.begin();
    
	int size = m_coll.size();
    pStm->Write(&size, sizeof(size),NULL);  // Save number of objects 

    while (iter != m_coll.end())    // iterate through container and save all objects
	{
        ItemColl::ContObj pItem = *iter;
        CComPtr<IPersistStream> spPersistStm;       
        if(FAILED(pItem->QueryInterface(IID_IPersistStream,(void**)&spPersistStm)))
        {
            bRet = FALSE;
            break;
        }

        if(FAILED(spPersistStm->Save(pStm, fClearDirty)))
        {
            bRet = FALSE;
            break;
        }
        iter++;
	}
   
    return bRet;
}

HRESULT CIItemCollection::CreateObject(ItemColl::ContObj* ppObj,IUnknown** ppIItem)
{
    *ppIItem = NULL;

    HRESULT hr = CComObject<CIItem>::CreateInstance(ppObj);
    if (FAILED(hr))
        return hr;

    return (*ppObj)->QueryInterface(ppIItem);
}

void CIItemCollection::RemoveAll()
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ItemColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        ItemColl::ContObj pItem = *iter;
        pItem->Release();
		iter++;
	}

    m_coll.clear();
}

STDMETHODIMP CIItemCollection::Add(long ID, enItemType Type, IItem **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ItemColl::ContObj pItem;
    BOOL bFound = FALSE;

    ItemColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        pItem = *iter;
        if ( pItem->m_ID == ((int)ID) && Type != ccTypeSeparator)
        {
            bFound = TRUE;
            break;
        }
		iter++;
	}

    if (bFound)
    {
	   return pItem->QueryInterface(IID_IDispatch,(void**)pVal);       
    }

    ItemColl::ContObj pObj;
    CComPtr<IUnknown> pIItem;

    HRESULT hr = CreateObject(&pObj,&pIItem);
    if (FAILED(hr))
        return E_FAIL;

    pObj->SetMainControl(m_pMainControl);
    pObj->m_ItemType = Type;
    pObj->m_ID = ID;
    m_coll.push_back(pObj);

    if (Type == ccTypeComboBox)
    {
        pObj->CreateComboObj();
    }
    else if (Type == ccTypeEdit)
    {
        pObj->CreateEditObj();
    }
    else if (Type == ccTypeSeparator)
    {
            ID = -1;
            pObj->m_strName.Format("Sep%d",m_coll.size()); // make uniq name for separator
    }

    pIItem.p->AddRef();


    return pIItem->QueryInterface(IID_IDispatch,(void**)pVal);
}

STDMETHODIMP CIItemCollection::Remove(VARIANT *Index)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (Index->vt == VT_EMPTY )
        return E_POINTER;

    HRESULT hr = E_FAIL;
    CComVariant var;
    var = *Index;
    if(var.vt == VT_BSTR)
    {
        // find item by Name
        CComBSTR bstr;
        bstr.AppendBSTR(var.bstrVal);
        CString Str = bstr;
        BOOL bFound = FALSE;
        int i = 0;  

        ItemColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end())
	    {
           ItemColl::ContObj pItem = *iter;
            if ( pItem->m_strName ==  Str) // CStrings compare
            {
                bFound = TRUE;
                break;
            }
		    iter++; i++;
	    }
        
        if ( bFound == FALSE)   //  not found
            return hr;

        var.vt = VT_I4;
        var.intVal = i+1;   // 1 based index
    }

    if (var.intVal == 0)
        return E_POINTER;

    if(var.vt == VT_I4 || var.vt == VT_I2)
    {
        long nIndex = var.iVal;
        if (var.vt == VT_I4)
            nIndex = var.intVal;

	    nIndex--;

        ItemColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end() && nIndex > 0)
	    {
		    iter++;
		    nIndex--;
	    }
	    if (iter != m_coll.end())
        {
            ItemColl::ContObj pItem = *iter;
            pItem->Release();
            m_coll.erase(iter);
            hr = S_OK;
        }
    }

	return hr;
}

STDMETHODIMP CIItemCollection::Clear()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    RemoveAll();
	return S_OK;
}

STDMETHODIMP CIItemCollection::Insert(VARIANT *ItemAfter, VARIANT *ItemMove)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    HRESULT hr = E_POINTER;
    if (ItemAfter->vt == VT_EMPTY || ItemAfter->intVal == 0)
        return hr;

    if (ItemMove->vt == VT_EMPTY || ItemMove->intVal == 0)
        return hr;

    int nIndexAfter = 0;
    int nIndexMove = 0;

    if (ItemAfter->vt == VT_BSTR)
    {
        // calc index from  IU address
        BOOL bFound = FALSE;
        CComBSTR bstrNameAfter(ItemAfter->bstrVal);

        ItemColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end())
	    {
            ItemColl::ContObj pItem = *iter;

            CComBSTR bstrName;
            hr = pItem->get_Name(&bstrName);
            if (FAILED(hr)) return hr;

            if (bstrName == bstrNameAfter)
            {
                bFound = TRUE;
                break;
            }
		    iter++;
            nIndexAfter++;
	    }

        if ( bFound == FALSE)   // Supplied IItem not found
            return E_FAIL;

        nIndexAfter++;
    }
    else if(ItemAfter->vt == VT_INT)
            nIndexAfter = ItemAfter->intVal;


    if (ItemMove->vt == VT_INT)
    {
        nIndexMove = ItemMove->intVal;
    }
    else if (ItemMove->vt == VT_BSTR)
    {
        BOOL bFound = FALSE;
        CComBSTR bstrNameMove (ItemMove->bstrVal);

        ItemColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end())
	    {
            ItemColl::ContObj pItem = *iter;
            CComBSTR bstrName;
            if (FAILED(pItem->get_Name(&bstrName))) return E_FAIL;

            if (bstrName == bstrNameMove)
            {
                bFound = TRUE;
                break;
            }
		    iter++;
            nIndexMove++;
	    }

        if ( bFound == FALSE)   // Supplied IItem not found
            return E_FAIL;

        nIndexMove++;
    }


    if (nIndexAfter && nIndexMove)
    {
	    nIndexMove--;
    
        ItemColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end() && nIndexMove > 0)
	    {
		    iter++;
		    nIndexMove--;
	    }
	    if (iter != m_coll.end())
        {
            ItemColl::ContObj pItemMove = *iter;

            CComPtr<IItem> spItem;
            CComVariant vAfter(nIndexAfter);
            if (FAILED(get_Item(&vAfter, &spItem))) return E_FAIL;

            CComBSTR bstrNameAfter;
            if (FAILED(spItem->get_Name(&bstrNameAfter))) return E_FAIL;

            m_coll.erase(iter);

            BOOL bFound = FALSE;
            ItemColl::ContainerType::iterator iter2 = m_coll.begin();
            while (iter2 != m_coll.end())
	        {
                ItemColl::ContObj pItem = *iter2;
                CComBSTR bstrName;
                hr = pItem->get_Name(&bstrName);
                if (FAILED(hr)) return hr;

                if (bstrName == bstrNameAfter)
                {
                    bFound = TRUE;
                    break;
                }
		        iter2++;
	        }
            if ( bFound == FALSE)   // Supplied IItem not found
                return E_FAIL;

		    iter2++;    // adjust as 'insert' always works before, but we need after
            if (iter2 != m_coll.end())
                m_coll.insert(iter2, pItemMove); // Always inserts before
            else
                m_coll.push_back(pItemMove); // if last just add new

            hr = S_OK;
        }
    }

	return hr;
}

STDMETHODIMP CIItemCollection::get_Item(VARIANT *Index, IItem **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (Index->vt == VT_EMPTY)
        return E_POINTER;

    HRESULT hr = E_FAIL;
    CComVariant var;
    var = *Index;
    if(var.vt == VT_BSTR)
    {
        // find item by Name
        CComBSTR bstr;
        bstr.AppendBSTR(var.bstrVal);
        CString Str = bstr;

        ItemColl::ContObj pItem;
        ItemColl::ContainerType::iterator iter = m_coll.begin();
		while (iter != m_coll.end())
		{
            pItem=*iter;
            if (pItem->m_strName == Str)
                break;            
			iter++;
		}
		if (iter != m_coll.end())
			hr = ItemColl::CollectionCopyType::copy(pVal, &*iter);

        return hr;
    }

    if(var.vt == VT_I4 || var.vt == VT_I2)
    {
        long index = var.iVal;
        if (var.vt == VT_I4)
            index = var.intVal;

		//Index is 1-based
		if (pVal == NULL)
			return E_POINTER;
		index--;
		ItemColl::ContainerType::iterator iter = m_coll.begin();
		while (iter != m_coll.end() && index > 0)
		{
			iter++;
			index--;
		}
		if (iter != m_coll.end())
			hr = ItemColl::CollectionCopyType::copy(pVal, &*iter);
    }

	return hr;
}

void CIItemCollection::SetMainControl(CICuteBar *pControl)
{
    m_pMainControl = pControl;
}
