#ifndef __GLOBAL_DATA_H
#define __GLOBAL_DATA_H

/////////////////////////////////////////////////////////////////////////////
// Auxiliary System/Screen metrics

struct GLOBAL_DATA
{
	// solid brushes with convenient gray colors and system colors
	HBRUSH hbrBtnHilite, hbrBtnShadow;

	// color values of system colors used for CToolBar
	COLORREF clrBtnFace, clrBtnShadow, clrBtnHilite;
	COLORREF clrBtnText, clrWindowFrame;
	COLORREF clrBtnDkShadow, clrBtnLight;
	COLORREF clrGrayedText;
	COLORREF clrHilite;
	COLORREF clrTextHilite;
	COLORREF clrMenu;
	COLORREF clrMenuText;

	HCURSOR	m_hcurStretch;
	HCURSOR	m_hcurStretchVert;

	// Toolbar and menu fonts:
	CFont	fontRegular;
	CFont	fontBold;
	CFont	fontVert;

	BOOL	bIsWindowsNT4;

// Implementation
	GLOBAL_DATA();
	~GLOBAL_DATA();

	void UpdateSysColors();
	BOOL SetMenuFont (LPLOGFONT lpLogFont, BOOL bHorz);

	int GetTextHeight (BOOL bHorz = TRUE)
	{
		return bHorz ? m_nTextHeightHorz : m_nTextHeightVert;
	}

protected:

	void UpdateTextMetrics ();
	
	int	m_nTextHeightHorz;
	int	m_nTextHeightVert;
};

extern GLOBAL_DATA globalData;

void AFXAPI AfxDeleteObject(HGDIOBJ* pObject);

/////////////////////////////////////////////////////////////////////////////

#endif // __GLOBAL_DATA_H
