////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// CuteBar.cpp : Implementation of CICuteBar

#include "stdafx.h"
#include "CuteBar.h"
#include "Bar.h"
#include "CToolBar.h"
//#include "CMenuBar.h"

/////////////////////////////////////////////////////////////////////////////
// CICuteBar

HRESULT CICuteBar::IOleObject_SetClientSite(IOleClientSite *pClientSite)
{
    HRESULT hr = CComControlBase::IOleObject_SetClientSite(pClientSite);

    if(GetRunningMode()== FALSE) // == user mode
    {
        if (hr == S_OK && pClientSite)
        {
            HWND hwndParent;
   	        RECT rcPos = {0,0,0,0};
		    HRESULT hr1 = m_spClientSite->QueryInterface(IID_IOleInPlaceSiteEx,
                                                        (void **)&m_pInPlaceSite);
	        if (hr1 == S_OK && m_pInPlaceSite->GetWindow(&hwndParent) == S_OK)
            {
                m_hParent = hwndParent;
                CreateControl( hwndParent, rcPos);

                RECT rcPos, rcClip;
                CComPtr<IOleInPlaceFrame> spInPlaceFrame;
            	CComPtr<IOleInPlaceUIWindow> spInPlaceUIWindow;
           	    OLEINPLACEFRAMEINFO frameInfo;
	            frameInfo.cb = sizeof(OLEINPLACEFRAMEINFO);

		        m_pInPlaceSite->GetWindowContext(&spInPlaceFrame,
			        &spInPlaceUIWindow, &rcPos, &rcClip, &frameInfo);
                m_bMDI = frameInfo.fMDIApp;
   				m_pInPlaceSite->OnInPlaceActivate();
                CComPtr<IOleInPlaceActiveObject> spActiveObject;
                ControlQueryInterface(IID_IOleInPlaceActiveObject, (void**)&spActiveObject);
// Reserved for menu proccesing
                if (spInPlaceFrame)
                {
                 HRESULT hr = spInPlaceFrame->SetActiveObject(spActiveObject, NULL);
//			    CComQIPtr<IOleControlSite, &IID_IOleControlSite> spSite(m_spClientSite);
//			    if (spSite != NULL)
//				    spSite->LockInPlaceActive(TRUE);
                }
//                if (spInPlaceUIWindow)
//                    spInPlaceUIWindow->SetActiveObject(spActiveObject, NULL);
// Force Container reread ACCEL table
//      			hr = m_pInPlaceSite->OnUIActivate();
//       			CComQIPtr<IOleControlSite, &IID_IOleControlSite> spSite(m_spClientSite);
//			    if ( spSite != NULL)
//				    spSite->OnControlInfoChanged();
            }
        }
        else
            DestroyAll();
    }
 return hr;
}
// IPersistStreamInit
HRESULT CICuteBar::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
    CComPtr<IPersistStream> spPersistStm;
    HRESULT hr = m_spBarCollection->QueryInterface(&spPersistStm);
    if(FAILED(hr))
        return hr;

    GetVersion(pStm);

    hr = spPersistStm->Load(pStm);
    if(FAILED(hr))
        return hr;

    hr = IPersistStreamInitImpl<CICuteBar>::IPersistStreamInit_Load( pStm, pMap);

//    if (m_bToolBarON == FALSE && !GetRunningMode()) // User Mode
//            m_bToolBarON = CreateControlBars(m_pWindow);
    return hr;
}
HRESULT CICuteBar::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap)
{
    CComPtr<IPersistStream> spPersistStm;
    HRESULT hr = m_spBarCollection->QueryInterface(&spPersistStm);
    if(FAILED(hr))
        return hr;

    hr = MarkVersion(pStm);
    if(FAILED(hr))
        return hr;

    hr =  spPersistStm->Save(pStm,fClearDirty);
    if(FAILED(hr))
        return hr;

    hr = IPersistStreamInitImpl<CICuteBar>::
                            IPersistStreamInit_Save( pStm, fClearDirty, pMap);
    return hr;
}

HRESULT CICuteBar::IPersistPropertyBag_Load(LPPROPERTYBAG pPropBag, LPERRORLOG pErrorLog, ATL_PROPMAP_ENTRY* pMap)
{ 
 CComVariant var(m_spBarCollection);  
 HRESULT hr = pPropBag->Read(CComBSTR("BarCollection"),&var,pErrorLog);

 hr = IPersistPropertyBagImpl<CICuteBar>::
                 IPersistPropertyBag_Load( pPropBag,  pErrorLog, pMap);

// if (m_bToolBarON == FALSE && !GetRunningMode())
//     m_bToolBarON = CreateControlBars(m_pWindow);
return hr;
}

HRESULT CICuteBar::IPersistPropertyBag_Save(LPPROPERTYBAG pPropBag, BOOL fClearDirty, BOOL fSaveAllProperties, ATL_PROPMAP_ENTRY* pMap)
{
 CComVariant var(m_spBarCollection);
 HRESULT hr = pPropBag->Write(CComBSTR("BarCollection"),&var);

 hr = IPersistPropertyBagImpl<CICuteBar>::
                   IPersistPropertyBag_Save(pPropBag, fClearDirty, fSaveAllProperties, pMap);
 return hr;
}

// IOleInPlaceObject
HRESULT CICuteBar::IOleInPlaceObject_SetObjectRects(LPCRECT prcPos,LPCRECT prcClip)
{
    RECT rc;
    CopyRect(&rc,prcPos);
    rc.right = rc.left + SC_ICONBMP_SIZE;
    rc.bottom = rc.top + SC_ICONBMP_SIZE;

    BOOL bSizeMatches;
    bSizeMatches = memcmp(&rc,prcPos, sizeof(RECT));
    ATLASSERT(m_spInPlaceSite);
    if (bSizeMatches)
    {
        m_spInPlaceSite->OnPosRectChange(&rc);
        return S_OK;
    }    
    return CComControlBase::IOleInPlaceObject_SetObjectRects(prcPos,prcClip);
}

BOOL CICuteBar::OnResizeBorder(CFrameWnd* pFrm, LPCRECT lpRectBorder)
{
    ASSERT_VALID(pFrm);
	ASSERT(lpRectBorder == NULL ||
		AfxIsValidAddress(lpRectBorder, sizeof(RECT), FALSE));
    
    if (m_pInPlaceSite == NULL)
        return FALSE;
    CBCBaseFrame* pFrame =  static_cast<CBCBaseFrame*>(pFrm);
	CComPtr<IOleInPlaceFrame> spInPlaceFrame;
	CComPtr<IOleInPlaceUIWindow> spInPlaceUIWindow;
	OLEINPLACEFRAMEINFO frameInfo;
	frameInfo.cb = sizeof(OLEINPLACEFRAMEINFO);
	RECT rcPos, rcClip;

	HWND hwndParent; 
	// This call to GetWindow is a fix for Delphi
	if (m_pInPlaceSite->GetWindow(&hwndParent) == S_OK)
	{
		HRESULT hr = m_pInPlaceSite->GetWindowContext(&spInPlaceFrame,
			&spInPlaceUIWindow, &rcPos, &rcClip, &frameInfo);
        if (FAILED(hr))
            return FALSE;
    }

	// use IOleInPlaceUIWindow::GetBorder if no border given
	CRect rectBorder;
    rectBorder.SetRectEmpty();
	if (lpRectBorder != NULL)
	{
		// use border space passed in
		rectBorder.CopyRect(lpRectBorder);
	}
	else
	{
		// GetBorderSpace may fail (WinWord6, for example)
		if (spInPlaceFrame->GetBorder(&rectBorder) != S_OK)
		{
			// in that case, always call SetBorderSpace(NULL), but
			// ignore the return value.
			spInPlaceFrame->SetBorderSpace(NULL);
            pFrame->GetClientRect(&rectBorder);
		}
	}

	// if this is the active document clear temphide bits from bars
	pFrame->ShowControlBars( TRUE);

	// see how much space we need by calling reposition bars
	CRect rectNeeded = rectBorder;
	pFrame->RepositionBars(0, 0xFFFF, 0, CWnd::reposQuery, &rectNeeded,
		&rectBorder);
    POINT ptPix1;
    POINT ptPix2;
    ptPix1.x = rectNeeded.left;
    ptPix1.y = rectNeeded.top;
    ptPix2.x = rectNeeded.right;
    ptPix2.y = rectNeeded.bottom;
    POINT ptTwips1;
    POINT ptTwips2;
    _PixelToTwips(ptPix1,&ptTwips1);
    _PixelToTwips(ptPix2,&ptTwips2);
    m_rcCliArea.SetRect(ptTwips1.x,ptTwips1.y,ptTwips2.x,ptTwips2.y);
    Fire_ClientAreaChanged();
   ATLTRACE("ClientRectNeeded) = %d,%d,%d,%d \n",
        rectNeeded.left,rectNeeded.top,rectNeeded.right,rectNeeded.bottom);
   ATLTRACE("ClientRectVBForm(Twips) = %d,%d,%d,%d \n",
        m_rcCliArea.left,m_rcCliArea.top,m_rcCliArea.right,m_rcCliArea.bottom);
    ATLTRACE("ClientRectBorder = %d,%d,%d,%d \n",
        rectBorder.left,rectBorder.top,rectBorder.right,rectBorder.bottom);
	// request the border space from the container
	CRect rectRequest(
		rectNeeded.left - rectBorder.left,
		rectNeeded.top - rectBorder.top,
		rectBorder.right - rectNeeded.right,
		rectBorder.bottom - rectNeeded.bottom);
	CRect rectTemp;
	rectTemp = rectRequest;

	// if no border space, just call SetBorderSpace
	if ((!rectRequest.IsRectNull() ||
		 !pFrame->m_listControlBars.IsEmpty()) &&
		spInPlaceFrame->RequestBorderSpace(&rectTemp) == S_OK)
	{
         m_bMDI = TRUE;
		// set the border space -- now this object owns it
		VERIFY(spInPlaceFrame->SetBorderSpace(&rectRequest) == S_OK);

		// move the bars into position after committing the space
		pFrame->RepositionBars(0, 0xFFFF, 0, CWnd::reposDefault, NULL,
			&rectBorder);

		// redraw all control bars
		POSITION pos = pFrame->m_listControlBars.GetHeadPosition();
		while (pos != NULL)
		{
			CControlBar* pBar =(CControlBar*)pFrame->m_listControlBars.GetNext(pos);
			ASSERT_VALID(pBar);
			if (!pBar->IsFloating())
				pBar->UpdateWindow();
		}
	}
	else
	{
        return FALSE;   //basically Frame is not MDI, then quit

		// hide any toolbars (since we couldn't get border space for any)
		pFrame->ShowControlBars( FALSE);

		// make sure border space is cleared
		CRect rect(0,0,0,0);
		spInPlaceFrame->SetBorderSpace(&rect);
	}
    return TRUE;
}

void CICuteBar::Serialize(CArchive &ar)
{
    if (ar.IsLoading())
	{
        CString strRegkey;
        CString strPrfNm;
        ar >> strRegkey;
        ar >> strPrfNm;

	    BOOL bEnable = AfxEnableMemoryTracking(FALSE);
	    free((void*)AfxGetApp()->m_pszRegistryKey);
	    AfxGetApp()->m_pszRegistryKey = _tcsdup(strRegkey);
	    free((void*)AfxGetApp()->m_pszProfileName);
	    AfxGetApp()->m_pszProfileName = _tcsdup(strPrfNm);
	    AfxEnableMemoryTracking(bEnable);
   }
   else
   {
        CString strRegkey(AfxGetApp()->m_pszRegistryKey);
        CString strPrfNm(AfxGetApp()->m_pszProfileName);
        ar << strRegkey;
        ar << strPrfNm;
   }
}

BOOL CICuteBar::CreateControlBars(CFrameWnd* pWnd)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ASSERT(pWnd);
    BOOL bRet = FALSE;

    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    bRet = pBarCol->ConstructBars();

    m_pWindow->DelayRecalcLayout();
    return bRet;
}

HRESULT CICuteBar::FinalConstruct()
{
    HRESULT hr = CComAggObject<CIBarCollection>::CreateInstance(GetUnknown(),&m_pBarCol);
//    HRESULT hr = CComObject<CIBarCollection>::CreateInstance(&m_pBarCol);
    if (FAILED(hr))
        return hr;
    hr = m_pBarCol->QueryInterface(&m_spBarCollection);
    m_pBarCol->m_contained.SetMainControl(this); // Set pointer to CuteBar instance
 
    // Save pointer to main control for _GetMainControl()
    _SetMainControl(this);  

    return hr;
}

void CICuteBar::FinalRelease()
{
    m_spBarCollection.Release();
}

STDMETHODIMP CICuteBar::get_LargeIcons(VARIANT_BOOL *pVal)
{
    *pVal = m_bLargeIcons;
	return S_OK;
}
STDMETHODIMP CICuteBar::GetControlInfo (LPCONTROLINFO  pCI )
{
	ATLTRACE(_T("CuteBars::GetControlInfo"));
    //-----------
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    if (pBarCol->GetControlInfo(pCI) == 0) return E_NOTIMPL; // nothing to do 

    return S_OK;
}

// IOleInPlaceActiveObjectImpl
BOOL CICuteBar::PreTranslateAccelerator(LPMSG pMsg, HRESULT& hRet)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ATLASSERT(m_pBarCol);
    hRet = S_FALSE;     // Assume no translation

    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    BOOL bRet = pBarCol->PreTranslateMessage(pMsg);

    if(bRet) hRet = S_OK;

    return bRet;
}

STDMETHODIMP CICuteBar::put_LargeIcons(VARIANT_BOOL newVal)
{
    m_bLargeIcons =newVal;
	return S_OK;
}

BOOL CICuteBar::DestroyToolBars()
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    ATLASSERT(m_pBarCol);

    BOOL bRet = TRUE;
    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    pBarCol->RemoveAll();
    m_bToolBarON = FALSE;

    return bRet;
}

STDMETHODIMP CICuteBar::Refresh()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    pBarCol->UpdateBars();
	return S_OK;
}

STDMETHODIMP CICuteBar::AboutBox()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	CAboutBox dlg(g_Version, g_Build);
	dlg.DoModal();
	return S_OK;
}

STDMETHODIMP CICuteBar::get_SaveState(VARIANT_BOOL *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = m_bSaveState ? VARIANT_TRUE:VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CICuteBar::put_SaveState(VARIANT_BOOL newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_bSaveState = newVal ? TRUE : FALSE;
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutBox
LRESULT CAboutBox::OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	EndDialog(wID);
	return 0;
}


STDMETHODIMP CICuteBar::get_RegistryCompanyKey(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR bstr(AfxGetApp()->m_pszRegistryKey);
    *pVal = bstr.Copy();

	return S_OK;
}

STDMETHODIMP CICuteBar::put_RegistryCompanyKey(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	USES_CONVERSION;

    LPCSTR lpszRegistryKey = OLE2CT(newVal);
    ASSERT(lpszRegistryKey != NULL);

	BOOL bEnable = AfxEnableMemoryTracking(FALSE);
	free((void*)AfxGetApp()->m_pszRegistryKey);
	AfxGetApp()->m_pszRegistryKey = _tcsdup(lpszRegistryKey);
	AfxEnableMemoryTracking(bEnable);
	return S_OK;
}

STDMETHODIMP CICuteBar::get_RegistryApplKey(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR bstr(AfxGetApp()->m_pszProfileName);
    *pVal = bstr.Copy();

	return S_OK;
}

STDMETHODIMP CICuteBar::put_RegistryApplKey(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	USES_CONVERSION;

    LPCSTR lpszRegistryKey = OLE2CT(newVal);

	ASSERT(lpszRegistryKey != NULL);

	BOOL bEnable = AfxEnableMemoryTracking(FALSE);
	free((void*)AfxGetApp()->m_pszProfileName);
	AfxGetApp()->m_pszProfileName = _tcsdup(lpszRegistryKey);
	AfxEnableMemoryTracking(bEnable);

	return S_OK;
}

STDMETHODIMP CICuteBar::Reset()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

     if (AfxGetApp()->m_pszRegistryKey)
     {
        CDockState DockState;
        DockState.Clear();
        DockState.SaveState(AfxGetApp()->m_pszRegistryKey);
     }
    Refresh();
	return S_OK;
}

STDMETHODIMP CICuteBar::get_ScaleTop(long *pVal)
{
    *pVal = m_rcCliArea.top;
	return S_OK;
}

STDMETHODIMP CICuteBar::get_ScaleLeft(long *pVal)
{
    *pVal = m_rcCliArea.left;
	return S_OK;
}

STDMETHODIMP CICuteBar::get_ScaleWidth(long *pVal)
{
    *pVal = m_rcCliArea.Width();
	return S_OK;
}

STDMETHODIMP CICuteBar::get_ScaleHeight(long *pVal)
{
    *pVal = m_rcCliArea.Height();
	return S_OK;
}

STDMETHODIMP CICuteBar::get_Bars(BarCollection **pVal)
{
    ASSERT(m_spBarCollection);
    return m_spBarCollection->QueryInterface(IID_IDispatch,(void**)pVal);
}


ULONG CICuteBar::InternalRelease()
{
    return CComObjectRootEx<CComSingleThreadModel>::InternalRelease();
}

void CICuteBar::UpdateImages(UINT id)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    ATLASSERT(m_pBarCol);

    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    pBarCol->UpdateImages(id);
}

HRESULT CICuteBar::MarkVersion(IStream *pStm)
{
    return pStm->Write(&g_Version, sizeof(g_Version),NULL);
}

HRESULT CICuteBar::GetVersion(IStream *pStm)
{
    HRESULT hr = pStm->Read(&g_VersionRead, sizeof(g_Version), NULL);
    if(SUCCEEDED(hr) && (g_VersionRead < 1.0 || g_VersionRead > 20.0 ))
    {
        hr = E_HANDLE;
        AfxThrowOleException(hr);
    }
    return hr;
}

void CICuteBar::GenHFile(HFILETYPE Type, CString &Buffer)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    ATLASSERT(m_pBarCol);

    CIBarCollection * pBarCol = &m_pBarCol->m_contained;
    pBarCol->GenHFile(Type,Buffer);
}

HWND CICuteBar::CreateControlWindow(HWND hWndParent, RECT &rcPos)
{
	HWND hWnd= CComControl<CICuteBar>::CreateControlWindow(hWndParent, rcPos);

     if (hWnd )
        CreateControl(hWndParent, rcPos);
     
     SetSize();

	return hWnd;
}

void CICuteBar::DestroyAll()
{
        if (m_pWindow)
        {
            if (m_pInPlaceSite)
            {
            	CComPtr<IOleInPlaceFrame> spInPlaceFrame;
	            CComPtr<IOleInPlaceUIWindow> spInPlaceUIWindow;
	            OLEINPLACEFRAMEINFO frameInfo;
	            frameInfo.cb = sizeof(OLEINPLACEFRAMEINFO);
	            RECT rcPos, rcClip;

	            HWND hwndParent; 
	            // This call to GetWindow is a fix for Delphi
	            if (m_pInPlaceSite->GetWindow(&hwndParent) == S_OK)
	            {
		            m_pInPlaceSite->GetWindowContext(&spInPlaceFrame,
			            &spInPlaceUIWindow, &rcPos, &rcClip, &frameInfo);
		            if (spInPlaceUIWindow)
			            spInPlaceUIWindow->SetActiveObject(NULL, NULL);
		            if (spInPlaceFrame)
			            spInPlaceFrame->SetActiveObject(NULL, NULL);
	            }
            }
    	    AFX_MANAGE_STATE(AfxGetStaticModuleState());
            if( !m_bDesignMode && m_bSaveState && AfxGetApp()->m_pszRegistryKey)
            {
                CDockState DockState;
                m_pWindow->GetDockState(DockState);
                DockState.SaveState(AfxGetApp()->m_pszRegistryKey);
            }

            m_pWindow->Unload();
            delete m_pWindow;
            m_pWindow = NULL;
        }
}

BOOL CICuteBar::CreateControl(HWND hWndParent, RECT &rcPos)
{
    if (m_pWindow == NULL)
    {
        AFX_MANAGE_STATE(AfxGetStaticModuleState());
	    m_pWindow=new CBCBaseFrame(this);
        CWnd* pTempCwnd=CWnd::FromHandle(hWndParent);
	    BOOL ret = m_pWindow->CBCBaseFrame::Create( 0, NULL, "AxControl",
		    WS_CHILD | WS_VISIBLE,  
		    rcPos, pTempCwnd, NULL);

	    if (m_pWindow == NULL && ret == NULL)       //
	    {			
		    DestroyWindow();	// Destr control window if fail
            return FALSE;
	    }
        // Init ClientArea with ClientRect on Main Frame
        CRect rect;
        ::GetClientRect(m_pWindow->m_hWnd, &rect);
        POINT ptPix1;
        POINT ptPix2;
        ptPix1.x = rect.left;
        ptPix1.y = rect.top;
        ptPix2.x = rect.right;
        ptPix2.y = rect.bottom;
        POINT ptTwips1;
        POINT ptTwips2;
        _PixelToTwips(ptPix1,&ptTwips1);
        _PixelToTwips(ptPix2,&ptTwips2);
        m_rcCliArea.SetRect(ptTwips1.x,ptTwips1.y,ptTwips2.x,ptTwips2.y);

    }
//    if (m_bToolBarON == FALSE)
//        m_bToolBarON = CreateControlBars(m_pWindow);

    return TRUE;
}

BOOL CICuteBar::GetRunningMode()    // if design mode ret == TRUE;
{
	CComVariant var;
	m_bDesignMode = FALSE;
    HRESULT hRes = GetAmbientProperty(DISPID_AMBIENT_USERMODE, var);
	if (SUCCEEDED(hRes) && var.vt == VT_BOOL && !var.boolVal)
	    m_bDesignMode = TRUE;
    return m_bDesignMode;
}

void CICuteBar::SetSize()
{
    m_bAutoSize = TRUE;

// Get running mode from Container
   	m_bDesignMode = FALSE;

    SIZEL size = {32,32};
    SIZEL szhim= {0,0};

	m_bDesignMode = GetRunningMode();
    if (m_bDesignMode)
        AtlPixelToHiMetric(&size,&szhim);

    m_sizeNatural=szhim;
    m_sizeExtent=szhim;

}

LRESULT CAboutBox::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
    char version[128];
    char build[64];
    sprintf(build, "Build %.6d",m_Build);
    sprintf(version,"Version %.2f %s",m_Version, build);
    SetDlgItemText(IDC_EDIT_VERSION, version);
	return 0;
}
