////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// ComboHook.cpp: implementation of the CComboHook class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cutecontrols.h"
#include "ComboHook.h"
#include "Combo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CComboHook::CComboHook()
{
    m_pCoreCombo = NULL;
    m_bHook = FALSE;
}

CComboHook::~CComboHook()
{
	HookWindow((HWND)NULL); // (unhook)
}

BOOL CComboHook::Install(CICombo *pCombo, HWND hWndToHook)
{
	ASSERT_VALID(pCombo);
	m_pCoreCombo = pCombo;
	m_bHook = HookWindow(hWndToHook);
    return m_bHook;
}

LRESULT CComboHook::WindowProc(UINT msg, WPARAM wp, LPARAM lp)
{
    if (m_bHook)
    {
    // Special Processing of KeyUp|Down|Press events for Combo Contol
        ASSERT(m_pCoreCombo);
       switch (msg)
        {
        case WM_SYSKEYDOWN:
        case WM_KEYDOWN:
            m_pCoreCombo->OnComboKeyDown(wp);
            break;
        case WM_CHAR:
            m_pCoreCombo->OnComboKeyPress(wp);
            break;
        case WM_SYSKEYUP:
        case WM_KEYUP:
            m_pCoreCombo->OnComboKeyUp(wp);
            break;
        }
    }
    return CSubclassWnd::WindowProc(msg, wp, lp);
}
