////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
#if !defined(AFX_CTOOLBAR_H__B702FD36_94CC_11D3_B680_000000000000__INCLUDED_)
#define AFX_CTOOLBAR_H__B702FD36_94CC_11D3_B680_000000000000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CToolBar.h : header file
//
#include "ToolBarImages.h"
#include "CuteControls.h"

class CIItem;
class CICuteBar;
static const int dwDefaultToolbarStyle = (WS_CHILD | CBRS_TOP | 
										  CBRS_GRIPPER | CBRS_HIDE_INPLACE);
enum iType {iNormal,iHot,iDisabled};
/////////////////////////////////////////////////////////////////////////////
// CBCToolBarBase window
class CBCBarButton;
struct DROPDOWNBUTTON {
	DROPDOWNBUTTON* next;
	UINT			idButton;		// command ID of button
	UINT			idMenu;			// popup menu to display
} ;

// for determining version of COMCTL32.DLL
#define VERSION_WIN4    MAKELONG(0, 4)
#define VERSION_IE3     MAKELONG(70, 4)
#define VERSION_IE4     MAKELONG(71, 4)
#define VERSION_IE401   MAKELONG(72, 4)

extern int _ComCtlVersion;
DWORD AFXAPI _GetComCtlVersion();

/////////////////////////////////////////////////////////////////////////////
// CToolBar idle update through CToolCmdUI class

class CCToolCmdUI : public CCmdUI        // class private to this file !
{
public: // re-implementations only
	virtual void Visible(BOOL bOn);
	virtual void Enable(BOOL bOn);
	virtual void SetCheck(int nCheck);
	virtual void SetText(LPCTSTR lpszText);
};

class CBCToolBarBase : public CToolBar
{
// One of these for each drop-down button
	DECLARE_SERIAL(CBCToolBarBase)
// Construction
public:
	CBCToolBarBase();
	virtual ~CBCToolBarBase();

// Attributes
public:
    CHCToolBarImages  m_Images;
    CHCToolBarImages  m_ImagesHot;
    CHCToolBarImages  m_ImagesDsbl;
    CList<TBBUTTON,TBBUTTON&> m_Buttons;
//    CStringArray
    CMapStringToPtr* m_pStringsMap;
// Operations
    void SetCtrlPos(CWnd *pCtrl, CRect &rect, UINT nIndex);

public:

    virtual BOOL OnButtonCommand(WPARAM wParam, LPARAM lParam){return FALSE;}
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBCToolBarBase)
    virtual	BOOL PreTranslateMessage(MSG* pMsg);
	virtual int OnToolHitTest(CPoint point, TOOLINFO* pTI) const;
//	virtual CSize CalcDynamicLayout(int nLength, DWORD nMode);
//	virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz);
	virtual void Serialize (CArchive& ar);
    protected:
	//}}AFX_VIRTUAL

	// override to do your own weird drop-down buttons
	virtual void OnDropDownButton(const NMTOOLBAR& nmtb, UINT nID, CRect rc);
	virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz);
	virtual CSize CalcDynamicLayout(int nLength, DWORD nMode);
	virtual BOOL TranslateMessage(MSG *pMsg);
	
	// implementation helpers
    virtual CSize GetButtonSize(TBBUTTON* pData, int nCount);

// Property helpers
	void SetButtonSize(int cx, int cy);
	void SetImageSize(int cx, int cy);
	void SetDockState(enDockState dstate);
	enDockState GetDockState();
	BOOL SetButtonState(long ID,enItemState state);
	enItemState GetButtonState(long ID);
    CSize GetButtonSize();

// Implementation
public:
	DROPDOWNBUTTON* FindDropDownButton(UINT nID);
	BOOL AddDropDownButton(UINT nIDButton, UINT nIDMenu, BOOL bArrow);
    virtual CIItem* FindItemByID(UINT ID);
	LPCSTR GetItemText(int nIndex);
	BOOL Create(CWnd* pParentWnd, DWORD dwCtrlStyle = TBSTYLE_FLAT,
		DWORD dwStyle = dwDefaultToolbarStyle,
		CRect rcBorders = CRect(1, 1, 1, 1),
		UINT nID = AFX_IDW_TOOLBAR);
	BOOL LoadToolBar();
	BOOL SetButtonSize(CSize& size);

	// Wrappers for some of the newer messages--not complete
	DWORD SetExtendedStyle(DWORD dwStyle);
	BOOL GetRect(UINT nIdButton, RECT& rc) const;
    void SetStyle(DWORD dwStyle);
    DWORD GetStyle() const;
    BOOL DeleteButton(int nIndex);

	// silly function to fake out compiler with const-ness
	LRESULT SendMessageC(UINT m, WPARAM wp=0, LPARAM lp=0) const;

public:
	void SetImageList(iType Type,HBITMAP hBmp, int nCount);
	void SetMainControl(CICuteBar* pControl);
	HCURSOR GetBarCursor(enMousePointer cursor);
	HBITMAP GetUpdatedBmp(IPictureDisp** pDisp);
	CWnd* InsertControl(CWnd* pCtrl, CRect & rect, UINT nID);
	CObject* InsertControl( CObject *pClass, LPCTSTR lpszWindowName, CRect& rect, UINT nID, DWORD dwStyle );
	UINT  m_DockStyle;
    UINT m_DockState;
    CMap<UINT, UINT&, UINT, UINT&>	m_AcellKeys;
	CString m_strName;

protected:
    BOOL m_bVisible;
    BOOL m_bHideControls;
    BOOL m_bUseImageList;
    DROPDOWNBUTTON*		m_pDropButtons;			// list of dropdown button/menu pairs
    BOOL m_bDirty;  // Flag for updating in CMDUpdate mode
    CICuteBar* m_pMainControl;

	// Generated message map functions
protected:
	void SetDsblImages(HBITMAP hBmp);
	void SetHotImages(HBITMAP hBmp);
	int UpdateImages(CBCBarButton* pBT);
	void FloatBar();
	void RemoveControls();

    virtual void EraseSep(CDC* pDC){}
	virtual BOOL AddControls();
    virtual void ControlsToButtons(TBBUTTON* pData){}
    virtual void PutButtons(TBBUTTON* pData){}
    virtual int ShrinkControls(TBBUTTON* pData, DWORD dwMode, int nCount){ return 0; }

	CObList* m_pControls;
    void GetButton(int nIndex, TBBUTTON* pButton) const;
	void SetButton(int nIndex, TBBUTTON* pButton);
	BOOL AddButtons(int nNumButtons, LPTBBUTTON pTB);
	BOOL LoadBitmap(HBITMAP hbmImageWell);
    // Toolbar Size Calculation
    CSize CalcLayout(DWORD nMode, int nLength = -1);
	CSize CalcSize(TBBUTTON* pData, int nCount);
//	int WrapToolBar(TBBUTTON* pData, int nCount, int nWidth);
	void SizeToolBar(TBBUTTON* pData, int nCount, int nLength, BOOL bVert = FALSE);
	int WrapToolBar(TBBUTTON* pData, int nCount, int nWidth);
//	void Layout(); // called for for delayed button layout
	void OnInitialUpdate();

	//{{AFX_MSG(CBCToolBarBase)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSysColorChange();
	//}}AFX_MSG
	afx_msg void OnToolBarBtnDropDown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnToolBarCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);
	DECLARE_MESSAGE_MAP()
};
inline BOOL CBCToolBarBase::DeleteButton(int nIndex)
	{ ASSERT(::IsWindow(m_hWnd)); return SendMessage(TB_DELETEBUTTON, nIndex); }

inline LRESULT CBCToolBarBase::SendMessageC(UINT m, WPARAM wp, LPARAM lp) const
	{ ASSERT(::IsWindow(m_hWnd)); return ((CBCToolBarBase*)this)->SendMessage(m, wp, lp); }

inline DWORD CBCToolBarBase::SetExtendedStyle(DWORD dwStyle)
	{ ASSERT(::IsWindow(m_hWnd)); return SendMessage(TB_SETEXTENDEDSTYLE, 0, dwStyle); }

inline BOOL CBCToolBarBase::GetRect(UINT nIdButton, RECT& rc) const
	{ ASSERT(::IsWindow(m_hWnd)); return SendMessageC(TB_GETRECT, nIdButton, (LPARAM)&rc); }

inline void CBCToolBarBase::SetStyle(DWORD dwStyle)
	{ ASSERT(::IsWindow(m_hWnd)); ::SendMessage(m_hWnd, TB_SETSTYLE, 0, dwStyle); }

inline DWORD CBCToolBarBase::GetStyle() const
	{ ASSERT(::IsWindow(m_hWnd)); return (DWORD) ::SendMessage(m_hWnd, TB_GETSTYLE, 0, 0L); }

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CTOOLBAR_H__B702FD36_94CC_11D3_B680_000000000000__INCLUDED_)
