////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// CToolBar.cpp : implementation file
//

#include "stdafx.h"
#include <afxpriv.h>
#include "resource.h"
#include "CToolBar.h"
#include "BarComboButton.h"
#include "Edit.h"
#include "CoreEdit.h"
#include "CoreCombo.h"
#include "Bar.h"
#include "CuteBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HBITMAP DDBTo256 (HBITMAP bitmap);
HBITMAP _SysColorBitmap(HBITMAP hBmp, BOOL bMono);

struct AFX_DLLVERSIONINFO
{
	DWORD cbSize;
	DWORD dwMajorVersion;                   // Major version
	DWORD dwMinorVersion;                   // Minor version
	DWORD dwBuildNumber;                    // Build number
	DWORD dwPlatformID;                     // DLLVER_PLATFORM_*
};

typedef HRESULT (CALLBACK* AFX_DLLGETVERSIONPROC)(AFX_DLLVERSIONINFO *);

int _ComCtlVersion = -1;

DWORD AFXAPI _GetComCtlVersion()
{
	// return cached version if already determined...
	if (_ComCtlVersion != -1)
		return _ComCtlVersion;
	
	// otherwise determine comctl32.dll version via DllGetVersion
	HINSTANCE hInst = ::GetModuleHandleA("COMCTL32.DLL");
	ASSERT(hInst != NULL);
	AFX_DLLGETVERSIONPROC pfn;
	pfn = (AFX_DLLGETVERSIONPROC)GetProcAddress(hInst, "DllGetVersion");
	DWORD dwVersion = VERSION_WIN4;
	if (pfn != NULL)
	{
		AFX_DLLVERSIONINFO dvi;
		memset(&dvi, 0, sizeof(dvi));
		dvi.cbSize = sizeof(dvi);
		HRESULT hr = (*pfn)(&dvi);
		if (SUCCEEDED(hr))
		{
			ASSERT(dvi.dwMajorVersion <= 0xFFFF);
			ASSERT(dvi.dwMinorVersion <= 0xFFFF);
			dwVersion = MAKELONG(dvi.dwMinorVersion, dvi.dwMajorVersion);
		}
	}
	_ComCtlVersion = dwVersion;
	return dwVersion;
}
int _DropDownWidth = -1;

int _GetDropDownWidth()
{
	// return cached version if already determined...
	if (_DropDownWidth != -1)
		return _DropDownWidth;

	// otherwise calculate it...
	HDC hDC = GetDC(NULL);
	ASSERT(hDC != NULL);
	HFONT hFont;
	if ((hFont = CreateFont(GetSystemMetrics(SM_CYMENUCHECK), 0, 0, 0,
		FW_NORMAL, 0, 0, 0, SYMBOL_CHARSET, 0, 0, 0, 0, _T("Marlett"))) != NULL)
		hFont = (HFONT)SelectObject(hDC, hFont);
	VERIFY(GetCharWidth(hDC, '6', '6', &_DropDownWidth));
	if (hFont != NULL)
	{
		SelectObject(hDC, hFont);
		DeleteObject(hFont);
	}
	ReleaseDC(NULL, hDC);
	ASSERT(_DropDownWidth != -1);
	return _DropDownWidth;
}
/////////////////////////////////////////////////////////////////////////////
// CBCToolBarBase
IMPLEMENT_SERIAL(CBCToolBarBase, CToolBar, VERSIONABLE_SCHEMA | 1)

CBCToolBarBase::CBCToolBarBase()
{
	m_strName =_T("New ToolBar");
    m_bVisible = TRUE;
    m_DockState = CBRS_TOP;
    m_pStringsMap = NULL;
    m_pControls = NULL;
    m_bHideControls = TRUE;
    m_bUseImageList = FALSE;
}

CBCToolBarBase::~CBCToolBarBase()
{
}

BEGIN_MESSAGE_MAP(CBCToolBarBase, CToolBar)
	//{{AFX_MSG_MAP(CBCToolBarBase)
	ON_WM_MOUSEMOVE()
	ON_NOTIFY_REFLECT(TBN_DROPDOWN,	 OnToolBarBtnDropDown)
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnToolBarCustomDraw)
	ON_WM_SYSCOLORCHANGE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBCToolBarBase message handlers

void CBCToolBarBase::Serialize(CArchive &ar)
{   
    CToolBar::Serialize(ar);

    if (ar.IsStoring())
	{
        ar << m_DockStyle;
        ar << m_DockState;
	    ar << m_strName;
        ar << m_bVisible;
        ar << m_sizeImage;
        ar << m_sizeButton;
        ar << m_bHideControls;
        ar << m_bUseImageList;
	}
	else
	{
       ar >> m_DockStyle;
       ar >> m_DockState;
       ar >> m_strName;
       ar >> m_bVisible;
       ar >> m_sizeImage;
       ar >> m_sizeButton;
       ar >> m_bHideControls;
       ar >> m_bUseImageList;
    }
}

BOOL CBCToolBarBase::LoadBitmap(HBITMAP hbmImageWell)
{
    ASSERT(hbmImageWell);

    BITMAP bitmap;

	VERIFY(::GetObject(hbmImageWell, sizeof(BITMAP), &bitmap));

	// add the bitmap to the common control toolbar
	BOOL bResult;
	if (m_hbmImageWell == NULL)
	{
		TBADDBITMAP addBitmap;
		addBitmap.hInst = NULL; // makes TBADDBITMAP::nID behave a HBITMAP
		addBitmap.nID = (UINT)hbmImageWell;
		bResult =  DefWindowProc(TB_ADDBITMAP,
			bitmap.bmWidth / m_sizeImage.cx, (LPARAM)&addBitmap) == 0;
    } 
	else
	{
		TBREPLACEBITMAP replaceBitmap;
		replaceBitmap.hInstOld = NULL;
		replaceBitmap.nIDOld = (UINT)m_hbmImageWell;
		replaceBitmap.hInstNew = NULL;
		replaceBitmap.nIDNew = (UINT)hbmImageWell;
		replaceBitmap.nButtons = bitmap.bmWidth / m_sizeImage.cx;
		bResult = (BOOL)DefWindowProc(TB_REPLACEBITMAP, 0,
			(LPARAM)&replaceBitmap);
	}
	// remove old bitmap, if present
	if (bResult)
	{
		AfxDeleteObject((HGDIOBJ*)&m_hbmImageWell);
		m_hbmImageWell = hbmImageWell;
	}

	return bResult;
}

BOOL CBCToolBarBase::AddButtons(int nNumButtons,LPTBBUTTON pTB)
{
    ASSERT(::IsWindow(m_hWnd));
    return SendMessage(TB_ADDBUTTONS, nNumButtons, (LPARAM)pTB);
}



BOOL CBCToolBarBase::SetButtonSize(CSize &size)
{
    ASSERT(::IsWindow(m_hWnd));
    return SendMessage(TB_SETBUTTONSIZE, 0, (LPARAM) MAKELONG(size.cx,size.cy));
}

BOOL CBCToolBarBase::LoadToolBar()
{
	ASSERT_VALID(this);

    POSITION pos = m_Buttons.GetHeadPosition();
    TBBUTTON pTB;
    UINT nCountButtons = m_Buttons.GetCount();
    if (nCountButtons == 0)
        return FALSE;

	UINT* pItems = new UINT[nCountButtons];
	for (int i = 0; i < nCountButtons; i++)
    {
        pTB = m_Buttons.GetNext(pos);
	    pItems[i] = pTB.idCommand;
    }
	BOOL bResult = SetButtons(pItems, nCountButtons);
	delete[] pItems;

	if (bResult)
    {
		// set new sizes of the buttons
//		CSize sizeImage(pData->wWidth, pData->wHeight);
//		CSize sizeButton(pData->wWidth + 7, pData->wHeight + 7);
	    SetSizes(m_sizeButton, m_sizeImage);

		// load bitmap now that sizes are known by the toolbar control
        pos = m_Buttons.GetHeadPosition();
        LPCSTR str;
        for (int i=0;i < nCountButtons;i++)
        {
           pTB = m_Buttons.GetNext(pos);
           SetButton(i, &pTB);
           str = GetItemText(i);
           if(str != NULL)
               SetButtonText(i,str);
        }

        HBITMAP bmp = m_Images.GetBitmap();
		if (bmp)
        {
            bResult = SetBitmap(DDBTo256(bmp));
//            SetImageList(iNormal, DDBTo256(bmp), m_Images.GetCount());
        }

        bmp = m_ImagesHot.GetBitmap();
		if (m_bUseImageList && bmp)
            SetImageList(iHot, DDBTo256(bmp), m_ImagesHot.GetCount());

        bmp = m_ImagesDsbl.GetBitmap();
		if (m_bUseImageList && bmp)
            SetImageList(iDisabled, DDBTo256(bmp), m_ImagesDsbl.GetCount());

        AddControls();
	}

	return bResult;
}

BOOL CBCToolBarBase::Create(CWnd* pParentWnd, DWORD dwCtrlStyle ,
		DWORD dwStyle,
		CRect rcBorders,
		UINT nID)
{
	ASSERT_VALID(pParentWnd);   // must have a parent
    m_bAutoDelete = FALSE;

    BOOL bGripper = (dwStyle & ~(CBRS_GRIPPER)) != 0;

	if (rcBorders.left < 1)
	{
		rcBorders.left = 1;	// Otherwise, I have a problem woith a "double" grippers
	}

	if (rcBorders.top < 1)
	{
		rcBorders.top = 1;	// Otherwise, I have a problem woith a "double" grippers
	}

	SetBorders (rcBorders);

	_GetComCtlVersion();
	_GetDropDownWidth();
	ASSERT(_DropDownWidth != -1);

//    dwCtrlStyle |=  TBSTYLE_TRANSPARENT;
//    dwCtrlStyle &= ~ TBSTYLE_FLAT;
//    dwStyle = WS_CHILD|WS_VISIBLE|CBRS_TOP|CBRS_TOOLTIPS;
//    dwCtrlStyle =0;
   	if (!CreateEx(pParentWnd, dwCtrlStyle, dwStyle,
        rcBorders,nID))
    {
       return FALSE;
    } 
	SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
    if (bGripper == FALSE)
        SetBarStyle(GetBarStyle() & ~(CBRS_GRIPPER));
		//| CBRS_BORDER_TOP | CBRS_BORDER_BOTTOM | CBRS_BORDER_LEFT | CBRS_BORDER_RIGHT));

    return TRUE;
}

void CBCToolBarBase::GetButton(int nIndex, TBBUTTON* pButton) const
{
	CBCToolBarBase* pBar = (CBCToolBarBase*)this;
	VERIFY(pBar->DefWindowProc(TB_GETBUTTON, nIndex, (LPARAM)pButton));
	// TBSTATE_ENABLED == TBBS_DISABLED so invert it
	pButton->fsState ^= TBSTATE_ENABLED;
}

void CBCToolBarBase::SetButton(int nIndex, TBBUTTON* pButton)
{
	// get original button state
	TBBUTTON button;
	VERIFY(DefWindowProc(TB_GETBUTTON, nIndex, (LPARAM)&button));

	// prepare for old/new button comparsion
	button.bReserved[0] = 0;
	button.bReserved[1] = 0;
	// TBSTATE_ENABLED == TBBS_DISABLED so invert it
	pButton->fsState ^= TBSTATE_ENABLED;
	pButton->bReserved[0] = 0;
	pButton->bReserved[1] = 0;

	// nothing to do if they are the same
	if (memcmp(pButton, &button, sizeof(TBBUTTON)) != 0)
	{
		// don't redraw everything while setting the button
		DWORD dwStyle = GetStyle();
		ModifyStyle(WS_VISIBLE, 0);
		VERIFY(DefWindowProc(TB_DELETEBUTTON, nIndex, 0));
		VERIFY(DefWindowProc(TB_INSERTBUTTON, nIndex, (LPARAM)pButton));
		ModifyStyle(0, dwStyle & WS_VISIBLE);

		// invalidate appropriate parts
		if (((pButton->fsStyle ^ button.fsStyle) & TBSTYLE_SEP) ||
			((pButton->fsStyle & TBSTYLE_SEP) && pButton->iBitmap != button.iBitmap))
		{
			// changing a separator
			Invalidate();
		}
		else
		{
			// invalidate just the button
			CRect rect;
			if (DefWindowProc(TB_GETITEMRECT, nIndex, (LPARAM)&rect))
				InvalidateRect(rect);
		}
	}
}

LPCSTR CBCToolBarBase::GetItemText(int nIndex)
{
	if (m_pStringsMap != NULL)
	{
		// look in map for matching iString
		POSITION pos = m_pStringsMap->GetStartPosition();
		CString str; void* p;
		while (pos)
		{
			m_pStringsMap->GetNextAssoc(pos, str, p);
			if ((int)p == nIndex)
			{
				return (LPCSTR) str;
			}
		}
	}
	return NULL;
}

int CBCToolBarBase::OnToolHitTest(CPoint point, TOOLINFO *pTI) const
{
	ASSERT_VALID(this);
	ASSERT(::IsWindow(m_hWnd));

	int nHit = -1; 

	// now hit test against CBCToolBarBase buttons
	CBCToolBarBase* pBar = (CBCToolBarBase*)this;
	int nButtons = (int)pBar->DefWindowProc(TB_BUTTONCOUNT, 0, 0);
	for (int i = 0; i < nButtons; i++)
	{
		CRect rect;
		TBBUTTON button;
		if (pBar->DefWindowProc(TB_GETITEMRECT, i, (LPARAM)&rect))
		{
			++rect.bottom;
			++rect.right;
			if (rect.PtInRect(point) &&
				pBar->DefWindowProc(TB_GETBUTTON, i, (LPARAM)&button) &&
				!(button.fsStyle & TBSTYLE_SEP))
			{
				int nHit = GetItemID(i);
				if (pTI != NULL && pTI->cbSize >= sizeof(AFX_OLDTOOLINFO))
				{
					pTI->hwnd = m_hWnd;
					pTI->rect = rect;
					pTI->uId = nHit;
                    CBCBarButton* pButton = pBar->FindItemByID(nHit);
                    if (pButton)
                    {
                        if (!pButton->m_strToolTip.IsEmpty())
                        {
                            			pTI->lpszText = (LPTSTR) 

                        pTI->lpszText = (LPTSTR)::calloc((pButton->m_strToolTip.GetLength()+1),
                                        sizeof (TCHAR));
			            _tcscpy(pTI->lpszText, pButton->m_strToolTip);
                        }
                    }
				}
				// found matching rect, return the ID of the button
				return nHit != 0 ? nHit : -1;
			}
		}
	}
	return -1;
}

CIItem* CBCToolBarBase::FindItemByID(UINT ID)
{
	return NULL;      // by default no implementation, inplemented in derived class
}

void CBCToolBarBase::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    MSG msg;
    msg.hwnd = m_hWnd;
    msg.lParam = MAKELPARAM(point.x,point.y);
    msg.message = WM_MOUSEMOVE;
    msg.wParam = nFlags;

    MSG MsgCopy;
    ::memcpy(&MsgCopy, GetCurrentMessage(), sizeof(MSG));
	FilterToolTipMessage(&MsgCopy);

	CToolBar::OnMouseMove(nFlags, point);
}

void CCToolCmdUI::Visible(BOOL bOn)
{
	CToolBar* pToolBar = (CToolBar*)m_pOther;
	ASSERT(pToolBar != NULL);
	ASSERT_KINDOF(CToolBar, pToolBar);
	ASSERT(m_nIndex < m_nIndexMax);

	UINT  nNewStyle = pToolBar->GetButtonStyle(m_nIndex); 
	nNewStyle &= ~TBBS_HIDDEN;
	if (!bOn)
	{
		nNewStyle |= TBBS_HIDDEN;
	    ASSERT(!(nNewStyle & TBBS_SEPARATOR));
	    pToolBar->SetButtonStyle(m_nIndex, nNewStyle);
	}
	pToolBar->SetButtonStyle(m_nIndex, nNewStyle);
}
void CCToolCmdUI::Enable(BOOL bOn)
{
	m_bEnableChanged = TRUE;
	CToolBar* pToolBar = (CToolBar*)m_pOther;
	ASSERT(pToolBar != NULL);
	ASSERT_KINDOF(CToolBar, pToolBar);
	ASSERT(m_nIndex < m_nIndexMax);

	UINT nNewStyle = pToolBar->GetButtonStyle(m_nIndex) & ~TBBS_DISABLED;
    if (nNewStyle & TBBS_HIDDEN)
        return;
	if (!bOn)
	{
		nNewStyle |= TBBS_DISABLED;
		// WINBUG: If a button is currently pressed and then is disabled
		// COMCTL32.DLL does not unpress the button, even after the mouse
		// button goes up!  We work around this bug by forcing TBBS_PRESSED
		// off when a button is disabled.
		nNewStyle &= ~TBBS_PRESSED;
	}
	ASSERT(!(nNewStyle & TBBS_SEPARATOR));
	pToolBar->SetButtonStyle(m_nIndex, nNewStyle);
}

void CCToolCmdUI::SetCheck(int nCheck)
{
	ASSERT(nCheck >= 0 && nCheck <= 2); // 0=>off, 1=>on, 2=>indeterminate
	CToolBar* pToolBar = (CToolBar*)m_pOther;
	ASSERT(pToolBar != NULL);
	ASSERT_KINDOF(CToolBar, pToolBar);
	ASSERT(m_nIndex < m_nIndexMax);

	UINT nNewStyle = pToolBar->GetButtonStyle(m_nIndex) &
				~(TBBS_CHECKED | TBBS_INDETERMINATE);
	if (nCheck == 1)
		nNewStyle |= TBBS_CHECKED;
	else if (nCheck == 2)
		nNewStyle |= TBBS_INDETERMINATE;
	ASSERT(!(nNewStyle & TBBS_SEPARATOR));
	pToolBar->SetButtonStyle(m_nIndex, nNewStyle | TBBS_CHECKBOX);
}

void CCToolCmdUI::SetText(LPCTSTR)
{
	// ignore it
}

BOOL CBCToolBarBase::PreTranslateMessage(MSG *pMsg)
{
   	if (m_bVisible &&
		pMsg->message == WM_KEYDOWN)
	{ 
		if(pMsg->wParam == VK_ESCAPE)
        {
		    CToolBar::OnCancelMode();
 		    return TRUE;
        }
       else if (TranslateMessage(pMsg))
		        return TRUE;
	}

	return NULL;    //CToolBar::PreTranslateMessage(pMsg);
}

//////////////////
// 1997 Microsoft Systems Journal - Written by Paul DiLascia.
// call to add drop-down menus to toolbar buttons.
//
BOOL CBCToolBarBase::AddDropDownButton(UINT nIDButton, UINT nIDMenu, BOOL bArrow)
{
	ASSERT_VALID(this);
	
	DROPDOWNBUTTON* pb = FindDropDownButton(nIDButton);
	if (!pb) {
		pb = new DROPDOWNBUTTON;
		ASSERT(pb);
		pb->next = m_pDropButtons;
		m_pDropButtons = pb;
	}
	pb->idButton = nIDButton;
	pb->idMenu   = nIDMenu;
	
	int iButton = CommandToIndex(nIDButton);
	
	DWORD dwStyle = GetButtonStyle(iButton);
	dwStyle |= TBSTYLE_DROPDOWN;
	SetButtonStyle(iButton, dwStyle);
	
	if (bArrow)
		SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	
	return TRUE;

}

void CBCToolBarBase::OnToolBarCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
    // Clean up Separators under Controls
    LPNMTBCUSTOMDRAW  lplvcd = (LPNMTBCUSTOMDRAW)pNMHDR;
    if(lplvcd->nmcd.dwDrawStage == CDDS_PREPAINT)
    {
       * pResult  =  CDRF_NOTIFYPOSTPAINT | CDRF_NOTIFYITEMDRAW ; 
    }
    else if(lplvcd->nmcd.dwDrawStage == CDDS_ITEMPREPAINT )
    {
        lplvcd->clrHighlightHotTrack = ::GetSysColor(COLOR_3DFACE); //COLOR_ACTIVECAPTION
       * pResult  =  TBCDRF_HILITEHOTTRACK  ; 
    }
    else if(lplvcd->nmcd.dwDrawStage == CDDS_POSTPAINT )
    {
        CDC pDC;
        pDC.Attach(lplvcd->nmcd.hdc);
        EraseSep(&pDC);
        pDC.Detach();
    }
}

DROPDOWNBUTTON* CBCToolBarBase::FindDropDownButton(UINT nID)
{
	for (DROPDOWNBUTTON* pb = m_pDropButtons; pb; pb = pb->next) {
		if (pb->idButton == nID)
			return pb;
	}
	return NULL;
}

//////////////////
// 1997 Microsoft Systems Journal - Written by Paul DiLascia.
// Message handler for TBN_DROPDOWN. Default is to display the 
// specified menu at the right place. You can override to generate dynamic menus
//
// Args:
//		- NMTOOLBAR struct from TBN_DROPDOWN
//		- command id of button
//		- point to display menu at
//
void CBCToolBarBase::OnToolBarBtnDropDown(NMHDR* pNMHDR, LRESULT* pRes)
{
	UNUSED_ALWAYS( pRes );
	
	const NMTOOLBAR& nmtb = *(NMTOOLBAR*)pNMHDR;
	
	// get location of button
	CRect rc;
	GetRect(nmtb.iItem, rc);
	ClientToScreen(&rc);
	
	// call virtual function to display dropdown menu
	OnDropDownButton(nmtb, nmtb.iItem, rc);
}

/////////////////
// 1997 Microsoft Systems Journal - Written by Paul DiLascia.
// Virtual fn you can override to hand drop-down button
// events with more friendly args
//
void CBCToolBarBase::OnDropDownButton(const NMTOOLBAR& nmtb, UINT nID, CRect rc)
{
	UNUSED_ALWAYS( nID );
#ifdef SDS	
	DROPDOWNBUTTON* pb = FindDropDownButton(nmtb.iItem);
	if (pb && pb->idMenu) {
	
		// load and display popup menu
		CMenu menu;
		VERIFY(menu.LoadMenu(pb->idMenu));
		CMenu* pPopup = (CMenu*)menu.GetSubMenu(0);
		ASSERT(pPopup);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_VERTICAL,
			rc.left, rc.bottom, GetParentFrame(), &rc);

	}
#endif
}

CObject* CBCToolBarBase::InsertControl(CObject *pClass, LPCTSTR lpszWindowName, CRect &rect, UINT nID, DWORD dwStyle)
{
	CWnd *pCtrl = NULL;
    CIItem* Cntrl=  ( CIItem*)pClass;
    if( Cntrl->m_ItemType == ccTypeComboBox)	// CComboBox control.
	{
		CICombo* pctrl = Cntrl->m_pComboObj;

		if(pctrl->Create( WS_CHILD|WS_VISIBLE|dwStyle, rect, this, nID ) == FALSE )
			return NULL;
        pCtrl = pctrl->GetControl();
	}
    else if( Cntrl->m_ItemType == ccTypeEdit)	// CEdit control.
	{
		CICEdit* pctrl = Cntrl->m_pEditObj;  

        switch (Cntrl->m_Algn)
        {
        case ccALeft:
            dwStyle |= ES_LEFT ;
            break;
        case ccACenter:
            dwStyle |= ES_CENTER;
            break;
        case ccARight:
            dwStyle |= ES_RIGHT;
            break;
        }

		if(pctrl->Create( WS_CHILD|WS_VISIBLE|dwStyle, rect, this, nID ) == FALSE )
			return NULL;
        pCtrl = pctrl->GetControl();
	}
    else if( Cntrl->m_ItemType == ccTypeLabel)	// Label (CStatic) control.
	{
		pCtrl = (CWnd*)&Cntrl->m_Label;
		ASSERT_VALID( pCtrl );

        BOOL bBmp = Cntrl->m_spImage != NULL;
        if (bBmp)
                dwStyle |= SS_BITMAP;

        switch (Cntrl->m_Algn)
        {
        case ccALeft:
            dwStyle |=bBmp ? 0 :SS_LEFT;
            break;
        case ccACenter:
            dwStyle |= bBmp ? SS_CENTERIMAGE : SS_CENTER;
            break;
        case ccARight:
            dwStyle |=bBmp ? SS_RIGHTJUST : SS_RIGHT;
            break;
        }

        if(Cntrl->m_Label.Create(Cntrl->m_strName,
            WS_CHILD|WS_VISIBLE|dwStyle, rect, this, nID ) == FALSE )
		{  
			return NULL;
		}
    }
	else	// An invalid object was passed in
	{
		ASSERT( FALSE );
		return NULL;
	}

	// if our object list has not been allocated, do it now...
	if( m_pControls == NULL )
	{
		m_pControls = new CObList();
		ASSERT( m_pControls );
	}

	// we have to remember this control, so we can delete it later
	m_pControls->AddTail( pCtrl );

	return InsertControl( pCtrl, rect, nID );

}

CWnd* CBCToolBarBase::InsertControl(CWnd *pCtrl, CRect &rect, UINT nID)
{
	ASSERT( pCtrl );

	// make sure the id is valid, and set the button 
	// style for a seperator.
	ASSERT( CommandToIndex( nID ) >= 0 );
    UINT nIndex = CommandToIndex( nID );
	SetButtonInfo( nIndex, nID, TBBS_SEPARATOR, rect.right); // width == from 0 to right, not rect.Width()

	// insert the control into the toolbar.
    SetCtrlPos(pCtrl, rect, nIndex);

	return pCtrl;
}

void CBCToolBarBase::SetCtrlPos(CWnd *pCtrl, CRect &rect, UINT nIndex)
{
    ASSERT(pCtrl);
	// insert the control into the toolbar.
    CRect rc;
	GetItemRect( nIndex, &rc );
	pCtrl->SetWindowPos(0, rc.left+ rect.left, rect.top, 0, 0,
		SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOCOPYBITS );
	pCtrl->SetFont( GetFont( ));
	pCtrl->ShowWindow( SW_SHOW );

}

BOOL CBCToolBarBase::AddControls()
{
    return FALSE; // implementation in derived class
}
//////////////////
// 1997 Microsoft Systems Journal - Written by Paul DiLascia.
// This is the all-important function that gets the true size of a button,
// instead of using m_sizeButton. And it's virtual, so you can override if
// my algorithm doesn't work, as will surely be the case in some circumstances.
//
// !!! not as in original 
// !!! significally modified to adopt for ActiveX contol by Dmitri Sviridov

CSize CBCToolBarBase::GetButtonSize(TBBUTTON* pData, int nCount)
{
//	ASSERT(_ComCtlVersion > 0);

	// Get the actual size of the button, not what's in m_sizeButton.
	// Make sure to do SendMessage instead of calling MFC's GetItemRect,
	// which has all sorts of bad side-effects! (Go ahead, take a look at it.)
	// 
    CSize sizeResult = m_sizeButton;
    for (int i = 0; i < nCount; i++)
    {
        if ((pData[i].fsStyle != TBSTYLE_BUTTON) ||
            (pData[i].fsState & TBSTATE_HIDDEN))
                continue;
	    CRect rc;
	    SendMessage(TB_GETITEMRECT, i, (LPARAM)&rc);	    
        CSize size  = rc.Size();
        sizeResult.cx = size.cx;    //max(size.cx, sizeResult.cx);
        sizeResult.cy = size.cy;    //max(size.cy, sizeResult.cy);
    }
	return sizeResult;
}

#define CX_OVERLAP  0

CSize CBCToolBarBase::CalcSize(TBBUTTON* pData, int nCount)
{
	ASSERT(pData != NULL && nCount > 0);

	CPoint cur(0,0);
    //SDS - BUG: Lets the Bar size be at least a button size
    m_sizeButton = GetButtonSize(pData, nCount);
	CSize sizeResult = m_sizeButton;

	DWORD dwExtendedStyle = DefWindowProc(TB_GETEXTENDEDSTYLE, 0, 0);

	for (int i = 0; i < nCount; i++)
	{
		//WINBUG: The IE4 version of COMCTL32.DLL calculates the separation
		//  on a TBSTYLE_WRAP button as 100% of the value in iBitmap compared
		//  to the other versions which calculate it at 2/3 of that value.
		//  This is actually a bug which should be fixed in IE 4.01, so we
		//  only do the 100% calculation specifically for IE4.
		int cySep = pData[i].iBitmap;
		ASSERT(_ComCtlVersion != -1);
		if (!(GetStyle() & TBSTYLE_FLAT) && _ComCtlVersion != VERSION_IE4)
			cySep = cySep * 2 / 3;

		if (pData[i].fsState & TBSTATE_HIDDEN)
			continue;

		int cx = m_sizeButton.cx;
		if (pData[i].fsStyle & TBSTYLE_SEP)
		{
			// a separator represents either a height or width
			if (pData[i].fsState & TBSTATE_WRAP)
				sizeResult.cy = max(cur.y + m_sizeButton.cy + cySep, sizeResult.cy);
			else
				sizeResult.cx = max(cur.x + pData[i].iBitmap, sizeResult.cx);
		}
		else
		{
			// check for dropdown style, but only if the buttons are being drawn
			if ((pData[i].fsStyle & TBSTYLE_DROPDOWN) &&
				(dwExtendedStyle & TBSTYLE_EX_DRAWDDARROWS))
			{
				// add size of drop down
				ASSERT(_DropDownWidth != -1);
				cx += _DropDownWidth;
			}
			sizeResult.cx = max(cur.x + cx, sizeResult.cx);
			sizeResult.cy = max(cur.y + m_sizeButton.cy, sizeResult.cy);
		}

		if (pData[i].fsStyle & TBSTYLE_SEP)
			cur.x += pData[i].iBitmap;
		else
			cur.x += cx - CX_OVERLAP;

		if (pData[i].fsState & TBSTATE_WRAP)
		{
			cur.x = 0;
			cur.y += m_sizeButton.cy;
			if (pData[i].fsStyle & TBSTYLE_SEP)
				cur.y += cySep;
		}
	}
	return sizeResult;
}
void  CBCToolBarBase::SizeToolBar(TBBUTTON* pData, int nCount, int nLength, BOOL bVert)
{
	ASSERT(pData != NULL && nCount > 0);

	if (!bVert)
	{
		int nMin, nMax, nTarget, nCurrent, nMid;

		// Wrap ToolBar as specified
		nMax = nLength;
		nTarget = WrapToolBar(pData, nCount, nMax);

		// Wrap ToolBar vertically
		nMin = 0;
		nCurrent = WrapToolBar(pData, nCount, nMin);

		if (nCurrent != nTarget)
		{
			while (nMin < nMax)
			{
				nMid = (nMin + nMax) / 2;
				nCurrent = WrapToolBar(pData, nCount, nMid);

				if (nCurrent == nTarget)
					nMax = nMid;
				else
				{
					if (nMin == nMid)
					{
						WrapToolBar(pData, nCount, nMax);
						break;
					}
					nMin = nMid;
				}
			}
		}
		CSize size = CalcSize(pData, nCount);
		WrapToolBar(pData, nCount, size.cx);
	}
	else
	{
		CSize sizeMax, sizeMin, sizeMid;

		// Wrap ToolBar vertically
		WrapToolBar(pData, nCount, 0);
		sizeMin = CalcSize(pData, nCount);

		// Wrap ToolBar horizontally
		WrapToolBar(pData, nCount, 32767);
		sizeMax = CalcSize(pData, nCount);

		while (sizeMin.cx < sizeMax.cx)
		{
			sizeMid.cx = (sizeMin.cx + sizeMax.cx) / 2;
			WrapToolBar(pData, nCount, sizeMid.cx);
			sizeMid = CalcSize(pData, nCount);

			if (nLength < sizeMid.cy)
			{
				if (sizeMin == sizeMid)
				{
					WrapToolBar(pData, nCount, sizeMax.cx);
					return;
				}
				sizeMin = sizeMid;
			}
			else if (nLength > sizeMid.cy)
				sizeMax = sizeMid;
			else
				return;
		}
	}
}

struct _CC_CONTROLPOS
{
	int nIndex, nID;
	CRect rectOldPos;
};

CSize CBCToolBarBase::CalcLayout(DWORD dwMode, int nLength)
{
	ASSERT_VALID(this);
	ASSERT(::IsWindow(m_hWnd));
	if (dwMode & LM_HORZDOCK)
		ASSERT(dwMode & LM_HORZ);

	int nCount;
	TBBUTTON* pData = NULL;
	CSize sizeResult(0,0);

	//BLOCK: Load Buttons
	{
		nCount = DefWindowProc(TB_BUTTONCOUNT, 0, 0);
		if (nCount != 0)
		{
			int i;
			pData = new TBBUTTON[nCount];
			for (i = 0; i < nCount; i++)
				GetButton(i, &pData[i]);
		}
	}

    // Find Custom controls and replace with buttons if VertDock and vise versa
    ControlsToButtons(pData);

	if (nCount > 0)
	{
		if (!(m_dwStyle & CBRS_SIZE_FIXED))
		{
			BOOL bDynamic = m_dwStyle & CBRS_SIZE_DYNAMIC;

			if (bDynamic && (dwMode & LM_MRUWIDTH))
				SizeToolBar(pData, nCount, m_nMRUWidth);
			else if (bDynamic && (dwMode & LM_HORZDOCK))
				SizeToolBar(pData, nCount, 32767);
			else if (bDynamic && (dwMode & LM_VERTDOCK))
            {
                PutButtons(pData);

				SizeToolBar(pData, nCount, 0);
            }
			else if (bDynamic && (nLength != -1))
			{
				CRect rect; rect.SetRectEmpty();
				CalcInsideRect(rect, (dwMode & LM_HORZ));
				BOOL bVert = (dwMode & LM_LENGTHY);
				int nLen = nLength + (bVert ? rect.Height() : rect.Width());

				SizeToolBar(pData, nCount, nLen, bVert);
			}
			else if (bDynamic && (m_dwStyle & CBRS_FLOATING))
				SizeToolBar(pData, nCount, m_nMRUWidth);
			else
            {
               if (!(dwMode & LM_HORZ))
                   PutButtons(pData);

				SizeToolBar(pData, nCount, (dwMode & LM_HORZ) ? 32767 : 0);
            }
		}

		sizeResult = CalcSize(pData, nCount);

		if (dwMode & LM_COMMIT)
		{
			BOOL bIsDelayed = m_bDelayedButtonLayout;
			m_bDelayedButtonLayout = FALSE;
ATLTRACE("LM_COMMIT \n");

			_CC_CONTROLPOS* pControl = NULL;
			int nControlCount = ShrinkControls(pData, dwMode, nCount);

			if (nControlCount > 0)
			{
				pControl = new _CC_CONTROLPOS[nControlCount];
				nControlCount = 0;

				for(int i = 0; i < nCount; i++)
				{
					if ((pData[i].fsStyle & TBSTYLE_SEP) && (pData[i].idCommand != 0))
					{
						pControl[nControlCount].nIndex = i;
						pControl[nControlCount].nID = pData[i].idCommand;

						CRect rect;
						GetItemRect(i, &rect);
						ClientToScreen(&rect);
						pControl[nControlCount].rectOldPos = rect;

						nControlCount++;
					}
				}
			}

			if ((m_dwStyle & CBRS_FLOATING) && (m_dwStyle & CBRS_SIZE_DYNAMIC))
				m_nMRUWidth = sizeResult.cx;

			for (int i = 0; i < nCount; i++)
				SetButton(i, &pData[i]);
//		    ModifyStyle(WS_VISIBLE, 0);
            DefWindowProc(TB_AUTOSIZE, 0, 0);

			if (nControlCount > 0)
			{
                for (int i = 0; i < nControlCount; i++)
				{
					CWnd* pWnd = GetDlgItem(pControl[i].nID);
					if (pWnd != NULL)
					{
						CRect rect;
						pWnd->GetWindowRect(&rect);
                        CPoint pt;
                        if( m_bHideControls == FALSE)
						    pt = rect.TopLeft() - pControl[i].rectOldPos.TopLeft();
                        else
                        {
                            CBCBarButton*  pTB = FindItemByID(pControl[i].nID);
                            ASSERT_VALID (pTB);
                            pt = CPoint(pTB->m_ControlLeft, pTB->m_ControlTop);
                        }
                        GetItemRect(pControl[i].nIndex, &rect);
						pt = rect.TopLeft() + pt;
						pWnd->SetWindowPos(NULL, pt.x, pt.y, 0, 0, SWP_NOACTIVATE |SWP_NOSIZE| SWP_NOZORDER); // pTB->m_ControlWidth,pTB->m_ControlHeight
                        ATLTRACE("SetWindowPos = %d,%d,%d,%d \n",pt.x, pt.y, 0, 0);
					}
				}
				delete[] pControl;
			}
            DefWindowProc(TB_AUTOSIZE, 0, 0);
			m_bDelayedButtonLayout = bIsDelayed;
		}
		delete[] pData;
	}

	//BLOCK: Adjust Margins
	{
		CRect rect; rect.SetRectEmpty();
		CalcInsideRect(rect, (dwMode & LM_HORZ));
		sizeResult.cy -= rect.Height();
		sizeResult.cx -= rect.Width();

		CSize size = CControlBar::CalcFixedLayout((dwMode & LM_STRETCH), (dwMode & LM_HORZ));
		sizeResult.cx = max(sizeResult.cx, size.cx);
		sizeResult.cy = max(sizeResult.cy, size.cy);
	}

	return sizeResult;
}

CSize CBCToolBarBase::CalcFixedLayout(BOOL bStretch, BOOL bHorz)
{
	DWORD dwMode = bStretch ? LM_STRETCH : 0;
	dwMode |= bHorz ? LM_HORZ : 0;

	return CalcLayout(dwMode);
}

CSize CBCToolBarBase::CalcDynamicLayout(int nLength, DWORD dwMode)
{
	if ((nLength == -1) && !(dwMode & LM_MRUWIDTH) && !(dwMode & LM_COMMIT) &&
		((dwMode & LM_HORZDOCK) || (dwMode & LM_VERTDOCK)))
	{
		return CalcFixedLayout(dwMode & LM_STRETCH, dwMode & LM_HORZDOCK);
	}
	return CalcLayout(dwMode, nLength);
}


void CBCToolBarBase::RemoveControls()
{

    if( m_pControls ) {
		for( POSITION pos = m_pControls->GetHeadPosition() ; pos ; )
        {
            CWnd* pObj =(CWnd*) m_pControls->GetNext(pos);
            if ( IsWindow(pObj->m_hWnd))
                pObj->DestroyWindow();
		}
		delete m_pControls;
        m_pControls = NULL;
	}
}

void CBCToolBarBase::OnInitialUpdate()
{
	// update the indicators before becoming visible
    CFrameWnd* pTarget = GetParentFrame();
    pTarget->DelayRecalcLayout();
}

HBITMAP CBCToolBarBase::GetUpdatedBmp(IPictureDisp** pDisp)
{
    ASSERT(pDisp);
    ASSERT(*pDisp);

    HBITMAP hBmp = NULL;
    CComQIPtr<IPicture,&IID_IPicture> pPic(*pDisp);
    if (pPic && SUCCEEDED(pPic->get_Handle((OLE_HANDLE*)&hBmp)) && hBmp)
    {
        CBitmap* pBmp = CBitmap::FromHandle(hBmp); 
	    BITMAP bmp;
	    pBmp->GetBitmap(&bmp);

	    if (bmp.bmWidth != m_sizeImage.cx ||
		    bmp.bmHeight != m_sizeImage.cy) //if size != Streach bitmap &
                                            // assign new Picture object
        {
	    CDC memDCSrc;
	    memDCSrc.CreateCompatibleDC (NULL);

		HBITMAP hOldBitmapSrc = (HBITMAP) memDCSrc.SelectObject(pBmp);
	    if (hOldBitmapSrc == NULL)
            return NULL;
	//----------------------------------------------------------
	// Create a new bitmap compatibel with the source memory DC
	// (original bitmap SHOULD BE ALREADY SELECTED!):
	//----------------------------------------------------------

        HBITMAP hNewBitmap = (HBITMAP) ::CreateCompatibleBitmap (memDCSrc,
									m_sizeImage.cx,
									m_sizeImage.cy);
	    if (hNewBitmap == NULL)
        {
            memDCSrc.SelectObject(hOldBitmapSrc);    
            return NULL;
        }
	//------------------------------------------------------
	// Create memory destination DC and select a new bitmap:
	//------------------------------------------------------
	    CDC memDCDst;
	    memDCDst.CreateCompatibleDC (&memDCSrc);
	    HBITMAP hOldBitmapDst = (HBITMAP) memDCDst.SelectObject(hNewBitmap);
	    if (hOldBitmapDst == NULL)
	    {
		    memDCSrc.SelectObject (hOldBitmapSrc);
		    ::DeleteObject (hNewBitmap);
		    return 0;
	    }

		//-----------------------------
		// Stretch original bitmap to new:
		//-----------------------------
        memDCDst.StretchBlt(0, 0, m_sizeImage.cx, m_sizeImage.cy, 
                     &memDCSrc, 0, 0, bmp.bmWidth, bmp.bmHeight, 
                     SRCCOPY);

	    memDCDst.SelectObject (hOldBitmapDst);
	    memDCSrc.SelectObject (hOldBitmapSrc);

		//-----------------------------
		// Create new Object & assing  bitmap to 
		//-----------------------------
        pPic.Release();

        PICTDESC PictDesc;
        PictDesc.cbSizeofstruct =  sizeof(PictDesc.cbSizeofstruct)+
                                    sizeof(PictDesc.picType)+
                                    sizeof(PictDesc.bmp);
        PictDesc.picType = PICTYPE_BITMAP;
        PictDesc.bmp.hbitmap = hNewBitmap;
        PictDesc.bmp.hpal = (HPALETTE) GetStockObject(DEFAULT_PALETTE);
        if (SUCCEEDED(OleCreatePictureIndirect(&PictDesc,
                    IID_IPictureDisp,TRUE,(void**)pDisp)))
                hBmp = hNewBitmap;
        }
    }
    return hBmp;
}

void CBCToolBarBase::FloatBar()
{
    CFrameWnd* pWnd = m_pMainControl->m_pWindow;
    ASSERT(pWnd);

    CRect rc(0,0,800,600);
    int x=20,y=20;
    int xx,yy;
    srand((unsigned)time( NULL ));
    pWnd->GetWindowRect(rc);
    for (int i = 0; i < 100; i++)
    {
        xx = 0x3ff & rand();
        yy = 0x2ff & rand();
        if (rc.PtInRect(CPoint(xx,yy)) || rc.IsRectEmpty())
        {
            x = xx; y = yy;
            break;
        }
    }
    pWnd->FloatControlBar(this,CPoint(x,y));

}

BOOL CBCToolBarBase::TranslateMessage(MSG *pMsg)
{
    return FALSE;
}



HCURSOR CBCToolBarBase::GetBarCursor(enMousePointer cursor)
{
    LPCTSTR nCursor = NULL;

    switch (cursor)
    {
    case ccDefault:
       nCursor = NULL;
       break;
    case ccArrow:
       nCursor = IDC_ARROW;
       break;
    case    ccCross:
       nCursor = IDC_CROSS;
       break;
    case    ccIBeam:
       nCursor = IDC_IBEAM;
       break;
    case    ccIcon:
       nCursor = IDC_ICON;
       break;
    case    ccSize:
       nCursor = IDC_SIZEALL;
       break;
    case    ccSizeNESW:
       nCursor = IDC_SIZENESW;
       break;
    case    ccSizeNS:
       nCursor = IDC_SIZENS;
       break;
    case    ccSizeNWSE:
       nCursor = IDC_SIZENWSE;
       break;
    case    ccSizeEW:
       nCursor = IDC_SIZEWE;
       break;
    case    ccUpArrow:
       nCursor = IDC_UPARROW;
       break;
    case    ccHourglass:
       nCursor = IDC_WAIT;
       break;
    case    ccNoDrop:
       nCursor = IDC_NO;
       break;
    case    ccArrowHourglass:
       nCursor = IDC_APPSTARTING;
       break;
    case    ccArrowQuestion:
       nCursor = IDC_HELP;
       break;
    case    ccSizeAll:
       nCursor = IDC_SIZEALL;
       break;
    default:
       nCursor = NULL;
    }
    return (nCursor ? ::LoadCursor(NULL, nCursor): NULL);
}

int CBCToolBarBase::UpdateImages(CBCBarButton *pBT)
{
    ASSERT (pBT);

    int iImage = -1;
    HBITMAP hBmp = NULL;

    if (pBT->m_spImage)
    {
        if ((pBT->m_ItemStyle == ccDefaultStyle)
            ||(pBT->m_ItemStyle == ccImageOnly)
            ||(pBT->m_ItemStyle == ccImageAndText))
        {
           hBmp = GetUpdatedBmp(&pBT->m_spImage);
            if (hBmp)
                iImage = m_Images.AddImage(hBmp);

           if (pBT->m_spImageHot)
            {
              HBITMAP hBmpHot = GetUpdatedBmp(&pBT->m_spImageHot);
                if (hBmpHot)
                    m_ImagesHot.AddImage(hBmpHot);
            }
            else if (hBmp)
                m_ImagesHot.AddImage(hBmp);

            if (pBT->m_spImageDsbl)
            {
               HBITMAP hBmpDsbl = GetUpdatedBmp(&pBT->m_spImageDsbl);
                if (hBmpDsbl)
                     m_ImagesDsbl.AddImage(hBmpDsbl);
            }
            else if (hBmp)
                 m_ImagesDsbl.AddImage(hBmp);
        }
    }
    return iImage;
}

void CBCToolBarBase::SetHotImages(HBITMAP hBmp)
{
    CImageList      imageList;
    CBitmap         bitmap;

    // Create and set the normal toolbar image list.
    bitmap.Attach(hBmp);
    imageList.Create( m_sizeImage.cx, m_sizeImage.cy,
                    ILC_COLORDDB|ILC_MASK, m_ImagesHot.GetCount(), 1);
    imageList.Add(&bitmap, RGB(255,0,255));
    imageList.Detach();
    bitmap.Detach();

}

void CBCToolBarBase::SetDsblImages(HBITMAP hBmp)
{
    CImageList      imageList;
    CBitmap         bitmap;

    // Create and set the normal toolbar image list.
    bitmap.Attach(hBmp);
    imageList.Create( m_sizeImage.cx, m_sizeImage.cy,
                    ILC_COLORDDB|ILC_MASK, m_ImagesDsbl.GetCount(), 1);
    imageList.Add(&bitmap, RGB(255,0,255));
    GetToolBarCtrl().SetDisabledImageList(&imageList);
    imageList.Detach();
    bitmap.Detach();
}

void CBCToolBarBase::SetImageList(iType Type, HBITMAP hBmp, int nCount)
{
    CImageList      imageList;
    CBitmap         bitmap;

    // Create and set the normal toolbar image list.
    bitmap.Attach(hBmp);
    imageList.Create( m_sizeImage.cx, m_sizeImage.cy,
                    ILC_COLORDDB|ILC_MASK, nCount, 1);
    imageList.Add(&bitmap, RGB(255,0,255));
    switch (Type)
    {
    case iHot:
        GetToolBarCtrl().SetHotImageList(&imageList);
        break;
    case iDisabled:
        GetToolBarCtrl().SetDisabledImageList(&imageList);
        break;
    case iNormal:
    default:
        GetToolBarCtrl().SetImageList(&imageList);
    }
    imageList.Detach();
    bitmap.Detach();
}

int CBCToolBarBase::WrapToolBar(TBBUTTON *pData, int nCount, int nWidth)
{
	ASSERT(pData != NULL && nCount > 0);

	int nResult = 0;
	int x = 0;
	for (int i = 0; i < nCount; i++)
	{
		pData[i].fsState &= ~TBSTATE_WRAP;

		if (pData[i].fsState & TBSTATE_HIDDEN)
			continue;

		int dx, dxNext;
		if (pData[i].fsStyle & TBSTYLE_SEP)
		{
			dx = pData[i].iBitmap;
			dxNext = dx;
		}
		else
		{
			dx = m_sizeButton.cx;
			dxNext = dx - CX_OVERLAP;
		}

		if (x + dx > nWidth)
		{
			BOOL bFound = FALSE;
			for (int j = i; j >= 0  &&  !(pData[j].fsState & TBSTATE_WRAP); j--)
			{
				// Find last separator that isn't hidden
				// a separator that has a command ID is not
				// a separator, but a custom control.
				if ((pData[j].fsStyle & TBSTYLE_SEP) &&
					(pData[j].idCommand == 0) &&
					!(pData[j].fsState & TBSTATE_HIDDEN))
				{
					bFound = TRUE; i = j; x = 0;
					pData[j].fsState |= TBSTATE_WRAP;
					nResult++;
					break;
				}
			}
			if (!bFound)
			{
				for (int j = i - 1; j >= 0 && !(pData[j].fsState & TBSTATE_WRAP); j--)
				{
					// Never wrap anything that is hidden,
					// or any custom controls
					if ((pData[j].fsState & TBSTATE_HIDDEN) ||
						((pData[j].fsStyle & TBSTYLE_SEP) &&
						(pData[j].idCommand != 0)))
						continue;

					bFound = TRUE; i = j; x = 0;
					pData[j].fsState |= TBSTATE_WRAP;
					nResult++;
					break;
				}
				if (!bFound)
					x += dxNext;
			}
		}
		else
			x += dxNext;
	}
	return nResult + 1;
}

void CBCToolBarBase::SetMainControl(CICuteBar *pControl)
{
    m_pMainControl = pControl;
}

void CBCToolBarBase::SetImageSize(int cx, int cy)
{
    if (cx && (m_sizeButton.cx >= cx + 7))
        m_sizeImage.cx = cx;
    if (cy && (m_sizeButton.cy >= cy + 6))
        m_sizeImage.cy = cy;
#ifdef ACCESS_WND_PROPERTIES
    SetSizes(m_sizeButton,m_sizeImage);
#endif
}

void CBCToolBarBase::SetButtonSize(int cx, int cy)
{
    if (cx && (cx >= m_sizeImage.cx +7))
        m_sizeButton.cx = cx;
    if (cy && (cy >= m_sizeImage.cy +6))
        m_sizeButton.cy = cy;

#ifdef ACCESS_WND_PROPERTIES
    SetSizes(m_sizeButton,m_sizeImage);
#endif
}

enDockState CBCToolBarBase::GetDockState()
{
    enDockState enDStyle = ccDTop;
    UINT DockState = m_DockState;
    if (m_hWnd)
    {
        if(IsFloating())
        {
//            m_DockState = CBRS_FLOATING;
            return ccDFloating;
        }
        DockState = ((CBRS_ALIGN_ANY)& GetBarStyle());    //CBRS_BORDER_ANY|
    }

    if ( DockState & CBRS_FLOATING)
        enDStyle = ccDFloating;
    else if (DockState & CBRS_ALIGN_TOP)
        enDStyle =	ccDTop;
    else if (DockState & CBRS_ALIGN_BOTTOM)
        enDStyle = ccDBottom;
    if (DockState & CBRS_ALIGN_LEFT)
        enDStyle =	ccDLeft;
   if (DockState & CBRS_ALIGN_RIGHT)
        enDStyle =	ccDRight;

    return enDStyle;
}

void CBCToolBarBase::SetDockState(enDockState dstate)
{
    ASSERT(m_pMainControl);

    CFrameWnd* pWnd = m_pMainControl->m_pWindow;
    ASSERT(pWnd);

    switch (dstate)
    {
        case ccDLeft:
            m_DockState = CBRS_LEFT;
            if(m_hWnd)
                pWnd->DockControlBar(this,AFX_IDW_DOCKBAR_LEFT);             
            break;
        case ccDTop:
            m_DockState = CBRS_TOP;
            if(m_hWnd)
                pWnd->DockControlBar(this,AFX_IDW_DOCKBAR_TOP);
            break;
        case ccDRight:
            m_DockState = CBRS_RIGHT;
             if(m_hWnd)
                pWnd->DockControlBar(this,AFX_IDW_DOCKBAR_RIGHT);
           break;
        case ccDBottom:
            m_DockState = CBRS_BOTTOM;
            if(m_hWnd)
                pWnd->DockControlBar(this,AFX_IDW_DOCKBAR_BOTTOM);
            break;
        case ccDFloating:
            m_DockState = CBRS_FLOATING;
            if(m_hWnd)
                FloatBar();
            break;
        default:
            m_DockState = CBRS_TOP;
            if(m_hWnd)
                pWnd->DockControlBar(this,AFX_IDW_DOCKBAR_TOP);
            break;
    }
}
enItemState CBCToolBarBase::GetButtonState(long ID)
{
    int ItemState = 0;
    
   DWORD state = DefWindowProc(TB_GETSTATE, (WPARAM)ID, (LPARAM)0);

   if ( state != -1)
   {
    if((state & TBSTATE_ENABLED)) ItemState |= ccItemUnpressed;
    if((state &  TBSTATE_CHECKED))  ItemState |= ccItemPressed;
    if((state &  TBSTATE_INDETERMINATE)) ItemState |= ccItemGrayed;
    if((state &  TBSTATE_HIDDEN)) ItemState |= ccItemGroup;
   }

   return (enItemState)ItemState;
}

BOOL CBCToolBarBase::SetButtonState(long ID, enItemState state)
{
    WORD fState = 0;
    
    if((state & ccItemUnpressed )) fState |= TBSTATE_ENABLED;
    if((state & ccItemPressed ))  fState |= TBSTATE_CHECKED;
    if((state & ccItemGrayed )) fState |= TBSTATE_INDETERMINATE;
    if((state & ccItemGroup )) fState |=TBSTATE_HIDDEN ;

   return DefWindowProc(TB_SETSTATE , (WPARAM)ID, (LPARAM) MAKELONG(fState, 0));
}
HBITMAP _SysColorBitmap(HBITMAP hBmp, BOOL bMono);
HBITMAP DDBTo256 (HBITMAP bitmap);

void CBCToolBarBase::OnSysColorChange() 
{
    // Bug Fix - MFC updates it's Colors only if m_pMainFrame != NULL
	// recolor global brushes used by control bars
	afxData.clrBtnFace = ::GetSysColor(COLOR_BTNFACE);
	afxData.clrBtnShadow = ::GetSysColor(COLOR_BTNSHADOW);
	afxData.clrBtnHilite = ::GetSysColor(COLOR_BTNHIGHLIGHT);
	afxData.clrBtnText = ::GetSysColor(COLOR_BTNTEXT);
	afxData.clrWindowFrame = ::GetSysColor(COLOR_WINDOWFRAME);

	afxData.hbrBtnFace = ::GetSysColorBrush(COLOR_BTNFACE);
	afxData.hbrWindowFrame = ::GetSysColorBrush(COLOR_WINDOWFRAME);

    CToolBar::OnSysColorChange();
/*
    HBITMAP bmp = m_Images.GetBitmap();
	if (bmp)
         SetBitmap(DDBTo256(bmp));
//            SetImageList(iNormal, DDBTo256(bmp), m_Images.GetCount());

    bmp = m_ImagesHot.GetBitmap();
	if (m_bUseImageList&& bmp)
        SetImageList(iHot, DDBTo256(bmp), m_ImagesHot.GetCount());

    bmp = m_ImagesDsbl.GetBitmap();
	if (m_bUseImageList && bmp)
        SetImageList(iDisabled, DDBTo256(bmp), m_ImagesDsbl.GetCount());
*/
}

CSize CBCToolBarBase::GetButtonSize()
{
    return m_sizeButton;
}