////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// BarCollection.h : Declaration of the CIBarCollection

#ifndef __BARCOLLECTION_H_
#define __BARCOLLECTION_H_

#include "resource.h"       // main symbols
#include <vector>
#include "bar.h"
#include "Reuse\VCUE_Copy.h"
#include "VCU_BarCopy.h"


class CICuteBar;

namespace BarColl
{
	// Store our data in a vector of std::strings
    typedef CComObject<CIBar>* ContObj;
    typedef std::vector< ContObj >		        ContainerType;

	// Use IEnumVARIANT as the enumerator for VB compatibility
	typedef VARIANT									EnumeratorExposedType;
	typedef IEnumVARIANT							EnumeratorInterface;

	// Our collection interface exposes the data as BSTRs
	typedef IBar*    	    						CollectionExposedType;
	typedef IBarCollection							CollectionInterface;

	// Typedef the copy classes using existing typedefs
	typedef VCUE::GenericCopy<EnumeratorExposedType, ContainerType::value_type>		EnumeratorCopyType;
	typedef VCUE::GenericCopy<CollectionExposedType, ContainerType::value_type>		CollectionCopyType;

	// Now we have all the information we need to fill in the template arguments on the implementation classes
	typedef CComEnumOnSTL< EnumeratorInterface, &__uuidof(EnumeratorInterface), EnumeratorExposedType,
							EnumeratorCopyType, ContainerType > EnumeratorType;

	typedef ICollectionOnSTLImpl< CollectionInterface, ContainerType, CollectionExposedType,
							CollectionCopyType, EnumeratorType > CollectionType;

}; // namespace BarColl;

/////////////////////////////////////////////////////////////////////////////
// CIBarCollection
class ATL_NO_VTABLE CIBarCollection : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CIBarCollection, &CLSID_BarCollection>,
	public ISupportErrorInfo,
   	public IPersistStreamInitImpl<CIBarCollection>,
    public IPersistStorageImpl<CIBarCollection>,
    public IDispatchImpl<BarColl::CollectionType, &IID_IBarCollection, &LIBID_CuteControlsLib>
{
public:
	CIBarCollection();
	~CIBarCollection();


DECLARE_REGISTRY_RESOURCEID(IDR_BARCOLLECTION)

DECLARE_ONLY_AGGREGATABLE(CIBarCollection)

DECLARE_PROTECT_FINAL_CONSTRUCT()

DECLARE_GET_CONTROLLING_UNKNOWN()

BEGIN_COM_MAP(CIBarCollection)
	COM_INTERFACE_ENTRY(IBarCollection)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersistStream, IPersistStreamInit)
END_COM_MAP()

BEGIN_PROP_MAP(CIBarCollection)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
//	 PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);
// Data Members
public:
    // --- ToolBars Data
    CICuteBar* m_pMainControl;
    unsigned  m_bRequiresSave:1;
	void RemoveAll();

// IBarCollection
public:
	void UpdateBars();
	void GenHFile(HFILETYPE Type, CString& Buffer);
	void UpdateImages(UINT id);
	BOOL PreTranslateMessage(LPMSG pMsg);
	int GetControlInfo(LPCONTROLINFO pCI);
	BOOL ConstructBars();
	STDMETHOD(get_Item)(/*[in]*/ VARIANT* Index, /*[out, retval]*/ IBar* *pVal);
	void SetMainControl(CICuteBar* pControl);
    STDMETHOD(Clear)();
	STDMETHOD(Remove)(/*[in]*/ VARIANT* Index);
	STDMETHOD(Add)(/*[in]*/ long ID, /*[in, optional]*/ VARIANT* Name, /*[in, optional]*/ VARIANT* Style, /*[out, retval]*/ IBar** pVal);

// IPersistStream

HRESULT IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap);
HRESULT IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap);

protected:
	void ClearState();
	HRESULT CreateObject(BarColl::ContObj* pObj,IUnknown** pIBar);
	BOOL RestoreObjects(LPSTREAM pStm);
	BOOL SaveObjects(LPSTREAM pStm, BOOL fClearDirty);
};

#endif //__BARCOLLECTION_H_
