/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.galileo.client.jsp.html.clientagent;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentExtraInfo;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfo;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfoComponent;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfoGenerator;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import com.softaspects.galileo.client.jsp.html.clientagent.ClientAgentInfoPolicy;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class ClientAgentInfoTag
extends TagSupport {
    public static final String DEFAULT_BEAN_NAME = "USER_AGENT_INFO";
    private String fBeanName = "USER_AGENT_INFO";
    private int fScope = 3;
    private boolean fExtraInfo = false;
    private String fVariable = null;
    private int fRefreshRate = 30;
    private boolean fRewriteBean = false;
    private ClientAgentInfo fUserAgentInfo = null;
    private ClientAgentExtraInfo fUserAgentExtraInfo = null;
    protected static final String FLAG_PAGE_REFRESHED = "RFRP";

    public void setBeanName(String aBeanName) {
        ClientAgentInfoTag.validateValue(aBeanName, "Bean name");
        this.fBeanName = aBeanName;
    }

    public String getBeanName() {
        return this.fBeanName;
    }

    public void setScope(String aScope) {
        ClientAgentInfoTag.validateValue(aScope, "Scope");
        int code = TagFactory.getScopeCode(aScope);
        if (code < 0) {
            throw new IllegalArgumentException("Scope value is incorrect.");
        }
        this.fScope = code;
    }

    public void setRefreshRate(String aRefresh) {
        ClientAgentInfoTag.validateValue(aRefresh, "Refresh");
        try {
            this.fRefreshRate = Integer.parseInt(aRefresh);
            if (this.fRefreshRate < 0) {
                throw new IllegalArgumentException("Refresh rate can't has negative value.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Refresh rate has incorrect value.");
        }
    }

    protected int getRefreshRate() {
        return this.fRefreshRate;
    }

    public void setRewriteBean(String aRewrite) {
        ClientAgentInfoTag.validateValue(aRewrite, "Rewrite");
        this.fRewriteBean = Boolean.valueOf(aRewrite);
    }

    protected boolean isRewriteBean() {
        return this.fRewriteBean;
    }

    protected int getScope() {
        return this.fScope;
    }

    public String getVariable() {
        return this.fVariable;
    }

    public void setVariable(String aVariable) {
        ClientAgentInfoTag.validateVariableName(aVariable);
        this.fVariable = aVariable;
    }

    public void setExtraInfo(String aExtraInfo) {
        ClientAgentInfoTag.validateValue(aExtraInfo, "User extra info");
        this.fExtraInfo = Boolean.valueOf(aExtraInfo);
    }

    public int doEndTag() throws JspException {
        this.fUserAgentInfo = (ClientAgentInfo)this.pageContext.getAttribute(this.fBeanName, this.fScope);
        boolean extraInfo = this.fExtraInfo;
        if (this.getUserAgentInfo() == null || this.isRewriteBean()) {
            if (this.getParent() != null && ClientAgentInfoPolicy.generateExceptionIfParentTagPresent()) {
                throw new IllegalStateException("UserAgentInfo can't have parent tags.");
            }
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            ClientAgentInfoGenerator infoGenerator = new ClientAgentInfoGenerator();
            if (extraInfo) {
                Object flag = this.pageContext.getAttribute(FLAG_PAGE_REFRESHED, 3);
                if (flag == null) {
                    ClientAgentInfoComponent component = new ClientAgentInfoComponent();
                    component.setRefreshRate(this.getRefreshRate());
                    try {
                        RendererFactory.componentRender(component, this.pageContext);
                    }
                    catch (RendererException e) {
                        throw new JspException(e.toString());
                    }
                    this.pageContext.setAttribute(FLAG_PAGE_REFRESHED, (Object)FLAG_PAGE_REFRESHED, 3);
                    try {
                        this.pageContext.getOut().println("</BODY></HTML>");
                    }
                    catch (IOException e) {
                        throw new JspException(e.toString());
                    }
                    return 5;
                }
                ClientAgentInfoTag clientAgentInfoTag = this;
                synchronized (clientAgentInfoTag) {
                    this.fUserAgentExtraInfo = infoGenerator.getUserAgentExtraInfo(request);
                    this.pageContext.setAttribute(this.fBeanName, (Object)this.getUserAgentExtraInfo(), this.fScope);
                    this.pageContext.removeAttribute(FLAG_PAGE_REFRESHED, 3);
                }
            }
            ClientAgentInfoTag clientAgentInfoTag = this;
            synchronized (clientAgentInfoTag) {
                this.fUserAgentInfo = infoGenerator.getUserAgentInfo(request);
                this.pageContext.setAttribute(this.fBeanName, (Object)this.getUserAgentInfo(), this.fScope);
            }
        }
        if (this.getVariable() != null) {
            if (extraInfo) {
                this.pageContext.setAttribute(this.getVariable(), this.pageContext.getAttribute(this.fBeanName, this.fScope), 1);
            } else {
                this.pageContext.setAttribute(this.getVariable(), this.pageContext.getAttribute(this.fBeanName, this.fScope), 1);
            }
        }
        return 0;
    }

    public void release() {
        super.release();
        this.fBeanName = DEFAULT_BEAN_NAME;
        this.fScope = 3;
        this.fExtraInfo = false;
        this.fVariable = null;
        this.fRefreshRate = 30;
        this.fRewriteBean = false;
    }

    protected static void validateValue(String aValue, String aName) {
        if (aValue == null || aValue.length() == 0) {
            throw new IllegalArgumentException("UserAgentInfo: " + aName + " can't be null.");
        }
    }

    protected static void validateVariableName(String aVariable) {
        ClientAgentInfoTag.validateValue(aVariable, "Variable name");
        char[] chars = aVariable.toCharArray();
        boolean result = false;
        if (Character.isJavaIdentifierStart(chars[0])) {
            result = true;
            int i = 1;
            while (i < chars.length) {
                if (!Character.isJavaIdentifierPart(chars[i])) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        if (!result) {
            throw new IllegalArgumentException("UserAgentInfo: Variable name has wrong syntax.");
        }
    }

    private ClientAgentInfo getUserAgentInfo() {
        return this.fUserAgentInfo;
    }

    private ClientAgentExtraInfo getUserAgentExtraInfo() {
        return this.fUserAgentExtraInfo;
    }
}

