/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class LazyHashMap
extends HashMap {
    public LazyHashMap() {
    }

    public LazyHashMap(int aInitialCapacity) {
        super(aInitialCapacity);
    }

    public LazyHashMap(int aInitialCapacity, float aLoadFactor) {
        super(aInitialCapacity, aLoadFactor);
    }

    public LazyHashMap(Map aMap) {
        super(aMap);
    }

    public Object get(Object aKey) {
        Object value;
        block6: {
            value = super.get(aKey);
            if (!(value instanceof LazyValue)) break block6;
            try {
                value = ((LazyValue)value).createValue(this);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (value == null) {
                    super.remove(aKey);
                } else {
                    super.put(aKey, value);
                }
                throw throwable;
            }
            Object var3_5 = null;
            if (value == null) {
                super.remove(aKey);
            } else {
                super.put(aKey, value);
            }
        }
        return value;
    }

    public Object put(Object aKey, Object aValue) {
        if (aKey == null) {
            throw new IllegalArgumentException("LazyHashMap: key can't be null.");
        }
        return aValue == null ? super.remove(aKey) : super.put(aKey, aValue);
    }

    public Object putLazyValue(Object aKey, Class aLazyValue) {
        return this.put(aKey, new ProxyLazyValue(aLazyValue));
    }

    public interface LazyValue {
        public Object createValue(LazyHashMap var1);
    }

    public static class ProxyLazyValue
    implements LazyValue {
        private Class fClass = null;
        private String fMethodName = null;
        private Object[] fArgs = null;

        public ProxyLazyValue(Class aClass, String aMethodName, Object[] aArgs) {
            if (aClass == null) {
                throw new IllegalArgumentException("ProxyLazyValue: class name can't be null.");
            }
            this.fClass = aClass;
            this.fMethodName = aMethodName;
            this.fArgs = aArgs;
        }

        public ProxyLazyValue(Class aClass, String aMethodName) {
            this(aClass, aMethodName, null);
        }

        public ProxyLazyValue(Class aClass) {
            this(aClass, null);
        }

        public Object createValue(LazyHashMap aLazyHashMap) {
            Object instance = null;
            try {
                if (this.fMethodName != null) {
                    Class[] types = this.getClassArray(this.fArgs);
                    Method method = this.fClass.getMethod(this.fMethodName, types);
                    instance = method.invoke((Object)this.fClass, this.fArgs);
                } else {
                    Class[] types = this.getClassArray(this.fArgs);
                    Constructor constructor = this.fClass.getConstructor(types);
                    instance = constructor.newInstance(this.fArgs);
                }
            }
            catch (Exception e) {
                System.out.println(" <-+-> LazyHashMap: Problem creating " + this.fClass.getName());
                System.out.println(e.toString());
            }
            return instance;
        }

        private Class[] getClassArray(Object[] fArgs) {
            Class[] types = null;
            if (fArgs != null) {
                types = new Class[fArgs.length];
                int i = 0;
                while (i < fArgs.length) {
                    types[i] = fArgs[i] instanceof Integer ? Integer.TYPE : (fArgs[i] instanceof Boolean ? Boolean.TYPE : (fArgs[i] instanceof Double ? Double.TYPE : fArgs[i].getClass()));
                    ++i;
                }
            }
            return types;
        }
    }
}

