/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.s.l;

import com.softaspects.framework.galileo.support.base.PC;
import com.softaspects.framework.galileo.support.components.ListException;
import com.softaspects.framework.galileo.support.s.l.K;
import com.softaspects.framework.galileo.support.s.l.L;
import com.softaspects.framework.galileo.support.s.l.LEL;
import com.softaspects.framework.galileo.support.s.l.ext.CD;
import com.softaspects.framework.galileo.support.s.l.ext.LExt;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.zip.CRC32;
import javax.servlet.ServletContext;

public class GLE
implements LExt {
    private LEL l = null;
    protected int v;
    private PC c = null;
    private static final String L_F_N = "webgalileo.key";

    public GLE(LEL aListener, int aVersion) {
        this.l = aListener;
        this.v = aVersion;
    }

    public L getL() throws ListException {
        L result;
        block7: {
            result = null;
            String licenseFileName = this.getLFP();
            try {
                File keyFile = new File(licenseFileName);
                if (keyFile.exists()) {
                    if (!keyFile.canRead()) break block7;
                    FileInputStream fis = new FileInputStream(keyFile);
                    try {
                        int len = fis.available();
                        byte[] fileContent = new byte[len];
                        fis.read(fileContent);
                        int startIndex = 0;
                        int bytesRead = len;
                        ByteArrayInputStream bis = new ByteArrayInputStream(fileContent);
                        DataInputStream dis = new DataInputStream(bis);
                        long originalCRC = dis.readLong();
                        byte[] bytes = new byte[len -= 8];
                        startIndex = 0;
                        bytesRead = 1;
                        do {
                            bytesRead = dis.read(bytes, startIndex, len);
                            startIndex += bytesRead;
                            len -= bytesRead;
                        } while (bytesRead != -1);
                        CRC32 cRC32 = new CRC32();
                        cRC32.update(bytes);
                        long obtainedCRC = cRC32.getValue();
                        if (originalCRC != obtainedCRC) {
                            throw new ListException(5, "LICENSE FILE IS CORRUPTED");
                        }
                        result = this.dL(bytes);
                    }
                    catch (Throwable throwable) {
                        Object var17_17 = null;
                        fis.close();
                        throw throwable;
                    }
                    Object var17_18 = null;
                    fis.close();
                    break block7;
                }
                throw new ListException(4, "LICENSE FILE NOT FOUND");
            }
            catch (Exception ex) {
                throw new ListException(ex.getMessage());
            }
        }
        return result;
    }

    private final L dL(byte[] aData) throws ListException {
        L result = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aData);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            byte[][] encodedContent = (byte[][])objectInputStream.readObject();
            byte[] privateKeyExponentBytes = this.getPKB();
            byte[] privateKeyModuloBytes = this.getPriKModB();
            String decodedString = CD.decrypt(encodedContent, privateKeyExponentBytes, privateKeyModuloBytes);
            result = new L();
            result.fromString(decodedString);
        }
        catch (Exception e) {
            throw new ListException(e.getMessage());
        }
        return result;
    }

    private byte[] getPKB() {
        return K.P_K_B;
    }

    private byte[] getPriKModB() {
        return K.PRI_K_M_B;
    }

    protected String getLFP() throws ListException {
        if (this.getC() == null) {
            throw new ListException("PRESENTATION CONTEXT MUSTN'T BE NULL");
        }
        ServletContext cntx = null;
        if (this.getC().getContext() == null) {
            throw new ListException("HttpRequest or ServletContext must be set in Context");
        }
        cntx = this.getC().getContext();
        String applicationPath = "/WEB-INF/" + L_F_N;
        String result = cntx.getRealPath(applicationPath);
        return result;
    }

    public PC getC() {
        return this.c;
    }

    public void setC(PC context) {
        this.c = context;
    }
}

