/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.frame.layout;

import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.components.base.Renderer;
import com.softaspects.framework.galileo.support.components.frame.Frame;
import com.softaspects.framework.galileo.support.components.frame.FrameContainer;
import com.softaspects.framework.galileo.support.components.frame.layout.FrameLayoutManager;
import java.util.Iterator;

public abstract class FrameLayoutManagerImpl
implements FrameLayoutManager {
    protected Renderer fRenderer = null;

    public void setRenderer(Renderer aRenderer) {
        FrameLayoutManagerImpl.validateRenderer(aRenderer);
        this.fRenderer = aRenderer;
    }

    public Renderer getRenderer() {
        return this.fRenderer;
    }

    public void delegateRenderer(FrameContainer aFrameContainer) {
        FrameLayoutManagerImpl.validateFrameContainer(aFrameContainer);
        aFrameContainer.setRenderer(this.getRenderer());
        this.getRenderer().setComponent(aFrameContainer);
    }

    protected static void validateFrame(Frame aFrame) {
        FrameLayoutManagerImpl.validateValue(aFrame, "Frame");
    }

    protected static void validateFrameContainer(FrameContainer aFrameContainer) {
        FrameLayoutManagerImpl.validateValue(aFrameContainer, "Frame container");
    }

    protected static void validateRenderer(Renderer aRenderer) {
        FrameLayoutManagerImpl.validateValue(aRenderer, "Renderer");
    }

    private static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("Frame layoutManager: " + aName + " can't be null.");
        }
    }

    public abstract void addLayoutFrame(Frame var1);

    public abstract void removeLayoutFrame(Frame var1);

    public abstract void removeAllLayoutFrames();

    public abstract void doLayout(FrameContainer var1);

    public abstract Iterator getLayoutFrames(Constraint var1);

    public abstract int getCountLayoutFrames(Constraint var1);
}

