/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.frame.layout;

import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.renderers.html.frame.layout.BorderFrameLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.constraint.BorderConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import com.softaspects.framework.galileo.support.components.frame.Frame;
import com.softaspects.framework.galileo.support.components.frame.FrameContainer;
import com.softaspects.framework.galileo.support.components.frame.layout.FrameLayoutManager;
import com.softaspects.framework.galileo.support.components.frame.layout.FrameLayoutManagerImpl;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class FrameBorderLayoutManager
extends FrameLayoutManagerImpl
implements FrameLayoutManager {
    private static final int MAX_COUNT = 5;
    private int fType = 1;
    private ArrayList[] fFramesArray = new ArrayList[5];

    public FrameBorderLayoutManager() {
        int i = 0;
        while (i < 5) {
            this.fFramesArray[i] = new ArrayList();
            ++i;
        }
        this.setRenderer(new BorderFrameLayoutRenderer());
    }

    public void setType(int aType) {
        if (aType != 2 && aType != 1) {
            throw new IllegalArgumentException("FrameBorderLayoutManager: type not supported.");
        }
        this.fType = aType;
    }

    public int getType() {
        return this.fType;
    }

    public Iterator getLayoutFrames(int aBorder) {
        this.validateBorder(aBorder);
        return ((AbstractList)this.fFramesArray[aBorder]).iterator();
    }

    public Iterator getLayoutFrames(Constraint aConstraint) {
        return this.getLayoutFrames(this.getBorderValue(aConstraint));
    }

    public int getCountLayoutFrames(int aBorder) {
        this.validateBorder(aBorder);
        return this.fFramesArray[aBorder].size();
    }

    public int getCountLayoutFrames(Constraint aConstraint) {
        return this.getCountLayoutFrames(this.getBorderValue(aConstraint));
    }

    public void addLayoutFrame(Frame aFrame) {
        if (aFrame != null) {
            int border = this.getBorderValue(aFrame.getConstraint());
            this.fFramesArray[border].add(aFrame);
        }
    }

    public void removeLayoutFrame(Frame aFrame) {
        if (aFrame != null) {
            int border = this.getBorderValue(aFrame.getConstraint());
            ((AbstractCollection)this.fFramesArray[border]).remove(aFrame);
        }
    }

    public void removeAllLayoutFrames() {
        int i = 0;
        while (i < 5) {
            this.fFramesArray[i].clear();
            ++i;
        }
    }

    public int getCountRows(FrameContainer aFrameContainer) {
        this.doLayout(aFrameContainer);
        int result = 0;
        if (this.getType() == 1) {
            if (!this.fFramesArray[4].isEmpty()) {
                ++result;
            }
            if (!this.fFramesArray[2].isEmpty()) {
                ++result;
            }
            if (!(this.fFramesArray[0].isEmpty() && this.fFramesArray[1].isEmpty() && this.fFramesArray[3].isEmpty())) {
                ++result;
            }
        } else {
            result = 1;
        }
        return result;
    }

    public int getCountColumns(FrameContainer aFrameContainer) {
        this.doLayout(aFrameContainer);
        int result = 0;
        if (this.getType() == 1) {
            result = 1;
        } else {
            if (!this.fFramesArray[4].isEmpty()) {
                ++result;
            }
            if (!this.fFramesArray[2].isEmpty()) {
                ++result;
            }
            if (!(this.fFramesArray[0].isEmpty() && this.fFramesArray[1].isEmpty() && this.fFramesArray[3].isEmpty())) {
                ++result;
            }
        }
        return result;
    }

    public void doLayout(FrameContainer aFrameContainer) {
        FrameLayoutManagerImpl.validateFrameContainer(aFrameContainer);
        ArrayList layoutFramesList = new ArrayList();
        int i = 0;
        while (i < 5) {
            layoutFramesList.addAll(this.fFramesArray[i]);
            ++i;
        }
        if (!Arrays.equals(layoutFramesList.toArray(), aFrameContainer.getFramesArray())) {
            this.removeAllLayoutFrames();
            Iterator componentsIterator = aFrameContainer.getFrames();
            while (componentsIterator.hasNext()) {
                this.addLayoutFrame((Frame)componentsIterator.next());
            }
            aFrameContainer.getFramesList().clear();
            int i2 = 0;
            while (i2 < 5) {
                aFrameContainer.getFramesList().addAll(this.fFramesArray[i2]);
                ++i2;
            }
        }
    }

    private void validateBorder(int aBorder) {
        if (aBorder < 0 || aBorder > 4) {
            throw new IllegalArgumentException("FrameBorderLayoutManager: border value is not supported.");
        }
    }

    private int getBorderValue(Constraint aConstraint) {
        int border = 0;
        if (aConstraint == null) {
            if (LayoutManagerPolicy.generateExceptionIfConstraintIsNull()) {
                throw new IllegalArgumentException("FrameBorderLayoutManager: constraint is null.");
            }
        } else if (aConstraint instanceof BorderConstraint) {
            border = ((BorderConstraint)aConstraint).getBorder();
        } else if (LayoutManagerPolicy.generateExceptionIfLayoutDontSupportedThisConstraint()) {
            throw new IllegalStateException("FrameBorderLayoutManager: type of constraint is not supported.");
        }
        return border;
    }
}

