/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.clientagent;

import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfo;
import com.softaspects.framework.galileo.support.components.clientagent.exception.PropertyNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ClientAgentInfoImpl
implements ClientAgentInfo {
    protected HashMap fPropertyMap = new HashMap();
    protected static HashSet fPropertySet = new HashSet();

    static {
        ClientAgentInfoImpl.initDefaultPrioperties();
    }

    protected static void addAvailablePropery(String aProperty) {
        fPropertySet.add(aProperty);
    }

    protected static void initDefaultPrioperties() {
        ClientAgentInfoImpl.addAvailablePropery("BROWSER_NAME");
        ClientAgentInfoImpl.addAvailablePropery("PLATFORM_NAME");
        ClientAgentInfoImpl.addAvailablePropery("REMOTE_ADR");
        ClientAgentInfoImpl.addAvailablePropery("REMOTE_HOST");
        ClientAgentInfoImpl.addAvailablePropery("REMOTE_USER");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPT_JS");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPT_CSS");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPT_UPLOADING");
        ClientAgentInfoImpl.addAvailablePropery("HTTP_VERSION");
        ClientAgentInfoImpl.addAvailablePropery("BROWSER_VERSION");
        ClientAgentInfoImpl.addAvailablePropery("SERVER_TIME");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPTED_MIME_TYPES");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPTED_CHARSETS");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPTED_ENCODING");
        ClientAgentInfoImpl.addAvailablePropery("ACCEPTED_LANGUAGES");
    }

    public Object getProperty(String aName) throws PropertyNotFoundException {
        if (aName == null || !fPropertySet.contains(aName)) {
            throw new PropertyNotFoundException(aName);
        }
        return this.fPropertyMap.get(aName);
    }

    public void setProperty(String aName, Object aValue) throws PropertyNotFoundException {
        if (aName == null || !fPropertySet.contains(aName)) {
            throw new PropertyNotFoundException(aName);
        }
        if (aValue != null) {
            this.fPropertyMap.put(aName, aValue);
        } else {
            this.fPropertyMap.remove(aName);
        }
    }

    public void setProperty(String aName, int aValue) throws PropertyNotFoundException {
        this.setProperty(aName, new Integer(aValue));
    }

    public void setProperty(String aName, boolean aValue) throws PropertyNotFoundException {
        this.setProperty(aName, new Boolean(aValue));
    }

    public void setProperty(String aName, float aValue) throws PropertyNotFoundException {
        this.setProperty(aName, new Float(aValue));
    }

    public Iterator getPropeties() {
        return new ReadOnlyIterator(this.fPropertyMap.keySet().iterator());
    }

    public Iterator getAvailableProperties() {
        return new ReadOnlyIterator(fPropertySet.iterator());
    }

    public void setBrowserName(String aName) {
        this.setProperty("BROWSER_NAME", aName);
    }

    public String getBrowserName() {
        return this.getStringProperty("BROWSER_NAME");
    }

    public void setBrowserVersion(float aVersion) {
        this.setProperty("BROWSER_VERSION", aVersion);
    }

    public float getBrowserVersion() {
        return this.getFloatProperty("BROWSER_VERSION", 1.0f);
    }

    public void setPlatformName(String aPlatform) {
        this.setProperty("PLATFORM_NAME", aPlatform);
    }

    public String getPlatformName() {
        return this.getStringProperty("PLATFORM_NAME");
    }

    public void setAcceptJavaScript(boolean aAcept) {
        this.setProperty("ACCEPT_JS", aAcept);
    }

    public boolean isAcceptJavaScript() {
        return this.getBooleanProperty("ACCEPT_JS");
    }

    public void setAcceptCSS(boolean aAcept) {
        this.setProperty("ACCEPT_CSS", aAcept);
    }

    public boolean isAcceptCSS() {
        return this.getBooleanProperty("ACCEPT_CSS");
    }

    public void setAcceptUploading(boolean aAcept) {
        this.setProperty("ACCEPT_UPLOADING", aAcept);
    }

    public boolean isAcceptUploading() {
        return this.getBooleanProperty("ACCEPT_UPLOADING");
    }

    public void setRemoteHost(String aRemoteHost) {
        this.setProperty("REMOTE_HOST", aRemoteHost);
    }

    public String getRemoteHost() {
        return this.getStringProperty("REMOTE_HOST");
    }

    public void setRemoteAddr(String aRemoteAddr) {
        this.setProperty("REMOTE_ADR", aRemoteAddr);
    }

    public String getRemoteAddr() {
        return this.getStringProperty("REMOTE_ADR");
    }

    public void setRemoteUser(String aRemoteUser) {
        this.setProperty("REMOTE_USER", aRemoteUser);
    }

    public String getRemoteUser() {
        return this.getStringProperty("REMOTE_USER");
    }

    public void setHTTPVersion(float aHTTPVersion) {
        this.setProperty("HTTP_VERSION", aHTTPVersion);
    }

    public float getHTTPVersion() {
        return this.getFloatProperty("HTTP_VERSION", 1.0f);
    }

    public boolean isAcceptEncoding() {
        return this.getProperty("ACCEPTED_ENCODING") != null;
    }

    public void setAcceptedEncoding(String[] aEncodings) {
        this.setProperty("ACCEPTED_ENCODING", aEncodings);
    }

    public String[] getAcceptedEncoding() {
        return (String[])this.getProperty("ACCEPTED_ENCODING");
    }

    public void setAcceptedMimeTypes(String[] aTypes) {
        this.setProperty("ACCEPTED_MIME_TYPES", aTypes);
    }

    public String[] getAcceptedMimeTypes() {
        return (String[])this.getProperty("ACCEPTED_MIME_TYPES");
    }

    public void setAcceptedCharsets(String[] aCharsets) {
        this.setProperty("ACCEPTED_CHARSETS", aCharsets);
    }

    public String[] getAcceptedCharsets() {
        return (String[])this.getProperty("ACCEPTED_CHARSETS");
    }

    public void setAcceptedLanguages(String[] aLanguages) {
        this.setProperty("ACCEPTED_LANGUAGES", aLanguages);
    }

    public String[] getAcceptedLanguages() {
        return (String[])this.getProperty("ACCEPTED_LANGUAGES");
    }

    public void setServerTime(long aServerTime) {
        this.setProperty("SERVER_TIME", new Date(aServerTime));
    }

    public Date getServerTime() {
        return (Date)this.getProperty("SERVER_TIME");
    }

    protected String getStringProperty(String aName) {
        return (String)this.getProperty(aName);
    }

    protected boolean getBooleanProperty(String aName) {
        if (this.getProperty(aName) == null) {
            return false;
        }
        return (Boolean)this.getProperty(aName);
    }

    protected int getIntProperty(String aName, int aDefaultValue) {
        if (this.getProperty(aName) == null) {
            return aDefaultValue;
        }
        return (Integer)this.getProperty(aName);
    }

    protected float getFloatProperty(String aName, float aDefaultValue) {
        if (this.getProperty(aName) == null) {
            return aDefaultValue;
        }
        return ((Float)this.getProperty(aName)).floatValue();
    }

    protected class ReadOnlyIterator
    implements Iterator {
        private Iterator fIterator;

        public ReadOnlyIterator(Iterator aIterator) {
            this.fIterator = aIterator;
        }

        public boolean hasNext() {
            return this.fIterator.hasNext();
        }

        public Object next() {
            return this.fIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }
}

