/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table.additions;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractCellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;

public abstract class AbstractImageTableCellRenderer
extends AbstractCellRenderer {
    protected boolean isImageFirst() {
        return true;
    }

    public String renderLabel(String aText, String aImage, String aHintText, int aCountOfImages) throws RendererException {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        int indentLevel = 1;
        StringBuffer sBuffer = new StringBuffer();
        boolean createTable = aText != null && aImage != null || aCountOfImages != -1;
        try {
            int countOfImages;
            if (createTable) {
                sBuffer.append("<TABLE");
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("BORDER", 0));
                if (aHintText != null) {
                    sBuffer.append(' ');
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("TITLE", aHintText));
                }
                sBuffer.append('>');
                sBuffer.append(RendererFactory.indentString(indentLevel++, "<TR>"));
            }
            Table table = this.getTable();
            String cellId = RendererUtils.getTableCellComponentId(table, rowIndex, columnIndex);
            int n = countOfImages = aCountOfImages == -1 ? 1 : aCountOfImages;
            if (aCountOfImages == 0 && aText == null) {
                aText = "&nbsp;";
            }
            if (aText != null && !this.isImageFirst()) {
                if (createTable) {
                    sBuffer.append(RendererFactory.indentString(indentLevel++, AbstractImageTableCellRenderer.getTDstart()));
                }
                sBuffer.append(RendererFactory.indentString(indentLevel++, this.getText(aText, cellId)));
                if (createTable) {
                    sBuffer.append(RendererFactory.indentString(indentLevel--, "</TD>"));
                }
            }
            if (aImage != null) {
                String hintText = createTable ? null : aHintText;
                int i = 0;
                while (i < countOfImages) {
                    if (createTable) {
                        sBuffer.append(RendererFactory.indentString(indentLevel++, AbstractImageTableCellRenderer.getTDstart()));
                    }
                    String cell_ID = aText == null && i == 0 ? cellId : null;
                    sBuffer.append(this.getImage(aImage, hintText, cell_ID));
                    if (createTable) {
                        sBuffer.append(RendererFactory.indentString(indentLevel--, "</TD>"));
                    }
                    ++i;
                }
            }
            if (aText != null && this.isImageFirst()) {
                if (createTable) {
                    sBuffer.append(RendererFactory.indentString(indentLevel++, AbstractImageTableCellRenderer.getTDstart()));
                }
                sBuffer.append(RendererFactory.indentString(indentLevel++, this.getText(aText, cellId)));
                if (createTable) {
                    sBuffer.append(RendererFactory.indentString(indentLevel--, "</TD>"));
                }
            }
            if (createTable) {
                sBuffer.append(RendererFactory.indentString(indentLevel--, "</TR>"));
                sBuffer.append(RendererFactory.indentString(indentLevel--, "</TABLE>"));
            }
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
        return sBuffer.toString();
    }

    public String renderLabel(String aText, String aImage, String aHintText) throws RendererException {
        return this.renderLabel(aText, aImage, aHintText, -1);
    }

    protected String getText(String aText, String aCellId) {
        if (aText != null) {
            boolean edited;
            boolean focused;
            boolean selected;
            InterfaceManager interfaceManager;
            int foreground;
            int rowIndex = this.getRowIndex();
            int columnIndex = this.getColumnIndex();
            StringBuffer sBuffer = new StringBuffer("<P");
            if (aCellId != null) {
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", aCellId));
            }
            if ((foreground = (interfaceManager = this.getTable().getInterfaceManager()).getCellForeground(selected = this.getTable().isCellSelected(rowIndex, columnIndex), focused = false, edited = false, rowIndex, columnIndex)) != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(foreground);
                sBuffer.append(' ');
                String style = RendererFactory.createHtmlStyleString("COLOR", color);
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("STYLE", style));
            }
            sBuffer.append('>');
            sBuffer.append(aText);
            return sBuffer.toString();
        }
        return null;
    }

    public String getImage(String aImage, String aHintText, String aCellId) {
        if (aImage != null) {
            StringBuffer sBuffer = new StringBuffer("<IMG");
            if (aCellId != null) {
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", aCellId));
            }
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("SRC", aImage));
            if (aHintText != null) {
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("ALT", aHintText));
            }
            sBuffer.append('>');
            return sBuffer.toString();
        }
        return null;
    }

    protected static String getTDstart() {
        StringBuffer sBuffer = new StringBuffer("<TD");
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("VALIGN", "center"));
        sBuffer.append('>');
        return sBuffer.toString();
    }
}

