/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.Cursor;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.ContextRenderer;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.listbox.ListBoxComponentImpl;
import com.softaspects.framework.galileo.support.components.listmodel.ListDataModelImpl;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModelImpl;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;

public class DefaultNavigationBarRenderer
extends ContextRendererImpl {
    public DefaultNavigationBarRenderer() {
    }

    public DefaultNavigationBarRenderer(ComponentBase component) {
        this.setComponent(component);
    }

    private String renderPageSizeCombo(Table table) throws RendererException {
        if (this.fPageContext == null) {
            throw new RendererException("PageContext is NULL");
        }
        ListBoxComponentImpl listBox = new ListBoxComponentImpl();
        listBox.setListBox(false);
        listBox.setId(table.getId() + "_pageSizeCombo");
        listBox.setPageContextRendering(false);
        ((ContextRenderer)listBox.getRenderer()).setPageContext(this.fPageContext);
        String jsListVar = RendererFactory.createJScriptVariableName(listBox);
        String jsTableVar = RendererFactory.createJScriptVariableName(table);
        String onChangeHandler = jsTableVar + ".changePageSize(" + jsListVar + ".dataModel.getValueAt(" + jsListVar + ".selectionModel.getSelectionIntervals()[0]))";
        listBox.addPresentationEvent(18, onChangeHandler);
        listBox.setWidth("50px");
        ListDataModelImpl listDataModel = new ListDataModelImpl();
        listDataModel.addValue("10");
        listDataModel.addValue("20");
        listDataModel.addValue("50");
        listDataModel.addValue("100");
        listBox.setListDataModel(listDataModel);
        ListSelectionModelImpl selectionModel = new ListSelectionModelImpl();
        int currentPageSize = table.getCursorPageSize();
        String pageSizeValue = String.valueOf(currentPageSize);
        int currentSelectionIndex = listDataModel.indexOf(pageSizeValue);
        selectionModel.select(currentSelectionIndex);
        listBox.setListSelectionModel(selectionModel);
        String content = "";
        try {
            content = listBox.render();
        }
        catch (Exception e) {
            throw new RendererException(e.getMessage());
        }
        return content;
    }

    public String doRender() throws RendererException {
        int rowsPerPage;
        int seriesTotal;
        Table table = (Table)this.getComponent();
        if (table == null) {
            throw new RendererException("TABLE COMPONENT MUSTN'T BE NULL");
        }
        Cursor pageCursor = table.getCursor();
        if (pageCursor == null) {
            throw new RendererException("PageCursor mustn't be NULL");
        }
        StringBuffer generatedContent = new StringBuffer();
        int seriesNumber = table.getCursorCurrentPage();
        int rowsTotal = table.getRowCount();
        int n = seriesTotal = rowsTotal % (rowsPerPage = table.getCursorPageSize()) > 0 ? rowsTotal / rowsPerPage + 1 : rowsTotal / rowsPerPage;
        if (seriesNumber - seriesTotal >= 0) {
            seriesNumber = 0;
        }
        long firstSeries = 1L;
        long prevSeries = 0L;
        long nextSeries = 0L;
        long currentStartSeries = 0L;
        long currentEndSeries = seriesTotal;
        String fontSize = "12px";
        String selectedFontSize = "15px";
        String pageSizeComboContent = this.renderPageSizeCombo(table);
        generatedContent.append("<table align=\"center\">\n <tr>\n<td style=\"font-size:" + fontSize + "\">\n" + "Rows per page :&nbsp;&nbsp;&nbsp;" + pageSizeComboContent + "&nbsp;&nbsp;&nbsp;Total &nbsp;: &nbsp;<b style=\"font-size:" + fontSize + ";\">");
        generatedContent.append(rowsTotal);
        generatedContent.append("</b></td></tr></table>\n");
        int visibleInterval = 10;
        if (seriesNumber - visibleInterval >= 0) {
            currentStartSeries = seriesNumber;
        }
        if (currentStartSeries + (long)visibleInterval < (long)seriesTotal) {
            currentEndSeries = currentStartSeries + (long)visibleInterval;
        } else if (seriesTotal >= visibleInterval) {
            currentStartSeries = currentEndSeries - (long)visibleInterval;
        }
        String tableJsVariable = RendererFactory.createJScriptVariableName(table);
        String navBackground = ColorFactory.convertColorFromIntToHtml(table.getInterfaceManager().getHeaderBackground(false, false, false, 0));
        String unselectedSerieForeground = ColorFactory.convertColorFromIntToHtml(table.getInterfaceManager().getHeaderForeground(false, false, false, 0));
        String selectedSerieForeground = ColorFactory.convertColorFromIntToHtml(table.getInterfaceManager().getHeaderForeground(true, false, false, 0));
        String selectedSerieBackground = ColorFactory.convertColorFromIntToHtml(table.getInterfaceManager().getHeaderBackground(true, false, false, 0));
        generatedContent.append("<table  align=\"center\" style=\"background:" + navBackground + "\" >\n <tr>\n");
        generatedContent.append("<td><b><a href=\"#\" onclick=\"" + tableJsVariable + ".pageStart() \" " + "><b><font style=\"font-size:" + fontSize + ";color:" + unselectedSerieForeground + "\" >" + "First</font></b>" + "</a>&nbsp;&nbsp;</b></td>");
        if (seriesNumber - visibleInterval >= 0) {
            prevSeries = seriesNumber - visibleInterval - 1;
            if (prevSeries < 0L) {
                prevSeries = 0L;
            }
            generatedContent.append("<td><b><a href=\"#\" onclick=\"" + tableJsVariable + ".goToPage(" + prevSeries + ") \" " + "><b><font style=\"font-size:" + fontSize + ";color:" + unselectedSerieForeground + "\" >" + "Previous</font></b>" + "</a>&nbsp;&nbsp;</b></td>");
        }
        int i = (int)currentStartSeries;
        while ((long)i < currentEndSeries) {
            generatedContent.append("<td>");
            if (i == seriesNumber) {
                generatedContent.append("<b><font style=\"color:" + selectedSerieForeground + ";background : " + selectedSerieBackground + ";font-size:" + selectedFontSize + ";\">");
            } else {
                generatedContent.append("<a href=\"#\" onclick=\"" + tableJsVariable + ".goToPage(" + i + ") \" " + "><font style=\"color:" + unselectedSerieForeground + ";font-size:" + fontSize + ";\">");
            }
            generatedContent.append(String.valueOf(i * rowsPerPage + 1) + "-");
            if ((i + 1) * rowsPerPage > rowsTotal) {
                generatedContent.append(rowsTotal);
            } else {
                generatedContent.append((i + 1) * rowsPerPage);
            }
            if (i == seriesNumber) {
                generatedContent.append("</font></b>");
            } else {
                generatedContent.append("</font></a>");
            }
            if ((long)i < currentEndSeries - 1L) {
                generatedContent.append("&nbsp;---");
            }
            generatedContent.append("</td>\n");
            ++i;
        }
        if (currentEndSeries != (long)seriesTotal) {
            nextSeries = seriesNumber + visibleInterval + 1;
            if (nextSeries > (long)(seriesTotal - 1)) {
                nextSeries = seriesTotal - 1;
            }
            generatedContent.append("<td>&nbsp;&nbsp;");
            generatedContent.append("<a href=\"#\" onclick=\"" + tableJsVariable + ".goToPage(" + nextSeries + ") \" " + "><b><font style=\"font-size:" + fontSize + ";color:" + unselectedSerieForeground + "\" >" + "Next</font></b>" + "</a></td>\n");
        }
        generatedContent.append("<td>&nbsp;&nbsp;");
        generatedContent.append("<a href=\"#\" onclick=\"" + tableJsVariable + ".pageEnd() \" " + "><b><font style=\"font-size:" + fontSize + ";color:" + unselectedSerieForeground + "\" >" + "Last</font></b>" + "</a></td></tr></table>\n");
        return generatedContent.toString();
    }
}

