/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractCellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;

public class DefaultCellRenderer
extends AbstractCellRenderer {
    public Object getValue() {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        Object value = this.getTable().getValueAt(rowIndex, columnIndex);
        return value == null ? null : value.toString();
    }

    protected String getTextValue() throws RendererException {
        String value = (String)this.getValue();
        return value != null && value.length() > 0 ? value : "&nbsp;";
    }

    public String makeRender() throws RendererException {
        Table table = this.getTable();
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        String cellId = RendererUtils.getTableCellComponentId(table, rowIndex, columnIndex);
        StringBuffer sBuffer = new StringBuffer();
        try {
            sBuffer.append("<P");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", cellId));
            InterfaceManager interfaceManager = table.getInterfaceManager();
            boolean selected = table.isCellSelected(rowIndex, columnIndex);
            boolean edited = false;
            boolean focused = false;
            int foreground = interfaceManager.getCellForeground(selected, focused, edited, rowIndex, columnIndex);
            if (foreground != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(foreground);
                sBuffer.append(' ');
                String style = RendererFactory.createHtmlStyleString("COLOR", color);
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("STYLE", style));
            }
            sBuffer.append('>');
            sBuffer.append(this.getTextValue());
            return RendererFactory.indentString(2, sBuffer.toString());
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
    }
}

