/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractTableRenderer;
import com.softaspects.framework.galileo.renderers.html.table.HeaderRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.framework.galileo.renderers.html.table.TableRenderer;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractHeaderRenderer
extends AbstractTableRenderer
implements HeaderRenderer {
    protected static final String TABLE_HEADER_SCRIPT_WAS_LOADED = "TABLE_HEADER_SCRIPT_WAS_LOADED";
    protected static final String TABLE_HEADER_SCRIPT_FUNCTION = "TableHeader";
    protected static final String TABLE_HEADER_SCRIPT = "tableheader.js";
    protected static final String TABLE_HEADER_SCRIPT_PREFIX = "header";
    protected int fColumnIndex = -1;

    public void setColumnIndex(int aColumnIndex) {
        AbstractHeaderRenderer.validateValue(aColumnIndex, "Column index");
        this.fColumnIndex = aColumnIndex;
    }

    public int getColumnIndex() {
        AbstractHeaderRenderer.validateState(this.fColumnIndex, "Column index");
        return this.fColumnIndex;
    }

    public Object getValue() {
        int columnIndex = this.getColumnIndex();
        Object value = this.getTable().getColumnHeaderValue(columnIndex);
        return value == null ? "" : value.toString();
    }

    public void addJScriptCommamd(String aJsCommand) {
        if (aJsCommand != null && aJsCommand.length() > 0) {
            ((TableRenderer)this.getTable().getRenderer()).addJScriptCommamd(aJsCommand);
        }
    }

    public String doRender() throws RendererException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(this.loadJScript());
        sBuffer.append(this.makeRender());
        this.createJSVariable();
        String result = sBuffer.toString();
        return result;
    }

    public String loadJScript() throws RendererException {
        Object flag = this.fPageContext.getAttribute(TABLE_HEADER_SCRIPT_WAS_LOADED, 2);
        StringBuffer sBuffer = new StringBuffer();
        if (flag == null) {
            try {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                this.fPageContext.getOut().println(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource("TABLE_HEADER"), null));
                this.fPageContext.getOut().println(RendererFactory.createJScriptEndTag());
                this.fPageContext.setAttribute(TABLE_HEADER_SCRIPT_WAS_LOADED, (Object)TABLE_HEADER_SCRIPT_WAS_LOADED, 2);
            }
            catch (Exception e) {
                throw new RendererException(e.toString());
            }
        }
        return sBuffer.toString();
    }

    public abstract String makeRender() throws RendererException;

    public void createJSVariable() throws RendererException {
        int columnIndex = this.getColumnIndex();
        Table table = this.getTable();
        String headerId = RendererUtils.getTableHeaderComponentId(table, columnIndex);
        this.addJScriptCommamd(AbstractTableRenderer.createJsCommand(TABLE_HEADER_SCRIPT_PREFIX, headerId, TABLE_HEADER_SCRIPT_FUNCTION));
    }

    protected static void validateValue(int aValue, String aName) {
        if (aValue < 0) {
            throw new IllegalArgumentException("TableHeaderRenderer: " + aName + " can't be negative.");
        }
    }

    protected static void validateState(int aValue, String aName) {
        if (aValue == -1) {
            throw new IllegalStateException("TableHeaderRenderer: " + aName + " must be initialized.");
        }
    }
}

